/*
**  convert XConsortium rgb.txt file to a database format. It makes 
**  color name the key and red, green and blue components as value in the
**  database. It converts the color names to lower case before saving.
**  The format of the rgb.txt file is:
**
**  red green blue      color name
**
**  Limitations and Comments:
**  The format of the database is determined before compiling by probing
**  the system. It supports on the Berkeley db 1.85, GNU gdbm or ndbm
**  databases.
**
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Aug-16-1999    first cut
*/


#include <stdio.h>
#include <ldbm.h>

#define R_VERSION_S   "1.1"

static int uSage(char *progname,char *dbtype)
{
    (void) fprintf(stderr,"-------------------------------------------------------------------------\n");
    (void) fprintf(stderr,"editdb version %s\n",R_VERSION_S);
    (void) fprintf(stderr,"Part of WWW Homepage Access Counter 2.6+\n");
    (void) fprintf(stderr,"http://www.fccc.edu/users/muquit/Count.html\n");
    (void) fprintf(stderr,"\nThe program is compiled with %s support\n",dbtype);
        fprintf(stderr,"-------------------------------------------------------------------------\n");

    (void) fprintf(stderr,"\n");
    (void) fprintf(stderr," Usage: %s rgb.txt rgb.db\n\n",progname);
    exit(1);
}


/*
** returns 0 on sucess, -1 on failure
*/
static int convertRGBtxt2Db(char *rgb_file,char *db_file)
{
    int
        r,
        g,
        b,
        items,
        rc=(-1);

    FILE
        *fp=(FILE *) NULL;

    LDBM
        dbp=(LDBM) NULL;

    char
        szcolor_name[BUFSIZ],
        szrgb[BUFSIZ],
        szbuf[BUFSIZ];

    Datum
        key_data,
        data_data;

    /* open the rgb file */
    fp=fopen(rgb_file,"r");
    if (fp == NULL)
    {
        (void) fprintf(stderr,"Could not open %s for reading\n",rgb_file);
        rc=(-1);
        goto ExitProcessing;
    }

    /* open the databse to write */
    dbp=ldbm_open(db_file,LDBM_WRCREAT,00644,0);
    if (dbp == NULL)
    {
        (void) fprintf(stderr,"Could not open database %s for writing\n",
                       db_file);
        rc=(-1);
        goto ExitProcessing;
    }


    while (fgets(szbuf,sizeof(szbuf)-1,fp))
    {

        items=sscanf(szbuf,"%d %d %d %[^\n]\n",&r,&g,&b,szcolor_name);
        if (items != 4)
            continue;
        (void) sprintf(szrgb,"%d %d %d",r,g,b);

        /* convert the color name to lower case */
        mutilsStrLower(szcolor_name);

        key_data.dptr=szcolor_name;
        key_data.dsize=strlen(szcolor_name)+1;

        data_data.dptr=szrgb;
        data_data.dsize=strlen(szrgb)+1;

        /* save to database */
        if (ldbm_store(dbp,key_data,data_data,LDBM_REPLACE) != 0)
        {
            (void) fprintf(stderr,"Could not write: \"%s\" =>\"%s\"\n",
                           szcolor_name,szrgb);
        }
    }

ExitProcessing:
    if (fp)
        (void) fclose(fp);

    if (dbp)
        ldbm_close(dbp);

    return(rc);
}

int main (int argc,char **argv) 
{
    char
        *rgb_file,
        *db_file,
        *dbtype="unknown";

    int
        rc;

#ifdef LDBM_USE_DBBTREE
        dbtype="Berkey DbTree";
#endif /* LDBM_USE_DBBTREE */

#ifdef LDBM_USE_DBHASH
        dbtype="Berkey DbHash";
#endif /* LDBM_USE_DBHASH */

#ifdef LDBM_USE_GDBM
        dbtype="GNU gdbm";
#endif /* LDBM_USE_GDBM */

#ifdef LDBM_USE_SDBM
        dbtype="sdbm";
#endif /* LDBM_USE_SDBM */

#ifdef LDBM_USE_NDBM
        dbtype="ndbm";
#endif /* LDBM_USE_NDBM */


    if (argc != 3)
    {
        uSage(argv[0],dbtype);
        /* won't be here */
    }

    rgb_file=argv[1];
    db_file=argv[2];
    rc=convertRGBtxt2Db(rgb_file,db_file);

    return(0);
}

