/*
**  show the url in the database
**
**  Limitations and Comments:
**  It can read berkeley db, GNU gdbm or ndbm database. It will link
**  with only one of the database.
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Jul-26-1999    first cut
*/


#include <stdio.h>
#include "ldbm.h"

#define TRUE    1
#define FALSE   0

#define VERSION_S   "1.1"

int main (int argc,char **argv) 
{
    char
        cmd_ch;

    Datum
        key_data,
        return_data;

    LDBM
        dbp;

    char
        *dbtype,
        *file_name;

    key_data.dptr=NULL;
    return_data.dptr=NULL;

    if (argc != 2)
    {
        (void) fprintf(stderr,"dumpdb %s\n",VERSION_S);
        (void) fprintf(stderr,"Dump WWW Homepage access counter database\n");
        (void) fprintf(stderr,"<url:http://www.fccc.edu/users/muquit/Count.html\n\n");

#ifdef LDBM_USE_DBBTREE
        (void) fprintf(stderr,"(-compiled with Berkeyley DBTREE support-)\n\n");
        dbtype="Berkey db";
#endif /* LDBM_USE_DBBTREE */

#ifdef LDBM_USE_DBHASH
        (void) fprintf(stderr,"(-compiled with Berkeyley DBHASH support-)\n\n");
        dbtype="Berkey db";
#endif /* LDBM_USE_DBHASH */


#ifdef LDBM_USE_GDBM
        (void) fprintf(stderr,"Compiled with GNU dbm (gdbm) support\n\n");
        dbtype="GNU gdbm";
#endif /* LDBM_USE_GDBM */

#ifdef LDBM_USE_SDBM
        (void) fprintf(stderr,"Compiled with sdbm support\n\n");
        dbtype="sdbm";
#endif /* LDBM_USE_SDBM */

#ifdef LDBM_USE_NDBM
        (void) fprintf(stderr,"Compiled with ndbm support\n\n");
        dbtype="ndbm";
#endif /* LDBM_USE_NDBM */

        (void) fprintf(stderr,"Usage: %s <%s file>\n\n",argv[0],dbtype);
        exit(1);
    }

    file_name=argv[1];

    dbp=ldbm_open(file_name,LDBM_READER,00644,0);
    if (dbp == NULL)
    {
        perror(file_name);
        exit(1);
    }
    return_data=ldbm_firstkey(dbp);
    while (return_data.dptr != NULL)
    {
        key_data=return_data;
        return_data=ldbm_fetch(dbp,key_data);
        (void) fprintf(stdout,"%s=>%s\n",key_data.dptr,return_data.dptr);
        (void) fflush(stdout);
        ldbm_datum_free(dbp,return_data);
        return_data=ldbm_nextkey(dbp,key_data);
    }

    ldbm_close(dbp);
    exit(0);
}


