#!/usr/local/bin/perl
##
## user adminster her own data value in the counter database via web.
## It is part of WWW Homepage Access Counter
## uses AnyDBM_File Perl module
##
## Muhammad A Muquit
## http://www.fccc.edu/users/muquit/
## a vacation hack (hmm.. a sick hack, i was sick)
### Aug-13-1999
##
## muquit@muquit.com    Sep-04-2000 modified
##--------------------------------------------------------------------------

## TODO: check if a URL exists before inserting to auth database.

# change the order of modules if you need
BEGIN
{
    @AnyDBM_File::ISA=qw(DB_File GDBM_File NDBM_File)
}
use strict;
use Fcntl;
use AnyDBM_File();
use CGI;
use CGI::Carp 'fatalsToBrowser';

use Digest::MD5 qw(md5_hex);

my $query=new CGI;


#------------globals starts-------------------
my $g_debug=0;

# create the following file in the same directory of the cgi program
# the format is
# userid|Unix_crypted_password|document_root_of_user

my $guser_textdb="count_admin.txt";

####################======================##########################
my $gcounter_db="/usr/local/etc/Counter/db/Countdb";
my $gauth_db="/usr/local/etc/Counter/db/Authdb";
my $gcouter_lock_file="/usr/local/etc/Counter/db/Count.lck";
####################=====================###########################

my $g_edit_authdb=0;
my $g_mode=0640;
my $g_r_flag=O_RDONLY;
my $g_rw_flag=O_RDWR|O_CREAT;


my $g_document_root='';
my @g_document_roota=();

my $g_title="administer your own data of WWW homepage access counter";
my $script_name=$query->script_name;
my $path_info=$query->path_info;

my $check_url=0;
my $check_url_prog="lwp-request -m HEAD";
#------------globals ends-------------------



print $query->header;

my $LOCAL_STYLE=<<EOF;
A:link { font-weight:normal; color: #00099; text-decoration: none; }
A:visited {color: #000099;text-decoration: none; }
A:hover { color:#9F9900; text-decoration: underline; }
EOF
;
print $query->start_html(
        -title=>"$g_title",
        -bgcolor=>"#ffffff",
        -link=>"#ff0000",
        -vlink=>"#ff0f00",
        -alink=>"#ffff00",
        -text=>"#000000");


# call routine based on path_info
&doModify() if $path_info eq "/modify";
&doAddOrModifyAuthdb() if ($path_info eq "/addmod_authdb");

if ($query->param)
{
    &doWork();
}
else
{
    &printLoginForm();
}

##-----
# printLoginForm() - print the login form
##-----
sub printLoginForm
{
    print "<center>\n";
    print<<EOF;
    <blockquote>
        <h2>Count database administration</h2>
    Please enter your <b>Userid</b> and <b>Password</b> set by your 
    administrator to modify your own data in 
    <a href="http://www.fccc.edu/users/muquit/Count.html">
    WWW Homepage Access Counter 2.6+</a> database.
    <br>
    Database Module: DB_File
    </blockquote>
EOF
;
    print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

    print $query->start_form;

    #------------- userid
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Userid:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->textfield(-name=>'userid',
            size=>20);
    print "</td>\n";
    print "</tr>\n";

    #------------- password
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Password:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->password_field(-name=>'password',
            -size=>20);
    print "</td>\n";
    print "</tr>\n";

    #------------- submit
    print "<tr>\n";
    print "<td colspan=2 align=\"center\">\n";
    print "<hr noshade size=1>\n";
    print $query->submit(-name=>'button',-value=>'Edit Hits');
    print "\&nbsp;\&nbsp\n";
    print $query->submit(-name=>'button',-value=>'Edit Authdb');
    print "</td>\n";
    print "</tr>\n";


    print $query->end_form;

    print "</table>\n";
    print "</center>\n";

}

##-------
# doWork() 
##-------
sub doWork
{
    my $em='';
    my $button=$query->param('button');
    my $userid;

    # import the paramets into a series of variables in 'q' namespace
    $query->import_names('q');
    #  check if the necessary fields are empty or not
    $em .= "<br>You must specify your Userid!<br>" if !$q::userid;
    $em .= "You must specify your Password!<br>" if !$q::password;

    $userid="$q::userid";

    if ($button eq 'Help')
    {
        &printLoginForm();
        &printHelp();
        exit;
    }

    if ($button eq 'Edit Authdb')
    {
        if (&validateUser() != 0) # user is verified
        {
            if ($g_edit_authdb == 1)
            {

                if ($query->param('textarea'))
                {
                    &printEditAuthdbForm2($userid);
                }
                else
                {
                    &printEditAuthdbForm($userid);
                }
                        
                exit;
            }
            else
            {
                &printError("You are not allowed to edit Auth database!");
                exit;
            }
        }
        else
        {
            &printError("Could not validate Userid: $userid!");
            return;
        }
    }

    &myDebug("Button=$button");

    if ($em)
    {
        &printLoginForm;
        &hLine("#99cccc");
        &printError($em);
        return;
    }

    if (&validateUser() == 0)
    {
        &printLoginForm;
        &hLine("#99cccc");
        &printError("Could not validate Userid: $q::userid");
        return;
    }

    # open the counter database and see if the url with the user document root
    # is in the database
    &printHitsModifyForm($q::userid);

}

##-----
# printEditAuthdbForm()
# form to edit auth database
#------
sub printEditAuthdbForm
{
    my $userid=shift;

    use vars qw(%h $k $v);

    my @u=();
    my $urls;
    my $len;
    my $subs='';
    my $a='';
    my $line='';
    

    &myDebug("userid=$userid");

    if (! $userid)
    {
        &printError("No userid specified!");
        return;
    }

    &myDebug("doc root=@g_document_roota");

    doLock();
    # open authdb for reading
    my $x=tie %h,'AnyDBM_File',"$gauth_db",$g_r_flag,$g_mode;
    if (!$x)
    {
        &printError("could not open auth database: $gauth_db for reading");
        return;
    }

    my %uh=();
    @u=();
    while (($k,$v)=each %h)
    {
        # remove terminating null from key. 
        $k =~ s/\x00$//;
        $v =~ s/\x00$//;
        # if no key, ignore
        next if (! $k);
        &myDebug("K=$k");

        my $ux;

        foreach $ux (@g_document_roota)
        {
            $len=length($ux);
            $subs=substr($k,0,$len);
            if ($subs eq $ux)
            {
                $line="$k\t$v";
                push(@u,$line);    
            }
        }
    }

    &myDebug("u array=@u");
    $urls=scalar(@u);
    &myDebug("n urls=$urls");
    if ($urls >= 1)
    {

        print "<center><b>Add/Modify Authdb</b></center><br>\n";
        print "<b>Userid:</b> $userid<br>\n";
        print "<b>Document root:</b> $g_document_root<br>\n";
        print "<br>\n";
        print<<EOF;
        To add a new URL to the auth database, edit any exising URL, BUT
        leave the <b>ID</b> field empty. If you want the new URL to
        be counted as an existing one, insert the <b>ID</b> of an
        existing URL.
        To delete an URL, click on the toggle button and press Submit.
        <b>Note:</b> Delete only works on un-modified URL and Key.
            
EOF
;
        print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

        print $query->start_form(-action=>"$script_name/addmod_authdb");
        print "<tr align=\"center\">\n";
        print "<td><b>Delete</b></td>\n";

        print "<td align=\"center\">\n";
        print "<b>URL</b>\n";
        print "</td>\n";

        print "<td align=\"center\">\n";
        print "<b>ID</b>\n";
        print "</tr>\n";

        my $counter=0;
        foreach $a (@u)
        {
            $counter++;
            ($k,$v)=split(/\t/,$a);
            print "<tr>\n";

            print "<td>\n";
            print $query->checkbox('selecturl',0,$k,$counter),"\n";
            print "</td>\n";

            print "<td>\n";
            print $query->textfield(-name=>"url_$counter",
                    -value=>"$k",
                    -label=>'',
                    -size=>50);
            print "</td>\n";

            print $query->hidden("\@hidden\@$k","$v");
            print $query->hidden("DocumentRoot","@g_document_roota");

            print "<td>\n";
            print $query->textfield(-name=>"md5_$counter",
                    -value=>"$v",
                    -size=>33);
            print "</td>\n";
            print "</tr>\n";
        }

        print "<td colspan=3 align=\"center\">\n";
        &hLine("#aaaaaa");
        print $query->submit(-label=>'Submit',
                -value=>'Submit');
        print "</td>\n";
        print "</tr>\n";
        print $query->end_form;
        print "</table>\n";
        print "</center>\n";
    }
    else
    {
        print "<center>\n";
        print "<h2>Add URLs to Authtdb</h2>\n";
        print "<b>Userid:</b> $userid<br>\n";
        print "<b>Document root:</b> $g_document_root<br>\n";
        print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

        print $query->start_form(-action=>"$script_name/addmod_authdb");
        print "<tr align=\"center\">\n";
        print "<td align=\"center\">\n";
        print "<b>URL</b>\n";
        print "</td>\n";

        print "<td align=\"center\">\n";
        print "<b>Unique ID</b>\n";
        print "</td>\n";
        print "</tr>\n";

        my $counter=1;

        print $query->hidden("\@hidden\@$k","$v");
        print $query->hidden("DocumentRoot","@g_document_roota");

        print "<tr>\n";
        print "<td>\n";
        print $query->textfield(-name=>"url_$counter",
                -value=>"$g_document_root",
                -label=>'',
                -size=>50);
        print "</td>\n";

        print "<td>\n";
        print $query->textfield(-name=>"md5_$counter",
                -value=>"id",
                -default=>'',
                -size=>33);
        print "</td>\n";
        print "</tr>\n";

        print "<tr>\n";
        print "<td colspan=2 align=\"center\">\n";
        &hLine("#aaaaaa");
        print $query->submit(-label=>'Submit',
                -value=>'Submit');
        print "</td>\n";
        print "</tr>\n";
        print $query->end_form;
        print "</table>\n";
        print "</center>\n";

    }

    untie %h;
}


##-----
# printEditAuthdbForm2()
# form to edit auth database with a single text area instead of
# two text fields. It can be useful to paset large number of urls instead
# of typing
#------
sub printEditAuthdbForm2
{
    my $userid=shift;

    use vars qw(%h $k $v);

    my @u=();
    my $urls;
    my $len;
    my $subs='';
    my $a='';
    my $line='';
    

    &myDebug("userid=$userid");

    if (! $userid)
    {
        &printError("No userid specified!");
        return;
    }

    &myDebug("doc root=@g_document_roota");

    doLock();
    # open authdb for reading
    my $x=tie %h,'AnyDBM_File',"$gauth_db",$g_r_flag,$g_mode;
    if (!$x)
    {
        &printError("could not open auth database: $gauth_db for reading");
        return;
    }

    my %uh=();
    while (($k,$v)=each %h)
    {
        # remove terminating null from key. 
        $k =~ s/\x00$//;
        $v =~ s/\x00$//;

        my $u;
        foreach $u (@g_document_roota)
        {
            $len=length($u);
            $subs=substr($k,0,$len);
            if ($subs eq $u)
            {
                $line="$k\t$v";
                push(@u,$line);    
            }
        }
    }

    $urls=@u;
    if ($urls >= 1)
    {

        print "<center><b>Add/Modify Authdb</b></center><br>\n";
        print "<b>Userid:</b> $userid<br>\n";
        print "<b>Document root:</b> $g_document_root<br>\n";
        print "<br>\n";
        print<<EOF;
        To add a new URL to the auth database, edit any exising URL, BUT
        leave the <b>ID</b> field empty. If you want the new URL to
        be counted as an existing one, insert the <b>ID</b> of an
        existing URL.
        To delete an URL, click on the toggle button and press Submit.
            
EOF
;

        my $counter=0;
        my @linea=();
        my $line='';
        foreach $a (@u)
        {
            $counter++;
            ($k,$v)=split(/\t/,$a);
            $line .= "${k}=>${v}\n";

            push(@linea,$line);
        }

#        $uline="@linea";

        print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

        print $query->start_form(-action=>"$script_name/addmod_authdb");
        print "<tr align=\"center\">\n";
            print "<td nowrap>\n";
            print $query->hidden("\@hidden\@$k","$v");
            print $query->hidden("DocumentRoot","@g_document_roota");

            print $query->textarea(-name=>"md5_$counter",
                    -value=>"$line",
                    -rows=>scalar(@linea)+10,
                    -linebreak=>'true',
                    -columns=>80);
            print "</td>\n";
            print "</tr>\n";

        print "<td align=\"center\">\n";
#        &hLine("#aaaaaa");
        print $query->submit(-label=>'Submit',
                -value=>'Submit');
        print "</td>\n";
        print "</tr>\n";
        print $query->end_form;
        print "</table>\n";
        print "</center>\n";
    }
    else
    {
        print "<center>\n";
        print "<h2>Add URLs to Authtdb</h2>\n";
        print "<b>Userid:</b> $userid<br>\n";
        print "<b>Document root:</b> $g_document_root<br>\n";
        print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

        print $query->start_form(-action=>"$script_name/addmod_authdb");
        print "<tr align=\"center\">\n";
        print "<td align=\"center\">\n";
        print "<b>URL</b>\n";
        print "</td>\n";

        print "<td align=\"center\">\n";
        print "<b>Unique ID</b>\n";
        print "</td>\n";
        print "</tr>\n";

        my $counter=1;

        print $query->hidden("\@hidden\@$k","$v");
        print $query->hidden("DocumentRoot","@g_document_roota");

        print "<tr>\n";
        print "<td>\n";
        print $query->textfield(-name=>"url_$counter",
                -value=>"$g_document_root",
                -label=>'',
                -size=>50);
        print "</td>\n";

        print "<td>\n";
        print $query->textfield(-name=>"md5_$counter",
                -value=>"id",
                -size=>33);
        print "</td>\n";
        print "</tr>\n";

        print "<tr>\n";
        print "<td colspan=2 align=\"center\">\n";
        &hLine("#aaaaaa");
        print $query->submit(-label=>'Submit',
                -value=>'Submit');
        print "</td>\n";
        print "</tr>\n";
        print $query->end_form;
        print "</table>\n";
        print "</center>\n";

    }

    untie %h;
}




##-----
# printHitsModifyForm()
#  Open the auth and counter database. Match the MD5 from auth db and 
#  Counter and show the URL and Hits. Allow edit the hits. Without the Auth
#  db, there's no way to know what thouse cryptinc md5 hash means.
##-----
sub printHitsModifyForm
{
    my $userid=shift;

    use vars qw(%h $k $v);
    my @a=();
    my $urls=0;
    my $url='';
    my $hits='';
    my $line='';
    my $i;
    my $counter=0;
    my $len;
    my $subs='';

    if (!$userid)
    {
        return;
    }


    # get the counter db content. in the hash, the key is the url
    # and the value is the hit. the url is obtained by matching the md5
    # from the Authdb
    my %ch=&getCountdb();
    $urls++ if %ch;

    $counter=0;
    if ($urls >= 1)
    {
        print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

        print "Userid: <b>$userid</b><br>\n";
        print "Allowed to edit Document root:<br>";
        
        foreach (@g_document_roota)
        {
            print "&nbsp;&nbsp;<a href=\"$_\">$_</a><br>\n";
        }
        print $query->start_form(-action=>"$script_name/modify");

        print "<tr align=\"center\">\n";
        print "<td align=\"center\">\n";
        print "URL\n";
        &hLine("#aaaaaa");
        print "</td>\n";

        print "<td align=\"center\">\n";
        print "Hits\n";
        &hLine("#aaaaaa");
        print "</tr>\n";

        # as many urls can have same md5, we need to weed out the dups
        my %th=();
        my $md5;
        my @t;
        foreach $url (sort keys %ch)
        {
            @t=split(/\t/,$ch{$url});
            $hits=$t[1];
            $md5=$t[0];
            $th{$md5}="${url}\t${hits}";
        }

        # hash has md5 as key, url<tab>hits as value
        foreach $md5 (sort keys %th)
        {
            $counter++;
            print "<tr>\n";
            if ($counter % 2 == 0)
            {
                print "<td align=\"right\" bgcolor=\"#dddddd\">\n";
            }
            else
            {
                print "<td align=\"right\">\n";
            }
            ($url,$hits)=split(/\t/,$th{$md5});
            my @t=split(/\t/,$ch{$i});
            print "<b>$counter</b>. <a href=\"$url\">$url<\/a>\n";
            print "<br><font size=\"2\">(ID= $md5)</font>\n";
            print "</td>\n";

            # URL is only for display, we need to pass the md5 and hits
            # pair as hidden. We'll store the md5 as key and the hits as
            # value in the counter database
            print $query->hidden("\@MD5_HIDDEN\@${md5}","${url}\t${hits}");

            if ($counter % 2 == 0)
            {
                print "<td bgcolor=\"#dddddd\">\n";
            }
            else
            {
                print "<td>\n";
            }
            print $query->textfield(-name=>"hits_$counter",
                    -value=>"$hits",
                    -size=>12);
            print "</td>\n";
            print "</tr>\n";
        }

        #------------- submit
        print "<td colspan=2 align=\"center\">\n";
        &hLine("#aaaaaa");
        print $query->submit(-label=>'Submit',
                -value=>'Submit');
        print "</td>\n";
        print "</tr>\n";

        print $query->end_form;
        print "</table>\n";

    }
    else
    {
        &printError("<center>No match found in Count database with document root:<br><b>$g_document_root</b></center>");
    }


#    print "urls=$urls<br>" if $g_debug;

    untie %h;
}

##------
# printError() - print error message
##------
sub printError
{
    my $em=shift;
    print<<EOF;
<center>
        <table border=0 bgcolor="#000000" cellpadding=0 cellspacing=0 width="60%">
        <tr>
            <td>
                <table border=0 width="100%" cellpadding=5 cellspacing=1>
                    <tr">
                        <td bgcolor="#ffefd5" width="100%">
                        
                        <font color="#ff0000"><b>Error -</b></font>
                        $em</td>
                    </tr>
                </table>
            </td>
        </tr>
            
        </table>
</center>
<p>
EOF
;
}


##--
# validate login name
# returns 1, if validated successfully
#         0 if  validation fails due to password or non existence of login 
#           name in text database
##--
sub validateUser
{
    my $rc=0;
    my ($u,$p,$http,$url);
    my $userid=$query->param('userid');
    my $plain_pass=$query->param('password');

    # open the text database
    unless(open(PFD,$guser_textdb))
    {
        &printError("Could not open user text database: $guser_textdb");
        return;
    }

    # first check if user exist
    my $document_root='';
    my $tmp='';
    my $line='';
    my $error='';
    while (<PFD>)
    {
        $line=$_;
        chomp($line);
        next if ($line =~ /^#/);
        ($u,$g_edit_authdb,$p,$tmp)=split(/\|/,$line);
        # if the $tmp has a tag like file=something then we assume the
        # list of document root is in a file and each line contains a URL
        if ($tmp =~ /file=/)
        {
            $tmp =~ s/file=//g;
            $document_root=&getDocRootFromFile($tmp);
        }
        else
        {
            $document_root=$tmp;
        }
        $error .= "No Userid in: $guser_textdb<br>" if (! $u);
        $error .= "No boolean to specify whether en user can edit Auth database of not in: $guser_textdb" if (! $g_edit_authdb);
        $error .= "No Password in: guser_textdb<br>" if (! $p);
        $error .= "No document root in: $guser_textdb<br>" if (!  $document_root);

        if ($userid eq $u)
        {
            &myDebug("docroot=$document_root");
            @g_document_roota=split(/,/,$document_root);
            $rc=1;
            last;
        }
    }
    close(PFD);

    if ($error)
    {
        &printError($error);
        exit;
    }

    &myDebug("g_document_roota=@g_document_roota");
    if (crypt($plain_pass,$p) ne $p)
    {
        $rc=0;
    }

    return ($rc);
}



sub compareArrays
{
#
# by Jim, Feb-04-1998
#
    my($a1,$a2) = @_;
    # a1 is pointer to array
    # a2 is pointer to array

    my($i);

    unless(scalar(@$a1) == scalar(@$a2))
    {
        return 0;
    }

    for($i=0; $i < scalar(@$a1) ; ++$i)
    {
        unless($$a1[$i] eq $$a2[$i])
        {
            return 0;
        }
    }

    return 1;
}


#------
# doModify
#------
sub doModify
{
    my @hiddena=();
    my @a=();
    my @b=();
    my %normal=();
    my %changed=();
    my %urlh=();
    my $url='';
    my $ov='';
    my $nv='';
    my $name;
    my $dirty_flag=0;
    my $line='';
    my $i;
    my $md5='';
    my $hits='';
    my $counter=0;
    my $q='';
    my $u='';
    my $v='';
    my $first=1;
    my $updated='';


    my $userid=$query->param('userid');
    my @allparams=$query->param;

    # allparams had hidden and normal field values. hiddens are the
    # original. Fortunately, order is hidden then normal. So we'll separate
    # the hidden and normals in two arrays. The array which contains the
    # hidden values, the content is, md5:value. But the normal array b
    # contains just the normal values. Then we'll go through all the
    # elements of array a and check if the value of the array with the
    # same index is same or not. If not same, the value is changed, update
    # the database. 
    # --muquit, Aug-14-1999
    foreach $name (@allparams)
    {
        $q=$query->param($name);
        $line="$name\t$q";
        if ($name =~ /\@MD5_HIDDEN\@/)
        {
            push(@a,$line);
        }
        else
        {
            # value from the text field
            push(@b,$q);
        }
    }


    $counter=0;
    foreach $i (@a)
    {
        ($md5,$url,$hits)=split(/\t/,$i);
        $md5 =~ s/\@MD5_HIDDEN\@//g;
        if ($b[$counter] ne $hits)
        {
            $changed{$md5}=$b[$counter];
            $urlh{$md5}=$url;
            $dirty_flag=1;
        }
        $counter++;
    }
    if ($dirty_flag == 0)
    {

        &printError("Nothing to update!");
        exit;
    }
    else
    {
        # open the database for updating.
        doLock();
        my $x=tie %h,'AnyDBM_File',"$gcounter_db",$g_rw_flag,$g_mode;

        if (!$x)
        {
            &printError("Could not open Counter database: $gcounter_db for writing");
            exit;
        }


        foreach $md5 (sort keys %changed)
        {
            $u= $md5;
            $v=$changed{$md5};

            # NULL terminate the key and value
            $u="$u\x00";
            $v="$v\x00";

            # make sure value is a number
            my $tmp=$v;
            $tmp =~ s/\x00//;
            if ($tmp =~ /\D/)
            {
                $u =~ s/\x00//;
                $v =~ s/\x00//;
                &printError("Key: <b>$u</b> rejected<br> value <b>$v</b> is not a number");
                next;
            }


            $h{$u}=$v;
            if ($first)
            {
                $updated="<b>Database updated</b><br>";
                $first=0;
            }
            else
            {
                $updated='';
            }
    print<<EOF;
<center>
    $updated
        <table border=0 bgcolor="#c0c0c0" cellpadding=0 cellspacing=0 
        width="60%">
        <tr>
            <td>
                <table border=0 width="100%" cellpadding=10 cellspacing=2>
                    <tr align="center">
                        <td bgcolor="#000099" width="100%" align="right">
                        <font color="#00ffff">
$md5
<br>
<a href="$urlh{$md5}">$urlh{$md5}</a>
                        </font>
                        </td>
                        <td bgcolor="#000099" width="100%" align="right">
                        <font color="#00ffff">
$changed{$md5}
                        </font>
                        </td>


                    </tr>
                </table>
            </td>
        </tr>
            
        </table>
</center>
<p>
EOF
;

        }

        untie %h;
    }

    exit;
}


#-----------------
# horizontal line
#-----------------
sub hLine
{
    my $color=shift;

    print<<EOL;
    <br>
    <table border=0 cellspacing=0 cellpadding=0 width=100%>
        <tr>
            <td bgcolor="$color" colspan=4>
               <table border=0 cellspacing=0 cellpadding=0>
                    <tr>
                        <td height=3></td>
                    </tr>
               </table>

            </td>
        </tr>
    </table>
<p>
EOL
;
}

##---
# printHelp()
#----
sub printHelp
{
        &hLine("#000088");
    print<<EOF;
    <blockquote>
        <h2>Counter Hits administration Help</h2>
    </blockquote>
EOF
;
}
sub LOCK_SH { 1 }
sub LOCK_EX { 2 }
sub LOCK_NB { 4 }
sub LOCK_UN { 8 }

#---
# doLock()
#---
sub doLock
{
    unless (open(LOCK_FD,$gcouter_lock_file))
    {
        &printError("Unable to lock, opening file $gcouter_lock_file failed");
        return;
    }
    unless (flock(LOCK_FD,LOCK_SH|LOCK_NB))
    {
        unless (flock(LOCK_FD,LOCK_SH))
        {
            &printError("Unable to lock, flock() failed");
            return;
        }
    }
}

##-----
# doAddOrModifyAuthdb()
# add or modify auth database
#------
sub doAddOrModifyAuthdb
{
    my @hiddena=();
    my %hiddenh=();
    my @a=();
    my @b=();
    my %hidden=();
    my %normal=();
    my %changed=();
    my $ov='';
    my $nv='';
    my $name;
    my $dirty_flag=0;
    my $line='';
    my $i;
    my $url_h='';
    my $comment_h='';
    my $url='';
    my $comment='';
    my $counter=0;
    my $q='';
    my $u='';
    my $v='';
    my $first=1;
    my $updated='';
    my $docroot='';
    my $len;
    my $subs='';
    my @cba=();

    my $url;
    my $userid=$query->param('userid');
    my @allparams=$query->param;

    my $key='';
    my $value='';

    $docroot=$query->param('DocumentRoot');
    if (! $docroot)
    {
        &printError("No document root found, aborting!");
        exit;
    }
    $len=length($docroot);
    &myDebug("Docroot=$docroot");

    foreach $name (@allparams)
    {
        $key='';
        $value='';
        $q=$query->param($name);
        $line="$name\t$q";
        if ($name eq 'DocumentRoot')
        {
            next;
        }
        if ($name eq 'selecturl')
        {
            # delete url
            @cba=$query->param($name);
            next;
        }

        if ($name =~ /\@hidden\@/)
        {
#            &myDebug("Hidden=$name");
            push(@a,$line);
        }
        else
        {
            if ($name =~ /url_[0-9]+/)
            {
                $key=$query->param($name);

                my $comm =$name;
                $comm =~ /url_([0-9]+)/;
                $comm="md5_$1";
                $value=$query->param($comm);
            }
            
            # value can be empty. if so we'll compute the md5 of it
            if ($key)
            {
                if (! $value)
                {
                    $value=md5_hex($key);
                }
                $line="$key\t$value";
                push(@b,$line);
            }

        }
    }

    $counter=0;
    $dirty_flag=0;
    # find the changed ones
    foreach $i (@a)
    {
        ($url_h,$comment_h)=split(/\t/,$i);
        $url_h =~ s/\@hidden\@//;

        ($url,$comment)=split(/\t/,$b[$counter]);
        if (($url_h ne $url) || ($comment_h ne $comment))
        {
            $changed{$url}=$comment;
            $dirty_flag=1;
        }
        $counter++;
    }


######
    my $u;
    # store the original url/md5 in a hash
    foreach $u (@a)
    {
        my $l=$u;
        $l =~ s/\@hidden\@//;
        my ($url_h,$md5_h)=split(/\t/,$l);
        $hiddenh{$url_h}=$md5_h;
##        &myDebug("$url_h=>$md5_h");
    }

    if ($dirty_flag == 0)
    {
        if(scalar(@cba))
        {
##            &myDebug("delete array=@cba");
        }
    }
    else
    {
        my $ok=0;
        foreach $url (sort keys %changed)
        {
            last if $ok == 1;
            &myDebug("<b>Changed:</b> $url=>$changed{$url}");
            # verify if the md5 is one of the users's own or the corrent
            # md5 of the url. 
            my $md5=md5_hex($url);
            
            # if the value is the md5 of the url, no further check needed
            if ($md5 eq $changed{$url})
            {
                $ok=1;
                last;
            }
            else
            {
                # go through all the original url/md5 pairs we stored in
                # hidden vars to verify if the md5 val is any of the old
                # ones. if not don't allow as the user might input someone
                # elses md5
                foreach $u (keys %hiddenh)
                {
                    if ($changed{$url} eq $hiddenh{$u})
                    {
                        $ok=1;
                        &myDebug("OK: url=$url,$u<br>$changed{$url}, $hiddenh{$u}");
                        last;
                    }
                }
                last if ($ok == 1);

                my $msg=<<EOF;
                ID of <a href=\"http://$url\">$url</a> is invalid<br>
You can specify the exact ID: <code>$md5</code><br>
or use one from one of your own URLs. If this URL is an alias for another
URL, specify the ID of that that URL. Note: a page can be accessed by
many different URLs, for example all the URLs below points to the same page, so
they all shoudl have the same ID.<br>

<a href="http://www.muquit.com/">http://www.muquit.com</a> or <br>
<a href="http://muquit.com/">http://muquit.com/</a> or <br>
<a href="http://www.muquit.com/index.html">http://www.muquit.com/index.html</a> or <br>
<a href="http://muquit.com/index.html">http://muquit.com/index.html</a> or
<br>
<a href="http://209.145.38.154/">http://209.145.38.154/</a> or <br>
<a href="http://209.145.38.154/index.html">http://209.145.38.154/index.html</a>
<br>
If they don't have the same ID, acess hits to each page will be different.
</pre>
EOF
;
                &printError("$msg");
            }

        }
    }
######

    my $u;
    foreach $u (@a)
    {
        my $l=$u;
        $l =~ s/\@hidden\@//;
        my ($url_h,$md5_h)=split(/\t/,$l);
##       &myDebug("$url_h=>$md5_h");
    }

    &myDebug("dirty_flag=$dirty_flag");
    my $rc;
    if ($dirty_flag == 1)
    {
        foreach $u (keys %changed)
        {
##           &myDebug("XXX $u, $changed{$u}");
            $rc=&isUrlInDocRoot($u);
           &myDebug("rc=$rc,u=$u");

           # check if the URL exists or not. It uses the program lwp-reqest
           # which comes with Perl LWP module to check if the URL exists or
           # not
           if ($check_url == 1)
           {
               my $command="$check_url_prog $u";
               my $status=`$command`;
               if ($status !~ /200 OK/)
               {
                   &printError("Url <a href=\"$u\">$u</a> does not exist");
               }
           }
        }
    }

    # note: delete only works if nothing has changed. if anything changed,
    # we won't be in the code segment which deletes.
    if ($dirty_flag == 0)
    {
        # delete
        if (scalar(@cba))
        {
            # open the auth database for writing
            doLock();
            my $x=tie %h,'AnyDBM_File',"$gauth_db",$g_rw_flag,$g_mode;
            if (!$x)
            {
                &printError("Could not open Authdatabase: $gauth_db for writing");
                exit;
            }
            foreach (@cba)
            {

                my $delurl="$_";

                #make sure the user can delete her own url only
                if (&isUrlInDocRoot($delurl) == 0)
                {
                    my $msg=<<EOF;
Will not delete URL <i>$u</i>. <br>It violates the document root: <i>$docroot</i> set by the admin. Note, you only can delete your own URL.<br>
EOF
;

                    &printError("$msg");
                }
                else
                {
                    # NULL terminate the key
                    $delurl="$delurl\x00";
                    delete $h{$delurl};
                    if ($first)
                    {
                        $updated="<b>Auth database updated, deleted URL</b><br>";
                        $first=0;
                    }
                    else
                    {
                        $updated='';
                    }

print<<EOF;
<center>
$updated
    <table border=0 bgcolor="#c0c0c0" cellpadding=0 cellspacing=0 
    width="60%">
    <tr>
        <td>
            <table border=0 width="100%" cellpadding=10 cellspacing=2>
                <tr align="center">
                    <td bgcolor="#000099" width="100%" align="right" nowrap>
                    <font color="#00ffff">
<a href="$delurl">$delurl</a>
                    </font>
                    </td>
                    <td bgcolor="#000099" width="100%" align="right" nowrap>
                    <font color="#00ffff">
-not shown-
                    </font>
                    </td>


                </tr>
            </table>
        </td>
    </tr>
        
    </table>
</center>
EOF
;
                }
            }

            if ($x)
            {
                untie %h;
            }
        }
        else
        {
            &printError("Nothing to update!");
        }

        exit;
    }
    else
    {
        $first=1;
        # open the auth database for writing
        doLock();
        my $x=tie %h,'AnyDBM_File',"$gauth_db",$g_rw_flag,$g_mode;
        if (!$x)
        {
            &printError("Could not open auth database: $gauth_db for writing");
            exit;
        }

        foreach $url (sort keys %changed)
        {
            $u= $url;
            $u =~ s/\@hidden\@//;
            $v=$changed{$url};


            # It is critical that the
            # user can only updated her own URL. so the the user's docroot must
            # be present in the supplied URL.
            # cut out the document root from the url, it must be equal
            # to the document root set by the admin the count_admin.txt
            # file
            # --muquit Aug-18-199
            my $rc=&isUrlInDocRoot($u);
            if ($rc == 0)
            {
                my $umsg=<<EOF;
Ignoring URL 
    <a href="$u">$u</a>. It violates the document root/s: 
&nbsp;&nbsp;<code><b>$docroot</b></code>
    <br>set by
    the admin. Note, you only can update your own URL.
EOF
;
                &printError("$umsg");
                print "<br>\n";
                next;
            }

            # NULL terminate the key and value
            $u="$u\x00";
            $v="$v\x00";
            $h{$u}=$v;
            
            if ($first)
            {
                $updated="<b>Auth database updated</b><br>";
                $first=0;
            }
            else
            {
                $updated='';
            }
    print<<EOF;
<center>
    $updated
        <table border=0 bgcolor="#c0c0c0" cellpadding=0 cellspacing=0 
        width="60%">
        <tr>
            <td>
                <table border=0 width="100%" cellpadding=10 cellspacing=2>
                    <tr align="center">
                        <td bgcolor="#000099" width="100%" align="right" nowrap>
                        <font color="#00ffff">
<a href="$u">$u</a>
                        </font>
                        </td>
                        <td bgcolor="#000099" width="100%" align="right" nowrap>
                        <font color="#00ffff">
$v
                        </font>
                        </td>


                    </tr>
                </table>
            </td>
        </tr>
            
        </table>
</center>
<p>
EOF
;

        }
        if ($x)
        {
            untie %h;
        }
    }
    exit;
}

##-----
# myDebug()
##-----
sub myDebug
{
    my $msg=shift;
    if ($g_debug)
    {
        print<<EOF;
        <code><font color="#000099">(DEBUG) $msg</font></code>
         <br>
EOF
;
    }
}

##----
# getAuthdb()
# opens the auth db for reading, returns the content as an hash. 
# the key is the URL the md5 is the val
# uses @g_document_roota, so this routine must be called after calling
# validateUser().
##----
sub getAuthdb
{
    use vars qw(%h $k $v);
    my %ah=();
    my $urls;
    my $len;
    my $subs='';
    my $a='';

    doLock();
    # open authdb for reading
    my $x=tie %h,'AnyDBM_File',"$gauth_db",$g_r_flag,$g_mode;
    if (!$x)
    {
        &printError("could not open auth database: $gauth_db for reading");
        return;
    }

    while (($k,$v)=each %h)
    {
        # remove terminating null from key. 
        $k =~ s/\x00$//;
        $v =~ s/\x00$//;

        my $u;
        foreach $u (@g_document_roota)
        {
            $len=length($u);
            $subs=substr($k,0,$len);
            if ($subs eq $u)
            {
                $ah{$k}=$v;
            }
        }
    }
    untie %h;

    return(%ah);
}

##-----
# getCountdb()
# get the content of counter db as hash for the docs of the user
# the key is the md5 digest, val is the md5<tab>hits
##------
sub getCountdb
{
    use vars qw(%h $k $v);
    my %ah;
    my %ch=();
    my $url;
    my $subs;
    my $hit;

    # get the auth db content for the user's urls
    %ah=getAuthdb();

    my $x=tie %h, 'AnyDBM_File', "$gcounter_db",O_RDONLY,0644;
    if (!$x)
    {
        &printError("Could not open Counter database: <b>$gcounter_db</b> for reading<br>$!");
        return;
    }

    my $len=length($g_document_roota[0]);
    foreach $url (keys %ah)
    {
        my $key="$ah{$url}";
        # add NULL at the end.
        $key =~ s/$/\x00/;
        $hit=$h{"$key"}; 
        if ($hit)
        {
            my @hits=split(/:/,$hit);

            # we need the hash to save the hits
            if (scalar(@hits))
            {
                $hit=$hits[0];
            }
            my $tmp="${ah{$url}}\t${hit}";

            # a url in the counter database has all possible form of it.
            # e.g., http://www.foo.com/index.html,
            # http://ipaddrss/index.html or http://www.foo.com/ indicates
            # the same URL, so we'll only show the one with the base
            # equals to the first url in the last field of count_admin.txt
            # database.
            $subs=substr($url,0,$len);
            if ($subs eq $g_document_roota[0])
            {
                $ch{$url}=$tmp;
            }
        }
    }

    untie %h;

    return(%ch);
}

##----
# isUrlInDocRoot()
# arg: $url
# returns 1 if the URL is in any of the docroot in count_admin.txt
##----
sub isUrlInDocRoot
{
    my $url=shift;
    my $docroot=$query->param('DocumentRoot');
    my @dra=();
    my $u;
    my $subs;
    my $len;

    if (!$docroot)
    {
        &printError("Document root is empty!");
        return(0);
    }
    @dra=split(/\s+/,$docroot);
    foreach $u (@dra)
    {
        $len=length($u);
        $subs=substr($url,0,$len);
        &myDebug("u=$u,$subs=$subs");
        if ($subs eq $u)
        {
            &myDebug("Match found=$subs,$u");
            return(1);
        }
    }

    return(0);
}

##-----
# getDocRootFromFile()
# returns get the command separated list of urls from a file each in a line
# arg: $file  - the full path of the file contains the list
##-----
sub getDocRootFromFile
{
    my $file=shift;
    my $urls='';
    local *FD;

    &myDebug("File=$file");
    unless(open(FD,$file))
    {
        &printError("Could not open file: $file");
        return($urls);
    }

    while (<FD>)
    {
        my $line=$_;
        chomp($line);
        next if (! $line);
        &myDebug("line=$line");
        $urls .= "$line,";
    }
    close(FD);
    $urls =~ s/,$//g;

    return ($urls);
}
