/*
**  test the ldbm library
**  the program is similar to the ones comes with gdbm source code. I only
**  called with generic function call.
**
** Does not work with Berkeley DB2, only works with 1.85
**  
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Apr-18-1998    first cut
*/

#include <stdio.h>
#include "ldbm.h"

#define TRUE    1
#define FALSE   0

int main (int argc,char **argv) 
{
    char
        cmd_ch;

    Datum
        key_data,
        data_data,
        return_data;

    char
        key_line[500],
        data_line[1000];

    LDBM
        dbp;

#ifdef HAVE_BERKELEY_DB2
    DBC
        *dbch=NULL;
#endif 

    char
        done=FALSE;

    char
        *file_name;

    data_data.dptr=data_line;
    key_data.dptr=NULL;
    return_data.dptr=NULL;

    if (argc > 2)
    {
        (void) fprintf(stderr,"Usage: %s <dbm file>\n",argv[0]);
        exit(1);
    }

    if (argc > 1)
    {
        file_name=argv[1];
    }
    else
        file_name="junkdbm";

    dbp=ldbm_open(file_name,LDBM_WRCREAT,00644,0);
    /*
    if (dbp == NULL)
    {
        perror(file_name);
        exit(1);
    }
    */

    while (!done)
    {
        (void) fprintf(stderr,"testldbm> ");
        cmd_ch=getchar();
        while (getchar() != '\n');
        switch(cmd_ch)
        {
            case 'q':
            {
                done=TRUE;
                break;
            }

            case 'f':
            {
                (void) fprintf(stderr,"key -> ");
                gets(key_line);
                key_data.dptr=key_line;
                key_data.dsize=strlen(key_line)+1;
                return_data=ldbm_fetch(dbp,key_data);
                if (return_data.dptr != NULL)
                    (void) fprintf(stderr,"data is -> %s\n\n",
                                   return_data.dptr);
                else
                    (void) fprintf(stderr,"No such item found.\n\n");
                break;
            }

            case 's':
            {
                (void) fprintf(stderr,"key -> ");
                gets(key_line);
                key_data.dptr=key_line;
                key_data.dsize=strlen(key_line)+1;
                (void) fprintf(stderr,"data -> ");
                gets(data_line);
                data_data.dsize=strlen(data_line)+1;
                if (ldbm_store(dbp,key_data,data_data,LDBM_REPLACE) != 0)
                    (void) fprintf(stderr,"Item not inserted.\n");
                (void) fprintf(stderr,"\n");
                break;
            }

            case 'd':
            {
                (void) fprintf(stderr,"key -> ");
                gets(key_line);
                key_data.dptr=key_line;
                key_data.dsize=strlen(key_line)+1;
                if (ldbm_delete(dbp,key_data) != 0)
                    (void) fprintf(stderr,"Item not found or deleted\n");
                (void) fprintf(stderr,"\n");

                break;
            }

            case '1':
            {
#ifdef HAVE_BERKELEY_DB2
                key_data=ldbm_firstkey(dbp,&dbch);
#else
                key_data=ldbm_firstkey(dbp);
#endif /* HAVE_BERKELEY_DB2 */

                if (key_data.dptr != NULL)
                {
                    return_data=ldbm_fetch(dbp,key_data);
                    (void) fprintf(stderr,"key is ->%s\n",key_data.dptr);
                    (void) fprintf(stderr,"data is ->%s\n",return_data.dptr);
                }
                else
                    (void) fprintf(stderr,"No such item found.\n\n");
                break;
            }

            case '2':
            {
#ifdef HAVE_BERKELEY_DB2
                return_data=ldbm_nextkey(dbp,key_data,dbch);
#else
                return_data=ldbm_nextkey(dbp,key_data);
#endif /* HAVE_BERKELEY_DB2 */
                if (return_data.dptr != NULL)
                {
                    ldbm_datum_free(dbp,key_data);
                    key_data=return_data;
                    (void) fprintf(stderr,"key is ->%s\n",key_data.dptr);
                    return_data=ldbm_fetch(dbp,key_data);
                    (void) fprintf(stderr,"data is ->%s\n",return_data.dptr);
                    ldbm_datum_free(dbp,return_data);
                }
                else
                    (void) fprintf(stderr,"No such item found.\n\n");
                break;
            }

            case 'c':
            {
                int
                    temp;
                temp=0;
#ifdef HAVE_BERKELEY_DB2
                return_data=ldbm_firstkey(dbp,&dbch);
#else
                return_data=ldbm_firstkey(dbp);
#endif /* HAVE_BERKELEY_DB2 */

                while (return_data.dptr != NULL)
                {
                    temp++;
                    key_data=return_data;
#ifdef HAVE_BERKELEY_DB2
                    return_data=ldbm_nextkey(dbp,key_data,dbch);
#else
                    return_data=ldbm_nextkey(dbp,key_data);
#endif /* HAVE_BERKELEY_DB2 */
                }
                (void) fprintf(stderr,"There are %d items in the database.\n\n",temp);
                break;
            }

            case '?':
            {

                  printf ("c - count elements\n");
                  printf ("d - delete\n");
                  printf ("f - fetch\n");
                  printf ("q - quit\n");
                  printf ("s - store\n");
                  printf ("1 - firstkey\n");
                  printf ("2 - nextkey on last return value\n\n");

                break;
            }

        }
    }

    ldbm_close(dbp);
    exit(0);
}


