#!/bin/sh
##
## based on the Type of Database in use, fix the Perl script
## muquit, Aug-17-1999

#if test $# -lt 1; then
#    echo "usage:`basename $0` db_type"
#    exit
#fi

#db_type="$1";
template="./utils/count_admin/count_admin.cgi.tmpl"
template2="./utils/dumpdb/dumpdb.pl.tmpl"
prog3="./utils/count_admin/count_admin_help.cgi"

modules_order='DB_File GDNM_File NDBM_File'
db_module='DB_File'

to_prog="./bin/count_admin.cgi"
to_prog2="./bin/dumpdb.pl"

if test ! -f $template; then
    echo "template $template not found"
    exit
fi

ok="notok"
ctmpl="./Config.tmpl"

if test -f "$ctmpl"; then
    . $ctmpl
    database="$DATABASE_DIR/$COUNT_DATABASE"
    lockfile="$DATABASE_DIR/$DB_LOCKFILE"
    authdb="$DATABASE_DIR/$AUTH_DATABASE"
else
    echo "Could not find $ctmpl, will not be able to configure"
    echo "count_admn.cgi program"
    exit
fi

# make sure .dbfile is there. it's get created by the configure. the datbase
# type is written to it
dbtf="./.dbtype"
if test -f $dbtf; then
    db_type=`cat $dbtf`
    if test "x$db_type" != "x"; then
        if test "$db_type" = "LDBM_USE_DBHASH"; then
            modules_order='DB_File GDBM_File NDBM_File'
            dbm_module='DB_File'
            ok="ok"
        fi 

        if test "$db_type" = "LDBM_USE_GDBM"; then
            modules_order='GDBM_File DB_File NDBM_File'
            db_module='GDBM_File'
            ok="ok"
        fi

        if test "$db_type" = "LDBM_USE_SDBM"; then
            modules_order='SDBM_File DB_File GDBM_File NDBM_File'
            db_module='SDBM_File'
            ok="ok"
        fi
        if test "$db_type" = "LDBM_USE_NDBM"; then
            modules_order='NDBM_File DB_File GDBM_File'
            db_module='NDBM_File'
            ok="ok"
        fi

    else
        exit
    fi
else
    exit;
fi

mwhich="./bin/mwhich"

if test ! -f "./bin/mwhich"; then
    echo "Utility $mwhich not found, will not fix CGI scripts"
    exit
fi
perl=`$mwhich perl` 
if test "$perl" != "not found"; then
    echo "perl found:  $perl"
else
    echo "Perl not found in path, won't be able to use count_admin.cgi"
    exit
fi

if test $ok = "ok"; then
sed -e " s,@PERL_PATH@,$perl,
         s,@MODULES_ORDER@,$modules_order,
         s,@DBMODULE@,$db_module,
         s,@COUNTER_DB@,$database,
         s,@AUTH_DB@,$authdb,
         s,@DB_LOCK@,$lockfile,
" < $template > $to_prog
chmod 755 $to_prog
echo "Prepared $to_prog with $db_module"

sed -e " s,@PERL_PATH@,$perl,
         s,@MODULES_ORDER@,$modules_order,
" < $template2 > $to_prog2
chmod 755 $to_prog2
echo "Prepared $to_prog2 with $db_module"

if test -f $prog3; then
    cp $prog3 ./bin
fi

fi
