dnl borrowed from PHP (http://www.php.net/ aclocal.m4 file
dnl Muhammad A Muquit, Jul-26-1999, hacking while sick at home
dnl 
dnl AC_PHP_ONCE(namespace, variable, code)
dnl
dnl execute code, if variable is not set in namespace
dnl
AC_DEFUN(AC_PHP_ONCE,[
  unique=`echo $ac_n "$2$ac_c" | tr -c -d a-zA-Z0-9`
  cmd="echo $ac_n \"\$$1$unique$ac_c\""
  if test -n "$unique" && test "`eval $cmd`" = "" ; then
    eval "$1$unique=set"
    $3
  fi
])

dnl
dnl AC_EXPAND_PATH(path, variable)
dnl
dnl expands path to an absolute path and assigns it to variable
dnl
AC_DEFUN(AC_EXPAND_PATH,[
  if test -z "$1" || echo "$1" | grep '^/' >/dev/null ; then
    $2="$1"
  else
    $2="`pwd`/$1"
  fi
])

dnl
dnl AC_ADD_INCLUDE(path)
dnl
dnl add a include path
dnl
AC_DEFUN(AC_ADD_INCLUDE,[
  AC_EXPAND_PATH($1, ai_p)
  AC_PHP_ONCE(INCLUDEPATH, $ai_p, [
    INCLUDES="$INCLUDES -I$ai_p"
  ])
])

dnl
dnl AC_ADD_INCLUDE(path)
dnl
dnl add a include path
dnl
AC_DEFUN(AC_ADD_INCLUDE,[
  AC_EXPAND_PATH($1, ai_p)
  AC_PHP_ONCE(INCLUDEPATH, $ai_p, [
    INCLUDES="$INCLUDES -I$ai_p"
  ])
])


dnl Assign INCLUDE/LFLAGS from PREFIX
AC_DEFUN(AC_DBA_STD_ASSIGN,[
  if test "$THIS_PREFIX" != "" -a "$THIS_PREFIX" != "/usr"; then
    THIS_INCLUDE="$THIS_PREFIX/include"
    THIS_LFLAGS="$THIS_PREFIX/lib"
  fi
])

dnl Standard check
AC_DEFUN(AC_DBA_STD_CHECK,[
  THIS_RESULT="yes"
  if test "$THIS_PREFIX" != "/usr"; then
  if test "$THIS_INCLUDE" = "" ; then
    AC_MSG_ERROR(cannot find necessary header file(s))
  elif test "$THIS_LIBS" = "" ; then
    AC_MSG_ERROR(cannot find necessary library)
  fi
  fi
])

dnl Attach THIS_x to DBA_x
AC_DEFUN(AC_DBA_STD_ATTACH,[
  AC_ADD_INCLUDE($THIS_INCLUDE)
  AC_ADD_LIBRARY_WITH_PATH($THIS_LIBS, $THIS_LFLAGS)

  THIS_INCLUDE=""
  THIS_LIBS=""
  THIS_LFLAGS=""
  THIS_PREFIX=""
])

AC_DEFUN(AC_TEMP_LDFLAGS,[
  old_LDFLAGS="$LDFLAGS"
  LDFLAGS="$1 $LDFLAGS"
  $2
  LDFLAGS="$old_LDFLAGS"
])

dnl
dnl AC_ADD_LIBRARY(library)
dnl
dnl add a library to the link line
dnl
AC_DEFUN(AC_ADD_LIBRARY,[
  AC_PHP_ONCE(LIBRARY, $1, [
    EXTRA_LIBS="$EXTRA_LIBS -l$1"
  ])
])

dnl
dnl AC_ADD_LIBPATH(path)
dnl
dnl add a library to linkpath/runpath
dnl
AC_DEFUN(AC_ADD_LIBPATH,[
  AC_EXPAND_PATH($1, ai_p)
  AC_PHP_ONCE(LIBPATH, $ai_p, [
    EXTRA_LIBS="$EXTRA_LIBS -L$ai_p"
    if test -n "$APXS" ; then
      RPATHS="$RPATHS ${apxs_runpath_switch}$ai_p'"
    else
      RPATHS="$RPATHS ${ld_runpath_switch}$ai_p"
    fi
  ])
])

dnl
dnl AC_ADD_LIBRARY_WITH_PATH(library, path)
dnl
dnl add a library to the link line and path to linkpath/runpath
dnl
AC_DEFUN(AC_ADD_LIBRARY_WITH_PATH,[
  AC_ADD_LIBPATH($2)
  AC_ADD_LIBRARY($1)
])

dnl Print the result message
AC_DEFUN(AC_DBA_STD_RESULT,[
  if test "$THIS_RESULT" = "yes"; then
    HAVE_DBA=1
    AC_MSG_RESULT(yes)
  else
    AC_MSG_RESULT(no)
  fi
  THIS_RESULT=""
])

