/* which - C version of the unix/csh 'which' command
 * vix 23jul86 [written]
 * vix 24jul86 [don't use dynamic memory]
 */

#include <stdio.h>

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h> /* ANSI string.h and pre-ANSI memory.h might conflict*/
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif
#else
#if  HAVE_STRINGS_H
#include <strings.h>
#endif
#endif


#if HAVE_CTYPE_H
#include <ctype.h>
#endif

#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#if SYS_UNIX
#include <sys/types.h>
#include <sys/stat.h>
#endif

#ifdef SYS_WIN32
#include <io.h>
#include <share.h>
#define ftruncate chsize
#endif

#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#if HAVE_STDLIB_H 
#include <stdlib.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_FCNTL_H
#ifndef O_RDONLY    /* prevent multiple inclusion on lame systems (from
vile)*/
#include <fcntl.h>
#endif
#endif

#if HAVE_MALLOC_H
#include <malloc.h>
#endif


#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

static int mWhich(name, path)
char	*name, *path;
{
	char
        test[1000],
        *pc,
        save;
	int	len, namelen = strlen(name), found;

	pc = path;
	found = 0;
	while (*pc != '\0' && found == 0)
	{
		len = 0;
		while (*pc != ':' && *pc != '\0')
		{
			len++;
			pc++;
		}

		save = *pc;
		*pc = '\0';
		sprintf(test, "%s/%s", pc-len, name);
		*pc = save;
		if (*pc)
			pc++;

		found = (0 == access(test, 01));	/* executable */
		if (found)
			puts(test);
	}
	if (found == 0)
	{
		printf("not found\n");
		return 1;
	}
	return 0;
}

int main(argc, argv)
int	argc;
char	*argv[];
{
	char	*getenv(), *path = getenv("PATH");

	for (argc--, argv++;  argc;  argc--, argv++)
		if (0 != mWhich(*argv, path))
			return(1);
    return(0);
}


