#!/usr/bin/perl
##
## a perl version to dump database. it will only work if the 2.x Berkeley
## db compiled with 1.85 API support.
##

BEGIN { @AnyDBM_File::ISA = qw(DB_File GDBM_File DB_File) }

use strict;
use Fcntl;
use AnyDBM_File ();


my $db_type='gdbm';



if ($#ARGV+1 < 1)
{
    print "Usage: $0 <db file>\n";
    exit;
}

my $db_file=$ARGV[0];

#print "dbfile: $db_file\n";

use vars qw( %h $k $v ) ;

tie %h, 'AnyDBM_File', "$db_file",O_RDONLY,0644
               or die "Cannot open file $db_file: $!\n";


while (($k,$v)=each %h)
{
    # remove terminating NULL
    $k =~ s/\x00$//;
    $v =~ s/\x00$//;

    print "$k=>$v\n";
}
untie %h;

