/*
**  show the url in the database
**
**  Limitations and Comments:
**  It can read berkeley db, GNU gdbm or ndbm database. It will link
**  with only one of the database.
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Jul-26-1999    first cut
*/


#include <stdio.h>
#include "ldbm.h"

#define TRUE    1
#define FALSE   0

#define R_VERSION_S   "1.2"

static int uSage(char *progname,char *dbtype)
{
    (void) fprintf(stderr,"-------------------------------------------------------------------------\n");
    (void) fprintf(stderr,"dumpdb version %s\n",R_VERSION_S);
    (void) fprintf(stderr,"Part of WWW Homepage Access Counter 2.6+\n");
    (void) fprintf(stderr,"http://www.muquit.com/muquit/software/Count/Count.html\n");
        (void) fprintf(stderr,"It supports any of:\n");
        (void) fprintf(stderr,"   Berkeley DB 1.x, 2.x, 3.x\n");
        (void) fprintf(stderr,"   GNU gdbm\n");
        (void) fprintf(stderr,"   ndbm\n");
        (void) fprintf(stderr,"   and sdbm.\n");
        (void) fprintf(stderr,"\n*This version is compiled with ");
#ifdef HAVE_BERKELEY_DB
        (void) fprintf(stderr,"Berkeley DB\n");
#ifdef DB_VERSION_MAJOR
        (void) fprintf(stderr,"   Major version: %d\n",DB_VERSION_MAJOR);
#endif /* DB_VERSION_MAJOR */
#ifdef DB_VERSION_MINOR
        (void) fprintf(stderr,"   Minor version: %d\n",DB_VERSION_MINOR);
#endif /* DB_VERSION_MINOR */
#endif /* HAVE_BERKELEY_DB */
    (void) fprintf(stderr,"\nThe program is compiled with %s support\n",dbtype);
        fprintf(stderr,"-------------------------------------------------------------------------\n");

    (void) fprintf(stderr,"\n");
    (void) fprintf(stderr," Usage: %s <db_file>\n\n",progname);
    exit(1);
}


int main (int argc,char **argv) 
{
    char
        cmd_ch;

    Datum
        key_data,
        return_data;

    LDBM
        dbp;

    char
        *dbtype="unknown",
        *file_name;

    LDBMCursor
        *dbch=NULL;

    key_data.dptr=NULL;
    return_data.dptr=NULL;

#ifdef LDBM_USE_DBBTREE
        dbtype="Berkey DbTree";
#endif /* LDBM_USE_DBBTREE */

#ifdef LDBM_USE_DBHASH
        dbtype="Berkey DbHash";
#endif /* LDBM_USE_DBHASH */

#ifdef LDBM_USE_GDBM
        dbtype="GNU gdbm";
#endif /* LDBM_USE_GDBM */

#ifdef LDBM_USE_SDBM
        dbtype="sdbm";
#endif /* LDBM_USE_SDBM */

#ifdef LDBM_USE_NDBM
        dbtype="ndbm";
#endif /* LDBM_USE_NDBM */

    if (argc != 2)
    {
        uSage("dumpdb",dbtype);

#if 0
        (void) fprintf(stderr,"dumpdb %s\n",VERSION_S);
        (void) fprintf(stderr,"Dump WWW Homepage access counter database\n");
        (void) fprintf(stderr,"<url:http://www.fccc.edu/users/muquit/Count.html\n\n");

#ifdef HAVE_BERKELEY_DB
        (void) fprintf(stderr,"Compiled with Berkeley DB:\n");
#ifdef DB_VERSION_MAJOR
        (void) fprintf(stderr,"   Major version: %d\n",DB_VERSION_MAJOR);
#endif /* DB_VERSION_MAJOR */
#ifdef DB_VERSION_MINOR
        (void) fprintf(stderr,"   Minor version: %d\n",DB_VERSION_MINOR);
#endif /* DB_VERSION_MINOR */
#endif /* HAVE_BERKELEY_DB */

#ifdef LDBM_USE_DBBTREE
        (void) fprintf(stderr,"(-compiled with Berkeyley DBTREE support-)\n\n");
        dbtype="Berkey db";
#endif /* LDBM_USE_DBBTREE */

#ifdef LDBM_USE_DBHASH
        (void) fprintf(stderr,"(-compiled with Berkeyley DBHASH support-)\n\n");
        dbtype="Berkey db";
#endif /* LDBM_USE_DBHASH */


#ifdef LDBM_USE_GDBM
        (void) fprintf(stderr,"Compiled with GNU dbm (gdbm) support\n\n");
        dbtype="GNU gdbm";
#endif /* LDBM_USE_GDBM */

#ifdef LDBM_USE_SDBM
        (void) fprintf(stderr,"Compiled with sdbm support\n\n");
        dbtype="sdbm";
#endif /* LDBM_USE_SDBM */

#ifdef LDBM_USE_NDBM
        (void) fprintf(stderr,"Compiled with ndbm support\n\n");
        dbtype="ndbm";
#endif /* LDBM_USE_NDBM */

        (void) fprintf(stderr,"Usage: %s <%s file>\n\n",argv[0],dbtype);
        exit(1);
#endif /* if 0 */

    }

    file_name=argv[1];
    if (file_name && file_name[0] == '-')
    {
        uSage("dumpdb",dbtype);
    }

    dbp=ldbm_open(file_name,LDBM_READER,00644,0);
    if (dbp == NULL)
    {
        (void) fprintf(stderr,"Failed to read database: %s\n",file_name);
        exit(1);
    }
#if DB_VERSION_MAJOR >=2 || DB_VERSION_MAJOR >=3 /* mm, dec-24-2000 */
    return_data=ldbm_firstkey(dbp,&dbch);
#else
    return_data=ldbm_firstkey(dbp,&dbch); /* FIXME */
#endif /* db < 2 */
    while (return_data.dptr != NULL)
    {
        key_data=return_data;
        return_data=ldbm_fetch(dbp,key_data);
        (void) fprintf(stdout,"%s=>%s\n",key_data.dptr,return_data.dptr);
        (void) fflush(stdout);
        ldbm_datum_free(dbp,return_data);

#if DB_VERSION_MAJOR >=2 || DB_VERSION_MAJOR >= 3
        if (dbch == NULL) /* first time */
            return_data=ldbm_firstkey(dbp,&dbch);
        else
            return_data=ldbm_nextkey(dbp,key_data,dbch);
#else
        return_data=ldbm_nextkey(dbp,key_data,dbch);
#endif /* db < 2 */
    }

    ldbm_close(dbp);
    exit(0);
}


