#!/usr/bin/perl
##
## muquit, Aug-17-199
## generate. <uid>|boolean|<crypted_password>|<document root> for 
## count_admin.cgi
## http://www.muquit.com/muquit/software/Count/Count.html
## modified, Sep-24-2000
## muquit@muquit.com  Dec-27-2000
#   - added one more fields to allow editing counter hits (2nd field) or not
#     3rd field for allow editing auth db or not
###################################################################

use strict;
use CGI qw/:standard :html3/;;

my $query=new CGI;
my $title="generate <uid>|<crypted_password>|<docuemet root> for CountAdmin.cgi";


##------
# printHTMLHeader()
##------
sub printHTMLHeader
{
    print $query->start_html(
            -title=>"$title",
            -bgcolor=>"#ffffff",
            -text=>"#000000");
}

print $query->header;
# print the HTML HEADER
&printHTMLHeader;

# print the HTML HEADER
&printHTMLHeader;

unless ($query->param)
{
    &printForm;
}
else
{
    &doWork;
}

#-------------
# print Form
#-------------
sub printForm
{
    print "<blockquote>\n";
    print<<EOF;
    <center><b>Helper program for 
        count_admin.cgi</b>
        <br>
        Counter page: 
<a href="http://www.muquit.com/muquit/software/Count/Count2.6/Count.html">
http://www.muquit.com/muquit/software/Count/Count2.6/Count.html</a>
        </center><br>
    This program is for administrators to help create the Countadmin.txt
    file to use with CountAdmin.cgi program. CountAdmin.cgi is a CGI script
    to allow users to administer their own counter values. Before the users
    can do that, the administrators must create a text file with userid,
    if the user is allowed to edit Authdb,
    crypted password and User's document root separated by a vertical bar |.
        <p>
     For example,
    if you enter Userid as foo, user is allowd to edit his counter hits
    and Auth database,
    user's Document root as
        <code>http://www.foo.com/~bar/,http://1.2.3.4/~bar/</code>
    and password as <code>foobar</code>, after pressing the Submit button, the
     output might look like:<p><center>
     <code><font color="#000099">foo|1|1|7nklhJX6IWTxA|http://www.foo.com/~bar/,http://1.2.3.4/~bar/</font></code>
     </center>
     <p>
     Look at the comma separated list of the Urls. You need to specify all 
     possible urls of the page as the page can be accessed different way.
     <p>
     You'll cut and paste the line put it at the end of the count_admin.txt
     file. The location of the file  count_admin.txt is specified with
     the variable <b>\$guser_textdb</b> in the program count_admin.pl.
EOF
;
    print "<center>\n";
    print "<table border=0 bgcolor=\"#c0c0c0\" cellpadding=5 cellspacing=0>\n";

    print $query->start_form,"\n";

    #------------- userid
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Userid:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->textfield(-name=>'userid',
            -size=>30);
    print "</td>\n";
    print "</tr>\n";

    #------------ Allowd editing Countdb or no
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Allow editing Counter hits:\n";
    print "</td>\n";
    print "<td>\n";
    print $query->radio_group(-name=>'countdb',
            -values=>['Yes','No'],
            -default=>'Yes');
    print "</td>\n";
    print "</tr>\n";




    #------------ Allow editing Auth db or not
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Allow editing Authdb:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->radio_group(-name=>'authdb',
            -values=>['Yes','No'],
            -default=>'Yes');
    print "</td>\n";
    print "</tr>\n";

    #------------- document root
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "User's Document root:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->textfield(-name=>'docroot',
            -size=>60);
    print "</td>\n";
    print "</tr>\n";



    #------------- password
    print "<tr>\n";
    print "<td align=\"right\">\n";
    print "Password:\n";
    print "</td>\n";

    print "<td>\n";
    print $query->password_field(-name=>'password',
            -size=>20);
    print "</td>\n";
    print "</tr>\n";

    # submit
    print "<tr>\n";
    print "<td colspan=2 align=\"center\">\n";
    print "<hr noshade size=1>\n";
    print $query->submit(-label=>'Submit',
            -value=>'Submit'),"\n";
    print "</td>\n";
    print "</tr>\n";

    print $query->end_form,"\n";

    print "</table>\n";
    print "</center>\n";

    print "</blockquote>\n";
}




sub doWork
{
    my @saltchars=('a'..'z','A'..'Z','0'..'9',',','/');
    my $salt='';
    my $crypted_pass='';
    my $word='';
    my $error='';

    my $userid=$query->param('userid');
    my $edit_countdb=$query->param('countdb');
    my $edit_authdb=$query->param('authdb');
    my $docroot=$query->param('docroot');
    my $password=$query->param('password');

    if (! $userid)
    {
        $error="No user id supplied<br>";
    }
    if (! $docroot)
    {
        $error .= "No document root supplied<br>";
    }
    if (! $password)
    {
        $error .= "No password supplied";
    }

    if ($error)
    {
        &printForm;
        &printError($error);
        return;
    }

    my $a1=0 if ($edit_countdb eq 'No');
    $a1=1 if ($edit_countdb eq 'Yes');

    my $a2=0 if ($edit_authdb eq 'No');
    $a2=1 if ($edit_authdb eq 'Yes');



    if (! $salt)
    {
        # random seed
        srand(time() ^ ($$ + ($$ << 15)));
        $salt=$saltchars[rand(64)].$saltchars[rand(64)];
        # why in the world salt is same all the time??? I'm puzzled
        # why rand() is returning same number all the time?? I'm puzzled
        # muquit, Aug-17-1999
    }

    $crypted_pass=crypt($password,$salt);

    &printForm;
    print "<hr>\n";
    print<<EOF;
    <center>
    Please cut and paste the followin the line put it at the end of the
    <font color="#000099"><code>count_admin.txt</code></font> file:
    <p>
    <code><font color="#000099"><b>$userid|$a1|$a2|$crypted_pass|$docroot</b></font></code>
    </center>
EOF
;

}

sub printError
{
    my $errmsg=shift;

    print "<hr noshade>\n";
    print "<center>\n";
    print "<font color=\"#ff0000\"><b>Error:<\/b><\/font>$errmsg";
    print "</center>\n";
}
