/*
** If you modify this or any file: Please DO NOT use tabs. I hate tabs.
** use 4 spaces instead of a tab. 
** - muquit@muquit.com 
*/

#ifdef __VMS
#include <fcntl.h>
#include <unixio.h>
#endif

#include "cdebug.h"
#include "combine.h"
#include "gdfonts.h"
#include "count.h"

#ifdef SYS_WIN32
#include "configNT.h"
#elif defined( __VMS )
#include "configVMS.h"
#else
#include "config.h"
#endif


#include <bigplus.h>

#ifdef USE_DATABASE
#include <ldbm.h>
#endif /* USE_DATABASE */

#define IP_LENGTH   16

/* protos */
static void add1toData       _Declare ((char *buf,int buflen));
static void getParts         _Declare ((char *allbuf,char *dbuf,char *ipbuf,
                                  int dbuf_size,int ipbuf_size));

#ifdef USE_DATABASE

static char *getCounterNumbuf _Declare ((LDBM dbp,char *preferer,
            char *remote_ip, int ignore_site,int do_increment,
            int use_st,int start_value));
static char *authReferer       _Declare((char *db_path,char *referer));

/*
** check if the referer is in the AUTH database.
** returns the value for the key if the key is found, NULL otherwise
**  exit if anything else goes wrong
*/
static char *authReferer(db_path,referer)
char
    *db_path;
char
    *referer;
{
    char
        *md5,
        szerrbuf[BUFSIZ];

    *szerrbuf='\0';

    md5=grepForKeyInDb(db_path,referer,szerrbuf);
    if (*szerrbuf != '\0')  /* an error has occured */
    {
        multilineStringImage(szerrbuf,ALIGN_CENTER,0,0,0,0,255,0);
        exit(0);
    }

    return (md5);
}


/*
**  rwCounterDatabase()
**  function to read and write counter data to a database. the function
**  does not do any locking. so you should use a better dtabase such as
**  Berkeley DB which does locking.
**
**  RCS
**      $Revision: 1.4 $
**      $Date: 2001/10/14 16:46:16 $
**  Return Values:
**      returns the buffer containing the counter digits in case of success.
**      in case of failure of some sort, the routine does not return, it
**      writes the error message image to the browser and exits with 0.
**
**  Parameters:
**
**
**  Side Effects:
**      the content of the counter datafile is modified.
**
**  Limitations and Comments:
**      The buffer returned points to a malloc'd space. the caller is
**      responsible to free this memory.
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Jul-25-1999    first cut
*/

char *rwCounterDatabase(dbpath,
                        key,           /* gg => dbkey */
                        remote_ip,
                        ignore_site,
                        use_st,
                        start_value,
                        do_increment)
char
    *dbpath;      /* full database path */

char
    *key;           /* gg => dbkey */

char
    *remote_ip;     /* remote IP, can be NULL, so check */

int
    ignore_site;    /* ignore this site or not */

int
    use_st;         /* use start value or not */

int
    start_value;    /* start value, used if use_st is true */

int
    do_increment;   /* should be counter be incremented */

{
    LDBM
        dbp=(LDBM) NULL;

    char
        *md5,
        *preferer=NULL,
        *q,
        *dbuf=NULL,
        *referer,
        szdb_path[BUFSIZ],
        szbuf[BUFSIZ],
        errbuf[BUFSIZ];

    *errbuf='\0';
    /* lock first */
    /* I will not worry about buffer overflow here as it is at compile time*/

#ifdef SYS_WIN32
    (void) strcpy(szbuf,g_sZ_vbase);
    (void) strcat(szbuf,DATABASE_DIR);
    (void) strcat(szbuf,DIR_SEPARATOR);
    (void) strcat(szbuf,DB_LOCKFILE);
#else
    (void) strcpy(szbuf,DATABASE_DIR);
    (void) strcat(szbuf,DIR_SEPARATOR);
    (void) strcat(szbuf,DB_LOCKFILE);
#endif /* SYS_WIN32 */

    mutilsDotLock(szbuf,errbuf);
    if (*errbuf != '\0')
    {
        multilineStringImage(errbuf,ALIGN_CENTER,0,0,0,0,255,0);
        exit(0);
    }
    Debug2("Opening database %s for writing",dbpath,0);
    /* open the database */
    dbp=ldbm_open(dbpath,LDBM_WRCREAT,00644,0);
    if (dbp == NULL)
    {
        (void) sprintf(szbuf,"Error opening database: %s",dbpath);
        Warning(szbuf);
        StringImage(szbuf);
        exit(0);            /* BYE BYE */
    }

    if (*key != '\0') /* gg => dbkey specified, go directly to count database */
    {
         preferer=mystrdup(key);
         dbuf=getCounterNumbuf(dbp,preferer,remote_ip,
             True, /* gg => ignore site */
            False, /* gg => do not increment */
            use_st,start_value);
    }
    else if (getcfgStrictMode() == True)
    {
        /* get the referer */
        referer=getenv("HTTP_REFERER");
        if (referer != NULL)
        {
            preferer=mystrdup(referer);
            if ((q=strrchr(preferer,'#')) != NULL)
                    *q='\0';

            /*  check if the referer is authorized in auth database*/
            /* make full path of auth database */

#ifdef SYS_WIN32
            (void) strcpy(szdb_path,g_sZ_vbase);
            (void) strcat(szdb_path,DATABASE_DIR);
            (void) strcat(szdb_path,DIR_SEPARATOR);
            (void) strcat(szdb_path,AUTH_DATABASE);
#else
            (void) strcpy(szdb_path,DATABASE_DIR);
            (void) strcat(szdb_path,DIR_SEPARATOR);
            (void) strcat(szdb_path,AUTH_DATABASE);
#endif /* SYS_WIN32 */

            md5=authReferer(szdb_path,preferer);
            if (md5 == NULL)
            {
               (void) sprintf(szbuf,"URL: %s\nis not in auth database:\n%s",
                              referer,szdb_path);
                multilineStringImage(szbuf,ALIGN_CENTER,0,0,0,0,255,0);
                exit(0); /* outta here */
            }
            /* pass the md5 value to get the hits */
            /* hits are stored as: md5=>ip:hits */
            dbuf=getCounterNumbuf(dbp,md5,remote_ip,
                ignore_site,do_increment, use_st,start_value);
            (void) free((char *) md5);
        }
        else
        {
            /* no referer url found */
            (void) strcpy(dbuf,"888888");
        }
    }
    else
    {
        referer=getenv("HTTP_REFERER");
        if (referer != NULL)
        {
            preferer=mystrdup(referer);
            if ((q=strrchr(preferer,'#')) != NULL)
                    *q='\0';
            dbuf=getCounterNumbuf(dbp,preferer,remote_ip,
                ignore_site,do_increment, use_st,start_value);
        }
        else
        {
            preferer=mystrdup("<NO REFERER>");
            dbuf=getCounterNumbuf(dbp,preferer,remote_ip,
                ignore_site,do_increment, use_st,start_value);
        }
    }

    if (dbp)
        ldbm_close(dbp);

    /* unlock */
    mutilsDotUnlock(0);

    if (preferer != (char *) NULL)
        (void) free(preferer);


    return(dbuf);
}
#endif /* USE_DATABASE */

/*
**  rwCounterDataFile()
**  function to read and write counter data from a flat file. the function
**  does the kernel locking on the file.
**
**  RCS
**      $Revision: 1.4 $
**      $Date: 2001/10/14 16:46:16 $
**  Return Values:
**      returns the buffer containing the counter digits in case of success.
**      in case of failure of some sort, the routine does not return, it
**      writes the error message image to the browser and exits with 0.
**
**  Parameters:
**
**
**  Side Effects:
**      the content of the counter datafile is modified.
**
**  Limitations and Comments:
**      The buffer returned points to a malloc'd space. the caller is
**      responsible to free this memory.
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-11-1997    first cut
**      ma_muquit@fccc.edu   Oct-30-1997    if content of datafile is 0,
**                                          data:IP was not written back
*/

char *rwCounterDataFile(filepath,
                        remote_ip,
                        ignore_site,
                        use_st,
                        start_value,
                        do_increment)
char
    *remote_ip;     /* remote IP, can be NULL, so check */

char
    *filepath;      /* full datafile path */

int
    ignore_site;    /* ignore this site or not */

int
    use_st;         /* use start value or not */

int
    start_value;    /* start value, used if use_st is true */

int
    do_increment;   /* should be counter be incremented */

{
    int
        length,
        n,
        fd;

    int
        ipbuf_size,
        malloc_size;

    char
        tmpbuf[1024],
        *readbuf=(char *) NULL,
        *ipbuf=(char *) NULL,
        *dbuf=(char *) NULL;

    *tmpbuf='\0';

    /*
    ** open the file
    */
    Debug2("filepath=%s",filepath,0);
    Debug2("remote_ip=%s",remote_ip,0);
#ifdef SYS_WIN32
        fd=sopen(filepath,_O_RDWR|_O_CREAT,_SH_DENYWR,_S_IREAD|_S_IWRITE);
#else
        fd=open(filepath,O_RDWR|O_CREAT,0644);
#endif

    if (fd < 0) /* open failed */
    {
        if (getcfgAutoFileCreation() == True)
        {
            if (CheckFile(filepath) != 0)
            {
                /* tmpbuf is a static buff, we can use sizeof safely */
                mutilsSafeStrcpy(tmpbuf,"Could not create data file: ",
                        sizeof(tmpbuf)-1);
                mutilsSafeStrcat(tmpbuf,filepath,sizeof(tmpbuf)-1);
            }
            else
            {
                /* tmpbuf is a static buff, we can use sizeof safely */
                mutilsSafeStrcpy(tmpbuf,"Could not write to counter file: ",
                        sizeof(tmpbuf)-1);
                mutilsSafeStrcat(tmpbuf,filepath,sizeof(tmpbuf)-1);
            }
        }
        else
        {
            /* tmpbuf is a static buff, we can use sizeof safely */
            mutilsSafeStrcpy(tmpbuf,"Could not write to counter file: ",
                    sizeof(tmpbuf)-1);
            mutilsSafeStrcat(tmpbuf,filepath,sizeof(tmpbuf)-1);
        }
        Warning(tmpbuf);
        StringImage(tmpbuf);
        exit(0);
    }

    /*
    ** lock the file
    */
#ifdef SYS_UNIX
        SetLock(fd);
#endif

    /*
    ** try to read from file, rewind it first
    */
    lseek(fd,0L,0);

    /*
    ** malloc. If malloc fails, we'll be outta here
    */
    malloc_size=(MAX_DIGITS+IP_LENGTH)*sizeof(char)+1;

    /*
    ** holds digit:IP
    */
    readbuf=(char *) cMalloc(malloc_size);
    memset(readbuf,0,malloc_size);

    /*
    ** holds digits
    */
    dbuf=(char *) cMalloc(malloc_size);
    memset(dbuf,0,malloc_size);

    /*
    ** holds IP
    */
    ipbuf_size=IP_LENGTH*sizeof(char) + 1;
    ipbuf=(char *) cMalloc(ipbuf_size);
    memset(ipbuf,0,ipbuf_size);

    /*
    ** read from file
    */
    n=read(fd,readbuf,malloc_size);

    if (n > 0)  /* read something */
    {
        /*
        ** dbuf and ipbuf will be filled. note dbuf will be returned
        ** so it bust have only digits
        ** NOTE, it's possible ipbuf holds NULL, so be careful!!
        */
        getParts(readbuf,dbuf,ipbuf,malloc_size-1,ipbuf_size-1);

    if (getcfgCountReload() == False)   /* don't count reload */
    {
        /*
        ** if the IP is the ignore list already, why bother checking the
        ** ipbuf. Only check if the IP is in the count list.
        */
        if ((ignore_site == False) && (do_increment == True))
        {
            if (remote_ip != (char *) NULL)
            {
                /*
                ** compare the IP from the connection and IP in the file
                ** if they'r same, no need to increment or write back to the
                ** data file
                */

                /*
                ** it was wrong to check if ipbuf was NULL, it will not
                ** be NULL as it already points to a malloc'd space,
                ** we'r supposed to check if it the content is NULL
                ** Thanks to Wincom Administrator <admin@wcis.com>
                ** Nov-07-11997
                */
                if (*ipbuf != '\0')
                {
                    if (strncmp(ipbuf,remote_ip,IP_LENGTH) == 0)
                    {
                        /*
                        ** same IP in connectin and in the file
                        */
                        do_increment=False;
                        ignore_site=True;
                    }
                    else
                    {
                        /*
                        ** new IP, overwrite ipbuf with it, we'r gonna store it
                        ** in the data file
                        */
                        Debug2("-- ipbuf=%s, remote_ip=%s",ipbuf,remote_ip);
                        mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                    }
                }
                else
                {
                    Debug2("ipbuf is NULL",0,0);
                    /*
                    ** remote IP is not NULL, and ipbuf is NULL, that means
                    ** the datafile has only digit part in it. overwrite
                    ** ipbuf with remote_ip
                    */
                    mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);

                }
            }
            else
            {
                Debug2("remote_ip is NULL, it should not be!",0,0);
            }
        }
    }
    else
    {
        /*
        ** site admin decided to count reload. now users have the option
        ** to increment or not
        */
        if (getUserReload() == False) /* user decided to ignore reload count*/
        {
                if ((ignore_site == False) && (do_increment == True))
                {
                    if (remote_ip != (char *) NULL)
                    {
                        Debug2(".... remote_ip=%s",remote_ip,0);
                        /*
                        ** compare the IP from the connection and IP
                        ** in the file if they'r same, no need to increment or
                        ** write back to the data file
                        */

                    /*
                    ** it was wrong to check if ipbuf was NULL, it will not
                    ** be NULL as it already points to a malloc'd space,
                    ** we'r supposed to check if it the content is NULL
                    ** Thanks to Wincom Administrator <admin@wcis.com>
                    ** Nov-07-11997
                    */
                    if (*ipbuf != '\0')
                    {
                        if (strncmp(ipbuf,remote_ip,IP_LENGTH) == 0)
                        {
                            /*
                            ** same IP in connectin and in the file
                            */
                            Debug2("== ipbuf=%s, remote_ip=%s",ipbuf,remote_ip);
                            do_increment=False;
                            ignore_site=True;
                        }
                        else
                        {
                            /*
                            ** new IP, overwrite ipbuf with it, we'r gonna
                            ** store it in the data file
                            */
                            Debug2("-- ipbuf=%s, remote_ip=%s",ipbuf,remote_ip);
                            mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                        }
                    }
                    else
                    {
                        Debug2("ipbuf is NULL",0,0);
                        /*
                        ** remote IP is not NULL, and ipbuf is NULL, that means
                        ** the datafile has only digit part in it. overwrite
                        ** ipbuf with remote_ip
                        */
                        mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);

                    }
                }
                else
                {
                    Debug2("remote_ip is NULL, it should not be!",0,0);
                }
            }
        }

    }

        /*
        ** if the content of the dbuf has anything but digit, replace
        ** the content with 1. If the content has digits and non-digits,
        ** null terminate at the first non-digit character
        */
        mutilsCleanBuf(dbuf,n,&length);

        if ((*dbuf == '\0') || (strcmp(dbuf,"0") == 0))
        {
            /* for bc lib */
            (void) strcpy(dbuf,"1");
            length=1;
        }
        else
        {
            /*
            ** now add 1 to the buffer. note: there's no fear to overflow
            ** int buffer. We can have digits as big as MAX_DIGITS long.
            ** the big number adding routines are from GNU bc library
            */

            if ((do_increment == True) && (ignore_site == False))
            {
                /*
                ** use bigplus lib from GNU bc to add 1. it can do
                ** arbitrary length arith.
                */
                add1toData(dbuf,malloc_size-1);

            }
        }
        if (ignore_site == False)
        {
           /* overwrite readbuf, we don't need it anymore */
            memset(readbuf,0,malloc_size);
            mutilsSafeStrcpy(readbuf,dbuf,malloc_size-1);
            /*
            ** if reload ignore is false, then don't bother to
            ** add the IP ad the end
            */
            if (getcfgCountReload() == False)   /* dont count reload */
            {
                if ((ipbuf != (char *) NULL) && (*ipbuf != '\0'))
                {
                    Debug2("ipbuf is not NULL=%s",ipbuf,0);
                    mutilsSafeStrcat(readbuf,":",malloc_size-1);
                    mutilsSafeStrcat(readbuf,ipbuf,malloc_size-1);
                }
            }
            else
            {
                /*
                ** site admin decided to count reload. now users have the option
                ** to increment or not
                */
                if (getUserReload() == False)
                {
                    /* at this point, ipbuf has something in it, is it?*/
                    if ((ipbuf != (char *) NULL) && (*ipbuf != '\0'))
                    {
                        Debug2("ipbuf is not NULL=%s",ipbuf,0);
                        mutilsSafeStrcat(readbuf,":",malloc_size-1);
                        mutilsSafeStrcat(readbuf,ipbuf,malloc_size-1);
                    }
                }
            }
        }
    }
    else    /* nothing was read */
    {
        if (use_st == True)
        {
            if (start_value <= 0)
                start_value=1;
            (void) sprintf(dbuf,"%d",start_value);
        }
        else
        {
            (void) strcpy(dbuf,"1");
        }

        /* create readbuf for writing */
         memset(readbuf,0,malloc_size);
         mutilsSafeStrcpy(readbuf,dbuf,malloc_size-1);

        /*
        ** if reload ignore is false, then don't bother to add the IP
        ** at the end
        */
        if (getcfgCountReload() == False)   /* dont Count reload */
        {
            if (remote_ip != (char *) NULL)
            {
                mutilsSafeStrcat(readbuf,":",malloc_size-1);
                mutilsSafeStrcat(readbuf,remote_ip,malloc_size-1);
            }
        }
        else
        {
            /*
            ** site admin decided to count reload. now users have the option
            ** to increment or not
            */
            if (getUserReload() == False)
            {
                if (remote_ip != (char *) NULL)
                {
                    mutilsSafeStrcat(readbuf,":",malloc_size-1);
                    mutilsSafeStrcat(readbuf,remote_ip,malloc_size-1);
                }
            }
        }
   }

   if (ignore_site == False)
   {
        (void) lseek(fd,0L,0);
        Debug2(" -- readbuf=%s",readbuf,0);

        /* Note: ftruncate() is gone! */

        /* at his point, readbuf has something in it */
        /* and it must be NULL terminaed as well */
        if (strlen(readbuf) > 0)
        {
            (void) strcat(readbuf,"$");
            if (write(fd,readbuf,strlen(readbuf)) > 0)
            {
                setCurrentHits(&readbuf);
                doVisitorLog();
            }
        }
    }

    (void) close(fd);   /* unlocks as well */

#ifdef SYS_UNIX
        UnsetLock(fd);
#endif

    if (readbuf != (char *) NULL)
        (void) free(readbuf);
    if (ipbuf != (char *) NULL)
        (void) free (ipbuf);

    return (dbuf);
}


/*
** add 1 to a very large number (80 digit long max in our case)
** uses the bigplus (I named it) library from GNU bc
*/

/* buf is changed */
static void add1toData(buf,buflen)
char
    *buf;
int
    buflen;
{
    bc_num
        n1,
        n2,
        result;

    char
        tbuf[2];

    int
        scale=0;

    Debug2("buf in add1toData()=%s",buf,0);
    (void) strcpy(tbuf,"1");

    init_numbers();
    init_num(&n1);
    init_num(&n2);
    init_num(&result);


    str2num(&n1,buf,scale);
    str2num(&n2,tbuf,scale);

    bc_add(n1,n2,&result,scale);
    mutilsSafeStrcpy(buf,num2str(result),buflen);

    free_num(&n1);
    free_num(&n2);
    free_num(&result);
}

/*
**  getParts()
**  get the digit and IP part out of a buffer, the items are separated
**  by a :
**
**  RCS
**      $Revision: 1.4 $
**      $Date: 2001/10/14 16:46:16 $
**  Return Values:
**      none
**
**  Parameters:
**      allbuf  digit+IP
**      dbuf    will contain digit part (returns)
**      ipbuf   will contain 15 character IP    (returns)
**
**  Side Effects:
**      contents of all buffers are changed
**
**  Limitations and Comments:
**      all the buffer must have space allocated for them before passing
**      then here. The caller must pass the correct size of the buffers
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Oct-24-1997    first cut
*/

static void getParts(allbuf,dbuf,ipbuf,dbuf_size,ipbuf_size)
char
    *allbuf,
    *dbuf,
    *ipbuf;
int
    dbuf_size,
    ipbuf_size;
{
    char
        *p,
        *v;

    p=allbuf;
    v=mutilsStrtok(p,":");
    if (v != (char *) NULL)
    {
        mutilsSafeStrcpy(dbuf,v,dbuf_size);
        /*
        Debug2("in getParts() dbuf=%s,strlen(dbuf)=%d",dbuf,strlen(dbuf));
        */

        p=(char *) NULL;
        v=mutilsStrtok(p,":");
        if (v != (char *) NULL)
        {
            mutilsSafeStrcpy(ipbuf,v,ipbuf_size);
            for (p=ipbuf; *p != '\0'; p++)
            {
                if (*p == '$')
                {
                    *p='\0';
                    break;
                }
            }
        }
    }
}


#ifdef USE_DATABASE
/*
**  getCounterNumbuf()
**  returns the count numbers
**
**  Parameters
**  LDBM    dbp             valid open LDBM object
**  char    *key            Key in the Counter database. It is either the
**                          MD5 of the URL in the auth database or the
**                          HTTP_REFERER if not running in strict mode or
**                          <NO_REFERER> if not running in strict mode and
**                          HTTP_REFERER is absent.
**  char    *remote_ip      IP address of the remote client
**  int     ignore_site     boolean
**  int     do_increment    boolean
**  int     use_st          boolean
**  int     start_value     the start value of the coutner
**
**  Return Values:
**  buf (char *)        in success
**  exits in case of failure
**
**  Limitations and Comments:
**  if needs to be written, the value is written to the database. But
**  database is not closed. caller is responsible to do so.
**
**
**  Development History:
**      who                  when           why
**      ma_muquit@fccc.edu   Jul-25-1999    first cut
*/

static char *getCounterNumbuf(dbp,key,remote_ip,ignore_site,do_increment,
        use_st,start_value)
LDBM
    dbp;

char
    *key,
    *remote_ip;

int
    ignore_site,
    do_increment,
    use_st,
    start_value;
{
    Datum
        key_data,
        data_data,
        return_data;

    int
        ipbuf_size,
        malloc_size,
        length;

    char
        *preadbuf=NULL,
        *dbuf=NULL,
        *ipbuf=NULL;

    /* muquit@muquit,com, Dec-26-2000 */
    ldbm_datum_init(key_data);
    ldbm_datum_init(data_data);

    malloc_size=(MAX_DIGITS+IP_LENGTH)*sizeof(char)+10;
    /* holds digit:IP */
    preadbuf=(char *) cMalloc(malloc_size);
    memset(preadbuf,0,malloc_size);

    /* holds digits */
    dbuf=(char *) cMalloc(malloc_size);
    memset(dbuf,0,malloc_size);

    /* holds IP */
    ipbuf_size=IP_LENGTH*sizeof(char) + 1;
    ipbuf=(char *) cMalloc(ipbuf_size);
    memset(ipbuf,0,ipbuf_size);

    key_data.dptr=key;
    key_data.dsize=strlen(key)+1;

    /* fetch the value from database */
    return_data=ldbm_fetch(dbp,key_data);
    if (return_data.dptr != NULL)
    {
        mutilsSafeStrcpy(preadbuf,return_data.dptr,malloc_size-1);
        Debug2("preadbuf=%s",preadbuf,0);
        getParts(preadbuf,dbuf,ipbuf,malloc_size-1,ipbuf_size-1);
        if (getcfgCountReload() == False)   /* don't count reload */
        {
            if ((ignore_site == False) && (do_increment == True))
            {
                if (remote_ip != (char *) NULL)
                {
                    /*
                    ** compare the IP from the connection and IP in
                    ** the file if they'r same, no need to
                    **  increment or write back to the data file
                    */
                    if (*ipbuf != '\0')
                    {
                        if (strncmp(ipbuf,remote_ip,IP_LENGTH) == 0)
                        {
                            do_increment=False;
                            ignore_site=True;
                        }
                        else
                        {
                            /*
                            **  new IP, overwrite ipbuf with it,
                            ** we'r gonna store it in the data file
                            */
                            mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                        }
                    }
                    else
                    {
                        /*
                        ** remote IP is not NULL, and ipbuf is NULL,
                        ** that means the datafile has only
                        **  digit part in it.  overwrite ipbuf
                        **  with remote_ip
                        */
                        mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                    }
                }
                else
                {
                    /* remote ip should not be null */
                    ;
                }
            }
        }
        else
        {
            /*
            ** site admin decided to count reload. now users have
            ** the choice to increment or not
            */
            if (getUserReload() == False)
            {
                /* user decided to ignore reload count*/
                if ((ignore_site == False) && (do_increment == True))
                {
                    if (remote_ip != (char *) NULL)
                    {
                        if (*ipbuf != '\0')
                        {
                          if (strncmp(ipbuf,remote_ip,IP_LENGTH) == 0)
                          {
                              do_increment=False;
                              ignore_site=True;
                          }
                          else
                          {
                             mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                          }

                        }
                        else
                        {
                            mutilsSafeStrcpy(ipbuf,remote_ip,ipbuf_size-1);
                        }
                    }
                    else
                    {
                        ;
                    }
                }
            }
        }

        /*
        ** if the content of the dbuf has anything but numbers, replace
        ** the content with 1. If the content has digits and non-digits,
        ** null terminate at the first non-digit character
        */
        mutilsCleanBuf(dbuf,malloc_size-1,&length);
        if ((*dbuf == '\0') || (strcmp(dbuf,"0") == 0))
        {
            /* for bc lib */
            (void) strcpy(dbuf,"1");
            length=1;
        }
        else
        {
            /*
            ** now add 1 to the buffer. note: there's no fear to
            ** overflow int buffer. We can have digits as big as
            ** MAX_DIGITS long.  the big number adding routines
            ** are from GNU bc library
            */
            if ((do_increment == True) && (ignore_site == False))
            {
                add1toData(dbuf,malloc_size-1);
            }
        }
        if (ignore_site == False)
        {

            /* overwrite preadbuf, we don't need it anymore */
            memset(preadbuf,0,malloc_size);
            mutilsSafeStrcpy(preadbuf,dbuf,malloc_size-1);

            /*
            ** if reload ignore is false, then don't bother to
            ** add the IP ad the end
            */
            if (getcfgCountReload() == False)   /* dont count reload */
            {
                if ((ipbuf != (char *) NULL) && (*ipbuf != '\0'))
                {
                    mutilsSafeStrcat(preadbuf,":",malloc_size-1);
                    mutilsSafeStrcat(preadbuf,ipbuf,malloc_size-1);
                }
            }
            else
            {
                /*
                ** site admin decided to count reload. now users have
                ** the option to increment or not
                */
                if (getUserReload() == False)
                {
                   /* at this point, ipbuf has something in it, is * it?*/
                   if ((ipbuf != (char *) NULL) && (*ipbuf != '\0'))
                   {
                       mutilsSafeStrcat(preadbuf,":",malloc_size-1);
                       mutilsSafeStrcat(preadbuf,ipbuf,malloc_size-1);
                   }
                }
            }
        }
    }
    else    /* new referer */
    {

        if (use_st == True)
        {
            if (start_value <= 0)
                start_value=1;
            (void) sprintf(dbuf,"%d",start_value);
        }
        else
        {
            (void) strcpy(dbuf,"1");
        }
        /* create preadbuf for writing */
        memset(preadbuf,0,malloc_size);
        mutilsSafeStrcpy(preadbuf,dbuf,malloc_size-1);
        Debug2("MMM preadbuf=%s",preadbuf,0);

        /*
        ** if reload ignore is false, then don't bother to add the IP
        ** at the end
        */
        if (getcfgCountReload() == False)   /* dont Count reload */
        {
            if (remote_ip != (char *) NULL)
            {
                mutilsSafeStrcat(preadbuf,":",malloc_size-1);
                Debug2("MMM preadbuf=%s",preadbuf,0);
                mutilsSafeStrcat(preadbuf,remote_ip,malloc_size-1);
                Debug2("MMM preadbuf=%s",preadbuf,0);
            }
        }
    }
    if (ignore_site == False)
    {
        if (strlen(preadbuf) > 0)
        {
            key_data.dptr=key;
            key_data.dsize=strlen(key)+1;

            data_data.dptr=preadbuf;
            data_data.dsize=strlen(preadbuf)+1;
            if (ldbm_store(dbp,key_data,data_data,LDBM_REPLACE) != 0)
            {
                Warning("Could not store to database");
                StringImage("Could not store to database");
                exit(0);
            }
            setCurrentHits(&preadbuf);
            doVisitorLog();
        }
    }


    if (preadbuf != (char *) NULL)
        (void) free(preadbuf);

    if (ipbuf != (char *) NULL)
        (void) free (ipbuf);

    return (dbuf);
}
#endif /* USE_DATABASE */
