#ifndef MUTILS_H
#define MUTILS_H

#include <stdio.h>

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h> /* ANSI string.h and pre-ANSI memory.h might conflict*/
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif
#else
#if  HAVE_STRINGS_H
#include <strings.h>
#endif
#endif


#if HAVE_CTYPE_H
#include <ctype.h>
#endif

#if HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#if SYS_UNIX
#include <sys/types.h>
#include <sys/stat.h>
#endif

#ifdef SYS_WIN32
#include <sys/types.h>
#include <sys/stat.h>
#include <io.h>
#include <share.h>
#define ftruncate chsize
#endif

#if HAVE_SYS_PARAM_H
#include <sys/param.h>
#endif

#if HAVE_STDLIB_H 
#include <stdlib.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_FCNTL_H
#ifndef O_RDONLY    /* prevent multiple inclusion on lame systems (from
vile)*/
#include <fcntl.h>
#endif
#endif

#if HAVE_MALLOC_H
#include <malloc.h>
#endif


#ifdef HAVE_SYS_FILE_H
#include <sys/file.h>
#endif

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "mmd5.h"

#ifndef True
#define True        1
#endif /* True */

#ifndef False
#define False       0
#endif /* False */

#ifndef Abort
#define Abort       -1
#endif /* Abort */

#if __STDC__ || defined(sgi) || defined(_AIX)
#undef _Declare
#define _Declare(formal_parameters) formal_parameters
#else
#define _Declare(formal_parameters) ()
#define const
#endif


/* function prototypes */
void  mutilsStripLeadingSpace  _Declare((char *s));
void  mutilsStripTrailingSpace _Declare((char *s));

int   mutilsParseURL        _Declare((char *url,char *hostname, 
                                      int hostname_len, int *port,
                                      char *page,int page_len));
char  *mutilsReverseString  _Declare((char *str));
char  *mutilsStrncat        _Declare((char *dst,char *src,int n));
char  *mutilsStrncpy        _Declare((char *dsr,char *src,int n));
int   mutilsStrncasecmp     _Declare((char *s1,char *s2,int n));
char  *mutilsStrdup         _Declare((char *str));
int   mutilsStrcasecmp      _Declare((char *a,char *b));
char  *mutilsSafeStrcpy     _Declare((char *dst,char *src,int n));
char  *mutilsSafeStrcat     _Declare((char *dsr,char *src,int n));
char  *mutilsStrtok         _Declare((char *s,char *delim));
int   mutilsHowmanyCommas   _Declare((char *buf));
void  mutilsCommaize        _Declare((char *buf));
void  mutilsCleanBuf        _Declare((char *buf,int bufsize,int *length));
char  *mutilsRmallws        _Declare((char *str));
char  *mutilsStristr        _Declare((char *s,char *t));
int   mutilsIsinname        _Declare((char *string,char *mask));
char  *mutilsGetTime        _Declare((void));
char  mutilsChopNL          _Declare((char *str));
void  mutilsTmpFilename     _Declare((char *filename));
char  *mutilsBasename       _Declare((char *path));
int   mutilsWhich           _Declare((char *name));
void  mutilsSetLock         _Declare((int fd));
void  mutilsDotLock         _Declare((char *filepath,char *errbuf));
void  mutilsDotUnlock       _Declare ((int delete));
char  *mutilsStrUpper       _Declare((char *str));
char  *mutilsStrLower       _Declare((char *str));
int   mutilsEatComment      _Declare((FILE *fp));
int   mutilsEatWhitespace   _Declare((FILE *fp));
char  *mutilsGetDirname     _Declare((char *file));
int   mutilsWildmat        _Declare((char *text,char *p));

#endif /* MUTILS_H */
