/* $OpenLDAP: pkg/ldap/include/ldbm.h,v 1.17.8.5 2000/09/13 00:42:34 kurt Exp $ */
/*
 * Copyright 1998-2000 The OpenLDAP Foundation, Redwood City, California, USA
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted only
 * as authorized by the OpenLDAP Public License.  A copy of this
 * license is available at http://www.OpenLDAP.org/license.html or
 * in file LICENSE in the top-level directory of the distribution.
 */
/* ldbm.h - ldap dbm compatibility routine header file */

#ifndef _LDBM_H_
#define _LDBM_H_

#ifdef SYS_WIN32
/* for malloc, muquit, Sep-13, 1999 */
#include <stdlib.h>
#include <malloc.h>
#endif /* SYS_WIN32 */

/* mm */
#if defined( HAVE_ERRNO_H )
# include <errno.h>
#elif defined( HAVE_SYS_ERRNO_H )
# include <sys/errno.h>
#endif

#ifndef HAVE_SYS_ERRLIST
    /* no sys_errlist */
#   define      sys_nerr    0
#   define      sys_errlist ((char **)0)
#elif DECL_SYS_ERRLIST 
    /* have sys_errlist but need declaration */
    LDAP_LIBC_V(int)      sys_nerr;
    LDAP_LIBC_V(char)    *sys_errlist[];
#endif

#undef _AC_ERRNO_UNKNOWN
#define _AC_ERRNO_UNKNOWN "unknown error"

#ifdef HAVE_SYS_ERRLIST
    /* this is thread safe */
#   define  STRERROR(e) ( (e) > -1 && (e) < sys_nerr \
            ? sys_errlist[(e)] : _AC_ERRNO_UNKNOWN )

#elif defined( HAVE_STRERROR )
    /* this may not be thread safe */
    /* and, yes, some implementations of strerror may return NULL */
#   define  STRERROR(e) ( strerror(e) \
        ? strerror(e) : _AC_ERRNO_UNKNOWN )

#else
    /* this is thread safe */
#   define  STRERROR(e) ( _AC_ERRNO_UNKNOWN )
#endif

#ifndef SAFEMEMCPY
#   if defined( HAVE_MEMMOVE )
#       define SAFEMEMCPY( d, s, n )    memmove((d), (s), (n))
#   elif defined( HAVE_BCOPY )
#       define SAFEMEMCPY( d, s, n )    bcopy((s), (d), (n))
#   else
        /* nothing left but memcpy() */
#       define SAFEMEMCPY( d, s, n )    memcpy((d), (s), (n))
#   endif
#endif

#define AC_MEMCPY( d, s, n ) (SAFEMEMCPY((d),(s),(n)))
#define AC_FMEMCPY( d, s, n ) do { \
        if((n) == 1) *((char*)(d)) = *((char*)(s)); \
        else AC_MEMCPY( (d), (s), (n) ); \
    } while(0)


/* mm */

#include <stdlib.h> /* mm */

#include <errno.h> /* mm */
#if defined( LDBM_USE_DBBTREE ) || defined( LDBM_USE_DBHASH )

/*****************************************************************
 *                                                               *
 * use berkeley db btree or hash package                         *
 *                                                               *
 *****************************************************************/
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>

#ifdef HAVE_DB_185_H
#	include <db_185.h>
#else
#	ifdef HAVE_DB1_DB_H
#		include <db1/db.h>
#	else
#		include <db.h>
#	endif
#endif

#ifndef DB_VERSION_MAJOR
#  define DB_VERSION_MAJOR 1
#endif
#ifndef DB_VERSION_MINOR
#  define DB_VERSION_MINOR 85
#endif

#if DB_VERSION_MAJOR >= 2
#	define R_NOOVERWRITE DB_NOOVERWRITE
#	ifndef DEFAULT_DB_PAGE_SIZE
#		define DEFAULT_DB_PAGE_SIZE 4096
#	endif
#endif

typedef DBT	Datum;
#define dsize	size
#define dptr	data

typedef DB	*LDBM;


/* for ldbm_open */
#if DB_VERSION_MAJOR >= 2
typedef DBC	LDBMCursor;

#	define LDBM_READER	DB_RDONLY
#	define LDBM_WRITER	0x00000      /* hopefully */
# if defined( HAVE_BERKELEY_DB_THREAD )
#	define LDBM_WRCREAT	(DB_NOMMAP|DB_CREATE|DB_THREAD)
#	define LDBM_NEWDB	(DB_TRUNCATE|DB_CREATE|DB_THREAD)
# else
#	define LDBM_WRCREAT	(DB_NOMMAP|DB_CREATE)
#	define LDBM_NEWDB	(DB_TRUNCATE|DB_CREATE)
# endif

#else
typedef void LDBMCursor;
#	define LDBM_READER	O_RDONLY
#	define LDBM_WRITER	O_RDWR
#	define LDBM_WRCREAT	(O_RDWR|O_CREAT)
#	define LDBM_NEWDB	(O_RDWR|O_TRUNC|O_CREAT)
#endif

/* for ldbm_open */
#define LDBM_NOSYNC	0
#define LDBM_SYNC	0
#define LDBM_LOCKING	0
#define LDBM_NOLOCKING	0

/* for ldbm_insert */
#define LDBM_INSERT	R_NOOVERWRITE
#define LDBM_REPLACE	0

#ifdef LDBM_USE_DBBTREE
#	define LDBM_ORDERED	1
#	define LDBM_SUFFIX	".dbb"
#	define DB_TYPE		DB_BTREE
#else
#	define LDBM_SUFFIX	".dbh"
#	define DB_TYPE		DB_HASH
#endif

#elif defined( LDBM_USE_GDBM )

/*****************************************************************
 *                                                               *
 * use gdbm if possible                                          *
 *                                                               *
 *****************************************************************/

#include <gdbm.h>

typedef datum		Datum;
typedef Datum LDBMCursor;
typedef GDBM_FILE	LDBM;

extern gdbm_error	gdbm_errno;

/* for ldbm_open */
#define LDBM_READER	GDBM_READER
#define LDBM_WRITER	GDBM_WRITER
#define LDBM_WRCREAT	GDBM_WRCREAT
#define LDBM_NEWDB	GDBM_NEWDB

#ifdef GDBM_FAST
#define LDBM_NOSYNC	GDBM_FAST
#else
#define LDBM_NOSYNC	0
#endif

#ifdef GDBM_SYNC
#define LDBM_SYNC	GDBM_SYNC
#else
#define LDBM_SYNC	0
#endif

#define LDBM_LOCKING	0
#ifdef GDBM_NOLOCK
#define LDBM_NOLOCKING	GDBM_NOLOCK
#else
#define LDBM_NOLOCKING	0
#endif

#define LDBM_SUFFIX	".gdbm"

/* for ldbm_insert */
#define LDBM_INSERT	GDBM_INSERT
#define LDBM_REPLACE	GDBM_REPLACE

#elif defined( HAVE_MDBM )

/*****************************************************************
 *                                                               *
 * use mdbm if possible                                          *
 *                                                               *
 *****************************************************************/

#include <mdbm.h>

typedef datum		Datum;
typedef int LDBMCursor;
typedef MDBM		*LDBM;

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

/* for ldbm_open */
#define LDBM_READER	O_RDONLY
#define LDBM_WRITER	O_RDWR
#define LDBM_WRCREAT	(O_RDWR|O_CREAT)
#define LDBM_NEWDB	(O_RDWR|O_TRUNC|O_CREAT)

#define LDBM_SYNC	0
#define LDBM_NOSYNC	0
#define LDBM_LOCKING	0
#define LDBM_NOLOCKING	0

#define LDBM_SUFFIX	".mdbm"

/* for ldbm_insert */
#define LDBM_INSERT	MDBM_INSERT
#define LDBM_REPLACE	MDBM_REPLACE

/* forgot sdbm, muquit@muquit.com Sat Mar 24 10:05:00 EST 2001*/
/*
** Use counter supplied sdbm 
*/
#elif defined(LDBM_USE_SDBM)

#include <sdbm.h>

typedef datum    Datum;
typedef int      LDBMCursor;
typedef DBM      *LDBM;

/* for ldbm_open */
#define LDBM_READER    O_RDONLY
#define LDBM_WRITER    O_WRONLY
#define LDBM_WRCREAT   (O_RDWR|O_CREAT)
#define LDBM_NEWDB     (O_RDWR|O_TRUNC|O_CREAT)
#define LDBM_FAST      0

#define LDBM_SUFFIX    ".sdbm"

/* for ldbm_insert */
#define LDBM_INSERT    DBM_INSERT
#define LDBM_REPLACE   DBM_REPLACE
#define LDBM_SYNC      0


#elif defined( HAVE_NDBM )

/*****************************************************************
 *                                                               *
 * if none of the above use ndbm, the standard unix thing        *
 *                                                               *
 *****************************************************************/

#include <ndbm.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

typedef datum	Datum;
typedef int LDBMCursor;
typedef DBM	*LDBM;

/* for ldbm_open */
#define LDBM_READER	O_RDONLY
#define LDBM_WRITER	O_WRONLY
#define LDBM_WRCREAT	(O_RDWR|O_CREAT)
#define LDBM_NEWDB	(O_RDWR|O_TRUNC|O_CREAT)

#define LDBM_NOSYNC	0
#define LDBM_SYNC	0
#define LDBM_NOLOCK	0
#define LDBM_SYNC	0

#define LDBM_SUFFIX	".ndbm"

/* for ldbm_insert */
#define LDBM_INSERT	DBM_INSERT
#define LDBM_REPLACE	DBM_REPLACE

#endif

int     ldbm_initialize( const char * );
int     ldbm_shutdown( void );
int     ldbm_errno( LDBM ldbm );
LDBM    ldbm_open( char *name, int rw, int mode, int dbcachesize );
void    ldbm_close( LDBM ldbm );
void    ldbm_sync( LDBM ldbm );
void    ldbm_datum_free( LDBM ldbm, Datum data );
Datum   ldbm_datum_dup( LDBM ldbm, Datum data );
Datum   ldbm_fetch( LDBM ldbm, Datum key );
int     ldbm_store( LDBM ldbm, Datum key, Datum data, int flags );
int     ldbm_delete( LDBM ldbm, Datum key );
Datum   ldbm_firstkey( LDBM ldbm, LDBMCursor **cursor );
Datum   ldbm_nextkey( LDBM ldbm, Datum key, LDBMCursor *cursor );

/* initialization of Datum structures */
#if defined( HAVE_BERKELEY_DB ) && (DB_VERSION_MAJOR >= 2)
    void *ldbm_malloc( size_t size );
#   define ldbm_datum_init(d) ((void)memset(&(d), '\0', sizeof(Datum)))
#else
#   define ldbm_datum_init(d) ((void)0)
#endif  /* HAVE_BERKELEY_DB */

#endif /* _ldbm_h_ */
