// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_tools.c
//											$Revision: 1.26 $
//											$Date: 2003/12/21 03:21:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include        <sys/types.h>

#include 		<ctype.h>
#include        <stdio.h>
#include		<stdlib.h>
#include 		<stdarg.h>
#include		<string.h>
#include		<limits.h>
#include 		<time.h>
#include 		<sys/stat.h>
#include        <errno.h>
#include 		<sys/types.h>
#include 		<fcntl.h>
#include 		<unistd.h>

#include		"wizd.h"
#include		"wizd_tools.h"


static unsigned char		debug_log_filename[FILENAME_MAX];	// ǥХåϥե̾(եѥ)
static unsigned char		debug_log_initialize_flag  = (-1);	// ǥХåե饰


/********************************************************************************/
// sentenceʸkeyʸrepʸִ롣
/********************************************************************************/
void replase_character(unsigned char *sentence, int sentence_buf_size, const unsigned char *key, const unsigned char *rep)
{
	int	malloc_size;
	unsigned char	*p, *buf;


	if ( strlen(key) == 0 )
		return;

	malloc_size = strlen(sentence) * 4;
	buf = malloc(malloc_size);
	if ( buf == NULL )
		return;

	p = strstr(sentence, key);

	while (p != NULL)
	{
		*p = '\0';
		strncpy(buf, p+strlen(key), malloc_size );
		strncat(sentence, rep, sentence_buf_size - strlen(sentence) );
		strncat(sentence, buf, sentence_buf_size - strlen(sentence) );
		p = strstr(p+strlen(rep), key);
	}

	free(buf);

	return;
}

// **************************************************************************
// sentence ʸΡstart_keyʸend_keyʸ˶ޤ줿ʬ
// **************************************************************************
void cut_enclose_words(unsigned char *sentence, int sentence_buf_size, unsigned char *start_key, unsigned char *end_key)
{
	int	malloc_size;
	unsigned char *start_p, *end_p, *buf;

	malloc_size = strlen(sentence) *2;
	buf = malloc(malloc_size);
	if ( buf == NULL )
		return;

	// start_keyõ
	start_p = strstr(sentence, start_key);

	while ( start_p != NULL )
	{
		// start_key 
		*start_p = '\0';

		// start_p θbuf˥ԡ
		strncpy(buf, start_p+strlen(start_key), malloc_size );

		// end_keyõ
		end_p = strstr(buf, end_key);

		if ( end_p == NULL )
		{
			// end_key̵С

			// start_key 
			strncat( sentence, start_key, sentence_buf_size - strlen(sentence) );

			//äĤ롣
			strncat( sentence, buf, sentence_buf_size - strlen(sentence) );
			break;
		}

		// end_key Ĥä

		// end_keyθsentenceˤäĤ롣
		strncat( sentence, end_p+strlen(end_key), sentence_buf_size - strlen(sentence) );

		// start_keyõ
		start_p = strstr(sentence, start_key);
	}


	free(buf);
	return;
}


//***************************************************************************
// sentenceʸꡢcut_char
//	Ĥʤв⤷ʤ
//***************************************************************************
void 	cut_after_character(unsigned char *sentence, unsigned char cut_char)
{
	unsigned char 	*symbol_p;

	// оݥ饯ä硢줫
	symbol_p = strchr(sentence, cut_char);

	if (symbol_p != NULL)
	{
		*symbol_p = '\0';
	}

	return;
}



//***************************************************************************
// sentenceʸΡcut_charǽ˽ФƤ꤫
// ⤷cut_charsentenceʸäƤʤä硢ʸ
//***************************************************************************
void 	cut_before_character(unsigned char *sentence, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;
	int				sentence_len;


	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);


	// оݥ饯ǽ˽ФƤõ
	symbol_p = strchr(sentence, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʸ
		strncpy(sentence, "", sentence_len);
		return;
	}

	symbol_p++;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(sentence_len + 10);
	if (malloc_p == NULL)
		return;

	// оݥ饯θǸޤǤʸ򥳥ԡ
	strncpy(malloc_p, symbol_p, sentence_len + 10);

	// sentence񤭴
	strncpy(sentence, malloc_p, sentence_len);

	free(malloc_p);

	return;
}


//************************************************************************
// sentenceʸΡcut_charǸ˽ФƤ꤫
// ⤷cut_charsentenceʸäƤʤä硢ʤˤ⤷ʤ
//************************************************************************
void 	cut_before_last_character(unsigned char *sentence, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;
	int				sentence_len;

	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// оݥ饯Ǹ˽ФƤõ
	symbol_p = strrchr(sentence, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʤˤ⤷ʤ
		return;
	}

	symbol_p++;

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(sentence_len + 10);
	if (malloc_p == NULL)
		return;

	// оݥ饯θǸޤǤʸ򥳥ԡ
	strncpy(malloc_p, symbol_p, sentence_len + 10);

	// sentence񤭴
	strncpy(sentence, malloc_p, sentence_len);

	free(malloc_p);

	return;
}

//************************************************************************
// sentenceʸΡcut_charǸ˽ФƤ꤫CUT
// ⤷cut_charsentenceʸäƤʤä硢ʸ
//************************************************************************
void 	cut_after_last_character(unsigned char *sentence, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	int				sentence_len;

	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// оݥ饯Ǹ˽ФƤõ
	symbol_p = strrchr(sentence, cut_char);
	if (symbol_p == NULL)
	{
		// ȯǤʤä硢ʸ
		strncpy(sentence, "", sentence_len);
		return;
	}

	*symbol_p = '\0';

	return;
}


//******************************************************************
// sentenceΡ n byteĤƺ
//******************************************************************
void 	cat_before_n_length(unsigned char *sentence,  unsigned int n)
{
	unsigned char	*malloc_p;
	unsigned char	*work_p;

	int				sentence_len;

	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// sentence nƱûʤreturn
	if ( sentence_len <= n )
		return;


	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(sentence_len + 10);
	if (malloc_p == NULL)
		return;

	work_p = sentence;
	work_p += sentence_len;
	work_p -= n;
	strncpy(malloc_p, work_p, sentence_len + 10);
	strncpy( sentence, malloc_p, sentence_len);

	free(malloc_p);
	return;
}

//******************************************************************
// sentenceΡ n byte
//  Ĺn byteʤä顢ʸ
//******************************************************************
void 	cat_after_n_length(unsigned char *sentence,  unsigned int n)
{
	unsigned char	*work_p;
	int				sentence_len;

	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// sentence nƱûʤСreturn;
	if ( sentence_len <= n )
	{
		strncpy(sentence, "", sentence_len);
		return;
	}


	//  n byte
	work_p = sentence;
	work_p += sentence_len;
	work_p -= n;
	*work_p = '\0';

	return;
}



//******************************************************************
// sentenceʸΡcut_charȴ
//******************************************************************
void 	cut_character(unsigned char *sentence, unsigned char cut_char)
{

	unsigned char 	*symbol_p;
	unsigned char	*malloc_p;
	unsigned char	*work_p;
	int				sentence_len;


	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(sentence_len + 10);
	if (malloc_p == NULL)
		return;

	symbol_p = sentence;
	work_p = malloc_p;


	// 롼ס
	while (*symbol_p != '\0')
	{
		// оݤΥ饯顢Ф
		if (*symbol_p == cut_char)
		{
			symbol_p++;
		}
		else	// оݥ饯ճä顢ԡ
		{
			*work_p = *symbol_p;
			work_p++;
			symbol_p++;
		}
	}

	// '\0' 򥳥ԡ
	*work_p = *symbol_p;

	// sentence񤭴
	strncpy(sentence, malloc_p, sentence_len);

	free(malloc_p);

	return;
}

//******************************************************************
// sentenceʸΡƬcut_char顢ȴ
//******************************************************************
void 	cut_first_character(unsigned char *sentence, unsigned char cut_char)
{

	unsigned char	*malloc_p;
	unsigned char	*work_p;
	int				sentence_len;

	if (sentence == NULL)
		return;

	sentence_len = strlen(sentence);

	// ƥݥꥨꥢmalloc.
	malloc_p = malloc(sentence_len + 10);
	if (malloc_p == NULL)
		return;

	strncpy(malloc_p, sentence, sentence_len + 10);

	work_p = malloc_p;



	// оݥ饯뤫ʤ롣
	while ((*work_p == cut_char) && (*work_p != '\0'))
	{
		work_p++;
	}

	// sentence񤭴
	strncpy(sentence, work_p, sentence_len);

	free(malloc_p);

	return;
}

// ***************************************************************************
// sentenceʸιˡcut_charäȤ
// ***************************************************************************
void 	cut_character_at_linetail(char *sentence, char cut_char)
{
	char	*source_p;
	int		length, i;


	if (sentence == NULL)
		return;

	length = strlen(sentence);	// ʸĹGet

	source_p = sentence;
	source_p += length;		// ݥ󥿤ʸκǸ˥åȡ


	for (i=0; i<length; i++)	// ʸο֤
	{
		source_p--;			// ʸء

		if (*source_p == cut_char)	//  ҥåȤ
		{
			*source_p = '\0';
		}
		else						// 㤦餬ФƤȤǽλ
		{
			break;
		}
	}

	return;
}



/********************************************************************************/
// sentenceʸunique_charϢ³ƤȤunique_char1ʸˤ롣
/********************************************************************************/
void duplex_character_to_unique(unsigned char *sentence, unsigned char unique_char)
{
	unsigned char	*source_p, *work_p;
	unsigned char 	*work_malloc_p;
	unsigned char	unique_char_count = 0;
	int				org_sentence_len;


	if (sentence == NULL)
		return;

	// ꥸʥʸĹ¸
	org_sentence_len = strlen(sentence);

	// Хåեݡ
	work_malloc_p = malloc( org_sentence_len+10 );
	if ( work_malloc_p == NULL )
		return;

	source_p = sentence;
	work_p = work_malloc_p;

	// sensenseʸ󤫤顢unique_charʳإԡ
	while (*source_p != '\0')
	{
		if (*source_p == unique_char)	// unique_charȯ
		{
			if (unique_char_count == 0)	// ǽΰĤʤ饳ԡʳʤ饹åס
			{
				*work_p = *source_p;
				work_p++;
			}
			unique_char_count++;
		}
		else	// unique_char ʳʤ饳ԡ
		{
			unique_char_count = 0;
			*work_p = *source_p;
			work_p++;
		}
		source_p++;
	}

	*work_p = '\0';

	// 顢sentenceء̤᤹
	strncpy(sentence, work_malloc_p, org_sentence_len );

	free( work_malloc_p );	// Mem Free.

	return;
}




//*********************************************************
// sentenceʸꡢǽ˽Ф褿cut_charʬ䡣
//
//	sentence	(IN) ʬоݤʸͿ롣
//	cut_char	(IN) ʬоݤʸ롣
//	split1		(OUT)åȤ줿ʬ롣sentenceƱΥ˾ޤ
//	split2		(OUT)åȤ줿ʬ롣sentenceƱΥ˾ޤ
//
//
// return
//		0: 			ｪλ
//		ʳ	顼ʬ伺Ԥʤɤʤɡ
//*********************************************************
int sentence_split(unsigned char *sentence, unsigned char cut_char, unsigned char *split1, unsigned char *split2)
{
	unsigned char 	*p;
	unsigned char	*malloc_p;
	int				sentence_len;

	// 顼å
	if ((sentence == NULL)||(split1 == NULL)||(split2 == NULL))
	{
		return 1;	// NULLޤꡣ
	}

	// sentence ĹGet.
	sentence_len = strlen(sentence);


	// ΰmalloc.
	malloc_p = malloc(sentence_len + 10);

	if (malloc_p == NULL)
	{
		// malloc ԡ顼
		return 1;
	}

	// sentenceʸ˥ԡ
	strncpy(malloc_p, sentence, sentence_len + 10);

	// sentence ˡcut_char ͭ뤫å̵Х顼
	p = strchr(malloc_p, cut_char);
	if (p == NULL)
	{
		free(malloc_p);
		return 1;	// ʬʸȯǤ
	}

	// cut_charꡢ򥫥åȡ
	*p = '\0';

	// Ⱦʬ򥳥ԡ
	strncpy(split1, malloc_p, sentence_len);

	// Ⱦʬ򥳥ԡ
	p++;
	strncpy(split2, p, sentence_len);


	free(malloc_p);

	return 0; // ｪλ
}

//******************************************************************
// filename顢ĥҤФ('.'ä
// '.'¸ߤʤä硢ĥҤĹϡ""롣
//******************************************************************
void filename_to_extension(unsigned char *filename, unsigned char *extension_buf, int extension_buf_size)
{
	unsigned char	*p;


	// ĥҤ¸ߥå
	p = strrchr(filename, '.' );
	if (( p == NULL ) || ( strlen(p) > extension_buf_size ))
	{
		strncpy(extension_buf, "", extension_buf_size );
		return;
	}


	// ĥҤڤФ
	p++;
	strncpy( extension_buf, p, extension_buf_size );

	return;
}


// **************************************************************************
// text_buf 顢CR/LF '\0'ޤǤڤФơline_bufcopy
// (CR/LFcopyʤ)
// ιԤƬΥݥ󥿤return
// Error'\0'줿NULL롣
// **************************************************************************
unsigned char *buffer_distill_line(unsigned char *text_buf_p, unsigned char *line_buf_p, unsigned int line_buf_size )
{
	unsigned char	*p;
	int			counter = 0;

	p = text_buf_p;

	// ------------------
	// CR/LF '\0'õ
	// ------------------
	while ( 1 )
	{
		if ( *p == '\r' ) // CR
		{
			p++;
			continue;
		}

		if ( *p == '\n' )	// LF
		{
			p++;
			break;
		}

		if ( *p == '\0' )
		{
			break;
		}

		p++;
		counter++;
	}

	// --------------------------------------------------
	// ʸline_buf_p ʸ򥳥ԡ
	// --------------------------------------------------
	memset(line_buf_p , '\0', line_buf_size );
	if ( counter >= line_buf_size )
	{
		counter = (line_buf_size -1);
	}
	strncpy(line_buf_p, text_buf_p, counter);

	if ( *p == '\0' )
		return NULL;		// ХåեκǸ
	else
		return p;			// Хåե

}



// **************************************************************************
//  URI󥳡ɤԤޤ.
//  ǽ : URIǥɤԤ
//   : int uri_encode
//  (char* dst,size_t dst_len,const char* src,int src_len);
//   : dst Ѵʸν񤭽Ф.
// 		   dst_len Ѵʸν񤭽ФκĹ.
// 		   src Ѵʸ.
// 		   src_len ѴʸĹ.
//   : 󥳡ɤʸο(Τޤޤޤ)
// **************************************************************************
int uri_encode(unsigned char *dst,  unsigned int dst_len, const unsigned char *src, int src_len)
{
	int idx_src;
	int idx_dst;
	int cnt;


	// å
	if((dst == NULL) || (dst_len < 1) || (src == NULL) || (src_len < 1))
	{
		return 0;
	}

	cnt = 0;
	for (idx_src = idx_dst = 0 ; (idx_src < src_len) && (idx_dst < dst_len) && (src[idx_src] != '\0'); idx_src++)
	{
		if (src[idx_src] == '.' || src[idx_src] == '_' || src[idx_src] == '-')
		{
			dst[idx_dst] = src[idx_src];
			idx_dst += 1;
		}
		else if ( src[idx_src] == ' ' )
		{
			dst[idx_dst] = '+';
			idx_dst += 1;
		}
		else if ( 	( src[idx_src]  <= 0x7F ) &&
				  	( src[idx_src]  != '='  ) &&
					( src[idx_src]  != '&'  ) &&
					( src[idx_src]  != '%'  ) &&
					( src[idx_src]  != '#'  ) &&
					( src[idx_src]  != '+'  ) )
		{
			dst[idx_dst] = src[idx_src];
			idx_dst += 1;
		}
		else
		{
			if ((idx_dst + 3) > dst_len)
				break;

			idx_dst += sprintf(&dst[idx_dst],"%%%2X",(unsigned char)(src[idx_src]));
		}
	  	cnt++;

	  	if ((idx_dst + 1) < dst_len)
	  	{
	  		dst[idx_dst] = '\0';
	  	}
	}

	return cnt;
}


// **************************************************************************
// URIǥɤԤޤ.
//  ǽ : URIǥɤԤ
//   : dst Ѵʸν񤭽Ф.
//		  dst_len Ѵʸν񤭽ФκĹ.
//		  src Ѵʸ.
//		  src_len ѴʸĹ.
//  : ǥɤʸο(Τޤޤޤ)
// **************************************************************************
int uri_decode(unsigned char *dst, unsigned int dst_len, const unsigned char *src, unsigned int src_len)
{

	int 		idx_src;
	int 		idx_dst;
	int 		cnt;
	char 		work[3];
	const char	*ptr_stop;
	char		*strtol_end_ptr;
	int 		code;


	// å
	if ((dst == NULL) || (dst_len < 1) || (src == NULL) || (src_len < 1))
	{
		return 0;
	}


  	cnt = 0;
  	ptr_stop = src;

	// =================
	// ᥤ롼
	// =================
	for (idx_src = idx_dst = 0; (idx_src < src_len) && (idx_dst < dst_len) && (src[idx_src] != '\0'); idx_dst++ , cnt++)
	{
		if (src[idx_src] == '%')
		{
			if (idx_src + 2 > src_len)
			{
				break;
			}

			work[0] = src[idx_src+1];
			work[1] = src[idx_src+2];
			work[2] = '\0';

			code = strtol(work, &strtol_end_ptr, 16);
			ptr_stop = &src[idx_src + (strtol_end_ptr - work) + 1];

			if (code == LONG_MIN || code == LONG_MAX)
			{
				break;
			}

			if (strtol_end_ptr != NULL)
			{
				if (*strtol_end_ptr != '\0')
				{
					break;
				}
			}
			dst[idx_dst] = code;
			idx_src += 3;
		}
	  	else if ( src[idx_src] == '+' )
		{
			dst[idx_dst] = ' ';
			idx_src += 1;
			ptr_stop++;
		}
	  	else
		{
			dst[idx_dst] = src[idx_src];
			idx_src += 1;
			ptr_stop++;
		}

	  	if (idx_dst + 1 < dst_len)
	  	{
	  		dst[idx_dst + 1] = '\0';
	  	}
	}

	return cnt;
}

/********************************************************************************/
// "YYYY/MM/DD HH:MM:SS" θߤʸ롣
/********************************************************************************/
void make_datetime_string(unsigned char *sentence)
{
	time_t				now;
	struct tm			*tm_p;

	// ߻Get.
	time(&now);
	tm_p = localtime(&now);

	sprintf(sentence, 	"%04d/%02d/%02d %02d:%02d:%02d",
						tm_p->tm_year+1900	,	// ǯ
						tm_p->tm_mon+1	,		// 
						tm_p->tm_mday	,		// 
						tm_p->tm_hour	,		// 
						tm_p->tm_min	,		// ʬ
						tm_p->tm_sec		);	// 

	return;
}


/********************************************************************************/
// time_t 顢"YYYY/MM/DD HH:MM" ʸ롣
/********************************************************************************/
void conv_time_to_string(unsigned char *sentence, time_t conv_time)
{
	struct tm			*tm_p;

	tm_p = localtime(&conv_time);
	sprintf(sentence, 	"%04d/%02d/%02d %02d:%02d",
						tm_p->tm_year+1900	,	// ǯ
						tm_p->tm_mon+1	,		// 
						tm_p->tm_mday	,		// 
						tm_p->tm_hour	,		// 
						tm_p->tm_min		);	// ʬ

	return;
}




/********************************************************************************/
// time_t 顢"YYYY/MM/DD" ʸ롣
/********************************************************************************/
void conv_time_to_date_string(unsigned char *sentence, time_t conv_time)
{
	struct tm			*tm_p;

	tm_p = localtime(&conv_time);
	sprintf(sentence, 	"%04d/%02d/%02d",
						tm_p->tm_year+1900	,	// ǯ
						tm_p->tm_mon+1	,		// 
						tm_p->tm_mday		);	// 

	return;
}




/********************************************************************************/
// time_t 顢"HH:MM" ʸ롣
/********************************************************************************/
void conv_time_to_time_string(unsigned char *sentence, time_t conv_time)
{
	struct tm			*tm_p;

	tm_p = localtime(&conv_time);
	sprintf(sentence, 	"%02d:%02d",
						tm_p->tm_hour	,		// 
						tm_p->tm_min		);	// ʬ

	return;
}



/********************************************************************************/
// 100000000  "100.00 MB" ؤѴԤ
//
//	K,M,G б
/********************************************************************************/
void conv_num_to_unit_string(unsigned char *sentence, off_t file_size)
{
	off_t	real_size;
	off_t	little_size;


	if ( file_size < 1024 )
	{
		sprintf(sentence, "%lld B", file_size );
	}
	else if ( file_size < (1024 * 1024) )
	{
		real_size 	= file_size / 1024;
		little_size = (file_size * 100 / 1024) % 100;

		sprintf(sentence, "%lld.%02lld KB", real_size, little_size);
	}
	else if ( file_size < (1024 * 1024 * 1024) )
	{
		real_size 	= file_size / ( 1024*1024 );
		little_size = (file_size * 100 / (1024*1024)) % 100;

		sprintf(sentence, "%lld.%02lld MB", real_size, little_size);
	}
	else
	{

		real_size 	= file_size / ( 1024*1024*1024 );
		little_size = (file_size * 100 / (1024*1024*1024)) % 100;

		sprintf(sentence, "%lld.%02lld GB", real_size, little_size);
	}

	return;
}








//*******************************************************************
// ǥХåϽ(ե̾å)ؿ
// δؿǽ˸Ƥ֤ޤǤϡǥХåϰڽϤʤ
//*******************************************************************
void debug_log_initialize(const unsigned char *set_debug_log_filename)
{
	// å
	if (set_debug_log_filename == NULL)
		return;

	if ( strlen(set_debug_log_filename) == 0 )
		return;


	// ǥХåե̾򥻥åȡ
	strncpy(debug_log_filename, set_debug_log_filename,	sizeof(debug_log_filename) );

	// ǥХå λե饰0ˡ
	debug_log_initialize_flag = 0;

	return;
}



//*************************************************
// ǥХåѴؿ
// printf() ƱեޥåȤˤƻѤ롣
//*************************************************
void debug_log_output(char *fmt, ...)
{
	FILE	*fp;
	unsigned char	buf[1024*5+1];
	unsigned char	work_buf[1024*4+1];
	unsigned char	date_and_time[32];
	unsigned char	replase_date_and_time[48];
	va_list 	arg;
	int		len;

	// =========================================
	// ǥХå ե饰å
	// =========================================
	if (debug_log_initialize_flag != 0 )
		return;


	// =========================================
	// Debugʸ
	// Ƭˡdate_and_time Ƥ
	// =========================================
	memset(buf, '\0', sizeof(buf));
	memset(work_buf, '\0', sizeof(work_buf));

	// Ϳ줿ʸŸ
	va_start(arg, fmt);
	vsnprintf(work_buf, sizeof(work_buf), fmt, arg);
	va_end(arg);

	// work_bufΰֺǸ'\n'ĤƤ
	len = strlen(work_buf);
	if (work_buf[len-1] == '\n')
	{
		work_buf[len-1] = '\0';
	}

	// ʸ( "\ndate_and_time" ˤʤ)
	make_datetime_string(date_and_time);
	snprintf(replase_date_and_time, sizeof(replase_date_and_time), "\n%s ", date_and_time );

	// ʸϡ
	snprintf(buf, sizeof(buf), "%s %s", date_and_time, work_buf);
	replase_character(buf, sizeof(buf), "\n", replase_date_and_time);	// \ndate_and_time

	// ֺǸ'\n'Ĥ롣
	strncat(buf, "\n", sizeof(buf)-strlen(buf) );


	// =====================
	// ե
	// =====================

	// ե륪ץɵ⡼)
	fp = fopen(debug_log_filename, "a");
	if ( fp == NULL )
		return;

	// 
	fwrite(buf, 1, strlen(buf), fp );	// åΤ

	// ե륯
	fclose( fp );

	return;
}



// **************************************************************************
// ĥѹɲѡ
//	extension_convert_list˽org  rename ؤѴԤ
//
// ) "hogehoge.m2p"  "hogehoge.m2p.mpg"
// **************************************************************************
void extension_add_rename(unsigned char *rename_filename_p)
{
	int i;
	unsigned char	work[FILENAME_MAX];
	int				rename_filename_len;


	if ( rename_filename_p == NULL )
		return;

	rename_filename_len = strlen(rename_filename_p);

	for ( i=0; ; i++ )
	{
		if ( extension_convert_list[i].org_extension == NULL )
			break;

		debug_log_output("org='%s', rename='%s'", 	extension_convert_list[i].org_extension,
													extension_convert_list[i].rename_extension);

		strncpy(work, rename_filename_p, sizeof(work));

		// ӤĥҤƱĹˤ롣
		cat_before_n_length(work, strlen(extension_convert_list[i].org_extension));

		// ĥҰס
		if ( strcasecmp(work, extension_convert_list[i].org_extension) == 0 )
		{
			debug_log_output(" HIT!!!" );
			// Υե뤫顢ĥʬ
			strncpy(work, rename_filename_p, sizeof(work));
			cat_after_n_length(work, strlen(extension_convert_list[i].org_extension));
			// rename줿ĥҤɲá
			strncat(work, extension_convert_list[i].rename_extension, sizeof(work) - strlen(work) );
			strncpy(rename_filename_p, work, rename_filename_len + strlen(extension_convert_list[i].rename_extension)+1 );

			debug_log_output("rename_filename_p='%s'", rename_filename_p);
			break;
		}
	}


	return;
}


// **************************************************************************
// ĥѹѡ
//	extension_convert_list˽rename  org ؤѴԤ
//
// ) "hogehoge.m2p.mpg"  "hogehoge.m2p"
// **************************************************************************
void extension_del_rename(unsigned char *rename_filename_p)
{
	int i;
	unsigned char	work[FILENAME_MAX];

	for ( i=0; ; i++ )
	{
		if ( extension_convert_list[i].org_extension == NULL )
			break;

		debug_log_output("org='%s', rename='%s'", 	extension_convert_list[i].org_extension,
													extension_convert_list[i].rename_extension);

		strncpy(work, rename_filename_p, sizeof(work));

		// ӤĥҤƱĹˤ롣
		cat_before_n_length(work, strlen(extension_convert_list[i].rename_extension));

		// ĥҰס
		if ( strcasecmp(work, extension_convert_list[i].rename_extension) == 0 )
		{
			debug_log_output(" HIT!!!" );

			// Υե뤫顢ĥʬ
			strncpy(work, rename_filename_p, sizeof(work));
			cat_after_n_length(work, strlen(extension_convert_list[i].rename_extension));

			// rename줿ĥҤɲá
			strncat(work, extension_convert_list[i].org_extension, sizeof(work) - strlen(work));
			strcpy(rename_filename_p, work);

			debug_log_output("rename_filename_p='%s'", rename_filename_p);

			break;
		}
	}

	return;
}



// **************************************************************************
// * EUCʸȾʸѤˤ롣
// **************************************************************************
void han2euczen(unsigned char *src, unsigned char *dist, int dist_size)
{

	unsigned char	*dist_p, *src_p;

	dist_p 	= dist;
	src_p	= src;

	while ( *src_p != '\0')
	{
		switch( (int)*src_p )
		{
			case ' ':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '!':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '"':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '#':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '$':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '%':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '&':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '\'':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '(':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case ')':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '*':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '+':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case ',':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '-':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '.':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '/':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '0':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '1':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '2':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '3':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '4':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '5':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '6':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '7':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '8':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '9':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case ':':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '<':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '=':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '>':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '?':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '@':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'A':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'B':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'C':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'D':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'E':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'F':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'G':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'H':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'I':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'J':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'K':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'L':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'M':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'N':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'O':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'P':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'Q':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'R':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'S':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'T':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'U':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'V':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'W':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'X':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'Y':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'Z':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '[':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '\\':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case ']':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '^':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '_':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '`':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'a':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'b':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'c':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'd':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'e':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'f':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'g':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'h':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'i':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'j':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'k':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'l':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'm':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'n':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'o':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'p':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'q':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'r':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 's':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 't':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'u':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'v':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'w':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'x':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'y':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case 'z':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '{':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '|':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;
			case '}':	strncpy(dist_p, "", dist_size);	dist_p+=2;	break;

			default:
				*dist_p = *src_p;
				dist_p++;
				*dist_p = '\0';
				break;
		}

		src_p++;
	}

	return;
}

//******************************************************************
// EUCʸn byte˺ʸ󶭳򸫤ɤ˷פ餦
//******************************************************************
void euc_string_cut_n_length(unsigned char *euc_sentence,  unsigned int n)
{
	int	euc_flag = 0;
	int	i;
	unsigned char	*p;


	if ( strlen(euc_sentence) < n )
	{
		return; // ڤɬפʤ
	}

	if ( n == 0 )
	{
		euc_sentence[0] = '\0';	// ʸ
		return;
	}

	p = euc_sentence;

	// n byteʬݥ󥿤ʤ롣
	for ( i=0; i<n; i++ )
	{
		if ( euc_flag == 0 )
		{
			if (( *p >= 0xA1 ) || ( *p == 0x8E )) // EUC-Code or Ⱦѥʤξ
	 		{
	 			euc_flag = 1;	// EUCʸ
	 		}
		}
		else
		{
			euc_flag = 0; // EUCʸ
		}
		p++;
	}
	// åȼ¹
	if ( euc_flag == 0 ) // EUCʸ椸ʤ
	{
		*p = '\0';	// ʸ󥫥å
	}
	else // ʸ
	{
		*(p-1) = '\0'; // ʸ򥫥å
	}

	return;
}
// **************************************************************************
// * PNGեޥåȥե뤫顢롣
// **************************************************************************
void png_size(unsigned char *png_filename, unsigned int *x, unsigned int *y)
{
	int		fd;
	unsigned char	buf[255];
	ssize_t	read_len;

	*x = 0;
	*y = 0;

	fd = open(png_filename, O_RDONLY);
	if ( fd < 0 )
	{
		return;
	}

	// إå+(0x18byte)  ɤ
	memset(buf, 0, sizeof(buf));
	read_len = read(fd, buf, 0x18);
	if ( read_len == 0x18)
	{
		*x = 	(buf[0x10] << 24)	+
				(buf[0x11] << 16)	+
				(buf[0x12] << 8 )	+
				(buf[0x13]);

		*y = 	(buf[0x14] << 24) 	+
				(buf[0x15] << 16)	+
				(buf[0x16] << 8 )	+
				(buf[0x17]);
	}

	close( fd );


	return;
}


// **************************************************************************
// * GIFեޥåȥե뤫顢롣
// **************************************************************************
void gif_size(unsigned char *gif_filename, unsigned int *x, unsigned int *y)
{
	int		fd;
	unsigned char	buf[255];
	ssize_t	read_len;

	*x = 0;
	*y = 0;

	fd = open(gif_filename, O_RDONLY);
	if ( fd < 0 )
	{
		return;
	}


	// إå+(10byte)  ɤ
	memset(buf, 0, sizeof(buf));
	read_len = read(fd, buf, 10 );
	if ( read_len == 10)
	{
		*x = buf[6] + (buf[7] << 8);
		*y = buf[8] + (buf[9] << 8);
	}

	close( fd );

	return;
}



// **************************************************************************
// * JPEGեޥåȥե뤫顢롣
// **************************************************************************
void  jpeg_size(unsigned char *jpeg_filename, unsigned int *x, unsigned int *y)
{
	int		fd;
	unsigned char	buf[255];
	ssize_t		read_len;
	off_t		length;

	*x = 0;
	*y = 0;

	//debug_log_output("jpeg_size: '%s'.", jpeg_filename);


	fd = open(jpeg_filename,  O_RDONLY);
	if ( fd < 0 )
	{
		return;
	}

	while ( 1 )
	{
		// ޡ(2byte)  ɤ
		read_len = read(fd, buf, 2);
		if ( read_len != 2)
		{
			//debug_log_output("fraed() EOF.\n");
			break;
		}

		// Start of Image.
		if (( buf[0] == 0xFF ) && (buf[1] == 0xD8))
		{
			continue;
		}

		// Start of Frame 
		if (( buf[0] == 0xFF ) && ( buf[1] >= 0xC0 ) && ( buf[1] <= 0xC3 )) // SOF 
		{
			//debug_log_output("SOF0 Detect.");

			// sof ǡɤ߹
			memset(buf, 0, sizeof(buf));
			read_len = read(fd, buf, 0x11);
			if ( read_len != 0x11 )
			{
				debug_log_output("fraed() error.\n");
				break;
			}

			*y = (buf[3] << 8) + buf[4];
			*x = (buf[5] << 8) + buf[6];

			break;
		}

		// SOS
		if (( buf[0] == 0xFF ) && (buf[1] == 0xDA)) // SOS 
		{
			//debug_log_output("Start Of Scan.\n");

			// 0xFFD9 õ
			while ( 1 )
			{
				// 1byte ɤ
				read_len = read(fd, buf, 1);
				if ( read_len != 1 )
				{
					//debug_log_output("fraed() error.\n");
					break;
				}

				// 0xFFä顢⤦1byteɤ
				if ( buf[0] == 0xFF )
				{
					buf[0] = 0;
					read(fd, buf, 1);

					// 0xD9ä λ
					if ( buf[0] == 0xD9 )
					{
						//debug_log_output("End Of Scan.\n");
						break;
					}
				}
			}
			continue;
		}


		// length ɤ
		memset(buf, 0, sizeof(buf));
		read(fd, buf, 2);
		length = (buf[0] << 8) + buf[1];

		// lengthʬȤФ
		lseek(fd, length-2, SEEK_CUR );
	}

	close(fd);

	return;
}



// **************************************************************************
// Samba  HEX/CAPʸ򡢥Хʥ᤹
// **************************************************************************
void decode_samba_hex_and_cap_coding( unsigned char *sentence )
{
	int		src_len;
	int		malloc_size;

	unsigned char	*malloc_p;
	unsigned char	*src_p, *dist_p;
	char			work[3];

	long int		hex_code;

	int	src_idx, dist_idx;

	src_len = strlen(sentence);

	malloc_size = src_len + 32;
	malloc_p = malloc( malloc_size );
	if ( malloc_p == NULL )
	{
		debug_log_output("decode_cap: malloc_error.");
		return;
	}
	memset( malloc_p, '\0', malloc_size ) ;

	src_idx = 0;
	dist_idx = 0;

	src_p = sentence;
	dist_p = malloc_p;


	while ( src_p[src_idx] != '\0' )
	{

		if (src_p[src_idx] == ':') // ':'ȯ
		{
			if (src_idx+2 < src_len) // ȣʸʬ롩
			{
				// ':' θʸʸå
				if (	(((src_p[src_idx+1] >= '0') && (src_p[src_idx+1] <= '9')) ||
						 ((src_p[src_idx+1] >= 'A') && (src_p[src_idx+1] <= 'F')) ||
						 ((src_p[src_idx+1] >= 'a') && (src_p[src_idx+1] <= 'f')) 	)	&&
						(((src_p[src_idx+2] >= '0') && (src_p[src_idx+2] <= '9')) ||
						 ((src_p[src_idx+2] >= 'A') && (src_p[src_idx+2] <= 'F')) ||
						 ((src_p[src_idx+2] >= 'a') && (src_p[src_idx+2] <= 'f')) 	)			)
				{
					// ':'θ2ʸwork˥ԡ
					work[0] = src_p[src_idx+1];
					work[1] = src_p[src_idx+2];
					work[2] = '\0';

					// Ѵ¹
					hex_code = strtol(work, NULL, 16);

					dist_p[dist_idx] = (unsigned char)(hex_code & 0xFF);
					src_idx += 3;
					dist_idx++;
					dist_p[dist_idx] = '\0';
					continue;
				}
			}
		}

		// ѴоݤǤʤСʸԡ
		dist_p[dist_idx] = src_p[src_idx];
		dist_idx++;
		src_idx++;
		dist_p[dist_idx] = '\0';
		continue;
	}



	debug_log_output("decode_cap: result='%s'", malloc_p);

	strncpy(sentence, malloc_p, src_len);




	free ( malloc_p );
	return;
}


// **************************************************************************
// * SJISʸ椫顢codeޤʸ(2byteʸ)򡢸ʸִ롣
// **************************************************************************
void sjis_code_thrust_replase(unsigned char *sentence, const unsigned char code)
{
	int i;
	unsigned char rep_code[2];

	// ִʸ(SJIS''
	rep_code[0] = 0x81;
	rep_code[1] = 0x96;

	// ʸĹ1byteʲʤ顢ɬפʤ
	if ( strlen(sentence) <= 1 )
	{
		return;
	}


	// ִоʸ ܺ
	for ( i=1; sentence[i] != '\0' ;i++ )
	{
		// code ˥ҥåȡ
		if ( sentence[i] == code )
		{
			// 1byteSJIS 1byteܤϰϡ(0x810x9F0xE00xFC)
			if ((( sentence[i-1] >= 0x81 ) && (sentence[i-1] <= 0x9F)) ||
			 	(( sentence[i-1] >= 0xE0 ) && (sentence[i-1] <= 0xFC))		)
			{

				debug_log_output("SJIS Replase HIT!!!!");

				// ִ¹
				sentence[i-1] = rep_code[0];
				sentence[i  ] = rep_code[1];
			}
		}
	}

	return;

}


