// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_send_file.c
//											$Revision: 1.7 $
//											$Date: 2003/12/21 03:21:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>


#include "wizd.h"

// defineΥȤ򳰤ȡread() & send()ˡmmap() & send()ǥե롢
// ¸ѥɤͭˤʤ롣

//#define MMAP_TEST





#ifndef MMAP_TEST
static int http_file_send(int accept_socket, unsigned char *filename, off_t content_length, off_t range_start_pos );
#else
#include <sys/mman.h>
#include <sys/time.h>
static int http_file_send_mmap(int accept_socket, unsigned char *filename, off_t content_length, off_t range_start_pos );
#endif


// **************************************************************************
// եΤֿ
// إå
// **************************************************************************
int http_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	int	send_header_data_len;
	int	result_len;

	unsigned char	send_http_header_buf[2048];
	unsigned char	work_buf[1024];

	off_t	content_length;
	
	struct	stat	file_stat;
	int				result;



	// ---------------
	// ѿ
	// ---------------
	memset(send_http_header_buf, '\0', sizeof(send_http_header_buf));



	// -------------------------------
	// ե륵å
	// -------------------------------
	if ( http_recv_info_p->range_end_pos > 0 )	// endֻͭꡣ
	{
		content_length = (http_recv_info_p->range_end_pos - http_recv_info_p->range_start_pos) + 1;
	}
	else // end̵ֻ
	{
		result = stat(http_recv_info_p->send_filename, &file_stat); // ե륵å
		if ( result != 0 )
		{
			debug_log_output("file not found.");
			return ( -1 );
		}

		content_length = file_stat.st_size - http_recv_info_p->range_start_pos;
	}



	// --------------
	// OK إå
	// --------------
	strncpy(send_http_header_buf, HTTP_OK, sizeof(send_http_header_buf));

	strncat(send_http_header_buf, HTTP_CONNECTION, sizeof(send_http_header_buf) - strlen(send_http_header_buf));

	snprintf(work_buf, sizeof(work_buf), HTTP_SERVER_NAME, SERVER_NAME);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf));

	snprintf(work_buf, sizeof(work_buf), HTTP_CONTENT_LENGTH, content_length);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );

	snprintf(work_buf, sizeof(work_buf), HTTP_CONTENT_TYPE, http_recv_info_p->mime_type);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );
	strncat(send_http_header_buf, HTTP_END, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );


	send_header_data_len = strlen(send_http_header_buf);
	debug_log_output("send_header_data_len = %d\n", send_header_data_len);
	debug_log_output("--------\n");
	debug_log_output("%s", send_http_header_buf);
	debug_log_output("--------\n");


	// --------------
	// إåֿ
	// --------------
	result_len = send(accept_socket, send_http_header_buf, send_header_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_header_data_len);


	// --------------
	// ֿ
	// --------------
#ifndef MMAP_TEST
	http_file_send(	accept_socket, 	http_recv_info_p->send_filename, 
									content_length,
									http_recv_info_p->range_start_pos );
#else
	http_file_send_mmap(	accept_socket, 	http_recv_info_p->send_filename, 
											content_length,
											http_recv_info_p->range_start_pos );

#endif

	return 0;
}




#ifndef MMAP_TEST
// **************************************************************************
// եμΤ¹
// **************************************************************************
static int http_file_send(int accept_socket, unsigned char *filename, off_t content_length, off_t range_start_pos )
{
	int		fd;

	unsigned char 	*send_buf_p;

	ssize_t			file_read_len;
	int				data_send_len;
	off_t			seek_ret;

	off_t			total_read_size;
	size_t			target_read_size;

	// ======================
	// Хåե
	// ======================

	send_buf_p = malloc(SEND_BUFFER_SIZE);
	if ( send_buf_p == NULL )
	{
		debug_log_output("malloc() error.\n");
		return (-1 );
	}

	// ---------------------
	// ե륪ץ
	// ---------------------
	fd = open(filename, O_RDONLY);
	if ( fd < 0 )
	{	
		debug_log_output("open() error.");
		free(send_buf_p);
		return ( -1 );
	}


	// ------------------------------------------
	// range_start_posإե륷
	// ------------------------------------------
	seek_ret = lseek(fd, range_start_pos, SEEK_SET);
	if ( seek_ret < 0 )	// lseek 顼å
	{
		debug_log_output("lseek() error.");
		free(send_buf_p);
		close(fd);
		return ( -1 );
	}


	total_read_size = 0;

	// ================
	// ž
	// ================
	while ( 1 )
	{
		// Хåեꥢ
		memset(send_buf_p, 0, SEND_BUFFER_SIZE);

		// ɸread׻
		if ( (content_length - total_read_size) > SEND_BUFFER_SIZE )
		{
			target_read_size = SEND_BUFFER_SIZE;
		}
		else
		{
			target_read_size = (size_t)(content_length - total_read_size);
		}


		// ե뤫ǡɤ߹ࡣ
		file_read_len = read(fd, send_buf_p, target_read_size);
		if ( file_read_len <= 0 )
		{
			debug_log_output("EOF detect.\n");
			break;
		}



		// SOCKET ˥ǡ
		data_send_len = send(accept_socket, send_buf_p, file_read_len, 0);
		if ( data_send_len != file_read_len ) 
		{
			debug_log_output("send() error.\n");
			close(fd);	// File Close.
			return ( -1 );
		}

		total_read_size += file_read_len;

		if ( content_length != 0 )
		{
			debug_log_output("Streaming..  %lld / %lld ( %lld.%lld%% )\n", total_read_size, content_length, total_read_size * 100 / content_length,  (total_read_size * 1000 / content_length ) % 10 );
		}
		if ( total_read_size >= content_length)
		{
			debug_log_output("send() end.(content_length=%d)\n", content_length );
		}


	}

	free(send_buf_p);	// Memory Free.
	close(fd);	// File Close.

	// ｪλ
	return 0;
}


#else



// **************************************************************************
// եμΤ¹ [mmap()¸ zero copy]
// **************************************************************************
static int http_file_send_mmap(int accept_socket, unsigned char *filename, off_t content_length, off_t range_start_pos )
{
	int		fd;

	unsigned char 	*send_buf_p = NULL;

	int				data_send_len;

	off_t			total_read_size;
	size_t			target_read_size;

	int		ret;

	struct timeval start_tv, end_tv;



	// ---------------------
	// ե륪ץ
	// ---------------------
	fd = open(filename, O_RDONLY);
	if ( fd < 0 )
	{	
		debug_log_output("open() error.");
		free(send_buf_p);
		return ( -1 );
	}


	total_read_size = 0;


	// ================
	// ž
	// ================
	while ( total_read_size < content_length  )
	{
		// ɸread׻
		if ( (content_length - total_read_size) > SEND_BUFFER_SIZE )
		{
			target_read_size = SEND_BUFFER_SIZE;
		}
		else
		{
			target_read_size = (size_t)(content_length - total_read_size);
		}


		// mmap() ¹
		gettimeofday(&start_tv, NULL);
		send_buf_p = (unsigned char *) mmap((void *) 0, target_read_size, PROT_READ, MAP_SHARED, fd, range_start_pos + total_read_size );
		gettimeofday(&end_tv, NULL);
		if ( send_buf_p == MAP_FAILED )
		{
			debug_log_output("mmap() error.\n");
			close(fd);	// File Close.
			return ( -1 );
		}

		// mmap() ¹Ի ɽ
		debug_log_output("mmap() time:   %6d [usec]\n", (end_tv.tv_usec - start_tv.tv_usec) + ((end_tv.tv_sec - start_tv.tv_sec) * 1000 * 1000 ) );


		// SOCKET ˥ǡ
		gettimeofday(&start_tv, NULL);
		data_send_len = send(accept_socket, send_buf_p, target_read_size, 0);
		gettimeofday(&end_tv, NULL);
		if ( data_send_len != target_read_size ) 
		{
			debug_log_output("send() error.\n");
			close(fd);	// File Close.
			return ( -1 );
		}

		// send() ¹Իɽ
		debug_log_output("send() time:   %6d [usec]\n", (end_tv.tv_usec - start_tv.tv_usec) + ((end_tv.tv_sec - start_tv.tv_sec) * 1000 * 1000 ) );


		// munmap() ¹
		gettimeofday(&start_tv, NULL);
		ret = munmap(send_buf_p, target_read_size);
		gettimeofday(&end_tv, NULL);

		if ( ret < 0 )
		{
			debug_log_output("munmap() error.\n");
			close(fd);	// File Close.
			return ( -1 );
		}

		// munmap() ¹Իɽ
		debug_log_output("munmap() time: %6d [usec]\n", (end_tv.tv_usec - start_tv.tv_usec) + ((end_tv.tv_sec - start_tv.tv_sec) * 1000 * 1000 ) );


		// ɤ߹ιפ׻
		total_read_size += target_read_size;

		// Debug
		if ( content_length != 0 )
		{
			debug_log_output("Streaming..  %lld / %lld ( %lld.%lld%% )\n", total_read_size, content_length, total_read_size * 100 / content_length,  (total_read_size * 1000 / content_length ) % 10 );
		}
		if ( total_read_size >= content_length)
		{
			debug_log_output("send() end.(content_length=%d)\n", content_length );
		}


	}

	close(fd);	// File Close.


	// ｪλ
	return 0;
}


#endif









