//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_menu.c
//											$Revision: 1.19 $
//											$Date: 2003/12/21 03:21:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>
#include <fcntl.h>


#include "wizd.h"


#define	SORT_FILE_MASK			( 0x000000FF )
#define	SORT_DIR_MASK			( 0x00000F00 )
#define	SORT_DIR_FLAG(_A_)		( ( _A_ & SORT_DIR_MASK ) >> 8 )
#define	SORT_DIR_UP				( 0x00000100 )
#define	SORT_DIR_DOWN			( 0x00000200 )
#define	DEFAULT_SORT_RULE		SORT_NONE






typedef struct {
	unsigned char	name[255];		// ɽѥե̾
	unsigned char	org_name[255];	// ꥸʥե̾
	mode_t			type;			// 
	off_t			size;			// 
	time_t			time;			// 
} FILE_INFO_T;



// ִѥǡʥХ
typedef struct  {

	unsigned char	current_directory_name[FILENAME_MAX];	// ǥ쥯ȥ ɽ(ʸĴѤ)
	unsigned char	current_directory_link[FILENAME_MAX];	// ǥ쥯ȥLinkѡURI󥳡ɺѤߡ

	unsigned char	parent_directory_link[FILENAME_MAX];	// ƥǥ쥯ȥLinkѡURI󥳡ɺѤߡ



	unsigned char	file_num_str[16];	// ǥ쥯ȥΥեɽ
	unsigned char	now_page_str[16];	// ߤΥڡֹɽ
	unsigned char	max_page_str[16];	// ڡֹɽ

	unsigned char	start_file_num_str[16];	// ߥڡɽϥեֹɽ
	unsigned char	end_file_num_str[16];	// ߥڡɽϥեֹɽ

	unsigned char	next_page_str[16];	// Υڡ(̵max_page)ɽ
	unsigned char	prev_page_str[16];	// Υڡ̵ 1)ɽ

	int		stream_files;	// ǽե


	// ǥ쥯ȥ
	unsigned char	secret_dir_link_html[512];

    // EUCǥ쥯ȥ̾ (ǥ쥯ȥƱʸǽ)
	unsigned char euc_current_dir_name[FILENAME_MAX];


} SKIN_REPLASE_GLOBAL_DATA_T;


// ִѥǡʥե
typedef struct  {
	int				stream_type;			// ȥ꡼ե뤫ݤ
	int				menu_file_type;			// եμ

	unsigned char	file_name[255];			// ե̾ɽ(ʸĴѤ)
	unsigned char	file_name_no_ext[255];	// ĥ̵ե̾ɽ(ʸĴѤ)
	unsigned char	file_extension[16];	// ĥҤΤ(ʸĴѤ)

	unsigned char	file_uri_link[FILENAME_MAX];	// եؤLink(URI󥳡ɺѤ)

	unsigned char	file_timestamp[32];		// ॹɽ
	unsigned char	file_timestamp_date[32];	// ॹɽ դΤ
	unsigned char	file_timestamp_time[32];	// ॹɽ Τ

	unsigned char	file_size_string[32];	// ե륵ɽ

	unsigned char	svi_info_data[SVI_INFO_LENGTH];	// SVI ե
	unsigned char	svi_rec_time_data[32];			// SVIϿ

	unsigned char	tvid_string[16];	// TVIDɽ
	unsigned char	vod_string[32];		// vod="0" or vod="playlist"  ɬפ˱դ

	unsigned char	image_width[16];	// ǡ 
	unsigned char	image_height[16];	// ǡ ⤵


	// MP3 ID3v1 
	unsigned char	mp3_id3v1_flag;			// MP3  ¸ߥե饰
	unsigned char	mp3_id3v1_title[32];	// MP3 ̾
	unsigned char	mp3_id3v1_album[32];	// MP3 Х̾
	unsigned char	mp3_id3v1_artist[32];	// MP3 ƥ
	unsigned char	mp3_id3v1_year[8];		// MP3 ǯ
	unsigned char	mp3_id3v1_comment[32];	// MP3 

	unsigned char	mp3_id3v1_title_info[32*3];			// MP3 ̾[Х̾/ƥ] ޤȤɽ
	unsigned char	mp3_id3v1_title_info_limited[32*3];	// MP3 ̾[Х̾/ƥ] ޤȤɽ(¤)



} SKIN_REPLASE_LINE_DATA_T;



// ImageViewer ִѥǡ
typedef struct  {

	unsigned char	current_uri_name[FILENAME_MAX];	// URI ɽ(ʸĴѤ)
	unsigned char	current_uri_link[FILENAME_MAX];	// URI LinkѡURI󥳡ɺѤߡ

	unsigned char	parent_directory_link[FILENAME_MAX];	// ƥǥ쥯ȥLinkѡURI󥳡ɺѤߡ

	unsigned char	now_page_str[16];	// ߤΥڡֹɽ

	unsigned char	file_timestamp[32];			// ॹɽ()
	unsigned char	file_timestamp_date[32];	// ॹɽ(դΤ)
	unsigned char	file_timestamp_time[32];		// ॹɽ(Τ)
	unsigned char	file_size_string[32];		// ե륵ɽ

	unsigned char	image_width[16];			// ǡ 
	unsigned char	image_height[16];			// ǡ ⤵

	unsigned char	image_viewer_width[16];		// ǡ ɽ
	unsigned char	image_viewer_height[16];	// ǡ ɽ⤵

	unsigned char	image_viewer_mode[16];		// ɽ⡼

} SKIN_REPLASE_IMAGE_VIEWER_DATA_T;


#define		FILEMENU_BUF_SIZE	(1024*16)


static int count_file_num(unsigned char *path);
static int directory_stat(unsigned char *path, FILE_INFO_T *file_info_p, int file_num);

static int file_ignoral_check(unsigned char *name, unsigned char *path);
static int directory_same_check_svi_name(unsigned char *name);

static void http_filemenu_send(int accept_socket, unsigned char *filemenu_data);

//static void create_system_filemenu(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size);
static void create_skin_filemenu(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size);
static void create_all_play_list(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size);

static unsigned char *skin_file_read(unsigned char *read_filename, int *malloc_size );


static void replase_skin_grobal_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_GLOBAL_DATA_T *skin_rep_data_global_p);
static void replase_skin_line_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p);

static void  mp3_id3v1_tag_read(unsigned char *mp3_filename, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p );
static void playlist_filename_adjustment(unsigned char *src_name, unsigned char *dist_name, int dist_size, int input_code );

static int file_read_line( int fd, unsigned char *line_buf, int line_buf_size);


static void 	file_info_sort( FILE_INFO_T *p, int num, unsigned long type );
static int 		_file_info_dir_sort( const void *in_a, const void *in_b, int order );
static int	 	_file_info_dir_sort_order_up( const void *in_a, const void *in_b );
static int 		_file_info_dir_sort_order_down( const void *in_a, const void *in_b );
static int		_file_info_name_sort( const void *in_a, const void *in_b, int order );
static int 		_file_info_name_sort_order_up( const void *in_a, const void *in_b );
static int 		_file_info_name_sort_order_down( const void *in_a, const void *in_b );
static int 		_file_info_size_sort( const void *in_a, const void *in_b, int order );
static int 		_file_info_size_sort_order_up( const void *in_a, const void *in_b );
static int 		_file_info_size_sort_order_down( const void *in_a, const void *in_b );
static int 		_file_info_time_sort( const void *in_a, const void *in_b, int order );
static int 		_file_info_time_sort_order_up( const void *in_a, const void *in_b );
static int 		_file_info_time_sort_order_down( const void *in_a, const void *in_b );


// ե륽Ѵؿ
static void * file_sort_api[] = {
	NULL,
	_file_info_name_sort_order_up,
	_file_info_name_sort_order_down,
	_file_info_time_sort_order_up,
	_file_info_time_sort_order_down,
	_file_info_size_sort_order_up,
	_file_info_size_sort_order_down,
};


// ǥ쥯ȥ꥽Ѵؿ
static void * dir_sort_api[] = {
	NULL,
	_file_info_dir_sort_order_up,
	_file_info_dir_sort_order_down
};




// **************************************************************************
// եꥹȤֿ
// **************************************************************************
void http_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char	*filemenu_buf_malloc_p;

	int				file_num;	// DIRΥե
	unsigned char	*file_info_malloc_p;
	FILE_INFO_T		*file_info_p;


	// recv_uri κǸ夬'/'Ǥʤä顢'/'ɲ
	if (( strlen(http_recv_info_p->recv_uri) > 0 ) &&
		( http_recv_info_p->recv_uri[strlen(http_recv_info_p->recv_uri)-1] != '/' ))
	{
		strncat(http_recv_info_p->recv_uri, "/", sizeof(http_recv_info_p->recv_uri) - strlen(http_recv_info_p->recv_uri) );
	}


	//  http_recv_info_p->send_filename κǸ夬'/'Ǥʤä顢'/'ɲ
	if (( strlen(http_recv_info_p->send_filename) > 0 ) &&
		( http_recv_info_p->send_filename[strlen(http_recv_info_p->send_filename)-1] != '/' ))
	{
		strncat(http_recv_info_p->send_filename, "/", sizeof(http_recv_info_p->send_filename) - strlen(http_recv_info_p->send_filename) );
	}


	// ==================================
	// ǥ쥯ȥǣţ
	// ==================================

	// recv_uri ǥ쥯ȥΥե롣
	file_num = count_file_num( http_recv_info_p->send_filename );
	debug_log_output("file_num = %d", file_num);
	if ( file_num < 0 )
	{
		return;
	}


	// ɬפʿե¸ꥢmalloc()
	file_info_malloc_p = malloc( sizeof(FILE_INFO_T)*file_num );
	if ( file_info_malloc_p == NULL )
	{
		debug_log_output("malloc() error");
		return;
	}


	memset(file_info_malloc_p, 0, sizeof(FILE_INFO_T)*file_num);
	file_info_p = (FILE_INFO_T *)file_info_malloc_p;



	// -----------------------------------------------------
	// ե¸ꥢˡǥ쥯ȥɤ߹ࡣ
	// -----------------------------------------------------
	file_num = directory_stat(http_recv_info_p->send_filename, file_info_p, file_num);
	debug_log_output("file_num = %d", file_num);


	// ǥХåfile_info_malloc_p ɽ
	//for ( i=0; i<file_num; i++ )
	//{
	//	debug_log_output("file_info[%d] name='%s'", i, file_info_p[i].name );
	//	debug_log_output("file_info[%d] size='%d'", i, file_info_p[i].size );
	//	debug_log_output("file_info[%d] time='%d'", i, file_info_p[i].time );
	//}


	// ---------------------------------------------------
	// sort=ǥȤؼƤ뤫ǧ
	// ؼƤ顢global_param
	// ---------------------------------------------------
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		if (strcasecmp(http_recv_info_p->sort ,"none") == 0 )
			global_param.sort_rule = SORT_NONE;
		else if (strcasecmp(http_recv_info_p->sort ,"name_up") == 0 )
			global_param.sort_rule = SORT_NAME_UP;
		else if (strcasecmp(http_recv_info_p->sort ,"name_down") == 0 )
			global_param.sort_rule = SORT_NAME_DOWN;
		else if (strcasecmp(http_recv_info_p->sort ,"time_up") == 0 )
			global_param.sort_rule = SORT_TIME_UP;
		else if (strcasecmp(http_recv_info_p->sort ,"time_down") == 0 )
			global_param.sort_rule = SORT_TIME_DOWN;
		else if (strcasecmp(http_recv_info_p->sort ,"size_up") == 0 )
			global_param.sort_rule = SORT_SIZE_UP;
		else if (strcasecmp(http_recv_info_p->sort ,"size_down") == 0 )
			global_param.sort_rule = SORT_SIZE_DOWN;
	}

	// ɬפʤСȼ¹
	if ( global_param.sort_rule != SORT_NONE )
	{
		file_info_sort( file_info_p, file_num,  global_param.sort_rule | SORT_DIR_UP  );
	}


	// =============================
	// ֿǡΰmalloc
	// =============================
	filemenu_buf_malloc_p = malloc( FILEMENU_BUF_SIZE );
	if (filemenu_buf_malloc_p == NULL)
	{
		debug_log_output("malloc() error");
		return;
	}

	// -------------------------------------------
	// ư
	// -------------------------------------------
	if ( strcasecmp(http_recv_info_p->action, "allplay") == 0 )
	{
		create_all_play_list(http_recv_info_p, file_info_p, file_num, filemenu_buf_malloc_p, FILEMENU_BUF_SIZE );
		debug_log_output("AllPlay List Create End!!! ");
	}
	// -------------------------------------------
	// ե˥塼
	// Ȥ߹ߥʬ
	//	 Ȥ߹ߥ󡢤äȺȾ֡ġ)
	// -------------------------------------------
	else
	{
	//	if ( global_param.flag_use_skin == TRUE )
	//	{
			create_skin_filemenu(http_recv_info_p, file_info_p, file_num, filemenu_buf_malloc_p, FILEMENU_BUF_SIZE );
	//	}
	//	else
	//	{
	//		create_system_filemenu(http_recv_info_p, file_info_p, file_num, filemenu_buf_malloc_p, FILEMENU_BUF_SIZE );
	//	}
		debug_log_output("Menu Create End!!! ");
	}

	debug_log_output("send_filemenu_size=%d", strlen(filemenu_buf_malloc_p)) ;



	// =================
	// ֿ¹
	// =================
	http_filemenu_send( accept_socket, filemenu_buf_malloc_p );


	free(filemenu_buf_malloc_p);
	free(file_info_malloc_p);

	return;
}





// ****************************************************************************************
// ˥塼Ѥdefine
// ****************************************************************************************



#define		SKIN_MENU_CONF						"wizd_skin.conf"

#define		SKIN_MENU_HEAD_HTML					"head.html"
#define		SKIN_MENU_LINE_MOVIE_FILE_HTML		"line_movie.html"
#define		SKIN_MENU_LINE_MUSIC_FILE_HTML		"line_music.html"
#define		SKIN_MENU_LINE_IMAGE_FILE_HTML		"line_image.html"
#define		SKIN_MENU_LINE_DOCUMENT_FILE_HTML	"line_document.html"
#define		SKIN_MENU_LINE_UNKNOWN_FILE_HTML	"line_unknown.html"
#define		SKIN_MENU_LINE_SVI_FILE_HTML		"line_svi_file.html"
#define		SKIN_MENU_LINE_DIR_HTML				"line_dir.html"
#define		SKIN_MENU_TAIL_HTML					"tail.html"


#define		SKIN_KEYWORD_SERVER_NAME		"<!--WIZD_INSERT_SERVER_NAME-->"		// ̾Сɽ
#define		SKIN_KEYWORD_CURRENT_PATH		"<!--WIZD_INSERT_CURRENT_PATH-->"		// PATHɽ

#define		SKIN_KEYWORKD_PARLENT_DIR_LINK	"<!--WIZD_INSERT_PARENT_DIR_LINK-->"	// ƥǥ쥯ȥꡣLINK URI󥳡ɺѤ
#define		SKIN_KEYWORKD_PARLENT_DIR_NAME	"<!--WIZD_INSERT_PARENT_DIR_NANE-->"	// ƥǥ쥯ȥꡣɽ

#define		SKIN_KEYWORD_CURRENT_PATH_LINK	"<!--WIZD_INSERT_CURRENT_PATH_LINK-->"	// PATHLINKѡURI󥳡ɺѤ


#define		SKIN_KEYWORD_CURRENT_PAGE		"<!--WIZD_INSERT_CURRENT_PAGE-->"		// ߤΥڡ
#define		SKIN_KEYWORD_MAX_PAGE			"<!--WIZD_INSERT_MAX_PAGE-->"			// ڡ
#define		SKIN_KEYWORD_NEXT_PAGE			"<!--WIZD_INSERT_NEXT_PAGE-->"			// Υڡ
#define		SKIN_KEYWORD_PREV_PAGE			"<!--WIZD_INSERT_PREV_PAGE-->"			// Υڡ
#define		SKIN_KEYWORD_FILE_NUM			"<!--WIZD_INSERT_FILE_NUM-->"			// ǥ쥯ȥ¸ߥե
#define		SKIN_KEYWORD_START_FILE_NUM		"<!--WIZD_INSERT_START_FILE_NUM-->"		// Υڡ
#define		SKIN_KEYWORD_END_FILE_NUM		"<!--WIZD_INSERT_END_FILE_NUM-->"		// Υڡ

#define		SKIN_KEYWORD_LINE_FILE_NAME			"<!--WIZD_INSERT_LINE_FILE_NAME-->"			// ե̾ ɽ
#define		SKIN_KEYWORD_LINE_FILE_NAME_NO_EXT	"<!--WIZD_INSERT_LINE_FILE_NAME_NO_EXT-->"	// ե̾(ĥ̵) ɽ
#define		SKIN_KEYWORD_LINE_FILE_EXT			"<!--WIZD_INSERT_LINE_FILE_EXT-->"			// եĥ ɽ
#define		SKIN_KEYWORD_LINE_FILE_LINK			"<!--WIZD_INSERT_LINE_FILE_LINK-->"			// ե̾  URI󥳡

#define		SKIN_KEYWORD_LINE_TIMESTAMP		"<!--WIZD_INSERT_LINE_TIMESTAMP-->"		// ॹ (YYYY/MM/DD HH:MM) ɽ

#define		SKIN_KEYWORD_LINE_FILE_DATE		"<!--WIZD_INSERT_LINE_FILE_DATE-->"		// ॹ դΤ(YYYY/MM/DD) ɽ
#define		SKIN_KEYWORD_LINE_FILE_TIME		"<!--WIZD_INSERT_LINE_FILE_TIME-->"		// ॹ Τ(HH:MM) ɽ



#define		SKIN_KEYWORD_LINE_TVID			"<!--WIZD_INSERT_LINE_TVID-->"			// TVID

#define		SKIN_KEYWORD_LINE_FILE_VOD		"<!--WIZD_INSERT_LINE_FILE_VOD-->"		// vod="0"  ɬפ˱դ
#define		SKIN_KEYWORD_LINE_FILE_SIZE		"<!--WIZD_INSERT_LINE_FILE_SIZE-->"		// ե륵 ɽ

#define		SKIN_KEYWORD_LINE_SVI_INFO		"<!--WIZD_INSERT_LINE_SVI_INFO-->"		// SVIե뤫ɤ ɽ
#define		SKIN_KEYWORD_LINE_SVI_REC_TIME	"<!--WIZD_INSERT_LINE_SVI_REC_TIME-->"	// SVIեϿ

#define		SKIN_KEYWORD_LINE_IMAGE_WIDTH	"<!--WIZD_INSERT_LINE_IMAGE_WIDTH-->"	// β
#define		SKIN_KEYWORD_LINE_IMAGE_HEIGHT	"<!--WIZD_INSERT_LINE_IMAGE_HEIGHT-->"	// ι⤵

#define		SKIN_KEYWORD_SECRET_DIR_LINK	"<!--WIZD_INSERT_SECRET_DIR_LINK-->"	// ǥ쥯ȥ


#define		SKIN_KEYWORD_LINE_MP3TAG_TITLE		"<!--WIZD_INSERT_LINE_MP3TAG_TITLE-->"		// MP3 ȥ
#define		SKIN_KEYWORD_LINE_MP3TAG_ALBUM		"<!--WIZD_INSERT_LINE_MP3TAG_ALBUM-->"		// MP3 Х̾
#define		SKIN_KEYWORD_LINE_MP3TAG_ARTIST		"<!--WIZD_INSERT_LINE_MP3TAG_ARTIST-->"		// MP3 ƥ
#define		SKIN_KEYWORD_LINE_MP3TAG_YEAR		"<!--WIZD_INSERT_LINE_MP3TAG_YEAR-->"		// MP3 ǯ
#define		SKIN_KEYWORD_LINE_MP3TAG_COMMENT	"<!--WIZD_INSERT_LINE_MP3TAG_COMMENT-->"	// MP3 

#define		SKIN_KEYWORD_LINE_MP3TAG_TITLE_INFO	"<!--WIZD_INSERT_LINE_MP3TAG_TITLE_INFO-->"	// MP3 ȥ[Х̾/ƥ] ɽ(menu_filename_length_maxˤ¤)


// ʲΥɤǶޤ줿ꥢϡפȤ˺롣

// 롼ȥǥ쥯ȥξ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_ROOTDIR				"<!--WIZD_DELETE_IS_ROOTDIR-->"
#define		SKIN_KEYWORD_DEL_IS_ROOTDIR_E			"<!--/WIZD_DELETE_IS_ROOTDIR-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV		"<!--WIZD_DELETE_IS_NO_PAGE_PREV-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV_E		"<!--/WIZD_DELETE_IS_NO_PAGE_PREV-->"

// ڡ¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT		"<!--WIZD_DELETE_IS_NO_PAGE_NEXT-->"
#define		SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT_E		"<!--/WIZD_DELETE_IS_NO_PAGE_NEXT-->"

// ǽե뤬¸ߤʤ (HEAD/TAILΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES		"<!--WIZD_DELETE_IS_NO_STREAM_FILES-->"
#define		SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES_E	"<!--/WIZD_DELETE_IS_NO_STREAM_FILES-->"


// MP3¸ߤʤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS			"<!--WIZD_DELETE_IS_NO_MP3_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS_E		"<!--/WIZD_DELETE_IS_NO_MP3_TAGS-->"

// MP3¸ߤȤ (LINEΤ)
#define		SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS		"<!--WIZD_DELETE_IS_HAVE_MP3_TAGS-->"
#define		SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS_E		"<!--/WIZD_DELETE_IS_HAVE_MP3_TAGS-->"


// **************************************************************************
// Ѥե˥塼
// **************************************************************************
static void create_skin_filemenu(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size)
{

	unsigned char	*menu_head_skin_p;
	int				menu_head_skin_malloc_size;

	unsigned char	*menu_tail_skin_p;
	int 			menu_tail_skin_malloc_size;

	unsigned char	*menu_line_movie_skin_p;
	int				menu_line_movie_skin_malloc_size;

	unsigned char	*menu_line_music_skin_p;
	int				menu_line_music_skin_malloc_size;

	unsigned char	*menu_line_image_skin_p;
	int				menu_line_image_skin_malloc_size;

	unsigned char	*menu_line_document_skin_p;
	int				menu_line_document_skin_malloc_size;

	unsigned char	*menu_line_unknown_skin_p;
	int				menu_line_unknown_skin_malloc_size;

	unsigned char	*menu_line_svi_skin_p;
	int				menu_line_svi_skin_malloc_size;

	unsigned char	*menu_line_dir_skin_p;
	int				menu_line_dir_skin_malloc_size;


	unsigned char	*menu_work_p;

	unsigned char	skin_path[FILENAME_MAX];
	unsigned char	read_filename[FILENAME_MAX];

	int		i, j;


	unsigned char	work_filename[FILENAME_MAX];

	unsigned char	work_data[FILENAME_MAX];
	unsigned char	work_data2[FILENAME_MAX];

	int		now_page;		// ߤΥڡֹ
	int		max_page;		// ڡֹ
	int		now_page_line;	// ߤΥڡɽԿ
	int		start_file_num;	// ߥڡɽϥեֹ
	int		end_file_num;	// ߥڡɽλեֹ

	int		next_page;		// Υڡ(̵max_page)
	int		prev_page;		// Υڡ̵ 1)


	SKIN_REPLASE_GLOBAL_DATA_T	*skin_rep_data_global_p;
	SKIN_REPLASE_LINE_DATA_T	*skin_rep_data_line_p;

	int skin_rep_line_malloc_size;

	unsigned int	rec_time;
	int	count;

	unsigned int	image_width, image_height;

	struct	stat	dir_stat;
	int				result;

	// ==========================================
	// SKINեեɤ߹
	// ==========================================

	// ----------------------------------------------
	// Τեѥʥեѥ)
	// ----------------------------------------------
	strncpy(skin_path, global_param.skin_root, sizeof(skin_path) ); // ֤
	if ( skin_path[ strlen(skin_path)-1 ] != '/' )// Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_path, "/", sizeof(skin_path) -strlen(skin_path) );
	}

	strncat(skin_path, global_param.skin_name, sizeof(skin_path) - strlen(skin_path) ); // ̾ʥǥ쥯ȥ
	if ( skin_path[ strlen(skin_path)-1 ] != '/' ) // Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_path, "/", sizeof(skin_path) - strlen(skin_path) );
	}


	// ----------------------------------------------
	// SKINեեΥեѥ
	// ----------------------------------------------
	strncpy(read_filename, skin_path, sizeof(read_filename) );
	strncat(read_filename, SKIN_MENU_CONF, sizeof(read_filename)- strlen(read_filename) );
	debug_log_output("skin: read_config_filename='%s'", read_filename);

	// ----------------------------------------------
	// SKIN եե ɤ߹߼¹
	// ----------------------------------------------
	skin_config_file_read(read_filename);



	// ==========================================
	// HTML Ƽ׻
	// ==========================================

	// ǥ쥯ȥ¸ߥե
	debug_log_output("file_num = %d", file_num);

	// ڡ׻
	if ( file_num == 0 )
	{
		max_page = 1;
	}
	else if ( (file_num % global_param.page_line_max) == 0 )
	{
		max_page = (file_num / global_param.page_line_max);
	}
	else
	{
		max_page = (file_num / global_param.page_line_max) + 1;
	}
	debug_log_output("max_page = %d", max_page);

	// ɽڡֹ ׻
	if ( (http_recv_info_p->page <= 1 ) || (max_page < http_recv_info_p->page ) )
		now_page = 1;
	else
		now_page = http_recv_info_p->page;

	debug_log_output("now_page = %d", now_page);

	// ɽڡɽԿ׻
	if ( max_page == now_page ) // ǸΥڡ
		now_page_line = file_num - (global_param.page_line_max * (max_page-1));
	else	// Ǹʳʤ顢ɽ
		now_page_line = global_param.page_line_max;
	debug_log_output("now_page_line = %d", now_page_line);


	// ɽϥեֹ׻
	start_file_num = ((now_page - 1) * global_param.page_line_max);
	debug_log_output("start_file_num = %d", start_file_num);

	if ( max_page == now_page ) // ǸΥڡ
		end_file_num = file_num;
	else // ǸΥڡǤϤʤä顣
		end_file_num = (start_file_num + global_param.page_line_max);
	debug_log_output("start_file_num = %d", start_file_num);




	// ڡֹ ׻
	prev_page =  1 ;
	if ( now_page > 1 )
		prev_page = now_page - 1;

	// ڡֹ ׻
	next_page = max_page ;
	if ( max_page > now_page )
		next_page = now_page + 1;

	debug_log_output("prev_page=%d  next_page=%d", prev_page ,next_page);



	// ===============================
	// ִѥǡ
	// ===============================

	// ȥꥢ
	skin_rep_data_global_p 	= malloc( sizeof(SKIN_REPLASE_GLOBAL_DATA_T) );
	if ( skin_rep_data_global_p == NULL )
	{
		debug_log_output("malloc() error.");
		return ;
	}
	memset(skin_rep_data_global_p, '\0', sizeof(SKIN_REPLASE_GLOBAL_DATA_T));

	skin_rep_line_malloc_size = sizeof(SKIN_REPLASE_LINE_DATA_T) * (global_param.page_line_max + 1);
	skin_rep_data_line_p 	= malloc( skin_rep_line_malloc_size );
	if ( skin_rep_data_line_p == NULL )
	{
		debug_log_output("malloc() error.");
		return ;
	}
	memset(skin_rep_data_line_p, '\0', sizeof(skin_rep_line_malloc_size));


	// ---------------------------------
	// Х ɽѾ 
	// ---------------------------------

	// ľΥǥ쥯ȥѥ(ƥѥ)(URI󥳡)
	strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) - strlen(work_data) );
	cut_after_last_character(work_data, '/'); //
	cut_after_last_character(work_data, '/');
	strncat(work_data, "/", sizeof(work_data) - strlen(work_data) ); // '/'ɲá
	debug_log_output("parent_directory='%s'", work_data);

 	uri_encode(skin_rep_data_global_p->parent_directory_link, sizeof(skin_rep_data_global_p->parent_directory_link), work_data, strlen(work_data));

	// '?'ɲ
	strncat(skin_rep_data_global_p->parent_directory_link, "?", sizeof(skin_rep_data_global_p->parent_directory_link) - strlen(skin_rep_data_global_p->parent_directory_link));
	// sort=ؼƤ硢Ѥ
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
		strncat(skin_rep_data_global_p->parent_directory_link, work_data, sizeof(skin_rep_data_global_p->parent_directory_link) - strlen(skin_rep_data_global_p->parent_directory_link));
	}
	debug_log_output("parent_directory_link='%s'", skin_rep_data_global_p->parent_directory_link);


	// ѥ̾ ɽ(ʸѴ)
	strncpy( work_data, http_recv_info_p->recv_uri, sizeof(work_data) );

	if ( global_param.flag_decode_samba_hex_and_cap == TRUE )
	{
		debug_log_output("current_directory_name(cap/hex) = '%s'", work_data);
		decode_samba_hex_and_cap_coding( work_data );
		debug_log_output("current_directory_name(bin) = '%s'", work_data);
	}

	// ѥ̾ ɽ(ʸѴ)
	convert_language_code(	work_data,
							skin_rep_data_global_p->current_directory_name,
							sizeof(skin_rep_data_global_p->current_directory_name),
							global_param.server_language_code,
							global_param.client_language_code );



	debug_log_output("current_dir = '%s'", skin_rep_data_global_p->current_directory_name );


	// ѥ̾ LinkURI󥳡ɡ
 	uri_encode(skin_rep_data_global_p->current_directory_link, sizeof(skin_rep_data_global_p->current_directory_link), http_recv_info_p->recv_uri, strlen(http_recv_info_p->recv_uri));

	// ?ɲ
	strncat(skin_rep_data_global_p->current_directory_link, "?", sizeof(skin_rep_data_global_p->current_directory_link) - strlen(skin_rep_data_global_p->current_directory_link)); // '?'ɲ
	// sort=ؼƤ硢Ѥ
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
		strncat(skin_rep_data_global_p->current_directory_link, work_data, sizeof(skin_rep_data_global_p->current_directory_link) - strlen(skin_rep_data_global_p->current_directory_link));
	}
	debug_log_output("current_directory_link='%s'", skin_rep_data_global_p->current_directory_link);

	// ǥ쥯ȥ¸ߥե ɽ
	snprintf(skin_rep_data_global_p->file_num_str, sizeof(skin_rep_data_global_p->file_num_str), "%d", file_num );

	// 	ߤΥڡ ɽ
	snprintf(skin_rep_data_global_p->now_page_str, sizeof(skin_rep_data_global_p->now_page_str), "%d", now_page );

	// ڡ ɽ
	snprintf(skin_rep_data_global_p->max_page_str, sizeof(skin_rep_data_global_p->max_page_str), "%d", max_page );

	// Υڡ ɽ
	snprintf(skin_rep_data_global_p->next_page_str, sizeof(skin_rep_data_global_p->next_page_str), "%d", next_page );

	// Υڡ ɽ
	snprintf(skin_rep_data_global_p->prev_page_str, sizeof(skin_rep_data_global_p->prev_page_str), "%d", prev_page );

	// ϥեֹɽ
	if ( file_num == 0 )
		snprintf(skin_rep_data_global_p->start_file_num_str, sizeof(skin_rep_data_global_p->start_file_num_str), "%d", start_file_num );
	else
		snprintf(skin_rep_data_global_p->start_file_num_str, sizeof(skin_rep_data_global_p->start_file_num_str), "%d", start_file_num +1 );

	// λեֹɽ
	snprintf(skin_rep_data_global_p->end_file_num_str, sizeof(skin_rep_data_global_p->end_file_num_str), "%d", end_file_num  );


	// ǥ쥯ȥƱ̾եǽ
	if ( global_param.flag_filename_cut_same_directory_name == TRUE )
	{
		// Х̾ (ǥ쥯ȥƱ̾եǽǻ)
		convert_language_code(	http_recv_info_p->recv_uri,
								skin_rep_data_global_p->euc_current_dir_name,
								sizeof(skin_rep_data_global_p->euc_current_dir_name),
								global_param.server_language_code,
								CODE_EUC );

		// Ǹ'/'դƤ
		cut_character_at_linetail(skin_rep_data_global_p->euc_current_dir_name, '/' );
		// '/'
		cut_before_last_character(skin_rep_data_global_p->euc_current_dir_name, '/' );

		debug_log_output("euc_current_dir = '%s'", skin_rep_data_global_p->euc_current_dir_name );
	}


	skin_rep_data_global_p->stream_files = 0;	// ǽե

	// ---------------------------------
	// եɽѾ 
	// ---------------------------------
	for ( i=start_file_num, count=0; i<(start_file_num + now_page_line) ; i++, count++ )
	{
		// --------------------------------------------------------------------------------
		// ĥ̵ե̾ɽѡ 
		// ե̾ Ĺ¤˹碌Cut
		// ե̾  EUCɤ  ĥCut  ʸCut  MediaWizʸɤ
		// --------------------------------------------------------------------------------

		// EUCˡ
		convert_language_code( 	file_info_p[i].name,
								work_data,
								sizeof(work_data),
								global_param.server_language_code,
								CODE_EUC);

		// ĥҡͭХå
		if ( strchr(work_data, '.') != NULL )
		{
			cut_after_last_character(work_data, '.');
		}
		debug_log_output("file_name_no_ext='%s'\n", work_data);


		// ()[]κե饰å
		// ե饰TRUEǡե뤬ǥ쥯ȥǤʤС̤롣

		if (( S_ISDIR( file_info_p[i].type ) == 0 ) &&
		    ( global_param.flag_filename_cut_parenthesis_area == TRUE ))
		{
			cut_enclose_words(work_data, sizeof(work_data), "(", ")");
			cut_enclose_words(work_data, sizeof(work_data), "[", "]");
			debug_log_output("file_name_no_ext(enclose_words)='%s'\n", work_data);
		}

		// ǥ쥯ȥƱ̾ʸե饰å
		// ե饰TRUEǡե뤬ǥ쥯ȥǤʤСƱʸ
		if (( S_ISDIR( file_info_p[i].type ) == 0 ) 						&&
		    ( global_param.flag_filename_cut_same_directory_name == TRUE ) 	&&
		    ( strlen(skin_rep_data_global_p->euc_current_dir_name) > 0 )		)
		{

			// ǥ쥯ȥƱ̾ʸ""ִ
			replase_character(work_data, sizeof(work_data), skin_rep_data_global_p->euc_current_dir_name, "");

			// Ƭ' 'դƤ褦ʤк
			cut_first_character(work_data, ' ');

			debug_log_output("file_name_no_ext(cut_same_directory_name)='%s'\n", work_data);
		}

		// Ĺ¤ĶƤCut
		debug_log_output("file_name_no_ext length=%d, menu_filename_length_max=%d", strlen(work_data) , global_param.menu_filename_length_max);
		if ( strlen(work_data) > global_param.menu_filename_length_max )
		{
			// CUT¹
			euc_string_cut_n_length(work_data, global_param.menu_filename_length_max);
			debug_log_output("file_name_no_ext(cut)='%s'\n", work_data);
		}

		// MediaWizʸɤ
		convert_language_code(	work_data,
								skin_rep_data_line_p[count].file_name_no_ext,
								sizeof(skin_rep_data_line_p[count].file_name_no_ext),
								CODE_AUTO,
								global_param.client_language_code);

		debug_log_output("file_name_no_ext='%s'\n", skin_rep_data_line_p[count].file_name_no_ext);

		// ե̾(ĥ̵) λ
		// --------------------------------------


		// --------------------------------------------------------------------------------
		// ĥҤ
		// --------------------------------------------------------------------------------
		filename_to_extension(file_info_p[i].name, skin_rep_data_line_p[count].file_extension, sizeof(skin_rep_data_line_p[count].file_extension));
		debug_log_output("file_extension='%s'\n", skin_rep_data_line_p[count].file_extension);

		// --------------------------------------------------------------------------------
		// ե̾  (ɽ)  (no_extext򤯤äĤ)
		// --------------------------------------------------------------------------------
		strncpy(skin_rep_data_line_p[count].file_name, skin_rep_data_line_p[count].file_name_no_ext, sizeof(skin_rep_data_line_p[count].file_name));
		if ( strlen(skin_rep_data_line_p[count].file_extension) > 0 )
		{
			strncat(skin_rep_data_line_p[count].file_name, ".", sizeof(skin_rep_data_line_p[count].file_name));
			strncat(skin_rep_data_line_p[count].file_name, skin_rep_data_line_p[count].file_extension, sizeof(skin_rep_data_line_p[count].file_name));
		}

		// --------------------------------------------------------------------------------
		// LinkURI(󥳡ɺѤ) 
		// --------------------------------------------------------------------------------
		strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) );
		strncat(work_data, file_info_p[i].org_name, sizeof(work_data) - strlen(work_data) );
	 	uri_encode(skin_rep_data_line_p[count].file_uri_link, sizeof(skin_rep_data_line_p[count].file_uri_link), work_data, strlen(work_data) );
		debug_log_output("file_uri_link='%s'\n", skin_rep_data_line_p[count].file_uri_link);


		// --------------------------------------------------------------------------------
		// ե륹פʸ
		// --------------------------------------------------------------------------------
		conv_time_to_string(skin_rep_data_line_p[count].file_timestamp, file_info_p[i].time );
		conv_time_to_date_string(skin_rep_data_line_p[count].file_timestamp_date, file_info_p[i].time );
		conv_time_to_time_string(skin_rep_data_line_p[count].file_timestamp_time, file_info_p[i].time );





		// --------------------------------------------------------------------------------
		// ե륵ɽʸ
		// --------------------------------------------------------------------------------
		conv_num_to_unit_string(skin_rep_data_line_p[count].file_size_string, file_info_p[i].size );
		debug_log_output("'%s'", skin_rep_data_line_p[count].file_size_string );

		// --------------------------------------------------------------------------------
		// tvid ɽʸ
		// --------------------------------------------------------------------------------
		snprintf(skin_rep_data_line_p[count].tvid_string, sizeof(skin_rep_data_line_p[count].tvid_string), "%d", i+1 );

		// --------------------------------------------------------------------------------
		// vod_string ɽʸ Ȥꤢ""
		// --------------------------------------------------------------------------------
		strncpy(skin_rep_data_line_p[count].vod_string, "", sizeof(skin_rep_data_line_p[count].vod_string) );


		// =========================================================
		// ե륿Ƚ
		// =========================================================
		if ( S_ISDIR( file_info_p[i].type ) != 0 ) // ǥ쥯ȥ꤫
		{

			skin_rep_data_line_p[count].stream_type = TYPE_NO_STREAM;
			skin_rep_data_line_p[count].menu_file_type = TYPE_DIRECTORY;
		}
		else // ǥ쥯ȥʳ
		{
			skin_rep_data_line_p[count].menu_file_type = TYPE_UNKNOWN;
			for (j=0;;j++)
			{
				if (( mime_list[j].mime_name == NULL ) || ( strlen(skin_rep_data_line_p[count].file_extension) == 0 ) )
					break;

				if ( strcasecmp(mime_list[j].file_extension, skin_rep_data_line_p[count].file_extension) == 0 )
				{
					skin_rep_data_line_p[count].stream_type = mime_list[j].stream_type;
					skin_rep_data_line_p[count].menu_file_type = mime_list[j].menu_file_type;
					break;
				}
			}
		}


		// =========================================================
		// ե륿ɬפʸɲä
		// =========================================================

		// ----------------------------
		// ǥ쥯ȥ 
		// ----------------------------
		if ( skin_rep_data_line_p[count].menu_file_type == TYPE_DIRECTORY )
		{
			// '?'ɲä롣
			strncat(skin_rep_data_line_p[count].file_uri_link, "?", sizeof(skin_rep_data_line_p[count].file_uri_link) - strlen(skin_rep_data_line_p[count].file_uri_link));

			// sort=ؼƤ硢Ѥ
			if ( strlen(http_recv_info_p->sort) > 0 )
			{
				snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
				strncat(skin_rep_data_line_p[count].file_uri_link, work_data, sizeof(skin_rep_data_line_p[count].file_uri_link) - strlen(skin_rep_data_line_p[count].file_uri_link));
			}

		}

		// -------------------------------------
		// ȥ꡼ե 
		// -------------------------------------
		if ( skin_rep_data_line_p[count].stream_type == TYPE_STREAM )
		{
			// vod_string "vod="0" 򥻥å
			strncpy(skin_rep_data_line_p[count].vod_string, "vod=\"0\"", sizeof(skin_rep_data_line_p[count].vod_string) );

			// ĥ֤
			extension_add_rename(skin_rep_data_line_p[count].file_uri_link);

			// ǽե륫
			skin_rep_data_global_p->stream_files++;


			// -------------------------------------
			// SVIե ɲ 
			// -------------------------------------
			if ( skin_rep_data_line_p[count].menu_file_type == TYPE_SVI )
			{
				// ------------------------------
				// SVIȴ
				// ------------------------------

				// SVIեΥեѥ
				strncpy(work_filename, http_recv_info_p->send_filename, sizeof(work_filename) );
				if ( work_filename[strlen(work_filename)-1] != '/' )
				{
					strncat(work_filename, "/", sizeof(work_filename) - strlen(work_filename) );
				}
				strncat(work_filename, file_info_p[i].org_name, sizeof(work_filename) - strlen(work_filename));

				// --------------------------------------------------
				// SVIե뤫򥲥åȤơʸѴ
				// Ĺ¤˹碌Cut
				//  EUCѴ  Cut  MediaWizʸɤѴ
				// --------------------------------------------------
				read_svi_info(work_filename, skin_rep_data_line_p[count].svi_info_data, sizeof(skin_rep_data_line_p[count].svi_info_data),  &rec_time );
				if ( strlen(skin_rep_data_line_p[count].svi_info_data) > 0 )
				{
					convert_language_code(	skin_rep_data_line_p[count].svi_info_data,
											work_data,
											sizeof(work_data),
											CODE_AUTO,
											CODE_EUC );

					if ( strlen(work_data) > global_param.menu_svi_info_length_max )
					{
						// CUT¹
						euc_string_cut_n_length(work_data, global_param.menu_svi_info_length_max);
					}
					// MediaWizʸɤ
					convert_language_code(	work_data,
											skin_rep_data_line_p[count].svi_info_data,
											sizeof(skin_rep_data_line_p[count].svi_info_data),
											CODE_AUTO,
											global_param.client_language_code);
				}
				debug_log_output("svi_info_data='%s'\n", skin_rep_data_line_p[count].svi_info_data);

				// SVIɤϿ֤ʸˡ
				snprintf(skin_rep_data_line_p[count].svi_rec_time_data, sizeof(skin_rep_data_line_p[count].svi_rec_time_data),
							"%02d:%02d:%02d", rec_time /3600, (rec_time % 3600) / 60, rec_time % 60 );
			}

			// ----------------------------
			// playlistե 
			// ----------------------------
			if ( (strcasecmp(skin_rep_data_line_p[count].file_extension, "plw") == 0) ||
				 (strcasecmp(skin_rep_data_line_p[count].file_extension, "upl") == 0) 	)
			{
				// vod_string  "vod="playlist"򥻥å
				strncpy(skin_rep_data_line_p[count].vod_string, "vod=\"playlist\"", sizeof(skin_rep_data_line_p[count].vod_string) );

			}



		}


		// ----------------------------
		// IMAGEե
		// ----------------------------
		if ( skin_rep_data_line_p[count].menu_file_type == TYPE_IMAGE )
		{
			// ----------------------------------
			// ᡼եΥեѥ
			// ----------------------------------
			strncpy(work_filename, http_recv_info_p->send_filename, sizeof(work_filename) );
			if ( work_filename[strlen(work_filename)-1] != '/' )
			{
				strncat(work_filename, "/", sizeof(work_filename) - strlen(work_filename) );
			}
			strncat(work_filename, file_info_p[i].org_name, sizeof(work_filename) - strlen(work_filename));
			debug_log_output("work_filename(image) = %s", work_filename);



			// ------------------------
			// ᡼ΥGET
			// ------------------------

			image_width = 0;
			image_height = 0;

			// ĥҤʬ
			if ( (strcasecmp( skin_rep_data_line_p[count].file_extension, "jpg" ) == 0 ) ||
				 (strcasecmp( skin_rep_data_line_p[count].file_extension, "jpeg" ) == 0 ))
			{
				// JPEGեΥGET
				jpeg_size( work_filename, &image_width, &image_height );
			}
			else if (strcasecmp( skin_rep_data_line_p[count].file_extension, "gif" ) == 0 )
			{
				// GIFեΥGET
				gif_size( work_filename, &image_width, &image_height );
			}
			else if (strcasecmp( skin_rep_data_line_p[count].file_extension, "png" ) == 0 )
			{
				// PNGեΥGET
				png_size( work_filename, &image_width, &image_height );
			}

			// ʸˡ
			snprintf(skin_rep_data_line_p[count].image_width, sizeof(skin_rep_data_line_p[count].image_width), "%d", image_width );
			snprintf(skin_rep_data_line_p[count].image_height, sizeof(skin_rep_data_line_p[count].image_height), "%d", image_height );

			// ----------------------------------
			// 󥯤κǸ'?'ɲä롣
			// ----------------------------------
			strncat(skin_rep_data_line_p[count].file_uri_link, "?", sizeof(skin_rep_data_line_p[count].file_uri_link) - strlen(skin_rep_data_line_p[count].file_uri_link));

			// sort=ؼƤ硢Ѥ
			if ( strlen(http_recv_info_p->sort) > 0 )
			{
				snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
				strncat(skin_rep_data_line_p[count].file_uri_link, work_data, sizeof(skin_rep_data_line_p[count].file_uri_link) - strlen(skin_rep_data_line_p[count].file_uri_link));
			}
		}


		// -------------------------------------
		// MUSICե 
		// -------------------------------------
		if (skin_rep_data_line_p[count].menu_file_type == TYPE_MUSIC)
		{
			// vod_string  "vod="playlist"򥻥å
			strncpy(skin_rep_data_line_p[count].vod_string, "vod=\"playlist\"", sizeof(skin_rep_data_line_p[count].vod_string) );

			// 󥯤κǸ'?action=SinglePlay&'ɲä롣
			strncat(skin_rep_data_line_p[count].file_uri_link, "?action=SinglePlay&", sizeof(skin_rep_data_line_p[count].file_uri_link) - strlen(skin_rep_data_line_p[count].file_uri_link));
		}




		// -------------------------------------
		// MP3ե 
		// -------------------------------------
		if ( (skin_rep_data_line_p[count].menu_file_type == TYPE_MUSIC) &&
			 (strcasecmp(skin_rep_data_line_p[count].file_extension, "mp3") == 0) )
		{

			// ----------------------------------
			// MP3եΥեѥ
			// ----------------------------------
			strncpy(work_filename, http_recv_info_p->send_filename, sizeof(work_filename) );
			if ( work_filename[strlen(work_filename)-1] != '/' )
			{
				strncat(work_filename, "/", sizeof(work_filename) - strlen(work_filename) );
			}
			strncat(work_filename, file_info_p[i].org_name, sizeof(work_filename) - strlen(work_filename));
			debug_log_output("work_filename(mp3) = %s", work_filename);


			// ------------------------
			// MP3ID3V1ǡGET
			// ------------------------
			mp3_id3v1_tag_read(work_filename, &(skin_rep_data_line_p[count]) );

			// for Debug.
			if ( skin_rep_data_line_p[count].mp3_id3v1_flag > 0 )
			{
				debug_log_output("mp3 title:'%s'", 		skin_rep_data_line_p[count].mp3_id3v1_title);
				debug_log_output("mp3 album:'%s'", 		skin_rep_data_line_p[count].mp3_id3v1_album);
				debug_log_output("mp3 artist:'%s'", 	skin_rep_data_line_p[count].mp3_id3v1_artist);
				debug_log_output("mp3 year:'%s'", 		skin_rep_data_line_p[count].mp3_id3v1_year);
				debug_log_output("mp3 comment:'%s'",	skin_rep_data_line_p[count].mp3_id3v1_comment);
				debug_log_output("mp3 title_info:'%s'",	skin_rep_data_line_p[count].mp3_id3v1_title_info);
				debug_log_output("mp3 title_info_limited:'%s'",	skin_rep_data_line_p[count].mp3_id3v1_title_info_limited);
			}

		}
	}

	debug_log_output("\ncount=%d", count);



	// ============================
	// ǥ쥯ȥ긡
	// ============================

	memset(skin_rep_data_global_p->secret_dir_link_html, '\0', sizeof(skin_rep_data_global_p->secret_dir_link_html));

	// ǥ쥯ȥ꤬¸ߤƤ뤫å
	for ( i=0; i<SECRET_DIRECTORY_MAX; i++)
	{
		if ( strlen(secret_directory_list[i].dir_name) > 0 )	// ǥ쥯ȥͭꡩ
		{
			// ----------------------------------
			// ǥ쥯ȥΥեѥ
			// ----------------------------------
			strncpy(work_filename, http_recv_info_p->send_filename, sizeof(work_filename) );
			if ( work_filename[strlen(work_filename)-1] != '/' )
			{
				strncat(work_filename, "/", sizeof(work_filename) - strlen(work_filename) );
			}
			strncat(work_filename, secret_directory_list[i].dir_name, sizeof(work_filename) - strlen(work_filename));
			debug_log_output("check: work_filename = %s", work_filename);

			// ¸ߥå
			result = stat(work_filename, &dir_stat);
			if ( result == 0 )
			{
				if ( S_ISDIR(dir_stat.st_mode) != 0 ) // ǥ쥯ȥ¸ߡ
				{
					// ¸ߤƤ顢URI
					strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) );
					strncat(work_data, secret_directory_list[i].dir_name, sizeof(work_data) - strlen(work_data) );
	 				uri_encode(work_data2, sizeof(work_data2), work_data, strlen(work_data) );

					// HTML
					snprintf(work_data, sizeof(work_data), "<a href=\"%s\" tvid=%d></a> ", work_data2, secret_directory_list[i].tvid);

					debug_log_output("secret_dir_html='%s'", work_data);
					strncat( skin_rep_data_global_p->secret_dir_link_html, work_data, sizeof(skin_rep_data_global_p->secret_dir_link_html) - strlen(skin_rep_data_global_p->secret_dir_link_html) );

				}
			}
		}
		else
		{
			break;
		}
	}
	debug_log_output("secret_dir_html='%s'", skin_rep_data_global_p->secret_dir_link_html);


	// ======================================================================================
	// ======================================================================================
	//  ǡϡ
	// ======================================================================================
	// ======================================================================================




	// ===============================
	// HEAD ե ɤ߹
	// ===============================

	// HEAD ե̾
	strncpy(read_filename, skin_path, sizeof(read_filename) );
	strncat(read_filename, SKIN_MENU_HEAD_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);

	// եɤ߹
	menu_head_skin_p = skin_file_read(read_filename, &menu_head_skin_malloc_size );
	if ( menu_head_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return ;
	}

	// ------------------------------------------------------------
	//  HEAD ִ
	// ------------------------------------------------------------
	replase_skin_grobal_data(menu_head_skin_p, menu_head_skin_malloc_size, skin_rep_data_global_p);

	// ----------------------
	// ̤򥳥ԡ
	// ----------------------
	strncpy(send_filemenu_buf, menu_head_skin_p, buf_size );
	free(menu_head_skin_p);
	debug_log_output("skin: free() end." );



	// ====================================
	// LINE ִ
	// ====================================

	// ȥꥢ
	menu_work_p = malloc(buf_size);
	if ( menu_work_p == NULL)
	{
		debug_log_output("malloc() error.");
		return;
	}


	// ===============================
	// ǡɤ߹
	// ===============================


	// DIR ɤ߹
	strncpy(read_filename, skin_path, sizeof(read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_DIR_HTML, sizeof(read_filename)-strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_dir_skin_p = skin_file_read( read_filename, &menu_line_dir_skin_malloc_size );
	if ( menu_line_dir_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// MOVIE ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_MOVIE_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_movie_skin_p = skin_file_read( read_filename, &menu_line_movie_skin_malloc_size );
	if ( menu_line_movie_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// MUSIC ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_MUSIC_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_music_skin_p = skin_file_read( read_filename, &menu_line_music_skin_malloc_size );
	if ( menu_line_music_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// IMAGE ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_IMAGE_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_image_skin_p = skin_file_read( read_filename, &menu_line_image_skin_malloc_size );
	if ( menu_line_image_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// DOCUMENT ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_DOCUMENT_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_document_skin_p = skin_file_read( read_filename, &menu_line_document_skin_malloc_size );
	if ( menu_line_document_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// UNKNOWN ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_UNKNOWN_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_unknown_skin_p = skin_file_read( read_filename, &menu_line_unknown_skin_malloc_size );
	if ( menu_line_unknown_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}


	// SVI ɤ߹
	strncpy(read_filename, skin_path, sizeof( read_filename) );
	strncat(read_filename, SKIN_MENU_LINE_SVI_FILE_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);
	menu_line_svi_skin_p = skin_file_read(read_filename, &menu_line_svi_skin_malloc_size );
	if ( menu_line_svi_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// =================================
	//  ϡ
	// =================================
	for ( count=0; count< now_page_line;  count++ )
	{

		// --------------------------------------------------------
		// ե륿פˤꡢб륹ǡcopy
		// --------------------------------------------------------

		if ( skin_rep_data_line_p[count].menu_file_type == TYPE_DIRECTORY )	// ǥ쥯ȥ
		{
			strncpy(menu_work_p, menu_line_dir_skin_p, buf_size );
		}
		else if ( skin_rep_data_line_p[count].menu_file_type == TYPE_MOVIE ) // MOVIE
		{
			strncpy(menu_work_p, menu_line_movie_skin_p, buf_size );
		}
		else if ( skin_rep_data_line_p[count].menu_file_type == TYPE_MUSIC ) // MUSIC
		{
			strncpy(menu_work_p, menu_line_music_skin_p, buf_size );
		}
		else if ( skin_rep_data_line_p[count].menu_file_type == TYPE_IMAGE ) // IMAGE
		{
			strncpy(menu_work_p, menu_line_image_skin_p, buf_size );
		}
		else if ( skin_rep_data_line_p[count].menu_file_type == TYPE_DOCUMENT ) // DOCUMENT
		{
			strncpy(menu_work_p, menu_line_document_skin_p, buf_size );
		}
		else if ( skin_rep_data_line_p[count].menu_file_type == TYPE_SVI )		// SVI
		{
			strncpy(menu_work_p, menu_line_svi_skin_p, buf_size );
		}
		else	// Unknown
		{
			strncpy(menu_work_p, menu_line_unknown_skin_p, buf_size );
		}


		// -----------------------------
		// LINE ִ
		// -----------------------------
		replase_skin_line_data(menu_work_p, buf_size, &(skin_rep_data_line_p[count]) );
		replase_skin_grobal_data(menu_work_p, buf_size, skin_rep_data_global_p);


		// ------------------------------
		// FILE_NAME ̤򥳥ԡ
		// ------------------------------
		strncat(send_filemenu_buf, menu_work_p, buf_size );
	}

	// ΰ
	free( menu_work_p );
	free( menu_line_movie_skin_p );
	free( menu_line_music_skin_p );
	free( menu_line_image_skin_p );
	free( menu_line_document_skin_p );
	free( menu_line_unknown_skin_p );
	free( menu_line_svi_skin_p );
	free( menu_line_dir_skin_p );



	// =======================
	// TAIL ե̾
	// =======================

	// ե̾
	strncpy(read_filename, skin_path, sizeof(read_filename) );
	strncat(read_filename, SKIN_MENU_TAIL_HTML, sizeof(read_filename) - strlen(read_filename) );
	debug_log_output("skin: read_filename='%s'", read_filename);

	// եɤ߹
	menu_tail_skin_p = skin_file_read( read_filename,  &menu_tail_skin_malloc_size );
	if ( menu_tail_skin_p == NULL )
	{
		debug_log_output("skin_file_read() error.");
		return;
	}

	// ------------------------------------------------------------
	// ============================================================
	//  TAIL ִ
	// ============================================================
	// ------------------------------------------------------------
	replase_skin_grobal_data(menu_tail_skin_p, menu_tail_skin_malloc_size, skin_rep_data_global_p);


	// ---------------
	// ̤򥳥ԡ
	// ---------------
	strncat(send_filemenu_buf, menu_tail_skin_p, buf_size - strlen(send_filemenu_buf));

	free(menu_tail_skin_p);



	free( skin_rep_data_global_p );
	free( skin_rep_data_line_p );


	return;
}





// **************************************************************************
// ѥǡ ޤȤִ
// **************************************************************************
static void replase_skin_grobal_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_GLOBAL_DATA_T *skin_rep_data_global_p)
{

	// ===============================
	// = ɤ
	// ===============================

	// 롼ȥѥξ硣
	if ( strcmp(skin_rep_data_global_p->current_directory_name, "/" ) == 0 )
	{
		//debug_log_output("SKIN_KEYWORD_DEL_IS_ROOTDIR hit.");
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_ROOTDIR, SKIN_KEYWORD_DEL_IS_ROOTDIR_E);
	}

	// ڡξ
	if ( strcmp(skin_rep_data_global_p->now_page_str, "1" ) == 0 )
	{
		//debug_log_output("SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV hit.");
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV, SKIN_KEYWORD_DEL_IS_NO_PAGE_PREV_E);
	}

	// ǸΥڡξ
	if ( strcmp(skin_rep_data_global_p->now_page_str, skin_rep_data_global_p->max_page_str) == 0 )
	{
		//debug_log_output("SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT hit.");
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT, SKIN_KEYWORD_DEL_IS_NO_PAGE_NEXT_E);
	}

	// ǽեξ
	if ( skin_rep_data_global_p->stream_files == 0 )
	{
		//debug_log_output("SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES hit.");
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES, SKIN_KEYWORD_DEL_IS_NO_STREAM_FILES_E);
	}



	// =============
	// = ִ¹
	// =============

	// SERVER_NAME
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_SERVER_NAME, SERVER_NAME);

	// CURRENT_PATH ߤΥѥɽѡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_CURRENT_PATH, skin_rep_data_global_p->current_directory_name);

	// CURRENT_PATH_LINK	ߤΥѥLINK URI󥳡ɡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_CURRENT_PATH_LINK, skin_rep_data_global_p->current_directory_link);

	// SKIN_KEYWORKD_PARLENT_DIR_LINK 	ƥǥ쥯ȥ(LINK URI󥳡)
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORKD_PARLENT_DIR_LINK, skin_rep_data_global_p->parent_directory_link );

	// SKIN_KEYWORD_CURRENT_PAGE	 	ߤΥڡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_CURRENT_PAGE, skin_rep_data_global_p->now_page_str);

	// SKIN_KEYWORD_MAX_PAGE			ڡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_MAX_PAGE, skin_rep_data_global_p->max_page_str);

	// SKIN_KEYWORD_NEXT_PAGE			Υڡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_NEXT_PAGE, skin_rep_data_global_p->next_page_str);

	// SKIN_KEYWORD_BACK_PAGE			Υڡ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_PREV_PAGE, skin_rep_data_global_p->prev_page_str);

	// SKIN_KEYWORD_FILE_NUM			 ǥ쥯ȥ¸ߥե
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_FILE_NUM, skin_rep_data_global_p->file_num_str);

	// SKIN_KEYWORD_START_FILE_NUM		 ɽϥեֹ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_START_FILE_NUM, skin_rep_data_global_p->start_file_num_str);

	// SKIN_KEYWORD_END_FILE_NUM		 ɽλեֹ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_END_FILE_NUM, skin_rep_data_global_p->end_file_num_str);


	// SKIN_KEYWORD_SECRET_DIR_LINK		ǥ쥯ȥ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_SECRET_DIR_LINK, skin_rep_data_global_p->secret_dir_link_html );

	return;
}

// **************************************************************************
// 饤ѥǡ ޤȤִ
// **************************************************************************
static void replase_skin_line_data(unsigned char *menu_work_p, int menu_work_buf_size, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p)
{


	// ===============================
	// = ɤ
	// ===============================

	// MP3̵
	if ( skin_rep_data_line_p->mp3_id3v1_flag == 0 )
	{
		// debug_log_output("SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS hit.");
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS, SKIN_KEYWORD_DEL_IS_NO_MP3_TAGS_E);
	}
	else // MP3¸ߤƤ
	{
		cut_enclose_words(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS, SKIN_KEYWORD_DEL_IS_HAVE_MP3_TAGS_E);
		
	}



	// =============
	//  ִ¹
	// =============

	// SKIN_KEYWORD_LINE_FILE_NAME	ե̾ ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_NAME, skin_rep_data_line_p->file_name );

	// SKIN_KEYWORD_LINE_FILE_NAME_NO_EXT	ե̾(ĥ̵) ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_NAME_NO_EXT, skin_rep_data_line_p->file_name_no_ext );

	// SKIN_KEYWORD_LINE_FILE_EXT	եĥ̾ ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_EXT, skin_rep_data_line_p->file_extension );

	// SKIN_KEYWORD_LINE_FILE_LINK	ե̾ LINK
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_LINK, skin_rep_data_line_p->file_uri_link );

	// SKIN_KEYWORD_LINE_TIMESTAMP	   ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_TIMESTAMP, skin_rep_data_line_p->file_timestamp );

	// SKIN_KEYWORD_LINE_FILE_DATE	   ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_DATE, skin_rep_data_line_p->file_timestamp_date );

	// SKIN_KEYWORD_LINE_FILE_TIME	   ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_TIME, skin_rep_data_line_p->file_timestamp_time );

	// SKIN_KEYWORD_LINE_TVID		TVID ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_TVID, skin_rep_data_line_p->tvid_string );

	// SKIN_KEYWORD_LINE_FILE_VOD	vod="0"  ɬפ˱դ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_VOD, skin_rep_data_line_p->vod_string );

	// SKIN_KEYWORD_LINE_FILE_SIZE	ե륵 ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_FILE_SIZE,  skin_rep_data_line_p->file_size_string );

	// SKIN_KEYWORD_LINE_SVI_INFO	SVI ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_SVI_INFO,  skin_rep_data_line_p->svi_info_data );

	// SKIN_KEYWORD_LINE_SVI_INFO	SVI ɽ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_SVI_REC_TIME,  skin_rep_data_line_p->svi_rec_time_data );

	// SKIN_KEYWORD_LINE_IMAGE_WIDTH	β
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_IMAGE_WIDTH,  skin_rep_data_line_p->image_width );

	// SKIN_KEYWORD_LINE_IMAGE_HEIGHT	ι⤵
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_IMAGE_HEIGHT,  skin_rep_data_line_p->image_height );

	// SKIN_KEYWORD_LINE_MP3TAG_TITLE		MP3 ȥ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_TITLE,	skin_rep_data_line_p->mp3_id3v1_title	);

	// SKIN_KEYWORD_LINE_MP3TAG_ALBUM		MP3 Х̾
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_ALBUM,	skin_rep_data_line_p->mp3_id3v1_album	);

	// SKIN_KEYWORD_LINE_MP3TAG_ARTIST		MP3 ƥ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_ARTIST,	skin_rep_data_line_p->mp3_id3v1_artist	);

	// SKIN_KEYWORD_LINE_MP3TAG_YEAR		MP3 ǯ
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_YEAR,	skin_rep_data_line_p->mp3_id3v1_year	);

	// SKIN_KEYWORD_LINE_MP3TAG_COMMENT		MP3 
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_COMMENT,skin_rep_data_line_p->mp3_id3v1_comment	);

	// SKIN_KEYWORD_LINE_MP3TAG_TITLE_INFO		MP3 ȥ(դ)
	replase_character(menu_work_p, menu_work_buf_size, SKIN_KEYWORD_LINE_MP3TAG_TITLE_INFO,	skin_rep_data_line_p->mp3_id3v1_title_info_limited	);

	return;
}




// **************************************************************************
// եɤ߹ࡣ
//
//  ե륵ˤ碌ơmalloc()
//  ʸѴ
// **************************************************************************
static unsigned char *skin_file_read(unsigned char *read_filename, int *malloc_size )
{
	int		fd;
	struct stat		file_stat;
	int				result;
	ssize_t			read_size;
	unsigned char 	*read_work_buf;
	unsigned char 	*read_buf;



	// ե륵å
	result = stat(read_filename, &file_stat);
	debug_log_output("skin: head stat()=%d, st_size=%lld", result, file_stat.st_size );
	if ( result != 0 )
	{
		debug_log_output("stat(%s) error.", read_filename);
		return NULL;
	}

	// ե륵6ܤΰmalloc()
	*malloc_size = file_stat.st_size * 6 ;

	read_work_buf = malloc( *malloc_size );
	if ( read_work_buf == NULL )
	{
		debug_log_output("maloc() error.");
		return NULL;
	}

	read_buf = malloc( *malloc_size );
	if ( read_buf == NULL )
	{
		debug_log_output("maloc() error.");
		return NULL;
	}

	memset(read_work_buf, '\0', *malloc_size);
	memset(read_buf, '\0', *malloc_size);

	// եɤ߹
	fd = open(read_filename, O_RDONLY );
	if ( fd < 0 )
	{
		debug_log_output("open() error.");
		free(read_buf);
		free(read_work_buf);
		return NULL;
	}

	read_size = read(fd, read_work_buf, file_stat.st_size );
	debug_log_output("skin: read() read_size=%d", read_size );

	if ( read_size != file_stat.st_size )
	{
		debug_log_output("read() error.");
		free(read_buf);
		free(read_work_buf);
		return NULL;
	}

	close( fd );

	// ɤǡʸɤMediaWizѥɤѴ
	convert_language_code(read_work_buf, read_buf, *malloc_size, CODE_AUTO, global_param.client_language_code);

	debug_log_output("skin: nkf end." );

	// ꥢfree.
	free(read_work_buf);


	return read_buf;	// ｪλ
}






// **************************************************************************
// *path ǻꤵ줿ǥ쥯ȥ¸ߤե򥫥Ȥ
//
// return: ե
// **************************************************************************
static int count_file_num(unsigned char *path)
{
	int		count;

	DIR	*dir;
	struct dirent	*dent;

	debug_log_output("count_file_num() start. path='%s'", path);

	dir = opendir(path);
	if ( dir == NULL )	// 顼å
	{
		debug_log_output("opendir() error");
		return ( -1 );
	}

	count = 0;
	while ( 1 )
	{
		dent = readdir(dir);
		if ( dent == NULL  )
			break;

		// ̵եå
		if ( file_ignoral_check(dent->d_name, path) != 0 )
			continue;

		count++;
	}

	closedir(dir);

	debug_log_output("count_file_num() end. counter=%d", count);
	return count;
}



// **************************************************************************
// ǥ쥯ȥ¸ߤ򡢥եοɤ߹ࡣ
//
// return: ɤ߹ե
// **************************************************************************
static int directory_stat(unsigned char *path, FILE_INFO_T *file_info_p, int file_num)
{
	int	count;
	DIR	*dir;
	struct dirent	*dent;
	struct stat		file_stat;
	int				result;
	unsigned char	fullpath_filename[FILENAME_MAX];
	unsigned char	file_extension[8];


	debug_log_output("directory_stat() start. path='%s'", path);


	dir = opendir(path);
	if ( dir == NULL )	// 顼å
	{
		debug_log_output("opendir() error");
		return ( -1 );
	}

	count = 0;
	while ( 1 )
	{
		if ( count >= file_num )
			break;

		// ǥ쥯ȥ꤫顢ե̾򣱸GET
		dent = readdir(dir);
		if ( dent == NULL  )
			break;

		// ̵եå
		if ( file_ignoral_check(dent->d_name, path) != 0 )
			continue;

		//debug_log_output("dent->d_name='%s'", dent->d_name);


		// եѥե̾
		strncpy(fullpath_filename, path, sizeof(fullpath_filename) );
		strncat(fullpath_filename, dent->d_name, sizeof(fullpath_filename) - strlen(fullpath_filename) );

		//debug_log_output("fullpath_filename='%s'", fullpath_filename );

		// stat() ¹
		memset(&file_stat, 0, sizeof(file_stat));
		result = stat(fullpath_filename, &file_stat);
		if ( result < 0 )
			continue;


		// оݤǥ쥯ȥä硢SVIƱ̾Υǥ쥯ȥå
		if (( S_ISDIR( file_stat.st_mode ) != 0 ) && ( global_param.flag_hide_same_svi_name_directory == TRUE ))
		{
			// å¹
			if ( directory_same_check_svi_name(fullpath_filename) != 0 )
				continue;
		}

		// ե̾¸
		strncpy(file_info_p[count].org_name, dent->d_name, sizeof(file_info_p[count].org_name) );
		strncpy(file_info_p[count].name, dent->d_name, sizeof(file_info_p[count].name) );


		// ɽѥե̾CAP/HEX ʸѴ
		if ( global_param.flag_decode_samba_hex_and_cap == TRUE )
		{
			debug_log_output("name(cap/hex) = '%s'", file_info_p[count].name);
			decode_samba_hex_and_cap_coding( file_info_p[count].name );
			debug_log_output("name(bin) = '%s'", file_info_p[count].name);
		}


		// ¾¸
		file_info_p[count].type = file_stat.st_mode;
		file_info_p[count].size = file_stat.st_size;
		file_info_p[count].time = file_stat.st_ctime;


		// SVIեä顢file_info_p[count].size ؤ롣
		filename_to_extension( fullpath_filename, file_extension, sizeof(file_extension));

		if ( strcasecmp(file_extension, "svi") ==  0 )
		{
			file_info_p[count].size = svi_file_total_size(fullpath_filename);
		}

		count++;
	}

	closedir(dir);

	debug_log_output("directory_stat() end. count=%d", count);

	return count;
}


// ******************************************************************
// ե̵å
// ǥ쥯ȥǡե̵뤹뤫ʤȽǤ롣
// return: 0:OK  -1 ̵
// ******************************************************************
static int file_ignoral_check( unsigned char *name, unsigned char *path )
{
	int				i;
	unsigned char	file_extension[16];
	char			flag;
	
	unsigned char	work_filename[FILENAME_MAX];
	struct stat		file_stat;
	int				result;

	// =====================================
	// "."".."ϥåפ롣
	// =====================================
	if ( strcmp(name , ".") == 0 )
		return ( -1 );

	if ( strcmp(name , "..") == 0 )
		return ( -1 );

	// =====================================
	// "lost+found" ⥹å
	// =====================================
	if ( strcmp(name , "lost+found") == 0 )
		return ( -1 );

	// ==================================================================
	// MacOSX "._" ǻϤޤե򥹥åסʥ꥽ե
	// ==================================================================
	if ( strncmp(name, "._", 2 ) == 0 )
	{
		return ( -1 );
	}


	// ==================================================================
	// wizdΤʤե뱣ե饰äƤ顢ĥҥå
	// ==================================================================
	if ( global_param.flag_unknown_extention_file_hide == TRUE ) 
	{
		filename_to_extension( name, file_extension, sizeof(file_extension) );

		if ( strlen(file_extension) > 0 ) // ĥ̵ϥå
		{
			flag = 0;
			for ( i=0; mime_list[i].file_extension != NULL; i++)
			{
				if ( strcasecmp(mime_list[i].file_extension, file_extension ) == 0 )
				{
					//debug_log_output("%s Known!!!", file_extension );
					flag = 1; // ΤäƤ
					break;
				}
			}

			if ( flag == 0 ) // Τʤä
			{
				// -----------------------------------------------
				// ե뤬ۥȤ˥ե뤫å
				// ⤷ǥ쥯ȥʤ顢returnʤ
				// -----------------------------------------------

				// եѥ
				strncpy(work_filename, path, sizeof(work_filename) );
				if ( work_filename[strlen(work_filename)-1] != '/' )
				{
					strncat(work_filename, "/", sizeof(work_filename) - strlen(work_filename) );
				}
				strncat(work_filename, name, sizeof(work_filename) - strlen(work_filename) );


				debug_log_output("'%s' Unknown. directory check start.", work_filename );

				// stat() ¹
				result = stat(work_filename, &file_stat);
				if ( result != 0 )
					return ( -1 );

				if ( S_ISDIR(file_stat.st_mode) == 0 ) // ǥ쥯ȥꤸʤΤʤĥҥեȳꡣ
				{
					debug_log_output("'%s' Unknown!!!", name );
					return ( -1 );
				}

				debug_log_output("'%s' is directory!!!", name );
			}
		}
	}


	// ==================================================================
	// ǥ쥯ȥå
	// ==================================================================
	for ( i=0; i<SECRET_DIRECTORY_MAX; i++ )
	{
		if ( strcmp(name, secret_directory_list[i].dir_name ) == 0 )
		{
			debug_log_output("secret_directory_list[%d].'%s' HIT!!", i, secret_directory_list[i].dir_name);
			return ( -1 );
		}
	}


	return ( 0 );
}

// ******************************************************************
// SVIƱ̾Υǥ쥯ȥå
// return: 0:OK  -1 ̵
// ******************************************************************
static int directory_same_check_svi_name( unsigned char *name )
{
	unsigned char	check_svi_filename[FILENAME_MAX];
	struct stat		svi_stat;
	int				result;

	debug_log_output("directory_same_check_svi_name() start.'%s'", name);

	// åSVIե̾
	strncpy( check_svi_filename, name, sizeof(check_svi_filename));
	strncat( check_svi_filename, ".svi", sizeof(check_svi_filename) - strlen(check_svi_filename) );

	result = stat(check_svi_filename, &svi_stat);
	if ( result >= 0 ) // ä
	{
		debug_log_output("check_svi_filename '%s' found!!", check_svi_filename);
		return ( -1 );
	}

	return ( 0 );	// OK
}



// **************************************************************************
//
// HTTP_OKإåơ˥塼ֿ¹
//
// **************************************************************************
static void http_filemenu_send(int accept_socket, unsigned char *filemenu_data)
{
	unsigned int	send_data_len;
	unsigned char	send_http_header_buf[1024];
	unsigned char	work_buf[1024];
	int	result_len;

	// --------------
	// OK إå
	// --------------
	memset(send_http_header_buf, '\0', sizeof(send_http_header_buf));

	strncpy(send_http_header_buf, HTTP_OK, sizeof(send_http_header_buf));
	strncat(send_http_header_buf, HTTP_CONNECTION, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );
	snprintf(work_buf, sizeof(work_buf), HTTP_CONTENT_TYPE, "text/html");
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf));
	snprintf(work_buf, sizeof(work_buf), HTTP_SERVER_NAME, SERVER_NAME);
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );

	snprintf(work_buf, sizeof(work_buf), HTTP_CONTENT_LENGTH, (long long int)strlen(filemenu_data) );
	strncat(send_http_header_buf, work_buf, sizeof(send_http_header_buf) - strlen(send_http_header_buf) );

	strncat(send_http_header_buf, HTTP_END, sizeof(send_http_header_buf) - strlen(send_http_header_buf));


	send_data_len = strlen(send_http_header_buf);
	debug_log_output("header_send_data_len = %d\n", send_data_len);
	debug_log_output("--------\n");
	debug_log_output("%s", send_http_header_buf);
	debug_log_output("--------\n");


	// --------------
	// إåֿ
	// --------------
	result_len = send(accept_socket, send_http_header_buf, send_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_data_len);


	// --------------
	// ֿ
	// --------------
	send_data_len = strlen(filemenu_data);
	result_len = send(accept_socket, filemenu_data, send_data_len, 0);
	debug_log_output("result_len=%d, send_data_len=%d\n", result_len, send_data_len );

	return;
}




// **************************************************************************
// * allplay ѤΥץ쥤ꥹȤ
// **************************************************************************
static void create_all_play_list(HTTP_RECV_INFO *http_recv_info_p, FILE_INFO_T *file_info_p, int file_num, unsigned char *send_filemenu_buf, int buf_size)
{
	int		i,j;

	int		stream_type;
	unsigned char	file_extension[32];
	unsigned char	file_name[255];
	unsigned char	file_uri_link[FILENAME_MAX];

	unsigned char	work_data[FILENAME_MAX * 2];
	SKIN_REPLASE_LINE_DATA_T	mp3_id3tag_data;	// MP3 ID3ɤ߹

	debug_log_output("create_all_play_list() start.");

	memset(send_filemenu_buf, '\0', buf_size);

	// =================================
	// եɽѾ 
	// =================================
	for ( i=0; i<file_num ; i++ )
	{
		// ĥҤ
		filename_to_extension(file_info_p[i].org_name, file_extension, sizeof(file_extension));
		debug_log_output("file_extension='%s'\n", file_extension);

		// ---------------------------------------------------------
		// ե륿ȽꡣSTREAMեʳʤcontinue.
		// ---------------------------------------------------------

		// ǥ쥯ȥ꤫
		if ( S_ISDIR( file_info_p[i].type ) != 0 )
		{
			continue;
		}

		// ĥҤ饹ȥ꡼ॿפȽǡ
		stream_type = TYPE_NO_STREAM;
		for (j=0;;j++)
		{
			if (( mime_list[j].mime_name == NULL ) || ( strlen(file_extension) == 0 ) )
				break;

			if ( strcasecmp(mime_list[j].file_extension, file_extension) == 0 )
			{
				stream_type = mime_list[j].stream_type;
				break;
			}
		}


		// ------------------------------------------------------
		// ȥ꡼եʳʤcontinue
		// ------------------------------------------------------
		if ( stream_type != TYPE_STREAM )
		{
			continue;
		}



		// -----------------------------------------
		// ĥҤmp3ʤ顢ID3å
		// -----------------------------------------
		mp3_id3tag_data.mp3_id3v1_flag = 0;

		if ( strcasecmp(file_extension, "mp3" ) == 0 )
		{
			// MP3եΥեѥ
			strncpy( work_data, http_recv_info_p->send_filename, sizeof(work_data));
			if ( work_data[strlen(work_data)-1] != '/' )
			{
				strncat(work_data, "/", sizeof(work_data) - strlen(work_data) );
			}
			strncat(work_data, file_info_p[i].org_name, sizeof(work_data) - strlen(work_data));
			debug_log_output("work_data(mp3) = %s", work_data);

			// ID3å
			memset( &mp3_id3tag_data, 0, sizeof(mp3_id3tag_data));
			mp3_id3v1_tag_read(work_data , &mp3_id3tag_data );
		}


		// MP3 ID3¸ߤʤСplaylist ɽե̾ID3֤롣
		if ( mp3_id3tag_data.mp3_id3v1_flag == 1 )
		{
			strncpy(work_data, mp3_id3tag_data.mp3_id3v1_title_info, sizeof(work_data));
			strncat(work_data, ".mp3", sizeof(work_data) - strlen(work_data));	// ߡγĥҡplaylist_filename_adjustment()Ǻ롣

			// =========================================
			// playlistɽ ID3Ĵ
			// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
			// =========================================
			playlist_filename_adjustment( work_data, file_name, sizeof(file_name), CODE_AUTO );
		}
		else
		// MP3 ID3¸ߤʤʤСե̾򤽤Τޤ޻Ѥ롣
		{
			// ---------------------------------
			// ɽե̾ Ĵ
			// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
			// ---------------------------------
			playlist_filename_adjustment(file_info_p[i].name, file_name, sizeof(file_name), global_param.server_language_code);
		}

		// ------------------------------------
		// LinkURI(󥳡ɺѤ) 
		// ------------------------------------
		strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) );
		strncat(work_data, file_info_p[i].org_name, sizeof(work_data)- strlen(work_data) );
	 	uri_encode(file_uri_link, sizeof(file_uri_link), work_data, strlen(work_data) );

		debug_log_output("file_uri_link='%s'\n", file_uri_link);

		// URIγĥ֤
		extension_add_rename(file_uri_link);


		// ------------------------------------
		// ץ쥤ꥹȤ
		// ------------------------------------
		strncpy(work_data, file_name, sizeof(work_data));
		strncat(work_data, "|0|0|http://", sizeof(work_data) - strlen(work_data) );
		strncat(work_data, http_recv_info_p->recv_host, sizeof(work_data) - strlen(work_data) );
		strncat(work_data, file_uri_link, sizeof(work_data) - strlen(work_data) );
		strncat(work_data, "|\r\n", sizeof(work_data) - strlen(work_data) );

		debug_log_output("work_data='%s'", work_data);

		// ------------------------------------
		// Хåեɲ
		// ------------------------------------
		strncat(send_filemenu_buf, work_data, buf_size - strlen(send_filemenu_buf) );

	}

	return;
}




// *************************************************************************
//  ɽե륽
// *************************************************************************
static void file_info_sort( FILE_INFO_T *p, int num, unsigned long type )
{


	int nDir, nFile, i, row;

	// ǥ쥯ȥȥեʬΥ
	for ( nDir = 0, i = 0; i < num; ++i )
	{
		if ( S_ISDIR( p[ i ].type ) )
		{
			++nDir;
		}
	}
	nFile = num - nDir;

	// Ƚ ******************************************************************
	// 
	row = 0;

	// ǥ쥯ȥ꥽ȤйԤ
	if ( SORT_DIR_FLAG( type ) && nDir > 0 )
	{
		// Ȥꤢ
		qsort( p, num, sizeof( FILE_INFO_T ), dir_sort_api[ SORT_DIR_FLAG( type ) ] );

		// ǥ쥯ȥ̾Υ
		qsort( &p[ ( SORT_DIR_FLAG( type ) == SORT_DIR_DOWN ) ? num - nDir : 0 ], nDir, sizeof( FILE_INFO_T ), file_sort_api[ SORT_NAME_UP ] );

		// եֳ
		row = ( SORT_DIR_FLAG( type ) == SORT_DIR_DOWN ) ? 0 : nDir;
	}
	else
	{
		// ե륽оݤˤ
		nFile = num;
	}

	// ե륽ȤԤ
	// ǥ쥯ȥ꤬оݤˤʤäƤʤСоݤˤ
	if ( ( type & SORT_FILE_MASK ) && nFile > 0 )
	{
		qsort( &p[ row ], nFile, sizeof( FILE_INFO_T ), file_sort_api[ ( type & SORT_FILE_MASK ) ] );
	}

	return;
}



// *************************************************************************
// ǥ쥯ȥΥ
// *************************************************************************
static int _file_info_dir_sort( const void *in_a, const void *in_b, int order )
{
	FILE_INFO_T *a, *b;
	int n1, n2;

	a = (FILE_INFO_T *) in_a;
	b = (FILE_INFO_T *) in_b;
	n1 = ( S_ISDIR( a->type ) ? 1 : 0 );
	n2 = ( S_ISDIR( b->type ) ? 1 : 0 );
	return ( n1 == n2 ? 0 : ( order ? n1 - n2 : n2 - n1 ) );
}
static int _file_info_dir_sort_order_up( const void *in_a, const void *in_b )
{
	return _file_info_dir_sort( in_a, in_b, 0 );
}
static int _file_info_dir_sort_order_down( const void *in_a, const void *in_b )
{
	return _file_info_dir_sort( in_a, in_b, 1 );
}




// *************************************************************************
// ̾Υ
// *************************************************************************
static int _file_info_name_sort( const void *in_a, const void *in_b, int order )
{
	FILE_INFO_T *a, *b;

	a = (FILE_INFO_T *) in_a;
	b = (FILE_INFO_T *) in_b;
	return ( order ? strcmp( b->name, a->name ) : strcmp( a->name, b->name ) );
}
static int _file_info_name_sort_order_up( const void *in_a, const void *in_b )
{
	return _file_info_name_sort( in_a, in_b, 0 );
}
static int _file_info_name_sort_order_down( const void *in_a, const void *in_b )
{
	return _file_info_name_sort( in_a, in_b, 1 );
}




// *************************************************************************
// Υ
// *************************************************************************
static int _file_info_size_sort( const void *in_a, const void *in_b, int order )
{
	FILE_INFO_T *a, *b;

	a = (FILE_INFO_T *) in_a;
	b = (FILE_INFO_T *) in_b;
	return (int)( order ? b->size - a->size : a->size - b->size );
}
static int _file_info_size_sort_order_up( const void *in_a, const void *in_b )
{
	return _file_info_size_sort( in_a, in_b, 0 );
}
static int _file_info_size_sort_order_down( const void *in_a, const void *in_b )
{
	return _file_info_size_sort( in_a, in_b, 1 );
}



// *************************************************************************
// ֤Υ
// *************************************************************************
static int _file_info_time_sort( const void *in_a, const void *in_b, int order )
{
	FILE_INFO_T *a, *b;

	a = (FILE_INFO_T *) in_a;
	b = (FILE_INFO_T *) in_b;
	return (int)( order ? b->time - a->time : a->time - b->time );
}
static int _file_info_time_sort_order_up( const void *in_a, const void *in_b )
{
	return _file_info_time_sort( in_a, in_b, 0 );
}
static int _file_info_time_sort_order_down( const void *in_a, const void *in_b )
{
	return _file_info_time_sort( in_a, in_b, 1 );
}








#define		SKIN_IMAGE_VIEWER_HTML 	"image_viewer.html"	// ImageViewerΥ

#define		SKIN_KEYWORD_IMAGE_VIEWER_WIDTH		"<!--WIZD_INSERT_IMAGE_VIEWER_WIDTH-->"		// ImageViewerɽ
#define		SKIN_KEYWORD_IMAGE_VIEWER_HEIGHT	"<!--WIZD_INSERT_IMAGE_VIEWER_HEIGHT-->"	// ImageViewerɽ⤵
#define		SKIN_KEYWORD_IMAGE_VIEWER_MODE		"<!--WIZD_INSERT_IMAGE_VIEWER_MODE-->"		// ImageViewerθߤΥ⡼



// FIT⡼ɤλʲϰϤ
#define		SKIN_KEYWORD_DEL_IS_FIT_MODE	"<!--WIZD_DELETE_IS_FIT_MODE-->"
#define		SKIN_KEYWORD_DEL_IS_FIT_MODE_E	"<!--/WIZD_DELETE_IS_FIT_MODE-->"


// FIT⡼ɰʳλʲϰϤ
#define		SKIN_KEYWORD_DEL_IS_NO_FIT_MODE		"<!--WIZD_DELETE_IS_NO_FIT_MODE-->"
#define		SKIN_KEYWORD_DEL_IS_NO_FIT_MODE_E	"<!--/WIZD_DELETE_IS_NO_FIT_MODE-->"


#define		FIT_TERGET_WIDTH	(533)
#define		FIT_TERGET_HEIGHT	(400)


// **************************************************************************
// * ᡼ӥ塼ֿ
// **************************************************************************
void http_image_viewer(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char	*image_viewer_skin_p;
	int				image_viewer_skin_malloc_size;
	unsigned int 	image_width, image_height;
	unsigned int 	image_viewer_width, image_viewer_height;

	unsigned char	file_extension[32];

	unsigned char	skin_filename[FILENAME_MAX];
	unsigned char	work_data[FILENAME_MAX];

	struct	stat	image_stat;
	int		result;
	int		now_page;

	int		flag_fit_mode = 0;

	SKIN_REPLASE_IMAGE_VIEWER_DATA_T	image_viewer_info;


	// ========================
	// ִѥǡ
	// ========================
	// ľΥǥ쥯ȥѥ(ƥѥ)(URI󥳡)
	strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) - strlen(work_data) );
	cut_after_last_character(work_data, '/');
	strncat(work_data, "/", sizeof(work_data) - strlen(work_data) ); // Ǹ'/'ɲá
	debug_log_output("parent_directory='%s'", work_data);


 	uri_encode(image_viewer_info.parent_directory_link, sizeof(image_viewer_info.parent_directory_link), work_data, strlen(work_data));
	strncat(image_viewer_info.parent_directory_link, "?", sizeof(image_viewer_info.parent_directory_link) - strlen(image_viewer_info.parent_directory_link));
	// sort=ؼƤ硢Ѥ
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
		strncat(image_viewer_info.parent_directory_link, work_data, sizeof(image_viewer_info.parent_directory_link) - strlen(image_viewer_info.parent_directory_link));
	}
	debug_log_output("parent_directory_link='%s'", image_viewer_info.parent_directory_link);


	// ѥ̾ ɽ (ʸѴ)
	convert_language_code(	http_recv_info_p->recv_uri,
							image_viewer_info.current_uri_name,
							sizeof(image_viewer_info.current_uri_name),
							global_param.server_language_code,
							global_param.client_language_code);
	debug_log_output("image_viewer: current_uri = '%s'", image_viewer_info.current_uri_name );

	// ѥ̾ LinkURI󥳡ɡ
 	uri_encode(image_viewer_info.current_uri_link, sizeof(image_viewer_info.current_uri_link), http_recv_info_p->recv_uri, strlen(http_recv_info_p->recv_uri));
	strncat(image_viewer_info.current_uri_link, "?", sizeof(image_viewer_info.current_uri_link) - strlen(image_viewer_info.current_uri_link)); // Ǹ'?'ɲ
	// sort=ؼƤ硢Ѥ
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
		strncat(image_viewer_info.current_uri_link, work_data, sizeof(image_viewer_info.current_uri_link) - strlen(image_viewer_info.current_uri_link));
	}
	debug_log_output("image_viewer: current_uri_link='%s'", image_viewer_info.current_uri_link);





	if ( http_recv_info_p->page <= 1 )
		now_page = 1;
	else
		now_page = http_recv_info_p->page;


	// 	ߤΥڡ ɽ
	snprintf(image_viewer_info.now_page_str, sizeof(image_viewer_info.now_page_str), "%d", now_page );


	// ե륵, ॹGET
	result = stat(http_recv_info_p->send_filename, &image_stat);
	if ( result != 0 )
	{
		debug_log_output("stat(%s) error.", http_recv_info_p->send_filename);
		return;
	}

	conv_num_to_unit_string(image_viewer_info.file_size_string, image_stat.st_size );
	conv_time_to_string(image_viewer_info.file_timestamp, image_stat.st_ctime );
	conv_time_to_date_string(image_viewer_info.file_timestamp_date, image_stat.st_ctime );
	conv_time_to_time_string(image_viewer_info.file_timestamp_time, image_stat.st_ctime );


	// GET
	image_width = 0;
	image_height = 0;

	// ĥҼФ
	filename_to_extension(http_recv_info_p->send_filename, file_extension, sizeof(file_extension) );

	// ĥҤʬ
	if ( (strcasecmp( file_extension, "jpg" ) == 0 ) ||
		 (strcasecmp( file_extension, "jpeg" ) == 0 ))
	{
		// JPEGեΥGET
		jpeg_size( http_recv_info_p->send_filename, &image_width, &image_height );
	}
	else if (strcasecmp( file_extension, "gif" ) == 0 )
	{
		// GIFեΥGET
		gif_size( http_recv_info_p->send_filename, &image_width, &image_height );
	}
	else if (strcasecmp( file_extension, "png" ) == 0 )
	{
		// PNGեΥGET
		png_size( http_recv_info_p->send_filename, &image_width, &image_height );
	}
	debug_log_output("image_width=%d, image_height=%d", image_width, image_height);

	snprintf(image_viewer_info.image_width, sizeof(image_viewer_info.image_width), "%d", image_width);
	snprintf(image_viewer_info.image_height, sizeof(image_viewer_info.image_height), "%d", image_height);



	// ɽʲ
	if ( strcasecmp(http_recv_info_p->option, "-2" ) == 0 )  // 0.5x
	{
		image_viewer_width = image_width / 2;
		image_viewer_height = image_height / 2;
		strncpy(image_viewer_info.image_viewer_mode, "0.5x", sizeof(image_viewer_info.image_viewer_mode) );
	}
	else if ( strcasecmp(http_recv_info_p->option, "2x" ) == 0 )  // 2x
	{
		image_viewer_width = image_width * 2;
		image_viewer_height = image_height * 2 ;
		strncpy(image_viewer_info.image_viewer_mode, "2x", sizeof(image_viewer_info.image_viewer_mode) );
	}
	else if ( strcasecmp(http_recv_info_p->option, "4x" ) == 0 )  // 4x
	{
		image_viewer_width = image_width * 4;
		image_viewer_height = image_height * 4 ;
		strncpy(image_viewer_info.image_viewer_mode, "4x", sizeof(image_viewer_info.image_viewer_mode) );
	}
	else if ( strcasecmp(http_recv_info_p->option, "fit" ) == 0 )  // FIT
	{
		// Ĥ˹碌ƥꥵƤߤ
		image_viewer_width = (image_width  * FIT_TERGET_HEIGHT) / image_height;
		image_viewer_height = FIT_TERGET_HEIGHT;

		if ( image_viewer_width > FIT_TERGET_WIDTH ) // ĶƤ
		{
			// ˹碌ƥꥵ롣
			image_viewer_width = FIT_TERGET_WIDTH;
			image_viewer_height = image_height * FIT_TERGET_WIDTH / image_width;
		}

		debug_log_output("fit:  (%d,%d) -> (%d,%d)", image_width, image_height, image_viewer_width, image_viewer_height);


		strncpy(image_viewer_info.image_viewer_mode, "FIT", sizeof(image_viewer_info.image_viewer_mode) );

		flag_fit_mode = 1;
	}
	else	// 1x
	{
		image_viewer_width = image_width;
		image_viewer_height = image_height;
		strncpy(image_viewer_info.image_viewer_mode, "1x", sizeof(image_viewer_info.image_viewer_mode) );
	}

	snprintf(image_viewer_info.image_viewer_width, sizeof(image_viewer_info.image_viewer_width), "%d", image_viewer_width );
	snprintf(image_viewer_info.image_viewer_height, sizeof(image_viewer_info.image_viewer_height), "%d", image_viewer_height );


	// ==============================
	// ImageViewer ɤ߹
	// ==============================

	// ----------------------------------------------
	// Υեѥ
	// Τեѥ
	// ----------------------------------------------
	strncpy(skin_filename, global_param.skin_root, sizeof(skin_filename) ); // ֤
	if ( skin_filename[ strlen(skin_filename)-1 ] != '/' )// Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_filename, "/", sizeof(skin_filename) -strlen(skin_filename) );
	}

	strncat(skin_filename, global_param.skin_name, sizeof(skin_filename) - strlen(skin_filename) ); // ̾ʥǥ쥯ȥ
	if ( skin_filename[ strlen(skin_filename)-1 ] != '/' ) // Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_filename, "/", sizeof(skin_filename) - strlen(skin_filename) );
	}

	// ImageView ե̾
	strncat(skin_filename, SKIN_IMAGE_VIEWER_HTML, sizeof(skin_filename) - strlen(skin_filename) );
	debug_log_output("skin: skin_filename='%s'", skin_filename);

	// ǡɤ߹
	image_viewer_skin_p = skin_file_read( skin_filename, &image_viewer_skin_malloc_size);


	// ==============================
	// ִ¹
	// ==============================


	// SERVER_NAME
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_SERVER_NAME, SERVER_NAME);

	// CURRENT_PATH ߤΥѥɽѡ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_CURRENT_PATH, image_viewer_info.current_uri_name);

	// CURRENT_PATH_LINK	ߤΥѥLINK URI󥳡ɡ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_CURRENT_PATH_LINK, image_viewer_info.current_uri_link);

	// SKIN_KEYWORKD_PARLENT_DIR_LINK 	ƥǥ쥯ȥ(LINK URI󥳡)
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORKD_PARLENT_DIR_LINK, image_viewer_info.parent_directory_link );

	// SKIN_KEYWORD_CURRENT_PAGE	 	ߤΥڡ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_CURRENT_PAGE, image_viewer_info.now_page_str);


	// SKIN_KEYWORD_LINE_TIMESTAMP	   ɽ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_TIMESTAMP, image_viewer_info.file_timestamp );

	// SKIN_KEYWORD_LINE_FILE_DATE	   ɽ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_FILE_DATE, image_viewer_info.file_timestamp_date );

	// SKIN_KEYWORD_LINE_FILE_TIME	   ɽ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_FILE_TIME, image_viewer_info.file_timestamp_time );



	// SKIN_KEYWORD_LINE_FILE_SIZE	ե륵 ɽ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_FILE_SIZE,  image_viewer_info.file_size_string );


	// SKIN_KEYWORD_LINE_IMAGE_WIDTH	// β
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_IMAGE_WIDTH,  image_viewer_info.image_width );

	// SKIN_KEYWORD_LINE_IMAGE_HEIGHT	// ι⤵
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_LINE_IMAGE_HEIGHT,  image_viewer_info.image_height );




	// SKIN_KEYWORD_IMAGE_VIEWER_WIDTH		// ɽ
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_IMAGE_VIEWER_WIDTH,  image_viewer_info.image_viewer_width );

	// SKIN_KEYWORD_IMAGE_VIEWER_HEIGHT		// ɽ⤵
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_IMAGE_VIEWER_HEIGHT,  image_viewer_info.image_viewer_height );

	// SKIN_KEYWORD_IMAGE_VIEWER_MODE		// ɽ⡼
	replase_character(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_IMAGE_VIEWER_MODE,  image_viewer_info.image_viewer_mode );

	// FIT⡼ɥå
	if ( flag_fit_mode == 0 ) // FIT⡼ɤǤϤʤ
	{
		cut_enclose_words(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_DEL_IS_NO_FIT_MODE, SKIN_KEYWORD_DEL_IS_NO_FIT_MODE_E);
	}
	else // FIT⡼
	{
		cut_enclose_words(image_viewer_skin_p, image_viewer_skin_malloc_size, SKIN_KEYWORD_DEL_IS_FIT_MODE, SKIN_KEYWORD_DEL_IS_FIT_MODE_E);
	}


	debug_log_output("response: %s", image_viewer_skin_p);

	// =================
	// ֿ¹
	// =================
	http_filemenu_send( accept_socket, image_viewer_skin_p );


	free(image_viewer_skin_p);

	return;
}

// **************************************************************************
// * Single Play Listֿ
// **************************************************************************
void http_music_single_play(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char	work_data[FILENAME_MAX*2];

	unsigned char	file_name[FILENAME_MAX];
	unsigned char	file_extension[16];
	unsigned char	file_uri_link[FILENAME_MAX];

	SKIN_REPLASE_LINE_DATA_T	mp3_id3tag_data;	// MP3 ID3ɤ߹


	// =========================================
	// URIե̾Ф
	// =========================================
	strncpy( work_data, http_recv_info_p->recv_uri, sizeof(work_data) );
	cut_before_last_character(work_data, '/');

	debug_log_output("file_name:'%s'", work_data);
	filename_to_extension(work_data, file_extension, sizeof(file_extension));



	// =========================================
	// ĥҤmp3ʤ顢ID3å
	// =========================================
	mp3_id3tag_data.mp3_id3v1_flag = 0;

	if ( strcasecmp(file_extension, "mp3" ) == 0 )
	{
		// ID3å
		memset( &mp3_id3tag_data, 0, sizeof(mp3_id3tag_data));
		mp3_id3v1_tag_read( http_recv_info_p->send_filename, &mp3_id3tag_data );
	}

	// MP3 ID3¸ߤʤСplaylist ɽե̾ID3֤롣
	if ( mp3_id3tag_data.mp3_id3v1_flag == 1 )
	{
		strncpy(work_data, mp3_id3tag_data.mp3_id3v1_title_info, 	sizeof(work_data));
		strncat(work_data, ".mp3" ,sizeof(work_data) - strlen(work_data));	// ߡγĥҡplaylist_filename_adjustment()Ǻ롣

		// =========================================
		// playlistɽ ID3Ĵ
		// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
		// =========================================
		playlist_filename_adjustment( work_data, file_name, sizeof(file_name), CODE_AUTO );

	}
	else 
	{
		// =========================================
		// playlistɽѥե̾ Ĵ
		// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
		// =========================================
		playlist_filename_adjustment( work_data, file_name, sizeof(file_name), global_param.server_language_code );
	}

	debug_log_output("file_name(adjustment):'%s'", file_name );


	// =========================================
	// LinkURI(󥳡ɺѤ) 
	// =========================================
	strncpy(work_data, http_recv_info_p->recv_uri, sizeof(work_data) );
	uri_encode(file_uri_link, sizeof(file_uri_link), work_data, strlen(work_data) );
	debug_log_output("file_uri_link='%s'\n", file_uri_link);

	// URIγĥ֤
	extension_add_rename(file_uri_link);


	// =========================================
	// ץ쥤ꥹȤ
	// =========================================
	strncpy(work_data, file_name, sizeof(work_data));
	strncat(work_data, "|0|0|http://", sizeof(work_data) - strlen(work_data) );
	strncat(work_data, http_recv_info_p->recv_host, sizeof(work_data) - strlen(work_data) );
	strncat(work_data, file_uri_link, sizeof(work_data) - strlen(work_data) );
	strncat(work_data, "|\r\n", sizeof(work_data) - strlen(work_data) );

	debug_log_output("work_data='%s'", work_data);


	// =================
	// ֿ¹
	// =================
	http_filemenu_send( accept_socket, work_data );


	return;
}



// **************************************************************************
// * wizd play listե(*.plw)ꡢPlayListֿ
// **************************************************************************
void http_listfile_to_playlist_create(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char *playlist_buf_malloc_p;

	int		fd;
	int		ret;

	unsigned char	buf[FILENAME_MAX];

	unsigned char	listfile_path[FILENAME_MAX];

	unsigned char	file_extension[32];
	unsigned char	file_name[255];
	unsigned char	file_uri_link[FILENAME_MAX];

	unsigned char	work_data[FILENAME_MAX *2];
	SKIN_REPLASE_LINE_DATA_T	mp3_id3tag_data;	// MP3 ID3ɤ߹



	// plwǡopen
	fd = open(http_recv_info_p->send_filename, O_RDONLY);
	if ( fd < 0 )
	{
		debug_log_output("'%s' can't open.", http_recv_info_p->send_filename);
		return;
	}


	// listfileѥ
	strncpy( listfile_path, http_recv_info_p->recv_uri, sizeof(listfile_path));
	cut_after_last_character( listfile_path, '/' );
	if ( listfile_path[strlen(listfile_path)-1] != '/' )
	{
		strncat( listfile_path, "/", sizeof(listfile_path) );
	}

	debug_log_output( "listfile_path: '%s'", listfile_path );


	// =============================
	// ֿǡΰmalloc
	// =============================
	playlist_buf_malloc_p = malloc( FILEMENU_BUF_SIZE );
	if (playlist_buf_malloc_p == NULL)
	{
		debug_log_output("malloc() error");
		return;
	}

	memset( playlist_buf_malloc_p, '\0', FILEMENU_BUF_SIZE );


	//=====================================
	// ץ쥤ꥹ 
	//=====================================
	while ( 1 )
	{
		// ե뤫顢ɤ
		ret = file_read_line( fd, buf, sizeof(buf) );
		if ( ret < 0 )
		{
			debug_log_output("listfile EOF Detect.");
			break;
		}

		debug_log_output("-------------");
		debug_log_output("read_buf:'%s'", buf);


		// Ⱥ
		if ( buf[0] == '#' )
		{
			buf[0] = '\0';
		}

		// Υڡ
		cut_character_at_linetail(buf, ' ');

		debug_log_output("read_buf(comment cut):'%s'", buf);

		// Ԥʤ顢continue
		if ( strlen( buf ) == 0 )
		{
			debug_log_output("continue.");
			continue;
		}


		// ĥ 
		filename_to_extension(buf, file_extension, sizeof(file_extension) );
		debug_log_output("file_extension:'%s'", file_extension);

		// ɽե̾ 
		strncpy(work_data, buf, sizeof(work_data));
		cut_before_last_character( work_data, '/' );
		strncpy( file_name, work_data, sizeof(file_name));
		debug_log_output("file_name:'%s'", file_name);


		// URI
		if ( buf[0] == '/' ) // Хѥ
		{
			strncpy( file_uri_link, buf, sizeof(file_uri_link) );
		}
		else // Хѥ
		{
			strncpy( file_uri_link, listfile_path, sizeof(file_uri_link) );
			strncat( file_uri_link, buf, sizeof(file_uri_link) - strlen(file_uri_link) );
		}

		debug_log_output("listfile_path:'%s'", listfile_path);
		debug_log_output("file_uri_link:'%s'", file_uri_link);


		// -----------------------------------------
		// ĥҤmp3ʤ顢ID3å
		// -----------------------------------------
		mp3_id3tag_data.mp3_id3v1_flag = 0;
		if ( strcasecmp(file_extension, "mp3" ) == 0 )
		{
			// MP3եΥեѥ
			strncpy(work_data, global_param.document_root, sizeof(work_data) );
			if ( work_data[strlen(work_data)-1] == '/' )
				work_data[strlen(work_data)-1] = '\0';
			strncat( work_data, file_uri_link, sizeof(work_data) );

			debug_log_output("full_path(mp3):'%s'", work_data); // եѥ

			// ID3å
			memset( &mp3_id3tag_data, 0, sizeof(mp3_id3tag_data));
			mp3_id3v1_tag_read(work_data , &mp3_id3tag_data );
		}


		// MP3 ID3¸ߤʤСplaylist ɽե̾ID3֤롣
		if ( mp3_id3tag_data.mp3_id3v1_flag == 1 )
		{
			strncpy(work_data, mp3_id3tag_data.mp3_id3v1_title_info, sizeof(work_data));
			strncat(work_data, ".mp3", sizeof(work_data) - strlen(work_data));	// ߡγĥҡplaylist_filename_adjustment()Ǻ롣

			// =========================================
			// playlistɽ ID3Ĵ
			// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
			// =========================================
			playlist_filename_adjustment( work_data, file_name, sizeof(file_name), CODE_AUTO );
		}
		else
		// MP3 ID3¸ߤʤʤСե̾򤽤Τޤ޻Ѥ롣
		{
			// ---------------------------------
			// ɽե̾ Ĵ
			// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸ
			// ---------------------------------
			strncpy( work_data, file_name, sizeof(work_data) );
			playlist_filename_adjustment(work_data, file_name, sizeof(file_name), global_param.server_language_code);
		}

		debug_log_output("file_name(adjust):'%s'", file_name);

		// ------------------------------------
		// LinkURI(󥳡ɺѤ) 
		// ------------------------------------
		strncpy(work_data, file_uri_link, sizeof(work_data) );
	 	uri_encode(file_uri_link, sizeof(file_uri_link), work_data, strlen(work_data) );

		debug_log_output("file_uri_link(encoded):'%s'", file_uri_link);

		// URIγĥ֤
		extension_add_rename(file_uri_link);


		// ------------------------------------
		// ץ쥤ꥹȤ
		// ------------------------------------
		strncpy(work_data, file_name, sizeof(work_data));
		strncat(work_data, "|0|0|http://", sizeof(work_data) - strlen(work_data) );
		strncat(work_data, http_recv_info_p->recv_host, sizeof(work_data) - strlen(work_data) );
		strncat(work_data, file_uri_link, sizeof(work_data) - strlen(work_data) );
		strncat(work_data, "|\r\n", sizeof(work_data) - strlen(work_data) );

		debug_log_output("work_data='%s'", work_data);

		// ------------------------------------
		// Хåեɲ
		// ------------------------------------
		strncat(playlist_buf_malloc_p, work_data,  FILEMENU_BUF_SIZE - strlen(playlist_buf_malloc_p) );

	}


	// =================
	// ֿ¹
	// =================
	http_filemenu_send( accept_socket, playlist_buf_malloc_p );

	close( fd );
	free( playlist_buf_malloc_p );
	return;
}

// *****************************************************
// fd 飱ɤ߹
// ɤ߹ʸreturn롣
// Ǹޤɤ顢-1롣
// *****************************************************
static int file_read_line( int fd, unsigned char *line_buf, int line_buf_size)
{
	int read_len;
	int	total_read_len;
	unsigned char	read_char;
	unsigned char *p;

	p = line_buf;
	total_read_len = 0;

	while ( 1 ) 
	{
		// ʸread.
		read_len  = read(fd, &read_char, 1);
		if ( read_len <= 0 ) // EOF
		{
			return ( -1 );
		}
		else if ( read_char == '\r' )
		{
			continue;
		}
		else if ( read_char == '\n' )
		{
			break;
		}

		*p = read_char;
		p++;
		total_read_len++;

		if ( total_read_len >= line_buf_size )
		{
			break;
		}
	}

	*p = '\0';
	return total_read_len;
}


#define		SKIN_OPTION_MENU_HTML 	"option_menu.html"	// OptionMenuΥ
#define		SKIN_KEYWORD_CURRENT_PATH_LINK_NO_SORT	"<!--WIZD_INSERT_CURRENT_PATH_LINK_NO_SORT-->"	// PATH(SortѤ̵)LINKѡURI󥳡ɺѤ

// **************************************************************************
// * ץ˥塼ֿ
// **************************************************************************
void http_option_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	unsigned char	*option_menu_skin_p;
	int				option_menu_skin_malloc_size;


	unsigned char	current_uri_link_no_sort[FILENAME_MAX];
	unsigned char	current_uri_link[FILENAME_MAX];
	unsigned char	work_data[FILENAME_MAX];

	int				now_page;
	unsigned char	now_page_str[16];
	unsigned char	skin_filename[FILENAME_MAX];

	// ========================
	// ִѥǡ
	// ========================

	// --------------------------------------------------------------
	// ѥ̾ Link(SortѤ̵)URI󥳡ɡ
	// --------------------------------------------------------------
 	uri_encode(current_uri_link_no_sort, sizeof(current_uri_link_no_sort), http_recv_info_p->recv_uri, strlen(http_recv_info_p->recv_uri));
	strncat(current_uri_link_no_sort, "?", sizeof(current_uri_link_no_sort) - strlen(current_uri_link_no_sort)); // '?'ɲ

	debug_log_output("OptionMenu: current_uri_link_no_sort='%s'", current_uri_link_no_sort);


	// -----------------------------------------
	// ѥ̾ Link(Sortդ) 
	// -----------------------------------------
 	uri_encode(current_uri_link, sizeof(current_uri_link), http_recv_info_p->recv_uri, strlen(http_recv_info_p->recv_uri));
	strncat(current_uri_link, "?", sizeof(current_uri_link) - strlen(current_uri_link)); // '?'ɲ

	// sort=ؼƤ硢Ѥ
	if ( strlen(http_recv_info_p->sort) > 0 )
	{
		snprintf(work_data, sizeof(work_data), "sort=%s&", http_recv_info_p->sort);
		strncat(current_uri_link, work_data, sizeof(current_uri_link) - strlen(current_uri_link));
	}
	debug_log_output("OptionMenu: current_uri_link='%s'", current_uri_link);


	// ---------------------
	// ڡ 
	// ---------------------

	if ( http_recv_info_p->page <= 1 )
		now_page = 1;
	else
		now_page = http_recv_info_p->page;

	// 	ߤΥڡ ɽ
	snprintf(now_page_str, sizeof(now_page_str), "%d", now_page );


	// ==============================
	// OptionMenu ɤ߹
	// ==============================

	// ----------------------------------------------
	// Υեѥ
	// Τեѥ
	// ----------------------------------------------
	strncpy(skin_filename, global_param.skin_root, sizeof(skin_filename) ); // ֤
	if ( skin_filename[ strlen(skin_filename)-1 ] != '/' )// Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_filename, "/", sizeof(skin_filename) -strlen(skin_filename) );
	}

	strncat(skin_filename, global_param.skin_name, sizeof(skin_filename) - strlen(skin_filename) ); // ̾ʥǥ쥯ȥ
	if ( skin_filename[ strlen(skin_filename)-1 ] != '/' ) // Ǹ夬'/'ʤä顢'/'ɲ
	{
		strncat(skin_filename, "/", sizeof(skin_filename) - strlen(skin_filename) );
	}

	// ImageView ե̾
	strncat(skin_filename, SKIN_OPTION_MENU_HTML, sizeof(skin_filename) - strlen(skin_filename) );
	debug_log_output("skin: skin_filename='%s'", skin_filename);

	// ǡɤ߹
	option_menu_skin_p = skin_file_read( skin_filename, &option_menu_skin_malloc_size);


	// ==============================
	// ִ¹
	// ==============================

	// SERVER_NAME
	replase_character(option_menu_skin_p, option_menu_skin_malloc_size, SKIN_KEYWORD_SERVER_NAME, SERVER_NAME);

	//
	// CURRENT_PATH_LINK	ߤΥѥLINK URI󥳡ɡ
	replase_character(option_menu_skin_p, option_menu_skin_malloc_size, SKIN_KEYWORD_CURRENT_PATH_LINK, current_uri_link);

	// CURRENT_PATH_LINK	ߤΥѥLINK URI󥳡ɡ
	replase_character(option_menu_skin_p, option_menu_skin_malloc_size, SKIN_KEYWORD_CURRENT_PATH_LINK_NO_SORT, current_uri_link_no_sort);

	// SKIN_KEYWORD_CURRENT_PAGE	 	ߤΥڡ
	replase_character(option_menu_skin_p, option_menu_skin_malloc_size, SKIN_KEYWORD_CURRENT_PAGE, now_page_str);



	// =================
	// ֿ¹
	// =================
	http_filemenu_send( accept_socket, option_menu_skin_p );


	free(option_menu_skin_p);


	return;
}



/********************************************************************************/
// ܸʸѴ
// (libnkfΥåѡؿ)
//
//	ݡȤƤϰʲ̤ꡣ
//		in_flag:	CODE_AUTO, CODE_SJIS, CODE_EUC, CODE_UTF8, CODE_UTF16
//		out_flag: 	CODE_SJIS, CODE_EUC
/********************************************************************************/
void convert_language_code(const unsigned char *in, unsigned char *out, size_t len, int in_flag, int out_flag)
{
	unsigned char	nkf_option[8];

	memset(nkf_option, '\0', sizeof(nkf_option));


	//=====================================================================
	// in_flag, out_flagߤơlibnkfؤΥץȤΩƤ롣
	//=====================================================================
	switch( in_flag )
	{
		case CODE_SJIS:
			strncpy(nkf_option, "S", sizeof(nkf_option));
			break;

		case CODE_EUC:
			strncpy(nkf_option, "E", sizeof(nkf_option));
			break;

		case CODE_UTF8:
			strncpy(nkf_option, "W", sizeof(nkf_option));
			break;

		case CODE_UTF16:
			strncpy(nkf_option, "W16", sizeof(nkf_option));
			break;

		case CODE_AUTO:
		default:
			strncpy(nkf_option, "", sizeof(nkf_option));
			break;
	}


	switch( out_flag )
	{
		case CODE_EUC:
			strncat(nkf_option, "e", sizeof(nkf_option) - strlen(nkf_option) );
			break;

		case CODE_SJIS:
		default:
			strncat(nkf_option, "s", sizeof(nkf_option) - strlen(nkf_option) );
			break;
	}


	//=================================================
	// libnkf ¹
	//=================================================
	nkf(in, out, len, nkf_option);




	return;
}

// **************************************************************************
// * MP3ե뤫顢ID3v1Υǡ
// **************************************************************************
static void  mp3_id3v1_tag_read(unsigned char *mp3_filename, SKIN_REPLASE_LINE_DATA_T *skin_rep_data_line_p )
{
	int	fd;
	unsigned char	buf[128];
	unsigned char	work_title_info[128];
	off_t		length;

	memset(buf, 			'\0', sizeof(buf));
	memset(work_title_info, '\0', sizeof(work_title_info));

	fd = open(mp3_filename,  O_RDONLY);
	if ( fd < 0 )
	{
		return;
	}

	// Ǹ夫128byteSEEK
	length = lseek(fd, -128, SEEK_END);


	// ------------------
	// "TAG"ʸǧ
	// ------------------

	// 3byteread. 
	read(fd, buf, 3);
	debug_log_output("buf='%s'", buf);

	// "TAG" ʸå
	if ( strncmp( buf, "TAG", 3 ) != 0 )
	{
		debug_log_output("NO ID3 Tag.");

		close(fd);
		return;		// MP3 ̵
	}


	// ------------------------------------------------------------
	// Tagread
	//
	//	ʸǸ0xFF' 'դƤ
	//  clientʸɤѴ
	// ------------------------------------------------------------


	// ̾
	memset(buf, '\0', sizeof(buf));
	read(fd, buf, 30);
	cut_character_at_linetail(buf, 0xFF);
	cut_character_at_linetail(buf, ' ');
	convert_language_code( 	buf, 
							skin_rep_data_line_p->mp3_id3v1_title,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_title), 
							CODE_AUTO, global_param.client_language_code);


	// ƥ
	memset(buf, '\0', sizeof(buf));
	read(fd, buf, 30);
	cut_character_at_linetail(buf, 0xFF);
	cut_character_at_linetail(buf, ' ');
	convert_language_code( 	buf, 
							skin_rep_data_line_p->mp3_id3v1_artist,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_artist), 
							CODE_AUTO, global_param.client_language_code);

	// Х̾
	memset(buf, '\0', sizeof(buf));
	read(fd, buf, 30);
	cut_character_at_linetail(buf, 0xFF);
	cut_character_at_linetail(buf, ' ');
	convert_language_code( 	buf, 
							skin_rep_data_line_p->mp3_id3v1_album,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_album), 
							CODE_AUTO, global_param.client_language_code);

	// ǯ
	memset(buf, '\0', sizeof(buf));
	read(fd, buf, 4);
	cut_character_at_linetail(buf, 0xFF);
	cut_character_at_linetail(buf, ' ');
	convert_language_code( 	buf, 
							skin_rep_data_line_p->mp3_id3v1_year,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_year), 
							CODE_AUTO, global_param.client_language_code);

	// 
	memset(buf, '\0', sizeof(buf));
	read(fd, buf, 28);
	cut_character_at_linetail(buf, 0xFF);
	cut_character_at_linetail(buf, ' ');
	convert_language_code( 	buf, 
							skin_rep_data_line_p->mp3_id3v1_comment,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_comment), 
							CODE_AUTO, global_param.client_language_code);


	// ---------------------
	// mp3_title_info
	// ---------------------
	strncpy(work_title_info, skin_rep_data_line_p->mp3_id3v1_title, sizeof(work_title_info));


	if ( (strlen(skin_rep_data_line_p->mp3_id3v1_album) > 0) && (strlen(skin_rep_data_line_p->mp3_id3v1_artist) > 0) )
	{
		strncat(work_title_info, " [", 									sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, skin_rep_data_line_p->mp3_id3v1_album, sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, "/", 									sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, skin_rep_data_line_p->mp3_id3v1_artist,sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, "]", 									sizeof(work_title_info) - strlen(work_title_info));
	}
	else if ( (strlen(skin_rep_data_line_p->mp3_id3v1_album) ==0) && (strlen(skin_rep_data_line_p->mp3_id3v1_artist) > 0) )
	{
		strncat(work_title_info, " [", 									sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, skin_rep_data_line_p->mp3_id3v1_artist,sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, "]", 									sizeof(work_title_info) - strlen(work_title_info));
	}
	else if ( (strlen(skin_rep_data_line_p->mp3_id3v1_album) > 0) && (strlen(skin_rep_data_line_p->mp3_id3v1_artist) ==0) )
	{
		strncat(work_title_info, " [", 									sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, skin_rep_data_line_p->mp3_id3v1_album, sizeof(work_title_info) - strlen(work_title_info));
		strncat(work_title_info, "]", 									sizeof(work_title_info) - strlen(work_title_info));
	}

	// mp3_title_info (̵)¸
	strncpy(skin_rep_data_line_p->mp3_id3v1_title_info, work_title_info, sizeof(skin_rep_data_line_p->mp3_id3v1_title_info) );

	// EUCѴ
	convert_language_code( 	work_title_info, 
							skin_rep_data_line_p->mp3_id3v1_title_info,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_title_info), 
							CODE_AUTO, CODE_EUC);
	strncpy(work_title_info, skin_rep_data_line_p->mp3_id3v1_title_info, sizeof(work_title_info));


	// Ĺ¤ĶƤCut
	if ( strlen(work_title_info) > global_param.menu_filename_length_max )
	{
		// CUT¹
		euc_string_cut_n_length(work_title_info, global_param.menu_filename_length_max);
		debug_log_output("mp3_title_info(cut)='%s'\n", work_title_info);
	}

	// 饤ʸɤˡ
	convert_language_code( 	work_title_info, 
							skin_rep_data_line_p->mp3_id3v1_title_info_limited,  
							sizeof(skin_rep_data_line_p->mp3_id3v1_title_info_limited), 
							CODE_EUC, global_param.client_language_code);


	// ---------------------
	// ¸ߥե饰
	// ---------------------
	skin_rep_data_line_p->mp3_id3v1_flag = 1;

	close(fd);
	return;
}


// *************************************************************************************
// playlistϤɽե̾ʤĴ
// *************************************************************************************
static void playlist_filename_adjustment(unsigned char *src_name, unsigned char *dist_name, int dist_size, int input_code )
{
	unsigned char	work_data[FILENAME_MAX];


	// ---------------------------------
	// ե̾  (ɽ)
	// EUCѴ  ĥҺ  (ɬפʤ)ȾʸѤѴ  MediaWizɤѴ  SJISʤ顢ʸ0x7C('|')ޤʸˡ
	// ---------------------------------
	convert_language_code(	src_name,
							dist_name,
							dist_size,
							input_code,
							CODE_EUC);

	if ( strchr(dist_name, '.') != NULL )
	{
		cut_after_last_character(dist_name, '.');
	}
	debug_log_output("dist_name(euc)='%s'\n", dist_name);

	if (global_param.flag_allplay_filelist_adjust == TRUE)
	{
		han2euczen(dist_name, work_data, sizeof(work_data) );
		debug_log_output("dist_name(euczen)='%s'\n", work_data);
	}
	else
	{
		strncpy(work_data, dist_name, sizeof(work_data));
	}

	convert_language_code( work_data, dist_name, dist_size, CODE_AUTO, global_param.client_language_code);
	debug_log_output("dist_name(MediaWiz Code)='%s'\n", dist_name);

	if ( global_param.client_language_code == CODE_SJIS )
	{
		sjis_code_thrust_replase(dist_name, '|');
		debug_log_output("dist_name(SJIS '|' replace)='%s'\n", dist_name);
	}


	return;
}