// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd_http.c
//											$Revision: 1.24 $
//											$Date: 2003/12/21 03:21:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <memory.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include <dirent.h>


#include "wizd.h"




static int http_header_receive(int accept_socket, HTTP_RECV_INFO *http_recv_info);
static int line_receive(int accept_socket, unsigned char *line_buf_p, int line_max);

static int http_file_check( HTTP_RECV_INFO *http_recv_info_p);


// **************************************************************************
// *  HTTP
// **************************************************************************
void 	server_http_process(int accept_socket)
{
	int					result;
	HTTP_RECV_INFO	http_recv_info;	//HTTP¸¤
	int				i;
	int				flag_allow_user_agent_check;

	memset(&http_recv_info, 0, sizeof(http_recv_info));


	// ----------------------------------------
	// HTTP ꥯȥإå
	// ----------------------------------------
	debug_log_output("HTTP Header receive start!\n");

	result = http_header_receive(accept_socket,  &http_recv_info);
	if ( result != 0 ) // 顼å
	{
		// 顼å
		debug_log_output("http_header_receive() Error. result=%d\n", result);
		// åȥ
		close(accept_socket);
		return;
	}
	debug_log_output("HTTP Header receive end!\n");

	debug_log_output("recv_uri:'%s'\n", http_recv_info.recv_uri);
	debug_log_output("user_agent:'%s'\n", http_recv_info.user_agent);

	debug_log_output("range_start_pos=%d\n", http_recv_info.range_start_pos);
	debug_log_output("range_end_pos=%d\n", http_recv_info.range_end_pos);


	// ==========================
	// = User-Agent å
	// ==========================

	flag_allow_user_agent_check = 0;

	if ( strlen(allow_user_agent[0].user_agent)  == 0 ) // User-Agnetؼ̵
	{
		debug_log_output("user_agent: allow_user_agent No List. All Allow.");
		flag_allow_user_agent_check = 1; // OK
	}
	else
	{
		// User-Agent å¹
		for ( i=0; i<ALLOW_USER_AGENT_LIST_MAX; i++)
		{
			if ( strlen(allow_user_agent[i].user_agent)  == 0 )
			{
				break;
			}

			// ץå
			debug_log_output("user_agent: Check[%d] '%s' in '%s'",i, allow_user_agent[i].user_agent, http_recv_info.user_agent);
			if ( strstr( http_recv_info.user_agent, allow_user_agent[i].user_agent ) != NULL )
			{
				debug_log_output("user_agent: '%s' OK.", allow_user_agent[i].user_agent );
				flag_allow_user_agent_check = 1; // סOK
				break;
			}
		}
	}

	// User-Agentå NGʤСåȥλ
	if ( flag_allow_user_agent_check == 0 )
	{
		debug_log_output("allow_user_agent check. Deny. Socket close.");

		// åȥ
		close(accept_socket);
		return;
	}




	// ----------------------------------------
	// äURIγĥҤrenameоݤʤrename
	// ----------------------------------------
	extension_del_rename(http_recv_info.recv_uri);


	// ============================
	// եå
	//  ˱ʬ
	// ============================
	result = http_file_check(&http_recv_info);

	// եΤʤСž
	if ( result == 0 )
	{
		// actionˡImageViewerؼƤ롩
		if ( strcasecmp(http_recv_info.action, "ImageView" ) == 0)
		{
			// ----------------------------------------
			// ᡼եӥ塼
			// ----------------------------------------
			debug_log_output("Image Viewer start!\n");
			http_image_viewer(accept_socket, &http_recv_info);
			debug_log_output("Image Viewer end!\n");
		}
		// actionˡSinglePlayؼƤ롩
		else if ( strcasecmp(http_recv_info.action, "SinglePlay" ) == 0)
		{
			// ----------------------------------------
			// Musicե ñȥץ쥤
			// ----------------------------------------
			debug_log_output("Music Single Play start!\n");
			http_music_single_play(accept_socket, &http_recv_info);
			debug_log_output("Music Single Play end!\n");
		}
		else // ˻̵
		{
			// ----------------------------------------
			// եμ
			// HTTPꥯȥإå˽äƥǡֿ
			// ----------------------------------------
			debug_log_output("HTTP response start!\n");
			http_file_response(accept_socket, &http_recv_info);
			debug_log_output("HTTP response end!\n");
		}

	}
	else if ( result == 2 )
	{
		// ----------------------------------------
		// SVIեʡ
		// SVIեƥǡֿ
		// ----------------------------------------
		debug_log_output("HTTP joint file response start!\n");
		http_joint_file_response(accept_socket, &http_recv_info);
		debug_log_output("HTTP joint file response end!\n");
	}
	else if ( result == 3 )
	{
		// ---------------------------------------------
		// plw/uplե(`؎) 
		// ꥹȥե뤫顢ץ쥤ꥹֿ
		// ---------------------------------------------
		debug_log_output("HTTP wizd play list create and response start!\n");
		http_listfile_to_playlist_create(accept_socket, &http_recv_info);
		debug_log_output("HTTP wizd play list create and response end!\n");
	}
	else 
	{
		// ----------------------------------------
		// ǥ쥯ȥ
		// ----------------------------------------

		// actionˡOptionMenuؼƤ롩
		if ( strcasecmp(http_recv_info.action, "OptionMenu" ) == 0)
		{
			debug_log_output("HTTP Option menu create.\n");
			http_option_menu(accept_socket, &http_recv_info);
			debug_log_output("HTTP Option menu end.\n");
		}
		else	// ˻̵
		{
			// -------------------------------------
			// ǥ쥯ȥ긡
			// եꥹȤֿ
			// -------------------------------------
			debug_log_output("HTTP file menu create.\n");
			http_menu(accept_socket, &http_recv_info);
			debug_log_output("HTTP file menu end.\n");
		}
	}




	// åȥ
	close(accept_socket);

	return;
}






// **************************************************************************
// HTTPإåƲϤ롣
// 
// ΤGETΤߡGETʳΥ᥽åɤ褿饨顼
// ΤȤURIuser_agentRangeHostϡ
// URIϡURIǥɤ롣
//
//	return: 0 		ｪλ
//	return: 0ʳ 	顼
// **************************************************************************
static int http_header_receive(int accept_socket, HTTP_RECV_INFO *http_recv_info_p)
{
	int result = 0;
	int	recv_len;
    unsigned char	line_buf[1024];	// 礭ˡ
    unsigned char 	work_buf[1024];
    unsigned char 	work_buf2[1024];
    unsigned char 	split1[1024];
    unsigned char 	split2[1024];

	int		ret;
	int		i;

	// ================================
	// ԤŤ HTTPإå
	// ================================
	for (i=0;;i++)
	{
		// 1Լ ¹ԡ
		memset(line_buf, '\0', sizeof(line_buf));
		recv_len = line_receive(accept_socket, line_buf, sizeof(line_buf));

		// debug. إåɽ
		debug_log_output("'%s'(%d byte)\n", line_buf, recv_len );

		// Ƥå
		if ( recv_len == 0 ) // ԸΡإåλ
		{
			break;
		}
		else if ( recv_len < 0 ) // 
		{
			return ( -1 );	
		}

		// --------------------------
		// GETåå
		// --------------------------
		if ( i == 0 ) // ܤΤߥå
		{
			debug_log_output("URI Check start.'%s'\n", line_buf);

			// GET롩
			if ( strstr(line_buf, "GET") == NULL )
			{
				debug_log_output("'GET' not found. error.");
				return ( -1 );
			}

			// ǽΥڡޤǤ
			cut_before_character(line_buf, ' ');

			// ˥ڡФƤȤθޤǤ
			cut_after_character(line_buf, ' ');

			// ===========================
			// GETץ
			// ===========================

			// '?'¸ߤ뤫å
			if ( strchr(line_buf, '?') != NULL )
			{

				strncpy(work_buf, line_buf, sizeof(work_buf));

				// '?'򥫥å
				cut_before_character(work_buf, '?' );
				debug_log_output("work_buf = '%s'", work_buf );

				while ( 1 ) 
				{
					memset(split1, '\0', sizeof(split1));
					memset(split2, '\0', sizeof(split2));

					// ǽо줹'&'ʬ
					ret = sentence_split(work_buf, '&', split1, split2 );
					if ( ret == 0 ) // ʬ
					{
						strncpy(work_buf, split2, sizeof(work_buf));
					}
					else if (strlen(work_buf) > 0) // ޤwork_bufȤ롩
					{
						strncpy( split1, work_buf, sizeof(split1));
						strncpy( work_buf, "", sizeof(work_buf));
					}
					else // λ
					{
						break;
					}

					// -------------------------------------
					// GET ϳ
					// ĶľΤӤǡ
					// -------------------------------------

					// URIǥ
					uri_decode(work_buf2, sizeof(work_buf2), split1, sizeof(split1) );

					// "page="뤫Ĵ
					if (strncasecmp( work_buf2, "page=", strlen("page=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');
						if ( strlen(work_buf2) > 0 )
						{
							// ¤Τͤ¸
							http_recv_info_p->page = atoi(work_buf2);
						}

						continue;
					}

					// "action="뤫Ĵ
					if (strncasecmp( work_buf2, "action=", strlen("action=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');

						// ¤Τͤ¸
						strncpy(http_recv_info_p->action, work_buf2, sizeof(http_recv_info_p->action));
						continue;
					}

					// "option="뤫Ĵ
					if (strncasecmp( work_buf2, "option=", strlen("option=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');

						// ¤Τͤ¸
						strncpy(http_recv_info_p->option, work_buf2, sizeof(http_recv_info_p->option));
						continue;
					}


					// "sort="뤫Ĵ
					if (strncasecmp( work_buf2, "sort=", strlen("sort=") ) == 0 )
					{
						// = 
						cut_before_character(work_buf2, '=');

						// ¤Τͤ¸
						strncpy(http_recv_info_p->sort, work_buf2, sizeof(http_recv_info_p->sort));
						continue;
					}





				}
			}

			debug_log_output("http_recv_info_p->page = '%d'", http_recv_info_p->page);
			debug_log_output("http_recv_info_p->action = '%s'", http_recv_info_p->action);

			// URIǥ
			cut_after_character(line_buf, '?');
			uri_decode(work_buf, sizeof(work_buf), line_buf, sizeof(line_buf) );
			strncpy(line_buf, work_buf, sizeof(line_buf));
			debug_log_output("URI(decoded):'%s'\n", line_buf);


			// ¤Τ¸
			strncpy(http_recv_info_p->recv_uri, line_buf, sizeof(http_recv_info_p->recv_uri));

			continue;

		}

		// User-agentڤФ
		if ( strncasecmp(line_buf, HTTP_USER_AGENT, strlen(HTTP_USER_AGENT) ) == 0 )
		{
			debug_log_output("User-agent: Detect.\n");
			// ':'ڤ
			cut_before_character(line_buf, ':');
			cut_first_character(line_buf, ' ');

			// ¤Τ¸
			strncpy( http_recv_info_p->user_agent, line_buf, sizeof(http_recv_info_p->user_agent));
			continue;
		}

		// Range뤫å
		if ( strncasecmp(line_buf, HTTP_RANGE,	strlen(HTTP_RANGE) ) == 0 )
		{
			debug_log_output("%s Detect.\n", HTTP_RANGE);
			// ':' ڤ롣
			cut_before_character(line_buf, ':');
			cut_first_character(line_buf, ' ');

			// '=' ڤ
			cut_before_character(line_buf, '=');


			// '-'ʬ䡣
			sentence_split(line_buf, '-', work_buf, work_buf2);

			debug_log_output("wrok_buf='%s'\n", work_buf);
			debug_log_output("wrok_buf2='%s'\n", work_buf2);

			// ͤʸ󢪿Ѵ
			http_recv_info_p->range_start_pos  = strtoull(work_buf, NULL, 10);

			if ( strlen(work_buf2) > 0 )
			{
				http_recv_info_p->range_end_pos = strtoull(work_buf2, NULL, 10);
			}

		
			debug_log_output("range_start_pos=%d\n", http_recv_info_p->range_start_pos);
			debug_log_output("range_end_pos=%d\n", http_recv_info_p->range_end_pos);

			continue;
		}

		// Host뤫å
		if ( strncasecmp(line_buf, HTTP_HOST,	strlen(HTTP_HOST) ) == 0 )
		{
			debug_log_output("%s Detect.\n", HTTP_HOST);
			// ':' ڤ롣
			cut_before_character(line_buf, ':');
			cut_first_character(line_buf, ' ');

			strncpy(http_recv_info_p->recv_host, line_buf, sizeof(http_recv_info_p->recv_host));

			debug_log_output("%s '%s'", HTTP_HOST, http_recv_info_p->recv_host);

			continue;
		}
	}

	return result;
}





// **************************************************************************
// ꥯȤ줿URIΥեå
// documet_rootȡskin֤򥻥åȤõ
// 
// ret		 0:
//			 1:ǥ쥯ȥ
//			 2:SVIեʡ
//			 3:plw/uplե(`؎) 
// **************************************************************************
static int http_file_check( HTTP_RECV_INFO *http_recv_info_p)
{
	struct stat send_filestat;
	int result;

	unsigned char	file_extension[16];


	debug_log_output("http_file_check() start.");

	// ---------------
	// ѿ
	// ---------------
	memset(http_recv_info_p->send_filename, '\0', sizeof(http_recv_info_p->send_filename));
	memset(file_extension, '\0', sizeof(file_extension));



	// -------------------------
	// եå
	// -------------------------

	// ׵ѥΥեѥ
	strncpy(http_recv_info_p->send_filename, global_param.document_root, sizeof(http_recv_info_p->send_filename));
	strncat(http_recv_info_p->send_filename, http_recv_info_p->recv_uri, sizeof(http_recv_info_p->send_filename));

	// '/' ŤʤäƤȤνʣӽ
	duplex_character_to_unique(http_recv_info_p->send_filename, '/');
	debug_log_output("http_recv_info_p->send_filename='%s'\n", http_recv_info_p->send_filename);

	// ------------------------------------------------------------
	// ե뤢뤫å
	// ------------------------------------------------------------
	result = stat(http_recv_info_p->send_filename, &send_filestat);
	debug_log_output("stat: result=%d, st_mode=0x%04X, S_ISREG=%d, S_ISDIR=%d\n", result, send_filestat.st_mode, S_ISREG(send_filestat.st_mode), S_ISDIR(send_filestat.st_mode) );

	// stat()η̤ʬ
	if ( ( result == 0 ) && ( S_ISREG(send_filestat.st_mode) == 1 ) )
	{
		 // եΤȸ
		debug_log_output("'%s' is File!!", http_recv_info_p->send_filename);
		debug_log_output("send_filestat.st_size= %lld\n", send_filestat.st_size);


		// -------------------------------------------
		// եγĥҤꡢContent-type 
		// -------------------------------------------
		filename_to_extension(http_recv_info_p->send_filename, file_extension, sizeof(file_extension));
		debug_log_output("http_recv_info_p->send_filename='%s', file_extension='%s'\n", http_recv_info_p->send_filename, file_extension);

		// ĥҤ顢mime_typeƳ
		check_file_extension_to_mime_type(file_extension, http_recv_info_p->mime_type,  sizeof(http_recv_info_p->mime_type));


		// SVIեȼΥեʬ
		if ( strcasecmp(file_extension, "svi") == 0  )
		{
			return ( 2 );	// sviե
		}
		else if (( strcasecmp(file_extension, "plw") == 0  ) ||
				 ( strcasecmp(file_extension, "upl") == 0  ) )
		{
			return ( 3 );	// plw/upl ե
		}
		else
		{
			return ( 0 );	// File
		}
	}
	else if ( ( result == 0 ) && ( S_ISDIR(send_filestat.st_mode) == 1 ) ) // ǥ쥯ȥ
	{
		// ǥ쥯ȥȸ
		debug_log_output("'%s' is Dir!!", http_recv_info_p->send_filename);

		return ( 1 ) ;	// ǥ쥯ȥ
	}
	else
	{
		debug_log_output("stat() error\n", result);

		// ----------------------------------------------------------------------------
		// ⤷Τ¸ߤʤä顢skin֤ѤƤ⤦٥å
		// Skin֤ϼΥեΤǧ롣
		// ----------------------------------------------------------------------------
		debug_log_output("DocumentRoot not found. SkinDir Check.");

		debug_log_output("global_param.skin_root='%s'", global_param.skin_root);
		debug_log_output("global_param.skin_name='%s'", global_param.skin_name);


		// skin֤ˤΤȤơեѥ
		strncpy(http_recv_info_p->send_filename, global_param.skin_root, sizeof(http_recv_info_p->send_filename));
		strncat(http_recv_info_p->send_filename, global_param.skin_name, sizeof(http_recv_info_p->send_filename));
		strncat(http_recv_info_p->send_filename, http_recv_info_p->recv_uri, sizeof(http_recv_info_p->send_filename));

		// '/' ŤʤäƤȤνʣӽ
		duplex_character_to_unique(http_recv_info_p->send_filename, '/');
		debug_log_output("SkinDir:http_recv_info_p->send_filename='%s'\n", http_recv_info_p->send_filename);


		// ------------------------------------------------------------
		// Skin֤˥ե뤢뤫å
		// ------------------------------------------------------------
		result = stat(http_recv_info_p->send_filename, &send_filestat);
		debug_log_output("stat: result=%d, st_mode=%04X, S_ISREG=%d\n", result, send_filestat.st_mode, S_ISREG(send_filestat.st_mode));


		// եΤȸΡ
		if ( ( result == 0 ) && (S_ISREG(send_filestat.st_mode) == 1 ) )
		{
			 // եΤȸ
			debug_log_output("'%s' is File!!", http_recv_info_p->send_filename);
			debug_log_output("send_filestat.st_size= %lld\n", send_filestat.st_size);

			// -------------------------------------------
			// եγĥҤꡢContent-type 
			// -------------------------------------------
			filename_to_extension(http_recv_info_p->send_filename, file_extension, sizeof(file_extension));
			debug_log_output("http_recv_info_p->send_filename='%s', file_extension='%s'\n", http_recv_info_p->send_filename, file_extension);

			check_file_extension_to_mime_type(file_extension, http_recv_info_p->mime_type,  sizeof(http_recv_info_p->mime_type));

			return ( 0 );	// File

		}
		else 
		{

			// -------------------------------------
			// File Not Found.
			// ˡdocument_root˶ư
			// äѤꡢ404ˤۤ⡣
			// -------------------------------------
			strncpy(http_recv_info_p->recv_uri,	"/",	sizeof(http_recv_info_p->recv_uri));
			strncpy(http_recv_info_p->send_filename, global_param.document_root, sizeof(http_recv_info_p->send_filename));
			// ǥ쥯ȥȤư	(ۥȤϤ⤦٥å٤ʤ)

			return ( 1 ) ;
		}

	}


	return ( 1 );

}






// **************************************************************************
// accept_socket顢(CRLFLFñȤޤ)
// CRLFϺ롣
// return롣
// **************************************************************************
static int line_receive(int accept_socket, unsigned char *line_buf_p, int line_max)
{
	unsigned char byte_buf;
	int 	line_len;
	int		recv_len;

	unsigned char *line_buf_work_p;

	line_buf_work_p = line_buf_p;
	line_len = 0;

	// Լ¹
	while ( 1 )
	{
   		recv_len = recv(accept_socket, &byte_buf, 1, 0);
		if ( recv_len != 1 ) // ԥå
		{
			return ( -1 );
		}

		// CR/LFå
		if ( byte_buf == '\r' )
		{
			continue;
		}
		else if ( byte_buf == '\n' )
		{
			break;
		}

		// Хåե˥å
		*line_buf_work_p = byte_buf;
		line_buf_work_p++;
		line_len++;

		// printf("line_len=%d, buf='%s'\n", line_len, line_buf_p);

		// Хåեå
		if ( line_len >= line_max) 
		{
			// ХåեСե
			debug_log_output("line_buf over flow.");
			return ( -1 );
		}
	}

	return line_len;
}
