// ==========================================================================
//code=EUC	tab=4
//
// wizd:	MediaWiz Server daemon.
//
// 		wizd.h
//											$Revision: 1.33 $
//											$Date: 2003/12/21 03:21:10 $
//
//	٤ƼǤǤʤޤġ
//  ΥեȤˤĤVertexLink䤤碌ʤǤ
// ==========================================================================
#ifndef	_WIZD_H
#define	_WIZD_H


#include	"wizd_tools.h"

// ======================
// define 
// ======================

#define		SERVER_NAME		"wizd 0.12"
#define		SERVER_DETAIL	"MediaWiz Server Daemon."


#ifndef TRUE
#define	TRUE	(1)
#endif
#ifndef FALSE
#define	FALSE	(0)
#endif





#define		LISTEN_BACKLOG	(32)

#define		SEND_BUFFER_SIZE	(1024*128)


#define DEFAULT_SERVER_PORT (8000)
#define	DEFAULT_DOCUMENT_ROOT	"/"


#define	DEFAULT_FLAG_DAEMON			TRUE
#define	DEFAULT_FLAG_AUTO_DETECT	TRUE




#define	DEFAULT_MIME_TYPE		"text/plain"

#define	DEFAULT_INDEX_FILENAME	"index.html"

#define	DEFAULT_CONF_FILENAME1	"./wizd.conf"
#define	DEFAULT_CONF_FILENAME2	"/usr/local/wizd/wizd.conf"
#define	DEFAULT_CONF_FILENAME3	"/etc/wizd.conf"


#define	DEFAULT_FLAG_DEBUG_LOG_OUTPUT	FALSE
#define	DEFAULT_DEBUG_LOG_FILENAME		"/tmp/wizd_debug.log"


#define	DEFAULT_FLAG_USE_SKIN		FALSE
#define	DEFAULT_SKINDATA_ROOT		"./skin"
#define	DEFAULT_SKINDATA_NAME		"default"

#define	DEFAULT_FLAG_HIDE_SAME_SVI_NAME_DIRECTORY	FALSE

#define	DEFAULT_MENU_FILENAME_LENGTH_MAX		FILENAME_MAX
#define	DEFAULT_MENU_SVI_INFO_LENGTH_MAX		FILENAME_MAX

#define	DEFAULT_FLAG_UNKNOWN_EXTENSION_FLAG_HIDE	TRUE

#define	DEFAULT_FLAG_FILENAME_CUT_PARENTHESIS_AREA	FALSE

#define	DEFAULT_FLAG_DECODE_SAMBA_HEX_AND_CAP			FALSE
#define	DEFAULT_FLAG_FILENAME_CUT_SAME_DIRECTORY_NAME	FALSE

#define	DEFAULT_FLAG_ALLPLAY_FILELIST_ADJUST			FALSE


#define	SORT_NONE				(0)
#define	SORT_NAME_UP			(1)
#define	SORT_NAME_DOWN			(2)
#define	SORT_TIME_UP			(3)
#define	SORT_TIME_DOWN			(4)
#define	SORT_SIZE_UP			(5)
#define	SORT_SIZE_DOWN			(6)

#define	DEFAULT_SORT_RULE		SORT_NONE
#define	DEFAULT_PAGE_LINE_MAX	(14)


#define	NKF_CODE_SJIS			"s"
#define	NKF_CODE_EUC			"e"


#define CODE_AUTO		(0)
#define CODE_SJIS		(1)
#define CODE_EUC		(2)
#define CODE_UTF8		(3)
#define CODE_UTF16		(4)

#define	DEFAULT_CLIENT_LANGUAGE_CODE	CODE_SJIS
#define	DEFAULT_SERVER_LANGUAGE_CODE	CODE_AUTO



#define	HTTP_USER_AGENT		"User-agent:"
#define	HTTP_RANGE			"Range:"
#define	HTTP_HOST			"Host:"

#define	HTTP_OK 			"HTTP/1.0 200 OK\r\n"
#define	HTTP_NOT_FOUND 		"HTTP/1.0 404 File Not Found\r\n"
#define HTTP_CONTENT_LENGTH	"Content-Length: %lld\r\n"
#define	HTTP_ACCEPT_RANGES	"Accept-Ranges: bytes\r\n"
#define HTTP_CONTENT_TYPE 	"Content-Type: %s\r\n"
#define	HTTP_SERVER_NAME	"Server: %s\r\n"
#define	HTTP_CONNECTION		"Connection: Close\r\n"
#define HTTP_END			"\r\n"


// ȥ Ͽǽ
#define		ACCESS_ALLOW_LIST_MAX	(32)


#define		ALLOW_USER_AGENT_LIST_MAX	(32)

// ǥ쥯ȥϿǽ
#define		SECRET_DIRECTORY_MAX	(4)


// MIME_LIST_T.stream_type 
#define		TYPE_STREAM			(0)
#define		TYPE_NO_STREAM		(1)

// MIME_LIST.menu_file_type
#define		TYPE_UNKNOWN			(0)
#define		TYPE_DIRECTORY			(1)
#define		TYPE_MOVIE				(2)
#define		TYPE_MUSIC				(3)
#define		TYPE_IMAGE				(4)
#define		TYPE_DOCUMENT			(5)
#define		TYPE_SVI				(6)



// SVI_INFO

#define	SVI_FILENAME_OFFSET		(4368)
#define	SVI_FILENAME_LENGTH		(255)

#define	SVI_INFO_OFFSET			(272)
#define	SVI_INFO_LENGTH			(1024)

#define	SVI_TOTAL_SIZE_OFFSET	(4984)
#define	SVI_TOTAL_SIZE_LENGTH	(5)

#define	SVI_REC_TIME_OFFSET		(4972)
#define	SVI_REC_TIME_LENGTH		(2)



// ==========================================================================
// MIMEꥹ¸ѹ¤
// ==========================================================================
typedef struct {
	unsigned char	*mime_name;
	unsigned char	*file_extension;
	int				stream_type;
	int				menu_file_type;
} MIME_LIST_T;


// ==========================================================================
// ĥѴơ֥
// ==========================================================================
typedef struct {
	unsigned char	*org_extension;
	unsigned char	*rename_extension;
} EXTENSION_CONVERT_LIST_T;





// ==========================================================================
// HTTP Request¸ѹ¤
// ==========================================================================
typedef struct {
	unsigned char 	recv_uri[FILENAME_MAX];		// URI
	unsigned char 	user_agent[256];			// User-Agent
	unsigned char	recv_host[256];				// 饤ȥɥ쥹

	off_t	range_start_pos;			// Rangeǡ ϰ
	off_t	range_end_pos;				// Rangeǡ λ

	unsigned char	mime_type[128];		// 
	unsigned char	send_filename[FILENAME_MAX];	// եѥ


	unsigned char	action[128];	// ?action=  
	int				page;			// ?page=	ǻꤵ줿ɽڡ

	unsigned char 	option[32];		// ?option= 
	unsigned char	sort[32];		// ?sort= 


} HTTP_RECV_INFO;



// ==========================================================================
// Υѥ᡼¸ѹ¤
// ==========================================================================
typedef struct {


	// -----------------
	// ƥ
	// -----------------

	// ǡ󲽤/ʤ
	char			flag_daemon;

	// ǥХå
	char			flag_debug_log_output;
	unsigned char	debug_log_filename[FILENAME_MAX];


	// ư桼̾
	char	exec_user[32];
	char	exec_group[32];

	// -----------------
	// ưз
	// -----------------

	// Хۥ̾
	unsigned char	server_name[32];

	char			flag_auto_detect;
	unsigned char	auto_detect_bind_ip_address[32];

	// --------------------
	// HTTP Server
	// --------------------

	// HTTP Server Port
	int		server_port;

	// Document Root
	unsigned char 	document_root[FILENAME_MAX];



	// ----------------------
	// ɽ
	// ----------------------

	// MediaWiz θ쥳
	int	client_language_code;

	// Serverθ쥳
	int	server_language_code;


	// Ѥ롿ʤ
	char			flag_use_skin;

	// ֤
	unsigned char	skin_root[FILENAME_MAX];

	// ̾
	unsigned char	skin_name[32];

	// ե륽ȤΥ롼
	int		sort_rule;

	//եꥹȤΣڡκɽ
	int		page_line_max;

	// ե̾ɽκĹ
	int		menu_filename_length_max;

	//sambaCAP/HEX󥳡ɻѤ뤫ե饰
	char	flag_decode_samba_hex_and_cap;

	// wizd Τʤե̾򱣤ե饰
	char	flag_unknown_extention_file_hide;

	// ɽե̾顢()[]ǰϤޤ줿ʬ뤫ե饰
	char	flag_filename_cut_parenthesis_area;

	// ɽե̾ǡƥǥ쥯ȥ̾Ʊʸ뤫ե饰
	char	flag_filename_cut_same_directory_name;

	//  SVIեƱ̾ĥǥ쥯ȥ򱣤ե饰
	char	flag_hide_same_svi_name_directory;

	// AllplayǤʸɻ(ե̾ȾѴ)뤫ե饰
	char	flag_allplay_filelist_adjust;


	// SVIեɽMAXĹ
	int		menu_svi_info_length_max;

} GLOBAL_PARAM_T;



// IPɥ쥹ȥ
typedef struct {
	int				flag;			// ͤäƤ뤫
	unsigned char 	address[4];		// ɥ쥹
	unsigned char 	netmask[4];		// ͥåȥޥ

} ACCESS_CHECK_LIST_T;


// User-Agent ȥ
typedef struct {
	unsigned char	user_agent[64];
} ACCESS_USER_AGENT_LIST_T;


// ǥ쥯ȥ
typedef struct {
	unsigned char	dir_name[64];	// ǥ쥯ȥ̾
	int				tvid;			// TVID
} SECRET_DIRECTORY_T;


// ======================
// extern 
// ======================

// ------------------
// Ƽꥹ
// ------------------
extern GLOBAL_PARAM_T	global_param;
extern MIME_LIST_T	mime_list[];
extern EXTENSION_CONVERT_LIST_T extension_convert_list[];


// ĥꥹ
extern ACCESS_CHECK_LIST_T	access_allow_list[ACCESS_ALLOW_LIST_MAX];

// User-Agent ĥꥹ
extern ACCESS_USER_AGENT_LIST_T	allow_user_agent[ALLOW_USER_AGENT_LIST_MAX];

// ǥ쥯ȥ ꥹ
extern SECRET_DIRECTORY_T secret_directory_list[SECRET_DIRECTORY_MAX];

// ------------------
// Хؿ
// ------------------


// wizd 
extern void global_param_init(void);

// config_file(wizd.conf) ɤ߹
extern void config_file_read(void);

extern void skin_config_file_read(unsigned char *skin_conf_filename);


// MediaWiz ưϿ
extern void	server_detect(void);


// HTTP Ԥ
extern void server_listen(void);	


// HTTP
extern void server_http_process(int accept_socket); 






// SVIեϡֿ
extern int http_joint_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p );

extern int read_svi_info(unsigned char *svi_filename, unsigned char *svi_info, int svi_info_size, unsigned int *rec_time );
off_t svi_file_total_size(unsigned char *svi_filename);

// եֿ
extern int http_file_response(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);


// ˥塼
extern void http_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info);


// Image Viewerʲɽ)
extern void http_image_viewer(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);

// Option Menu(Sort⡼ѹ)
extern void http_option_menu(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);

// Music Single Play.(ڥե ʬαեǡ)
extern void http_music_single_play(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);

// wizd play list(*.plw)ե
extern void http_listfile_to_playlist_create(int accept_socket, HTTP_RECV_INFO *http_recv_info_p);

// MIME
extern void check_file_extension_to_mime_type(const unsigned char *file_extension, unsigned char *mime_type, int mime_type_size );


// ܸʸѴ(NKFåѡ
extern void convert_language_code(const unsigned char *in, unsigned char *out, size_t len, int in_flag, int out_flag);


// ========================================================
// ʸѴ
// libnkf򤽤Τޤ޻ѡͤ˴ա()
// http://www.mr.hum.titech.ac.jp/~morimoto/libnkf/
// ========================================================
int nkf(const char *, char *, size_t, const char *);



#endif

