<?php
// $Horde: turba/lib/Turba.php,v 1.15.2.12 2003/02/10 10:46:30 jan Exp $

// Search types
/** @const TURBA_SEARCH_AND. Boolean 'and' search. */ define('TURBA_SEARCH_AND', 1);
/** @const TURBA_SEARCH_OR Boolean 'or' search.    */ define('TURBA_SEARCH_OR', 2);
/** @const TURBA_DELETE Delete Contact.            */ define('TURBA_DELETE', 3);
/** @const TURBA_ADD Add Contact to a List.        */ define('TURBA_ADD', 4);

/**
 * Turba Base Class.
 *
 * @author Chuck Hagenbuch <chuck@horde.org>
 * @author Jon Parise <jon@horde.org>
 * @version $Revision: 1.2 $
 * @package turba
 */
class Turba {

    function getBareEmail($address)
    {
	require_once 'Mail/RFC822.php';
	
	static $rfc822;
	if (is_null($rfc822)) {
	    $rfc822 = new Mail_RFC822();
	}
	
	$rfc822->validateMailbox($address);
	
	return $address->mailbox . '@' . $address->host;
    }

    function string2Columns($string)
    {
        $ret = array();
        $lines = explode("\n", $string);
        foreach ($lines as $line) {
            $line = trim($line);
            if (!empty($line)) {
                $columns = explode("\t", $line);
                if (count($columns) > 1) {
                    $source = array_splice($columns, 0, 1);
                    $ret[$source[0]] = $columns;
                }
            }
        }

        return $ret;
    }

    function columns2String($hash)
    {
        foreach ($hash as $source => $columns) {
            if (isset($string)) {
                $string .= "\n";
            } else {
                $string = '';
            }
            $line = '';
            foreach ($columns as $column) {
                if (!empty($line)) {
                    $line .= "\t";
                }
                $line .= $column;
            }
        }

        return $string;
    }

    function wapFormat($phoneNumber)
    {
        $phoneNumber = preg_replace('|[ .()-]|', '', $phoneNumber);
        $phoneNumber = preg_replace('|ext(.)*|', '', $phoneNumber);

        return $phoneNumber;
    }

    /**
     * Add a name=value pair to an URL, taking care of whether there
     * are existing parameters and whether to use ? or & as the glue.
     *
     * @access public
     *
     * @param string $url       The URL to modify
     * @param string $parameter The name=value pair to add.
     *
     * @return string The modified URL.
     *
     * @since Turba 1.2
     */
    function addParameter($url, $parameter)
    {
        if (!empty($parameter) && strstr($url, $parameter) === false) {
            if (substr($parameter, 0, 1) == '?') {
                $parameter = substr($parameter, 1);
            }

            $pos = strpos($url, '?');
            if ($pos !== false) {
                $url = substr_replace($url, $parameter . ini_get('arg_separator.output'),
                                      $pos + 1, 0);
            } else {
                $url .= '?' . $parameter;
            }
        }
        return $url;
    }

    /**
     * Returns a best guess at the lastname in a string.
     *
     * @param $name     String contain the full name.
     *
     * @return          String containing the last name.
     */
    function guessLastname($name)
    {
        if (!empty($name)) {
            /* Assume that last names are always before any commas. */
            if (is_int(strpos($name, ','))) {
                $name = substr($name, 0, strpos($name, ','));
            }

            /* Take out anything in parentheses. */
            $name = preg_replace('|\(.*\)|', '', $name);

            /* Remove single quotes. */
            $name = str_replace('\'', '', $name);

            $name = trim(preg_replace('|\s+|', ' ', $name));
            $namelist = explode(' ', $name);
            $name = $namelist[($nameindex = (count($namelist) - 1))];

            while (strlen($name) < 5 &&
                   strspn($name[(strlen($name) - 1)], '.:-') &&
                   isset($namelist[($nameindex - 1)])) {
                $nameindex--;
                $name = $namelist[$nameindex];
            }
        }
        return $name;
    }

    /**
     * Formats the name according to the user's preference.
     *
     * @param string $name  The full name.
     * @return string       The formatted name, either "Firstname Lastname"
     *                      or "Lastname, Firstname" depending on the user's
     *                      preference.
     */
    function formatName($name)
    {
        global $prefs;

        $format = $prefs->getValue('name_format');
        $lastname = Turba::guessLastname($name);
        if ($format == 'last_first' &&
            !is_int(strpos($name, ',')) &&
            strlen($name) > strlen($lastname)) {
            $name = preg_replace("|\s+$lastname|", '', $name);
            $name = $lastname . ', ' . $name;
        }
        if ($format == 'first_last' &&
            is_int(strpos($name, ',')) &&
            String::length($name) > String::length($lastname)) {
            $name = preg_replace("|$lastname,\s*|", '', $name);
            $name = $name . ' ' . $lastname;
        }
        return $name;
    }

}
