<?php
/**
 * decode/iso_2022_jp.php
 *
 * Copyright (c) 2003-2005 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This file contains iso-2022-jp decoding function that is needed to read
 * iso-2022-jp encoded mails in non-iso-2022-jp locale.
 *
 * @version $Id: iso_2022_jp.php,v 1.2 2005/06/15 00:23:57 masato Exp $
 * @package squirrelmail
 * @subpackage decode
 */

/**
 * Decode iso-2022-jp string
 * @param string $string Encoded string
 * @return string $string Decoded string
 */
function charset_decode_iso_2022_jp ($string) {
    global $squirrelmail_language;

    //if ($squirrelmail_language != 'ja_JP') {
        include_once(SM_PATH . 'functions/decode/utf_8.php');
        $string = charset_decode_utf_8(@mb_convert_encoding($string, 'UTF-8', 'AUTO'));
        //}

    return $string;
}

?>
