.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "VALUES" "" "2008-10-31" "SQL - Language Statements" "SQL Commands"
.SH NAME
VALUES \- compute a set of rows

.SH SYNOPSIS
.sp
.nf
VALUES ( \fIexpression\fR [, ...] ) [, ...]
    [ ORDER BY \fIsort_expression\fR [ ASC | DESC | USING \fIoperator\fR ] [, ...] ]
    [ LIMIT { \fIcount\fR | ALL } ]
    [ OFFSET \fIstart\fR ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBVALUES\fR computes a row value or set of row values
specified by value expressions. It is most commonly used to generate
a ``constant table'' within a larger command, but it can be
used on its own.
.PP
When more than one row is specified, all the rows must have the same
number of elements. The data types of the resulting table's columns are
determined by combining the explicit or inferred types of the expressions
appearing in that column, using the same rules as for UNION
(see in the documentation).
.PP
Within larger commands, \fBVALUES\fR is syntactically allowed
anywhere that \fBSELECT\fR is. Because it is treated like a
\fBSELECT\fR by the grammar, it is possible to use the ORDER
BY, LIMIT, and OFFSET clauses with a
\fBVALUES\fR command.
.SH "PARAMETERS"
.TP
\fB\fIexpression\fB\fR
A constant or expression to compute and insert at the indicated place
in the resulting table (set of rows). In a \fBVALUES\fR list
appearing at the top level of an \fBINSERT\fR, an
\fIexpression\fR can be replaced
by DEFAULT to indicate that the destination column's
default value should be inserted. DEFAULT cannot
be used when \fBVALUES\fR appears in other contexts.
.TP
\fB\fIsort_expression\fB\fR
An expression or integer constant indicating how to sort the result
rows. This expression can refer to the columns of the
\fBVALUES\fR result as column1, column2,
etc. For more details see
ORDER BY Clause [\fBselect\fR(l)].
.TP
\fB\fIoperator\fB\fR
A sorting operator. For details see
ORDER BY Clause [\fBselect\fR(l)].
.TP
\fB\fIcount\fB\fR
The maximum number of rows to return. For details see
LIMIT Clause [\fBselect\fR(l)].
.TP
\fB\fIstart\fB\fR
The number of rows to skip before starting to return rows.
For details see 
LIMIT Clause [\fBselect\fR(l)].
.SH "NOTES"
.PP
\fBVALUES\fR lists with very large numbers of rows should be avoided,
as you might encounter out-of-memory failures or poor performance.
\fBVALUES\fR appearing within \fBINSERT\fR is a special case
(because the desired column types are known from the \fBINSERT\fR's
target table, and need not be inferred by scanning the \fBVALUES\fR
list), so it can handle larger lists than are practical in other contexts.
.SH "EXAMPLES"
.PP
A bare \fBVALUES\fR command:
.sp
.nf
VALUES (1, 'one'), (2, 'two'), (3, 'three');
.sp
.fi
This will return a table of two columns and three rows. It's effectively
equivalent to:
.sp
.nf
SELECT 1 AS column1, 'one' AS column2
UNION ALL
SELECT 2, 'two'
UNION ALL
SELECT 3, 'three';
.sp
.fi
.PP
More usually, \fBVALUES\fR is used within a larger SQL command.
The most common use is in \fBINSERT\fR:
.sp
.nf
INSERT INTO films (code, title, did, date_prod, kind)
    VALUES ('T_601', 'Yojimbo', 106, '1961-06-16', 'Drama');
.sp
.fi
.PP
In the context of \fBINSERT\fR, entries of a \fBVALUES\fR list
can be DEFAULT to indicate that the column default
should be used here instead of specifying a value:
.sp
.nf
INSERT INTO films VALUES
    ('UA502', 'Bananas', 105, DEFAULT, 'Comedy', '82 minutes'),
    ('T_601', 'Yojimbo', 106, DEFAULT, 'Drama', DEFAULT);
.sp
.fi
.PP
\fBVALUES\fR can also be used where a sub-\fBSELECT\fR might
be written, for example in a FROM clause:
.sp
.nf
SELECT f.*
  FROM films f, (VALUES('MGM', 'Horror'), ('UA', 'Sci-Fi')) AS t (studio, kind)
  WHERE f.studio = t.studio AND f.kind = t.kind;

UPDATE employees SET salary = salary * v.increase
  FROM (VALUES(1, 200000, 1.2), (2, 400000, 1.4)) AS v (depno, target, increase)
  WHERE employees.depno = v.depno AND employees.sales >= v.target;
.sp
.fi
Note that an AS clause is required when \fBVALUES\fR
is used in a FROM clause, just as is true for
\fBSELECT\fR. It is not required that the AS clause
specify names for all the columns, but it's good practice to do so.
(The default column names for \fBVALUES\fR are column1,
column2, etc in PostgreSQL, but
these names might be different in other database systems.)
.PP
When \fBVALUES\fR is used in \fBINSERT\fR, the values are all
automatically coerced to the data type of the corresponding destination
column. When it's used in other contexts, it might be necessary to specify
the correct data type. If the entries are all quoted literal constants,
coercing the first is sufficient to determine the assumed type for all:
.sp
.nf
SELECT * FROM machines
WHERE ip_address IN (VALUES('192.168.0.1'::inet), ('192.168.0.10'), ('192.168.1.43'));
.sp
.fi
.sp
.RS
.B "Tip:"
For simple IN tests, it's better to rely on the
list-of-scalars form of IN than to write a \fBVALUES\fR
query as shown above. The list of scalars method requires less writing
and is often more efficient.
.RE
.sp
.SH "COMPATIBILITY"
.PP
\fBVALUES\fR conforms to the SQL standard, except that
LIMIT and OFFSET are
PostgreSQL extensions.
.SH "SEE ALSO"
INSERT [\fBinsert\fR(l)], SELECT [\fBselect\fR(l)]
