/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Id: kanji.h,v 1.1.1.1 2000/03/04 05:37:56 rug Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

typedef struct character {
    char type;
    unsigned char c1, c2;
} Character;

/* character set */
#define ASCII    0
#define JISROMAN 1
#define KATAKANA 2
#define GRAPHIC  3
#define JIS78    4
#define JIS83    5
#define OTHER  127

/* assign */
#define SETG0  0
#define SETG1  1
#define SETG2  2
#define SETG3  3
#define SJKANA 4

/* terminal type */
#define UNKNOWN 0
#define OLDJIS  1
#define NEWJIS  2
#define DEC     3
#define EUC     4
#define MSKANJI 5

extern int input_term_type;

extern int input_GL;
extern int input_GR;
extern int input_G[5];

extern int output_term_type;

extern int output_GL;
extern int output_GR;
extern int output_G[5];

#define HEPBURN 0
#define KUNREI  1

extern int romaji_type;

extern int prohibited_zenkaku;
extern int prohibited_katakana;
extern int prohibited_graphic;

extern int bunkatu_mode;
extern int heiki_mode;
extern int furigana_mode;
