/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Id: jj2.h,v 1.1.1.1 2000/03/04 05:37:56 rug Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#define MAXJISYO 10

/* The internal dictionary format of KAKASI. */

struct kanji_yomi *jisyo_table[0x80][0x80]; /* hush table */
int kanwa_load[0x80][0x80];                 /* Is kanwadict put? */

struct kanji_yomi {
    struct kanji_yomi *next;
    int  length;
    unsigned char *kanji;
    unsigned char *yomi;
    unsigned char tail;
};

/* The dictionary format of kanwadict. */

   /* A part at the head of kakasi, load does only this at the time of the start. */
struct {
    int index; /* It points at the offset in the file. */
    int entry; /* The registered number of words. */
} kanwa[0x60][0x60]; /* ujis Only 0xa0 is shift to code. */

   /* The part of the body.
unsigned char tail;         If there is an okurigana, if it is not here, '0'.
unsigned char kanji_length; The entire length of the part of the kanji, a character at the head, '\0' of the end aren't contained.
unsigned char kanji[];      The body of the kanji.
unsigned char yomi_length;  The entire length of the part of the reading, '\0' of the end aren't contained.
unsigned char yomi[];       The body of the reading.
*/
