<?php
/*
 * $Horde: imp/status.php,v 2.6.2.11 2003/01/03 12:48:17 jan Exp $
 *
 * Copyright 1999-2003 Charles J. Hagenbuch <chuck@horde.org>
 * Copyright 1999-2003 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

if (isset($imp['stream'])) {
    $alerts = imap_alerts();
    if (is_array($alerts)) {
        foreach ($alerts as $alert) {
            Horde::raiseMessage($alert, HORDE_MESSAGE);
        }
    }
}

/* Servicable kludge to make Maintenance notification display work across
   requests. */
if (isset($_SESSION['logintasks'])) {
    foreach ($_SESSION['logintasks'] as $value) {
        $hordeMessageStack[] = $value;
    }
    $_SESSION['logintasks'] = null;
}

if (isset($hordeMessageStack) && is_array($hordeMessageStack)) {
    echo '<table width="100%" border="0" cellpadding="0" cellspacing="0"><tr><td class="item"><table border="0" cellspacing="2" cellpadding="2" width="100%">';
    foreach ($hordeMessageStack as $message) {
        switch ($message['type']) {
        case HORDE_ERROR:
            echo '<tr><td class="control">' . Horde::img('alerts/error.gif', 'alt="' . _("Error") . '" class="control"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . htmlspecialchars($message['message']) . '</b></td></tr>';
            break;

        case HORDE_SUCCESS:
            echo '<tr><td class="control">' . Horde::img('alerts/success.gif', 'alt="' . _("Success") . '" class="control"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . htmlspecialchars($message['message']) . '</b></td></tr>';
            break;

        case HORDE_WARNING:
            echo '<tr><td class="control">' . Horde::img('alerts/warning.gif', 'alt="' . _("Warning") . '" class="control"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . htmlspecialchars($message['message']) . '</b></td></tr>';
            break;

        case HORDE_MESSAGE:
        default:
            echo '<tr><td class="control">' . Horde::img('alerts/message.gif', 'alt="' . _("Message") . '" class="control"', $registry->getGraphicsPath("horde")) . '&nbsp;&nbsp;<b>' . htmlspecialchars($message['message']) . '</b></td></tr>';
            break;

        }
    }
    echo '</table></td></tr></table><br />';
}
?>
