<?php
/**
 * The Horde_Cipher_BlockMode_ofb64:: This class implements the
 * Horde_Cipher_BlockMode using a 64 bit output feedback. This can
 * used to encypt any length string and the encrypted version will be
 * the same length.
 *
 * $Horde: horde/lib/Cipher/BlockMode/ofb64.php,v 1.2.2.3 2003/01/03 13:23:25 jan Exp $
 *
 * Copyright 2002-2003 Mike Cochrane <mike@graftonhall.co.nz>
 *
 * See the enclosed file COPYING for license information (LGPL). If you
 * did not receive this file, see http://www.fsf.org/copyleft/lgpl.html.
 *
 * @author  Mike Cochrane <mike@graftonhall.co.nz>
 * @version $Revision: 1.1.1.1 $
 * @since   Horde 2.2
 * @package horde.cipher
 */
class Horde_Cipher_BlockMode_ofb64 extends Horde_Cipher_BlockMode {

    function encrypt(&$cipher, $plaintext)
    {
        $encrypted = '';

        $n = 0;
        for ($j = 0; $j < strlen($plaintext); $j++) {
            if ($n == 0) {
                $this->_iv = $cipher->encryptBlock($this->_iv);
            }

            $c = substr($plaintext, $j, 1) ^ substr($this->_iv, $n, 1);
            $encrypted .= $c;

            $n = (++$n) & 0x07;
        }

        return $encrypted;
    }

    function decrypt(&$cipher, $ciphertext)
    {
        $decrypted = '';

        $n = 0;
        for ($j = 0; $j < strlen($ciphertext); $j++) {
            if ($n == 0) {
                $this->_iv = $cipher->encryptBlock($this->_iv);
            }

            $c = substr($ciphertext, $j, 1) ^ substr($this->_iv, $n, 1);
            $decrypted .= $c;

            $n = (++$n) & 0x07;
        }

        return $decrypted;
    }

}
