<?php
// ------------------------------------------------------------
// 
// wsjt-x ADIF log rewite to jtlinker
// 
// T.Kabu/JS1FVG    https://js1fvg.kabu.direct/
// 
// ------------------------------------------------------------
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adifrewrite_end($signo)
{
    global $ADIFREWRITED_CONF;
    
    // シグナル別に処理
    switch ($signo)
    {
    // SIGINTなら
    case SIGINT:
    // SIGTERMなら
    case SIGTERM:
        // 終了要求の場合のログ出力とかの終了処理は、coreのメインループを抜けた後ですることにした
        // 終了要求(=1)を設定
        $ADIFREWRITED_CONF['stop'] = 1;
        break;
    // SIGHUPなら
    case SIGHUP:
        // 再読み込みする旨を出力
        $ADIFREWRITED_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: RELOAD"."\n";
        // ログに出力する
        log_write($ADIFREWRITED_CONF);
        // ログファイルポインタが開かれているなら
        if (isset($ADIFREWRITED_CONF['log_p']))
        {
            // ログファイルを閉じる
            fclose($ADIFREWRITED_CONF['log_p']);
        }
        // 再読み込み要求(=1)を設定
        $ADIFREWRITED_CONF['reload'] = 1;
        break;
    }
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adifrewrite_close($TARGET_CONF)
{
    // inotifyによる監視をしていたら
    if (isset($TARGET_CONF['target_inotify']) && is_resource($TARGET_CONF['target_inotify']))
    {
        // inotifyによる監視を削除
        inotify_rm_watch($TARGET_CONF['target_inotify'], $TARGET_CONF['target_watch']);
        fclose($TARGET_CONF['target_inotify']);
    }
    
    // 対象ファイルが開いていたら
    if (isset($TARGET_CONF['target_fp']) && is_resource($TARGET_CONF['target_fp']))
    {
        // 対象ファイルを閉じる
        fclose($TARGET_CONF['target_fp']);
    }
    
    // パラメータを戻す
    return $TARGET_CONF;
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adif_decode($TARGET_DATA)
{
    // 対象データに<EOR>が無ければ
    if (stristr($TARGET_DATA, '<EOR>') == FALSE)
    {
        // 0を返して戻る
        return 0;
    }
    
    // ADIFデータを初期化
    $TARGET_ADIF = array();
    
    // 各タグごとに分割する
    $TARGET_ARRAY = preg_split('/</', $TARGET_DATA);
    
    foreach($TARGET_ARRAY as $TARGET_TAG)
    {
        // $TARGET_TAGに「>」が無ければ飛ばす
        if (stristr($TARGET_TAG, '>') == FALSE)
        {
            // 次
            continue;
        }
        // $TARGET_TAGに「eor>」があったら抜ける
        if (stristr($TARGET_TAG, 'eor>') == true)
        {
            // 次
            break;
        }
        // タグの内容を解析する
        $TARGET_PARAM = preg_split('/(.*):(.*)>/', trim($TARGET_TAG), -1, PREG_SPLIT_DELIM_CAPTURE);
        // タグの解析結果が配列型であり、4つの要素があるなら
        if (is_array($TARGET_PARAM) && count($TARGET_PARAM) == 4)
        {
            // 解析結果の要素1がタグ名、要素3が実際の値、となるので、これを設定
            $TARGET_ADIF[ $TARGET_PARAM[1] ] = $TARGET_PARAM[3];
        }
        else
        {
            // ありえないんだけど、タグの実際の値の中に「<」とか「>」があったらどうするんだろ？
        }
    }
    return $TARGET_ADIF;
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adif_modify($TARGET_DATA, $TARGET_CONF)
{
    // 対象データが配列でなければ
    if (is_array($TARGET_DATA) == FALSE)
    {
        // 0を返して戻る
        return FALSE;
    }
    
    // 「  Rcvd: 」を「 Rcvd:」にする
    // 「 Sent: 」を「Sent:」にする
    // 半角スペースが連続しているなら、一つにする
    $SEARCH_ARRAY = array('  Rcvd: ', ' Sent: ', '  ');
    $REPLACE_ARRAY = array(' Rcvd:', 'Sent:', ' ');
    $TARGET_DATA = str_replace($SEARCH_ARRAY, $REPLACE_ARRAY, $TARGET_DATA);
    
    // QSLMSGフォーマットが定義されているなら
    if (isset($TARGET_CONF['qslmsg_format']))
    {
        // QSLMSGタグの文字列を初期化
        $TARGET_DATA['qslmsg'] = "";
        // フォーマットをスペースごとにADIFタグに分割して
        $FORMAT_TAG = preg_split('/ +/', $TARGET_CONF['qslmsg_format']);
        // それぞれのタグのデータを、QSLMSGタグのデータとして連結していく
        foreach($FORMAT_TAG as $TARGET_TAG)
        {
            // $TARGET_TAGが設定されていないか、そのタグのの文字列長が0なら
            if (isset($TARGET_DATA[$TARGET_TAG]) == FALSE || mb_strlen($TARGET_DATA[$TARGET_TAG]) <= 0)
            {
                // 次
                continue;
            }
            // QSLMSGタグのデータに追加していく
            $TARGET_DATA['qslmsg'] .= $TARGET_DATA[$TARGET_TAG].' ';
        }
        // 最後の' 'を取り除く
        $TARGET_DATA['qslmsg'] = rtrim($TARGET_DATA['qslmsg']);
        // commentタグもqslmsgタグと同じにする
        $TARGET_DATA['comment'] = $TARGET_DATA['qslmsg'];
    }
    
    return $TARGET_DATA;
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adif_encode($TARGET_DATA)
{
    // 対象データが配列でなければ
    if (is_array($TARGET_DATA) == FALSE)
    {
        // 0を返して戻る
        return FALSE;
    }
    
    // ADIFデータを初期化
    $TARGET_ADIF = '';
    // タグごとのADIFデータのフォーマットを設定
    $ADIF_FORMAT = '<%s:%0d>%s ';
    
    // ADIFデータを生成する
    foreach($TARGET_DATA as $TARGET_TAG => $TARGET_VALUE)
    {
        // $TARGET_TAGの文字列長が0なら
        if (mb_strlen($TARGET_TAG) <= 0)
        {
            // 次
            continue;
        }
        // $TARGET_VALUEの長さを取得する
        $TARGET_LEN = mb_strlen($TARGET_VALUE);
        // 長さが0でも出力した方がいいのかな？
        $TARGET_ADIF .= sprintf($ADIF_FORMAT, $TARGET_TAG, $TARGET_LEN, $TARGET_VALUE);
    }
    // レコードの終了を追加する
    $TARGET_ADIF .= '<eor>';
    
    return $TARGET_ADIF;
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adifrewrite_loop($TARGET_CONF)
{
    // ログデータ初期化
    $LOGDATA = '';
    
    // イベントの有無が読める限り
    while (($EVENTS = inotify_read($TARGET_CONF['target_inotify'])) !== false)
    {
        // イベント発生
        foreach($EVENTS as $EVENT)
        {
            // ファイルが新しくなったなら
            if ($EVENT['mask'] & IN_MOVE_SELF)
            {
                // 対象ファイルが切り詰められた？旨のメッセージを設定
                $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."INFO target_adif was rotate? (".$TARGET_CONF['target_adif'].")"."\n";
                // ログに出力する
                log_write($TARGET_CONF);
                // ログデータ解析処理を抜ける
                return $TARGET_CONF;
            }
            // ファイルに変更があったのなら
            if (($EVENT['mask'] & IN_MODIFY))
            {
                // 対象ログから読み込み
                $LOGDATA .= fread($TARGET_CONF['target_fp'], 8192);
                
                // 読み込んだログデータを一行ごとのログ配列に格納
                $LOGARRAY = explode("\n", $LOGDATA);
                
                // ログ配列から一行ずつ処理
                foreach($LOGARRAY as $LOGSTR)
                {
                    // データが無いなら
                    if ($LOGSTR == '')
                    {
                        // 飛ばして次の行に行く
                        continue;
                    }
                    
                    // 対象文字列かどうかを検査
                    // ここでADIFフォーマットを解析というか、書き換えて、JTLinkerが監視しているADIFファイルに出力する
                    // 対象ファイルが切り詰められた？旨のメッセージを設定
                    $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ADIF: ".$LOGSTR."\n";
                    // ログに出力する
                    log_write($TARGET_CONF);
                    
                    // ADIFデコード(配列に変換)
                    $ADIF_DATA = adif_decode($LOGSTR);
                    // デコード結果が0なら
                    if (is_array($ADIF_DATA) == FALSE)
                    {
                    }
                    // きちんとデコードできたなら
                    else
                    {
                        // 追加QSLMSGが定義されているなら
                        if (isset($TARGET_CONF['add_qslmsg']))
                        {
                            $ADIF_DATA['add_qslmsg'] = $TARGET_CONF['add_qslmsg'];
                        }
                        // ADIFデータを編集する
                        $ADIF_MODIFY = adif_modify($ADIF_DATA, $TARGET_CONF);
                        
                        // ADIFデータをADIFフォーマットに変換する
                        $ADIF_LOGDATA = adif_encode($ADIF_MODIFY);
                        
                        // ADIFデータをログ(とバックアップ)に出力する
////                        adif_output($ADIF_LOGDATA);
                        $ADIF_FILE = fopen($TARGET_CONF['output_adif'], "a+");
                        // ファイルが開けたなら
                        if ($ADIF_FILE)
                        {
                            fwrite($ADIF_FILE, $ADIF_LOGDATA."\n");
                            fclose($ADIF_FILE);
                        }
                        else
                        {
                            $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."Cannot open ".$TARGET_CONF['output_adif']."\n";
                            // ログに出力する
                            log_write($TARGET_CONF);
                        }

                        $ADIF_BACK = fopen($TARGET_CONF['backup_adif'], "a+");
                        // ファイルが開けたなら
                        if ($ADIF_BACK)
                        {
                            fwrite($ADIF_BACK, $LOGSTR."\n");
                            fclose($ADIF_BACK);
                        }
                        else
                        {
                            $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."Cannot open ".$TARGET_CONF['backup_adif']."\n";
                            // ログに出力する
                            log_write($TARGET_CONF);
                        }
                    }
                }
                // 行の途中かもしれないのでログデータに戻す
                $LOGDATA = $LOGSTR;
            }
        }
    }
    // パラメータを戻す
    return $TARGET_CONF;
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function adifrewrite_init($TARGET_CONF)
{
    // ログメッセージを初期化
    $TARGET_CONF['log_msg'] = '';
    
    // --------------------------------
    
    // 対象ログがないなら
    if (!is_file($TARGET_CONF['target_adif']))
    {
        // エラーメッセージに、対象ログが開けない旨を設定
        $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Cannot find target_adif. (".$TARGET_CONF['target_adif'].")"."\n";
        // ログに出力する
        log_write($TARGET_CONF);
        // 100msくらいのウェイトを置く
        usleep(100000);
        // パラメータを戻す
        return $TARGET_CONF;
    }
    // 対象ログが読めない状態なら(ログローテートした可能性あり)
    if (!is_readable($TARGET_CONF['target_adif']))
    {
        // エラーメッセージに、対象ログが読めない旨を設定
        $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Cannot read target_adif. (".$TARGET_CONF['target_adif'].")"."\n";
        // ログに出力する
        log_write($TARGET_CONF);
        // 100msくらいのウェイトを置く
        usleep(100000);
        // パラメータを戻す
        return $TARGET_CONF;
    }
    // 対象ログを開く
    $TARGET_CONF['target_fp'] = fopen($TARGET_CONF['target_adif'], "r");
    // 対象ログが開けなかったら
    if ($TARGET_CONF['target_fp'] == FALSE)
    {
        // エラーメッセージに、対象ログが開けない旨を設定
        $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Cannot open target_adif. (".$TARGET_CONF['target_adif'].")"."\n";
        // ログに出力する
        log_write($TARGET_CONF);
        // パラメータを戻す
        return $TARGET_CONF;
    }
    
    // 対象ログの最後にシーク
    $RESULT = fseek($TARGET_CONF['target_fp'], 0, SEEK_END);
    // 対象ログの最後にシークできなかったら
    if ($RESULT == -1)
    {
        // エラーメッセージに、対象ログの最後にシークできない旨を設定
        $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Cannot seek target_adif. (".$TARGET_CONF['target_adif'].")"."\n";
        // ログに出力する
        log_write($TARGET_CONF);
        // パラメータを戻す
        return $TARGET_CONF;
    }
    
    // inotifyモジュール初期化
    $TARGET_CONF['target_inotify'] = inotify_init();
    // 失敗したなら
    if ($TARGET_CONF['target_inotify'] === false)
    {
        // エラーメッセージに、対象ログの最後にシークできない旨を設定
        $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Failed to obtain an inotify instance!?"."\n";
        // ログに出力する
        log_write($TARGET_CONF);
        // パラメータを戻す
        return $TARGET_CONF;
    }
    else
    {
        // 指定ファイルに変化があったらイベントを起こすように設定(IN_MODIFYは追記があったとき、IN_MOVE_SELFはlogrotateで切り詰めがあったとき)
        $TARGET_CONF['target_watch'] = inotify_add_watch($TARGET_CONF['target_inotify'], $TARGET_CONF['target_adif'], IN_MODIFY | IN_MOVE_SELF);
        
        // 設定が失敗したら
        if ($TARGET_CONF['target_watch'] === false)
        {
            // エラーメッセージに、イベントを起こすように設定できない旨を設定
            $TARGET_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: "."ERROR Cannot watch target_adif. (".$TARGET_CONF['target_adif'].")"."\n";
            // ログに出力する
            log_write($TARGET_CONF);
            // パラメータを戻す
            return $TARGET_CONF;
        }
        // inotify_read()でノンブロッキング処理とする
        $read = array($TARGET_CONF['target_inotify']);
        $write = null;
        $except = null;
        stream_select($read,$write,$except,0);
        stream_set_blocking($TARGET_CONF['target_inotify'], 0);
    }
    // パラメータを戻す
    return $TARGET_CONF;
}
?>
