<?php
// ------------------------------------------------------------
// 
// wsjt-x ADIF log rewite to jtlinker
// 
// T.Kabu/JS1FVG    https://js1fvg.kabu.direct/
// 
// ------------------------------------------------------------
?>
<?php
// ----------------------------------------------------------------------
// Init Routine
// ----------------------------------------------------------------------
// 環境変数などを設定する
// 時刻オフセット初期化
$TIME_OFFSET = 0;

// Cannot find timezone
if (ini_get('date.timezone') == FALSE)
{
    // Set system timezone to UTC
    date_default_timezone_set(@date_default_timezone_get());
    
    // Get system time
    exec("/bin/date +'%Y/%m/%d %H:%M:%S'", $EXEC_RESULT, $EXEC_RETVAL);
    // Complete
    if ($EXEC_RETVAL == 0)
    {
        // Get difference between the values of system time and PHP time
        $TIME_OFFSET = strtotime($EXEC_RESULT[0]) - time();
        
        // Set offset time if it is more than 60sec
        if ($TIME_OFFSET && ($TIME_OFFSET % 60) == 0)
        {
        }
        else if ($TIME_OFFSET > 0)
        {
            // Set time offset in minutes
            $TIME_OFFSET += (60 - ($TIME_OFFSET % 60));
        }
        else if ($TIME_OFFSET < 0)
        {
            // Set time offset in minutes
            $TIME_OFFSET -= ($TIME_OFFSET % 60);
        }
    }
}

// 内部文字コード
mb_internal_encoding('UTF-8');

// 出力文字コード
mb_http_output('UTF-8');

// メイン設定ファイル名
$ADIFREWRITED_CONF['main_conf'] = '/etc/adifrewrited.conf';
// PIDファイル名
$ADIFREWRITED_CONF['pid_file'] = '/var/run/adifrewrited.pid';
// LOGファイル名
$ADIFREWRITED_CONF['log_file'] = '/var/log/adifrewrited.log';


?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function local_time()
{
    global $TIME_OFFSET;
    return(time() + $TIME_OFFSET);
}
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
function log_write($ADIFREWRITED_CONF)
{
    // ログファイルの指定がないなら
    if (!isset($ADIFREWRITED_CONF['log_file']) || !is_file($ADIFREWRITED_CONF['log_file']))
    {
        print $ADIFREWRITED_CONF['log_msg'];
        return;
    }
    
    // ログファイルポインタが開かれていないなら
    if (!isset($ADIFREWRITED_CONF['log_p']))
    {
        $ADIFREWRITED_CONF['log_p'] = fopen($ADIFREWRITED_CONF['log_file'], 'a');
    }
    // ログファイルポインタが開かれているなら
    if (is_resource($ADIFREWRITED_CONF['log_p']))
    {
        // ログファイルを排他的ロック
        while(!flock($ADIFREWRITED_CONF['log_p'], LOCK_EX));
        // ログファイルの一番最後までシーク
        fseek($ADIFREWRITED_CONF['log_p'], 0, SEEK_END);
        // ログファイルに書き出し
        fprintf($ADIFREWRITED_CONF['log_p'], $ADIFREWRITED_CONF['log_msg']);
        // ログファイルをアンロック
        flock($ADIFREWRITED_CONF['log_p'], LOCK_UN);
    }
    else
    {
        print $ADIFREWRITED_CONF['log_msg'];
    }
    
}
?>
<?php
// ----------------------------------------------------------------------
// Read Configration
// ----------------------------------------------------------------------
function get_config()
{
    global $ADIFREWRITED_CONF;
    
    // メイン設定ファイルがあるなら
    if (is_file($ADIFREWRITED_CONF['main_conf']))
    {
        // メイン設定ファイルを読み込んで変数展開する
        $ADIFREWRITED_CONF = array_merge($ADIFREWRITED_CONF, parse_ini_file($ADIFREWRITED_CONF['main_conf'], FALSE, INI_SCANNER_NORMAL));
    }
    // 無ければ、
    else
    {
        print $ADIFREWRITED_CONF['main_conf']." not found!?"."\n";
        // FALSEを返す
        return FALSE;
    }
    // 読み込めなかったら
    if ($ADIFREWRITED_CONF === FALSE)
    {
        print "Cannot loaded main config file!?"."\n";
        // FALSEを返す
        return FALSE;
    }
    
    // TRUEを返す
    return TRUE;
}
?>
<?php
// ----------------------------------------------------------------------
// Check inotify module
// ----------------------------------------------------------------------
// inotifyモジュールがあるか確認
if (!extension_loaded('inotify'))
{
    print "inotify extension not loaded!?"."\n";
    exit -1;
}
?>
<?php
// ----------------------------------------------------------------------
// Read Configration
// ----------------------------------------------------------------------
// 各種設定が読めなかったら
if (get_config() == FALSE)
{
    // 終わり
    exit -1;
}
?>
<?php
// ----------------------------------------------------------------------
// Get init or systemd
// ----------------------------------------------------------------------
// システムがinit管理かsystemd管理かを取得
$ADIFREWRITED_CONF['system_pid0'] = file_get_contents('/proc/1/comm');
$ADIFREWRITED_CONF['system_pid0'] = rtrim($ADIFREWRITED_CONF['system_pid0']);
?>
