<?php
// ------------------------------------------------------------
// 
// wsjt-x ADIF log rewite to jtlinker
// 
// T.Kabu/JS1FVG    https://js1fvg.kabu.direct/
// 
// ------------------------------------------------------------
?>
<?php
// ----------------------------------------------------------------------
// Sub Routine
// ----------------------------------------------------------------------
require(__DIR__."/adifrewrited_sub.php");
?>
<?php
// ----------------------------------------------------------------------
// Check Other process
// ----------------------------------------------------------------------
// PIDファイルがあるなら
if (is_file($ADIFREWRITED_CONF['pid_file']))
{
    // エラーメッセージに、別のプロセスがある旨を設定
    $ERR_MSG = 'Found other process : '.$ADIFREWRITED_CONF['pid_file'].'!?';
    // メッセージを表示
    print "\n".'adifrewrited ... '.$ERR_MSG."\n\n";
    // 終わり
    exit -1;
}

// ログファイルの指定があるなら
if (isset($ADIFREWRITED_CONF['log_file']))
{
    // ファイルをtouch(無ければ新規作成)
    touch($ADIFREWRITED_CONF['log_file']);
    // ファイルのパーミッションを700に設定
    chmod($ADIFREWRITED_CONF['log_file'], 0600);
}

// PIDファイルを新規に開く
$PID_FILE = fopen($ADIFREWRITED_CONF['pid_file'], "a");
// PIDファイルにプロセスIDを出力(改行しない)
fputs($PID_FILE, getmypid());
// PIDファイルを閉じる
fclose($PID_FILE);
?>
<?php
// ----------------------------------------------------------------------
// Main
// ----------------------------------------------------------------------
// 親プロセスの開始完了を出力
$ADIFREWRITED_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: START under ".$ADIFREWRITED_CONF['system_pid0'];

// QSLMSGフォーマットが設定されているなら
if (isset($ADIFREWRITED_CONF['qslmsg_format']))
{
    $ADIFREWRITED_CONF['log_msg'] .= ', QSLMSG_FORMAT="'.$ADIFREWRITED_CONF['qslmsg_format'].'"';
}
// 追加のQSLMSGメッセージが設定されているなら
if (isset($ADIFREWRITED_CONF['add_qslmsg']))
{
    $ADIFREWRITED_CONF['log_msg'] .= ', ADD_QSLMSG="'.$ADIFREWRITED_CONF['add_qslmsg'].'"';
}
$ADIFREWRITED_CONF['log_msg'] .= "\n";
// ログに出力する
log_write($ADIFREWRITED_CONF);

do // SIGHUPに対応したループ構造にしている
{
    // 終了要求を初期化
    $ADIFREWRITED_CONF['stop'] = 0;
    // 再読み込み要求を初期化
    $ADIFREWRITED_CONF['reload'] = 0;
    
    // シグナルハンドラを設定します(親プロセスだけ)
    declare(ticks = 1);
    pcntl_signal(SIGINT,  "adifrewrite_end");
    pcntl_signal(SIGTERM, "adifrewrite_end");
    pcntl_signal(SIGHUP,  "adifrewrite_end");    // SIGHUPの場合には、再読み込み要求($ADIFREWRITED_CONF['reload'])が1になる
    
    // 対象ADIFファイルの監視初期化
    $ADIFREWRITED_CONF = adifrewrite_init($ADIFREWRITED_CONF);
    // 初期化に失敗したら
    if (strlen($ADIFREWRITED_CONF['log_msg']))
    {
        // loop_mode!=1なら、ログがない場合にはここで終わり
        if ($ADIFREWRITED_CONF['loop_mode'] != 1)
        {
            // 終わり
            adifrewrite_end(SIGTERM);
        }
    }
    
    // 終了要求(=1)か、再読み込み要求(=1)が来るまで無限ループ(親プロセスがSIGHUPを受けると1)
    while($ADIFREWRITED_CONF['stop'] == 0 && $ADIFREWRITED_CONF['reload'] == 0)
    {
        // 対象ADIFファイルの監視開始
        $ADIFREWRITED_CONF = adifrewrite_loop($ADIFREWRITED_CONF);
    }
    
    // シグナルハンドラをデフォルトに戻します(親プロセスだけ)
    pcntl_signal(SIGHUP,  SIG_DFL);
    pcntl_signal(SIGTERM, SIG_DFL);
    pcntl_signal(SIGINT,  SIG_DFL);
    
    // 各種設定を再取得できなかったら
    if (get_config() == FALSE)
    {
        $ADIFREWRITED_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: CANNOT RELOAD?!"."\n";
        // ログに出力する
        log_write($ADIFREWRITED_CONF);
        // 終わり
        adifrewrite_end(SIGTERM);
    }
} while($ADIFREWRITED_CONF['stop'] == 0);
?>
<?php
// ----------------------------------------------------------------------
// Ending process
// ----------------------------------------------------------------------
// 終了する旨を出力
$ADIFREWRITED_CONF['log_msg'] = date("Y-m-d H:i:s", local_time())." adifrewrite[".getmypid()."]: END"."\n";
// ログに出力する
log_write($ADIFREWRITED_CONF);
// ログファイルポインタが開かれているなら
if (isset($ADIFREWRITED_CONF['log_p']))
{
    // ログファイルを閉じる
    fclose($ADIFREWRITED_CONF['log_p']);
}
// PIDファイルがあれば
if (is_file($ADIFREWRITED_CONF['pid_file']))
{
    // PIDファイルを削除する
    unlink($ADIFREWRITED_CONF['pid_file']);
}
?>
