#!c:/Python26/python.exe  
# -*- coding: utf-8 -*-   
import sys
import os
import subprocess  # Python 2.4以上が必要
import urllib
import urllib2
import re

debug=0

#---- debug prints
def dbg0 (*arg):
	str=''.join(arg)
	print >>sys.stderr, str

def dbg (*arg):
	global debug
	if(debug>0):
		dbg0(*arg)

def error (*arg):
	header="[ERROR]:"
	str=header+''.join(arg)
	dbg0(str)

#---- read url contents
def url_read (url):
	dbg("url_read: Start, url=%s" % (url))
	rc=0
	try:
		fi= urllib.urlopen(url)
		out=fi.read()
	except IOError,e:
		error("url_read: IOError, e=%r" % (e))
		rc=-1
	except Exception,e:
		error("url_read: Unknown Exception, e=%r" % (e))
		rc=-2
	
	dbg("url_read: End")
	return(rc,out)
	
def get_kwd(url,type):
	(rc,out)=url_read(url)
	dbg0("url_read rc=%d, url=%s" % (rc,url))
	dbg0("contents=%s" % out)
	
	#--- dump result
	if(False):
		fo=open("out_wk.html","w+b")
		fo.write(out)
		fo.close()
	
	#-----------------------------------------------------------------------------------------
	#--- newest ranking
	#	<li>
	#		<span class="rankingGold">1</span>
	#		<a href="https://rdsig.yahoo.co.jp/RV=1/RU.....Q--;_ylt=A2RhpwfwvPVYH3cASCV2xv17">蛸壺屋</a>
	#	</li>
	#--- daily ranking
	#	<li>
	#		<span class="rankingGold">1</span>
	#		<span class="score">1457783点</span>
	#		<a 		href="http://rdsig.yahoo.co.jp/RV=1/RU......PVVURi04JnJrZj0x">細山貴嶺</a>
	#		<p class="description">タレント。慶應義塾大学の卒業に合わせ芸能界を引退することを発表</p>
	#	</li>
	#--- weekly
	#	<li>
	#		<span class="rankingSilver">2</span>
	#		<span class="trend up">up</span>
	#		<a href="http://rdsig.yaho................REAZhyKaux7">永野芽郁</a>
	#	</li>
	#--- monthly
	#	<li>
	#		<span class="ranking">4</span>
	#		<span class="trend stay">stay</span>
	#		<a href="http://rdsig.yahoo.co.jp/RV=1/RU=aHR0cDoH9FYD0IA9itkdu57">楽天</a>
	#	</li>
	#-----------------------------------------------------------------------------------------
	
	#--- regular expression for exruct keyword from result
	pat=r"<span class=.+score.+>.+</span>.+<a +href=.+>(.+)</a>"
	
	pats=[
		r"<span class=\"ranking.*\">(?:.*\n)+?<a href=.*>(.*)</a>" ,
		r"<span class=\"ranking.*\">(?:.*\n)+?<a href=.*>(.*)</a>" ,
		r"<h3><a href=.*>(.*)</a>",
		r"<a href=\"https://rdsig.*>(.*)</a>\n", 
		r"<a href=\"https://rdsig.*>(.*)</a>\n", 
		r"<a href=\"https://rdsig.*>(.*)</a>\n", 
	]
	
	rpat=re.compile(pats[type])
	kwlist=re.findall(rpat, out)
	return kwlist

if __name__ == '__main__':
	
	argv=sys.argv  # コマンドライン引数を格納したリストの取得 
	argc=len(argv) # 引数の個数
	
	if(debug>0):
		dbg0("---- Script main : Start")
		dbg0("python.exe=%s" % sys.executable)
		dbg0("arg_cnt=%d, argv=%r" % (argc,argv))
		for i in range(argc):
			print "arg[%d]=%s" % (i,argv[i])

	#------------------------------------------------------------------
	#	How Keywords
	#------------------------------------------------------------------
	fo=open(argv[1],"w+b")
	print >>fo, "Hot Keywords/"
	
	#------------------------------------------------------------------
	#	Newest Ranking
	#------------------------------------------------------------------
	print >>fo, "	Newest/"
	url="https://searchranking.yahoo.co.jp/rt_burst_ranking/"
	kwlist=get_kwd(url,1)
	print >>fo, "		急上昇ワード/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	url="https://searchranking.yahoo.co.jp/realtime_buzz/"
	kwlist=get_kwd(url,2)
	print >>fo, "		Twitter/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
	
	url="https://searchranking.yahoo.co.jp/image_buzz/"
	kwlist=get_kwd(url,3)
	print >>fo, "		画像/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	url="https://searchranking.yahoo.co.jp/video_buzz/"
	kwlist=get_kwd(url,4)
	print >>fo, "		動画/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
		
	url="https://searchranking.yahoo.co.jp/people_buzz/"
	kwlist=get_kwd(url,5)
	print >>fo, "		人物/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
		
	#------------------------------------------------------------------
	#	Daily Ranking
	#------------------------------------------------------------------
	type=1
	print >>fo, "	Daily/"
	url="http://searchranking.yahoo.co.jp/burst_ranking/"
	kwlist=get_kwd(url,0)
	print >>fo, "		急上昇ワード/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	url="http://searchranking.yahoo.co.jp/total_ranking/general/"
	kwlist=get_kwd(url,0)
	print >>fo, "		総合/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
	
	url="http://searchranking.yahoo.co.jp/total_ranking/people/"
	kwlist=get_kwd(url,0)
	print >>fo, "		人物/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	#------------------------------------------------------------------
	#	Weekly Ranking
	#------------------------------------------------------------------
	print >>fo, "	Weekly/"

	url="http://searchranking.yahoo.co.jp/total_ranking_week/general/"
	kwlist=get_kwd(url,0)
	print >>fo, "		総合/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	url="http://searchranking.yahoo.co.jp/total_ranking_week/people/"
	kwlist=get_kwd(url,0)
	print >>fo, "		人物/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
	
	#------------------------------------------------------------------
	#	Monthly Ranking
	#------------------------------------------------------------------
	print >>fo, "	Monthly/"

	url="http://searchranking.yahoo.co.jp/total_ranking_month/general/"
	kwlist=get_kwd(url,0)
	print >>fo, "		総合/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)

	url="http://searchranking.yahoo.co.jp/total_ranking_month/people/"
	kwlist=get_kwd(url,0)
	print >>fo, "		人物/"
	for kw in kwlist:
		print >>fo, "			%s" % (kw)
		
	#------------------------------------------------------------------
	
	fo.close()
	#dbg0("---- Script main : End")


