!include "MUI.nsh"
!include "FileFunc.nsh"
!include "LogicLib.nsh"

!define REG_KEY_UNINSTALL "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\PMS for REGZA"
!define REG_KEY_SOFTWARE "SOFTWARE\PMS for REGZA"

RequestExecutionLevel admin

Name "PMS for REGZA"
;OutFile "dist\pms-setup-windows-${VERSION}.exe"
OutFile "dist\PmsForRegza-setup-win-v1.69.exe"
InstallDir "$PROGRAMFILES\PMS for REGZA"

;Get install folder from registry for updates
InstallDirRegKey HKCU "${REG_KEY_SOFTWARE}" ""

SetCompressor /SOLID lzma
SetCompressorDictSize 32

!define MUI_ABORTWARNING
!define MUI_FINISHPAGE_RUN "$INSTDIR\PMS.exe"
!define MUI_WELCOMEFINISHPAGE_BITMAP "${NSISDIR}\Contrib\Graphics\Wizard\win.bmp"

!define MUI_FINISHPAGE_SHOWREADME ""
!define MUI_FINISHPAGE_SHOWREADME_NOTCHECKED
!define MUI_FINISHPAGE_SHOWREADME_TEXT "Create Desktop Shortcut"
!define MUI_FINISHPAGE_SHOWREADME_FUNCTION CreateDesktopShortcut

!insertmacro MUI_PAGE_WELCOME
!insertmacro MUI_PAGE_DIRECTORY
!insertmacro MUI_PAGE_INSTFILES
!insertmacro MUI_PAGE_FINISH
!insertmacro MUI_UNPAGE_CONFIRM
!insertmacro MUI_UNPAGE_INSTFILES
!insertmacro MUI_LANGUAGE "English"

ShowUninstDetails show

Function CreateDesktopShortcut
  CreateShortCut "$DESKTOP\PMS for REGZA.lnk" "$INSTDIR\pms.exe"
FunctionEnd


Section "Program Files"
  SetOutPath "$INSTDIR"
  SetOverwrite on
  
  ;---- copy folders (DANGER!! see NSI memo)
  File /r /x ".svn" /x "*.jar" /x "*.conf" /x "*.zip" /x "*.dll" /x "third-party" "plugins"
  File /r /x ".svn" "documentation"
  File /r /x ".svn" "renderers"
  File /r /x ".svn" "win32"

  File /r "regzamod"
  File /r "utility"
  File /r "conf.def"

  ;---- copy files
  File "PMS.exe"
  File "PMS_kick.bat"
  File "PMS_serv.bat"
  File "PMS_SJIS.bat"
  File "pms.jar"
  File "MediaInfo.dll"
  File "MediaInfo64.dll"
  File "CHANGELOG"
  File "README"
  File "LICENSE.txt"
  File "logback.xml"
  File "logback.headless.xml"
  File "icon.ico"
  File "ReadMe*.txt"
  ;File /r /x ".svn" "resources\videos\*.mpg"  ;File seems can't handle sub directories
  ;File /r /x ".svn" "videos"
  
  ;SetOutPath "$INSTDIR\resources"
  ;SetOverwrite on
  ;File /r /x ".svn" "resources\videos"
  
  ;---- copy Config files 
  ;the user may have set the installation dir
  ;as the profile dir, so we can't clobber this
  ;SetOutPath "$INSTDIR\conf"
  ;SetOverwrite off
  
  AccessControl::GrantOnFile "$INSTDIR" "(BU)" "FullAccess"
  Var /GLOBAL confdir
  ;${If} ${FileExists} $INSTDIR\conf\*
  ${If} 1 = 1    ;always 
    StrCpy $confdir $INSTDIR\conf
    ;(BU): all authentificated users (BUILTIN/Users)
    AccessControl::GrantOnFile "$INSTDIR" "(BU)" "FullAccess"
  ${Else}
	ReadENVStr $R0 ALLUSERSPROFILE
    StrCpy $confdir "$R0\PMS for REGZA\conf"
  ${EndIf}
  MessageBox MB_OK "config folder is $confdir"
  
  SetOutPath $confdir
  ;(S-1-5-32-545): same as (BU) (a numeric string SID of (BU))
  AccessControl::GrantOnFile "$confdir" "(S-1-5-32-545)" "FullAccess"
  SetOverwrite on
  File "conf.def\*" 

  ;---- Registor install folder
  WriteRegStr HKCU "${REG_KEY_SOFTWARE}" "" $INSTDIR

  ;---- Create uninstaller
  WriteUninstaller "$INSTDIR\Uninst.exe"

  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "DisplayName" "PMS for REGZA"
  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "DisplayIcon" "$INSTDIR\icon.ico"
  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "DisplayVersion" "1.69"
  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "Publisher" "PMS for REGZA"
  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "URLInfoAbout" "http://www.ps3mediaserver.org"
  WriteRegStr HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}" "UninstallString" '"$INSTDIR\uninst.exe"'

  ${GetSize} "$INSTDIR" "/S=0K" $0 $1 $2
  IntFmt $0 "0x%08X" $0
  WriteRegDWORD HKLM "${REG_KEY_UNINSTALL}" "EstimatedSize" "$0"

  WriteUnInstaller "uninst.exe"

  ;ReadENVStr $R0 ALLUSERSPROFILE
  ;SetOutPath "$R0\PMS for REGZA"
  ;AccessControl::GrantOnFile "$R0\PMS for REGZA" "(S-1-5-32-545)" "FullAccess"
  ;SetOverwrite off
  
  ;SetOutPath "$INSTDIR\conf"
  ;SetOverwrite on

  ;File "PMS.conf"
  ;File "WEB.conf"
  ;File "WEB_QS.conf"
  ;File "KwdMenu.conf"
  ;File "KwdList.conf"
  ;File "ClipList.conf"

SectionEnd

Section "Start Menu Shortcuts"
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\PMS for REGZA"
  CreateShortCut "$SMPROGRAMS\PMS for REGZA\PMS for REGZA.lnk" "$INSTDIR\PMS.exe" "" "$INSTDIR\PMS.exe" 0
  CreateShortCut "$SMPROGRAMS\PMS for REGZA\PMS for REGZA (Select Profile).lnk" "$INSTDIR\PMS.exe" "profiles" "$INSTDIR\PMS.exe" 0
  CreateShortCut "$SMPROGRAMS\PMS for REGZA\Uninstall.lnk" "$INSTDIR\uninst.exe" "" "$INSTDIR\uninst.exe" 0
SectionEnd

Section "Uninstall"
  SetShellVarContext all

  Delete /REBOOTOK "$INSTDIR\Uninst.exe"
  RMDir /R /REBOOTOK "$INSTDIR\plugins"
  RMDir /R /REBOOTOK "$INSTDIR\renderers"
  RMDir /R /REBOOTOK "$INSTDIR\resources"
  RMDir /R /REBOOTOK "$INSTDIR\documentation"
  RMDir /R /REBOOTOK "$INSTDIR\win32"
  RMDir /R /REBOOTOK "$INSTDIR\regzamod"
  RMDir /R /REBOOTOK "$INSTDIR\utility"
  RMDir /R /REBOOTOK "$INSTDIR\conf.def"
  Delete /REBOOTOK "$INSTDIR\PMS.exe"
  Delete /REBOOTOK "$INSTDIR\PMS_kick.bat"
  Delete /REBOOTOK "$INSTDIR\PMS_serv.bat"
  Delete /REBOOTOK "$INSTDIR\PMS_SJIS.bat"
  Delete /REBOOTOK "$INSTDIR\pms.jar"
  Delete /REBOOTOK "$INSTDIR\MediaInfo.dll"
  Delete /REBOOTOK "$INSTDIR\MediaInfo64.dll"
  Delete /REBOOTOK "$INSTDIR\CHANGELOG"
  
  ;Delete /REBOOTOK "$INSTDIR\WEB.conf"
  ;Delete /REBOOTOK "$INSTDIR\WEB_QS.conf"
  ;Delete /REBOOTOK "$INSTDIR\PMS.conf"
  ;Delete /REBOOTOK "$INSTDIR\KwdMenu.conf"
  ;Delete /REBOOTOK "$INSTDIR\KwdList.conf"
  ;Delete /REBOOTOK "$INSTDIR\ClipList.conf"

  Delete /REBOOTOK "$INSTDIR\README"
  Delete /REBOOTOK "$INSTDIR\ReadMe*.txt"
  Delete /REBOOTOK "$INSTDIR\LICENSE.txt"
  Delete /REBOOTOK "$INSTDIR\debug.log"
  Delete /REBOOTOK "$INSTDIR\logback.xml"
  Delete /REBOOTOK "$INSTDIR\logback.headless.xml"
  Delete /REBOOTOK "$INSTDIR\icon.ico"
  RMDir  /REBOOTOK "$INSTDIR"

  Delete /REBOOTOK "$DESKTOP\PMS for REGZA.lnk"
  RMDir  /REBOOTOK "$SMPROGRAMS\PMS for REGZA"
  Delete /REBOOTOK "$SMPROGRAMS\PMS for REGZA\PMS for REGZA.lnk"
  Delete /REBOOTOK "$SMPROGRAMS\PMS for REGZA\PMS for REGZA (Select Profile).lnk"
  Delete /REBOOTOK "$SMPROGRAMS\PMS for REGZA\Uninstall.lnk"

  DeleteRegKey HKEY_LOCAL_MACHINE "${REG_KEY_UNINSTALL}"
  DeleteRegKey HKCU "${REG_KEY_SOFTWARE}"

  nsSCM::Stop "PMS for REGZA"
  nsSCM::Remove "PMS for REGZA"
SectionEnd
