package net.pms.util;
import java.util.Arrays;
import java.io.UnsupportedEncodingException;

public class StringUtil {
	/**Appends "&lt;<u>tag</u> " to the StringBuilder. This is a typical HTML/DIDL/XML tag opening.
	 * @param sb String to append the tag beginning to.
	 * @param tag String that represents the tag
	 */
	public static void openTag(StringBuilder sb, String tag) {
		sb.append("&lt;");
		sb.append(tag);
	}

	/**Appends the closing symbol &gt; to the StringBuilder. This is a typical HTML/DIDL/XML tag closing.
	 * @param sb String to append the ending character of a tag.
	 */
	public static void endTag(StringBuilder sb) {
		sb.append("&gt;");
	}

	/**Appends "&lt;/<u>tag</u>&gt;" to the StringBuilder. This is a typical closing HTML/DIDL/XML tag.
	 * @param sb
	 * @param tag
	 */
	public static void closeTag(StringBuilder sb, String tag) {
		sb.append("&lt;/");
		sb.append(tag);
		sb.append("&gt;");
	}

	public static void addAttribute(StringBuilder sb, String attribute, Object value) {
		sb.append(" ");
		sb.append(attribute);
		sb.append("=\"");
		sb.append(value);
		sb.append("\"");
	}

	public static void addXMLTagAndAttribute(StringBuilder sb, String tag, Object value) {
		sb.append("&lt;");
		sb.append(tag);
		sb.append("&gt;");
		sb.append(value);
		sb.append("&lt;/");
		sb.append(tag);
		sb.append("&gt;");
	}

	/**Does basic transformations between characters and their HTML representation with ampersands.
	 * @param s String to be encoded
	 * @return Encoded String
	 */
	public static String encodeXML(String s) {
		if(s==null) return "";  //regzamod
		s = s.replace("&", "&amp;");
		s = s.replace("<", "&lt;");
		s = s.replace(">", "&gt;");
		s = s.replace("\"", "&quot;");
		s = s.replace("'", "&apos;");
		s = s.replace("&", "&amp;");

		return s;
	}

	/**Converts an URL string to it more canonical form
	 * @param url String to be converted
	 * @return Converted String.
	 */
	public static String convertURLToFileName(String url) {
		url = url.replace('/', '\u00b5');
		url = url.replace('\\', '\u00b5');
		url = url.replace(':', '\u00b5');
		url = url.replace('?', '\u00b5');
		url = url.replace('*', '\u00b5');
		url = url.replace('|', '\u00b5');
		url = url.replace('<', '\u00b5');
		url = url.replace('>', '\u00b5');
		return url;
	}
	
	public static String convertNameToFileName(String url) {	//regzamod, add
		url = url.replace('"', '\'');
		url = url.replace('/', '-');
		url = url.replace('\\', ' ');
		url = url.replace(':', '-');
		url = url.replace('?', ' ');
		url = url.replace('*', ' ');
		url = url.replace('|', ' ');
		url = url.replace('<', '(');
		url = url.replace('>', ')');
		return url;
	}

	public static String StrDecode(String src,String enc)
    {
    	String s=null;
        try {
        	s=new String(src.getBytes(enc));
        }
        catch(UnsupportedEncodingException e) {
            return s;
        }
    	return s;
    }

	public static boolean isUTF8(byte[] src)
    {
        try {
            byte[] tmp = new String(src, "UTF8").getBytes("UTF8");
            return Arrays.equals(tmp, src);
        }
        catch(UnsupportedEncodingException e) {
            return false;
        }
    }

    public static boolean isSJIS(byte[] src)
    {
        try {
            byte[] tmp = new String(src, "Shift_JIS").getBytes("Shift_JIS");
            return Arrays.equals(tmp, src);
        }
        catch(UnsupportedEncodingException e) {
            return false;
        }
    }
	
	public static  String [] StrArrayConcat(String[] ps1,String[] ps2,int pos1,int pos2) {
		if(ps1!=null) {
			if(ps2!=null) {  //both ps1,ps2
				String[] ps3 = new String[ps1.length-pos1 + ps2.length-pos2];
				System.arraycopy(ps1,pos1,ps3,0,ps1.length-pos1); 
				System.arraycopy(ps2,pos2,ps3,ps1.length-pos1,ps2.length-pos2); 
				return ps3;
			}
			else {  //only ps1
				String[] ps3 = new String[ps1.length-pos1];
				System.arraycopy(ps1,pos1,ps3,0,ps1.length-pos1); 
				return ps3;
			}
		}
		else if(ps2!=null) {  //only ps2
			String[] ps3 = new String[ps2.length-pos2];
			System.arraycopy(ps2,pos2,ps3,0,ps2.length-pos2); 
			return ps3;
		}
		else {  // both array are null!!
			return null;
		}
	}

}
