/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005-2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package net.pms.network;

import static org.jboss.netty.channel.Channels.*;

import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

import org.jboss.netty.handler.execution.ExecutionHandler; //regzamod
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor; //regzamod
import org.jboss.netty.handler.execution.MemoryAwareThreadPoolExecutor; //regzamod
import net.pms.PMS; //regzamod

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author The Netty Project (netty-dev@lists.jboss.org)
 * @author Andy Taylor (andy.taylor@jboss.org)
 */
public class HttpServerPipelineFactory implements ChannelPipelineFactory {
	private static final Logger logger = LoggerFactory.getLogger(HttpServerPipelineFactory.class);
	private ChannelGroup group;
	
	public HttpServerPipelineFactory(ChannelGroup group) {
	    this.group = group;
	}

    public ChannelPipeline getPipeline() throws Exception {
		logger.trace("Creating new pipeline");
		boolean use_execHandler=false;	// test for asynchronously detecting channel.closed event
		ExecutionHandler exeHandler=null;
		
		if(use_execHandler) {	//regzamod
			//test for asynchronous execution of received messages: seems has no good effects
			if(PMS.rz_debug>1) PMS.dbg("HttpServerPipelineFactory.getPipeline: insert ExecutionHandler for asynchronous execution test");
			exeHandler = new ExecutionHandler(new MemoryAwareThreadPoolExecutor(16, 1048576, 1048576));
				//= new ExecutionHandler(new OrderedMemoryAwareThreadPoolExecutor(16, 1048576, 1048576));
				//OrderedMemoryAwareThreadPoolExecutor(int corePoolSize, long maxChannelMemorySize, long maxTotalMemorySize)
		}
		
		// Create a default pipeline implementation.
		ChannelPipeline pipeline = pipeline();
		pipeline.addLast("decoder", new HttpRequestDecoder());
		pipeline.addLast("aggregator", new HttpChunkAggregator(65536)); // eliminate the need to decode http chunks from the client
		pipeline.addLast("encoder", new HttpResponseEncoder());
		pipeline.addLast("chunkedWriter", new ChunkedWriteHandler());
		
		if(use_execHandler==true) { //regzamod
			pipeline.addLast("execution", exeHandler);
		}
			
		pipeline.addLast("handler", new RequestHandlerV2(group));
		return pipeline;
	}
}
