/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2010  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.logging;

import java.io.File;
//import java.io.PrintWriter;
//import java.io.FileOutputStream;

import ch.qos.logback.core.PropertyDefinerBase;
import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;

/**
 * Logback PropertyDefiner to set the path for the <code>debug.log</code> file.
 * <p>
 * If the current working directory is writable it returns an empty string. If
 * not then the path to the system temp directory is returned.
 * </p>
 * <p>
 * This is equivalent to the old behavior of PMS.
 * </p>
 * 
 * @see System#getProperty(String)
 * @author thomas@innot.de
 * 
 */
public class DebugLogPathDefiner extends PropertyDefinerBase {
	/*
	 * (non-Javadoc)
	 * 
	 * @see ch.qos.logback.core.spi.PropertyDefiner#getPropertyValue()
	 */
	//private static final PmsConfiguration configuration = PMS.getConfiguration();

	String key="";
	public void setKey(String key) {
			this.key = key;
	}
	
	@Override
	public String getPropertyValue() {
		
		if(true) {
			//will cause [debugLogPath_IS_UNDEFINED/debug.log]
			String result = null;
			switch(key) {
			case "debugLogPath":
			case "logFilePath":
				//seems called 2 times or more.. 
				try {
					if(true) {
						result = PmsConfiguration.getDebugLogDir();
						PMS.dbgw("getPropertyValue: get by getDebugLogDir()");
					}
					else {
						PmsConfiguration configuration=PMS.getConfiguration();  //may return null
						//PmsConfiguration configuration=PMS.get().getConfiguration(); //cause multi-PMS and exception
						PMS.dbgw("getPropertyValue: configuration="+configuration);
						if(configuration!=null) {
							//called AFTER configuration set-upped
							PMS.dbgw("getPropertyValue: get by getDebugLogDir()");
							result = PMS.getConfiguration().getDebugLogDir();
						}
						else {
							//called BEFORE configuration set-upped: this really happens.
							//to avoid this: you should direct coding without using PMS.getConfiguration()
							PMS.dbgw("getPropertyValue: configuration is NULL, get dummy");
							result=new File("").getAbsolutePath();  //return working dir: anyway, this is dummy
						}
					}
				} catch (Exception e) {
					//may never come here, if processed correctry when configuration==null
					PMS.dbgw("getPropertyValue: Exception="+e);
					//result = System.getProperty("java.io.tmpdir");
					result=new File("").getAbsolutePath();  //return working dir: anyway, this is dummy
				}
				PMS.dbgw("getPropertyValue: End, valid key="+key+", result="+result);
				return result;  
			default:
			}
			PMS.dbgw("getPropertyValue: End, invalid key="+key+", result="+result);
			return result;
		}
		else if(false) {
			//Cause [debugLogPath_IS_UNDEFINED/debug.log] under Install Dir, Why ?
			File file = new File("write_test_file");
			String result=PMS.getConfiguration().getDebugLogDir();
			try {
				file.createNewFile();
				if (file.canWrite()) {
					file.delete();
					PMS.dbgw("getPropertyValue: 1 result="+result);
					return result;
				}
			} catch (Exception e) {
				PMS.dbgw("getPropertyValue: Exception="+e);
			}
			// Return path to temp folder, which should be writeable
			PMS.dbgw("getPropertyValue: 2 result="+result);
			return result;
		}
		else { //origin
			// Check if current directory is writable
			File file = new File("write_test_file");
			String result=null;
			try {
				file.createNewFile();
				if (file.canWrite()) {
					file.delete();
					result=PMS.getConfiguration().getDebugLogDir();
					//result=new File("").getAbsolutePath();
					PMS.dbgw("getPropertyValue: 1 result="+result);
					return result;
				}
				else {
					result=PMS.getConfiguration().getDebugLogDir();
					PMS.dbgw("getPropertyValue: 2 result="+result);
					return result;
				}
			} catch (Exception e) {
				PMS.dbgw("getPropertyValue: Exception="+e);
				//result=PMS.getConfiguration().getDebugLogDir();
				// Could not create / write the file
			}
			// Return path to temp folder, which should be writeable
			if(result==null) {
				result=System.getProperty("java.io.tmpdir");
			}
			PMS.dbgw("getPropertyValue: result="+result);
			return result;
		}
	}
	
}

