/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.io;

import java.io.IOException;
import java.io.InputStream;
import net.pms.PMS;
import net.pms.util.PMSUtil;
import net.pms.io.BufferedOutputFileImpl;

public class WaitBufferedInputStream extends InputStream {
	private BufferedOutputFile outputStream;
	private long readCount;
	private boolean firstRead;

	public void setReadCount(long readCount) {
		this.readCount = readCount;
	}

	public long getReadCount() {
		return readCount;
	}
	
	WaitBufferedInputStream(BufferedOutputFile outputStream) {
		this.outputStream = outputStream;
		firstRead = true;
	}

	public int read () throws IOException {
		long[] readc_o= {0,0};
		int r = outputStream.read(firstRead, getReadCount(), readc_o);
		//if (r != -1) {
		//	setReadCount(getReadCount() + 1);
		//}
		if (r > -1) {
			setReadCount(getReadCount() + 1);
		}
		else if(r <-1) {  //regzam, rollbacked
			//r is subtracted by 1000
			r=r+1000;  //get original value
			setReadCount(readc_o[0] + 1);
		}
		firstRead = false;
		return r;
	}

	@Override
	public int read (byte[] b, int off, int len) throws IOException {
		int returned = outputStream.read(firstRead, getReadCount(), b, off, len);
		//if (returned != -1) {
		//	setReadCount(getReadCount() + returned);
		//}
		if (returned >-1) {
			setReadCount(getReadCount() + returned);
		}
		else if(returned <-1) {  //regzam
			returned= -returned;
			setReadCount(0 + returned);
		}
		firstRead = false;
		return returned;
	}

	@Override
	public int read (byte[] b) throws IOException {
		return read(b, 0, b.length);
	}

	public int available() throws IOException {
		return (int) outputStream.getWriteCount();
	}

	public void setCanStop(boolean stop, int limit) {	//regamod
		if(true) return; //for test
		((BufferedOutputFileImpl)outputStream).setCanStop(stop,limit);
	}
	public void close() throws IOException {
		//PMS.dbg("WaitBufferedInputStream.close: called");
		if(PMS.rz_debug>=7) {
			PMSUtil.strace();
		}
		if(((BufferedOutputFileImpl)outputStream).canStop()) {
			if(PMS.rz_debug>1) PMS.dbg("WaitBufferedInputStream.close: outputStream.canStop() is true, call detachInputStream");
			outputStream.removeInputStream(this);
			outputStream.detachInputStream();
		}
		else {
			//PMS.dbg("WaitBufferedInputStream.close: outputStream.canStop()==false, don't close for TEST");
		}
	}
	public BufferedOutputFileImpl getOutputStream() {
		return ((BufferedOutputFileImpl)outputStream);
	}
}

