// a utility class, instances of which trigger start/stop callbacks before/after streaming a resource
package net.pms.external;

import net.pms.PMS;	//regzamod
import net.pms.dlna.DLNAResource;
import net.pms.dlna.rz_SessionCtl;	//regzamod
import net.pms.dlna.rz_SessionInfo;	//regzamod
import net.pms.configuration.RendererConfiguration;

import net.pms.formats.Format;

import org.slf4j.Logger;		//regzamod
import org.slf4j.LoggerFactory;	//regzamod

public class StartStopListenerDelegate {
	private static final Logger logger = LoggerFactory.getLogger(StartStopListenerDelegate.class);	//regzamod

	private final String rendererId;
	private DLNAResource dlna;
	//private RendererConfiguration renderer;
	private rz_SessionInfo sess;
	private boolean started = false;
	private boolean stopped = false;

	public StartStopListenerDelegate(String rendererId) {
		this.rendererId = rendererId;
	}
	public StartStopListenerDelegate(String rendererId, rz_SessionInfo sess) {
		this.rendererId = rendererId;
		this.sess=sess;
	}

	// technically, these don't need to be synchronized as there should be
	// one thread per request/response, but it doesn't hurt to enforce the contract
	//public synchronized void start(DLNAResource dlna) {
	public void start(DLNAResource dlna) {
		/*
		startStop(1,dlna,0);
		*/
		if(PMS.rz_debug>1) {
			PMS.dbg("===> StartStopListenerDelegate.start: dlna="+dlna);	//regzamod
		}
			
		assert this.dlna == null;
		this.dlna = dlna;
		Format ext = dlna.getExt();
		// only trigger the start/stop events for audio and video
		//if (!started && ext != null && (ext.isVideo() || ext.isAudio())) {
		if (!started && ext != null && (ext.isVideo() || ext.isAudio() || dlna.is_iav())) {
			dlna.startPlaying(rendererId);
			started = true;
		}
	}

	//public synchronized void stop() {
	public void stop(int mode) { //regzamod
		/*
		startStop(2,null,mode);
		*/
		//mode:=0:only for resume_memory,=1:really exec stop_procedure
		if(PMS.rz_debug>1) {
			PMS.dbg2("===> StartStopListenerDelegate.stop: dlna="+this.dlna);	//regzamod
		}
			
		if (started && !stopped) {
			dlna.stopPlaying(rendererId,sess,mode);
			stopped = true;
		}
	}
	private synchronized void startStop(int start, DLNAResource dlna,int stopMode) { //regzamod
		//not good for resume/pause
		if(start==1) {	//start
			if(PMS.rz_debug>1) {
				PMS.dbg("===> StartStopListenerDelegate.start: dlna="+dlna);	//regzamod
			}
				
			assert this.dlna == null;
			this.dlna = dlna;
			Format ext = dlna.getExt();
			// only trigger the start/stop events for audio and video
			//if (!started && ext != null && (ext.isVideo() || ext.isAudio())) {
			if (!started && ext != null && (ext.isVideo() || ext.isAudio() || dlna.is_iav())) {
				dlna.startPlaying(rendererId);
				started = true;
			}
		}
		else {//stop
			//mode:=0:only for resume_memory,=1:really exec stop_procedure
			if(PMS.rz_debug>1) {
				PMS.dbg2("===> StartStopListenerDelegate.stop: dlna="+this.dlna);	//regzamod
			}
			if (started && !stopped) {
				dlna.stopPlaying(rendererId,sess,stopMode);
				stopped = true;
			}
		}
	}
}
