/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// FolderType Buttons
// for the renderers that don't work well with FileType Buttons
//-----------------------------------------------------------------------------
package net.pms.dlna;

import java.io.File;

import net.pms.PMS;
import net.pms.dlna.virtual.VirtualFolder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class rz_VirtualFolderButton extends VirtualFolder {
	private static final Logger logger = LoggerFactory.getLogger(rz_VirtualFolderButton.class);
	
	public rz_VirtualFolderButton(String name) {
		super(name,null);
		
		File okmovie=new File("videos/action_success-512.mpg");
		rz_PlayMetaFile pxm=new rz_PlayMetaFile(okmovie,"OK", 0);
		pxm.rz_MetaNotExistSuffix=false;
		pxm.rz_MetaTransType[0]=PMS.ENC_DIRECT;
		this.addChild(pxm);
	}

	@Override
	public boolean isTranscodeFolderAvailable() {
		return false;
	}

	@Override
	public int activate(int type) {
		//PMS.dbg("rz_VirtualFolderButton.activate: called, type="+type);
		return -1;
	}
}

