/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.dlna;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAResource;
import net.pms.dlna.rz_VirtualVideoActionF;
import net.pms.dlna.rz_ResumeFolder;
import net.pms.dlna.virtual.TranscodeVirtualFolder;

//import net.pms.dlna.virtual.VirtualVideoAction;
//import net.pms.formats.MPG;
//import net.pms.network.HTTPResource;

public class rz_SortMenuButton extends rz_VirtualVideoActionF {
	private DLNAResource target;
	
	public rz_SortMenuButton(String name, DLNAResource target) {
		super(name,false,0,0); //should call, if params not equals to super constructor
		this.target=target;
	}
	
	@Override
	public int action () {
		DLNAResource pa=this.target;
		//PMS.dbg("rz_SortMenuButton.action: set doSort=true, target="+pa.getName()+", change sorttype="+pa.rz_MetaSortType+" to"+this.rz_MetaSortType);
		if(pa==null) {
			return 0;
		}
		pa.sort_enabled=true;
		pa.rz_MetaSortType=this.rz_MetaSortType;
		pa.doSort=true;
		if(pa.rz_MetaSortRecursive) {
			pa.setDoSortToSubfolders(pa);
		}
		
		//sort also TranscodeVirtualFolder under link target
		TranscodeVirtualFolder vf=pa.getTranscodeFolder(false,-1);
		if(vf!=null) {
			vf.sort_enabled=true;
			vf.rz_MetaSortType=pa.rz_MetaSortType;
			//PMS.dbg("rz_SortMenuButton.action: TranscodeVirtualFolder of tartget --> set doSort=true");
			vf.doSort=true;
		}
		//sort also resumeDeleteFolder if target is resumeFolder
		if(pa.sotype==SO_RESUME_FOLDER) {
			rz_ResumeFolder rf=(rz_ResumeFolder)pa;
			if(rf.delFolder!=null) {
				//PMS.dbg("rz_SortMenuButton.action: ResumeFolder of tartget --> set doSort=true");
				rf.delFolder.sort_enabled=true;
				rf.delFolder.rz_MetaSortType=pa.rz_MetaSortType;
				rf.delFolder.doSort=true;
			}
		}
		/*
		if(sort_menu_type>=2) {  // newType , disp OK 
			resource=PMS.getCommonFolder_OK();
		}
		else {// disp target folder sorted
			resource=pa;
		}
		*/
		return 0;
	}
}
