/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

//-----------------------------------------------------------------------------
// Session Controll
//-----------------------------------------------------------------------------
package net.pms.dlna;

import java.io.File;
import java.util.List;
import java.util.ArrayList;
import java.net.InetAddress;
import java.net.InetSocketAddress;

import net.pms.PMS;
import net.pms.dlna.rz_SessionInfo;
import net.pms.configuration.RendererConfiguration;

//import net.pms.configuration.PmsConfiguration;
//import net.pms.configuration.RendererConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class  rz_SessionCtl {
	private static final Logger logger = LoggerFactory.getLogger(rz_SessionCtl.class);
	private static List <rz_SessionInfo> sessList;
	
	public rz_SessionCtl() {
		sessList=new ArrayList<rz_SessionInfo>();
	}
	
	public void reset() {
		sessList=new ArrayList<rz_SessionInfo>();
	}
	
	public List<RootFolder> getRootFolders() {
		List <RootFolder> dlist= new ArrayList<RootFolder>();
		if(sessList==null) return null;
		for(rz_SessionInfo s : sessList) {
			if(s.renderer!=null && s.renderer.rootFolder!=null) {
				dlist.add(s.renderer.rootFolder);
			}
		}
		return dlist;
	}
	
	
	
	public List<rz_SessionInfo> getSessAll() {
		return sessList;
	}
	
	public synchronized rz_SessionInfo getSess(InetSocketAddress ipaddr, RendererConfiguration r,
		boolean isMyHost, boolean initScript, boolean dispIconEnable) {
		//get session info according to ipaddr
		//if not exist, then create new sessionInfo
		
		//sockaddr(portNo.) may change within one logical session
		InetAddress ia = ipaddr.getAddress();
		boolean onMyHost=ia.equals(PMS.myHostAddr);
		
		//PMS.dbg("getSession: target renderer="+ r);
		int i=0;
		for(rz_SessionInfo s : sessList) {
			//PMS.dbg("getSess list_No"+i+" sess ="+s);
			i++;
			if(!s.ia.equals(ia)) {
				continue;
			}
			if(s.isMyHost) {  //myself entry
				if(isMyHost) {
					if(PMS.rz_debug>1) PMS.dbg("getSess: return-1 Existing Session(myHost)="+s);
					return s;
				}
				else {
					continue;
				}
			}
			if(PMS.rz_rend_judge_type==0) { // search by ipAddr
				if(PMS.rz_debug>1) PMS.dbg("getSess: return-2 Existing Session(match ipAddr)="+s);
				return s;
			}
			else if(PMS.rz_rend_judge_type==1) { 
				if(onMyHost) {	//on my host: search by ipAddr+Renderer
					if(r!=null && s.renderer!=null) {
						//if(s.renderer.getRendererName().equals(r.getRendererName())) {
						if(s.renderer.getRank()==r.getRank()) {  //same confType
							if(PMS.rz_debug>1) PMS.dbg("getSess: dev on myHost, return-3 Existing Session(match ipAddr+rendererType)="+s);
							return s;
						}
					}
				}
				else { 	//on other host : search by ipAddr
					if(PMS.rz_debug>1) PMS.dbg("getSess: dev on otherHost, return-4 Existing Session(match ipAddr)="+s);
					return s;
				}
			}
			else { //PMS.rz_rend_judge_type==2 : search by HostAddr+Renderer for all
				if(s.renderer!=null && r!=null) {
					//if(s.renderer.getRendererName().equals(r.getRendererName())) {
					if(s.renderer.getRank()==r.getRank()) {  //same confType
						if(PMS.rz_debug>1) PMS.dbg("getSess: return-5 Existing Session(match ipAddr+rendererType)="+s);
						return s;
					}
				}
			}
		}
		//--- create new session
		rz_SessionInfo s= new rz_SessionInfo();
		s.sa=ipaddr;
		s.ia=ia;
		s.ia_str=ia.getHostAddress();
		s.id=sessList.size();
		s.isMyHost=isMyHost;
		s.initScript=initScript;
		s.dispIconEnable=dispIconEnable;
		
		//---- regsiter session
		sessList.add(s);
		if(PMS.rz_debug>1) PMS.dbg("getSess: return-6 Create New Session="+s);
		return s;
	}
			
	public void setFname(InetAddress ipAddr, String friendlyName) {
		for(rz_SessionInfo s : sessList) {
			if(s.ia.equals(ipAddr)) {
				s.fname=friendlyName;
			}
		}
	}
	public void setFname(String ipAddr, String friendlyName) {
		for(rz_SessionInfo s : sessList) {
			if(s.ia_str.equals(ipAddr)) {
				s.fname=friendlyName;
			}
		}
	}
	
	public String toString() {
		String ret="";
		for(rz_SessionInfo s : sessList) {
			ret+=s.toString();
			ret+="\n";
		}
		return ret;
	}

}
