/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// Folder for TransOptScript menu folder
//-----------------------------------------------------------------------------
package net.pms.dlna;

//import java.io.*;
import java.io.File;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;

import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.MapFileConfiguration;
//import net.pms.dlna.RealFile;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.util.PMSUtil;
import net.pms.dlna.rz_ScriptExecutor;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class rz_ScriptMenuFolder extends VirtualFolder {
	private static final Logger logger = LoggerFactory.getLogger(rz_ScriptMenuFolder.class);
	private boolean resolved=false;
	RendererConfiguration renderer;

	public rz_ScriptMenuFolder(String name,String thumbnailIcon,RendererConfiguration renderer) {
		super(name,thumbnailIcon);
		this.renderer=renderer;
		//resolve();
	}
	
	public int activate(int type) {
		resolve_in();
		return 0;
	}
	
	public void resolve_in() {
		//PMS.dbg("rz_ScriptMenuFolder.resolve: start, resolved="+resolved);
		if(resolved) {
			//PMS.dbg("rz_ScriptMenuFolder.resolve: already resolved");
			return ;
		}
		//PMS.dbg("rz_ScriptMenuFolder.resolve: exec resolve, renderer="+renderer);
		if(renderer==null) {
			//PMS.dbg("rz_ScriptMenuFolder.resolve: default renderer is null, myname="+getName());
			return;
		}
		//PMS.dbg("rz_ScriptMenuFolder: currentSession="+getCurrentSession()); 
		if(getCurrentSession()==null) return;
		
		rz_ScriptMenuButton m1;
		DLNAResource pa=null;
		
		VirtualFolder vf= new VirtualFolder("#- Reset Menu -#", null);
		addChildInternal(vf);
		
		if(getCurrentSession().scex==null) {
			resolved=true;
			return;
		}
		
		// #- SCRIPT_RESET (DEFAULT) -#
		//allways create, even if script not exist
		m1= new rz_ScriptMenuButton(0,renderer,0);
		m1.sort_enabled=false;
		//m1.sort_immune=1;
		m1.allowCtlFolder=false;
		vf.addChild(m1);
		
		
		// #- SCRIPT_RESET (ALL_OFF) -#
		//allways create, even if script not exist
		m1= new rz_ScriptMenuButton(1,renderer,0);
		m1.sort_enabled=false;
		//m1.sort_immune=1;
		m1.allowCtlFolder=false;
		vf.addChild(m1);
		
		//create per menu buttons if according script exist
		ArrayList<rz_ScriptExecutor.ScriptEnt> TransOptScriptList=getCurrentSession().scex.getRz_TransOptScriptList();
		//PMS.dbg("rz_ScriptMenuFolder.resolve: ScriptList cnt="+TransOptScriptList.size());
		int i=0;
		for(rz_ScriptExecutor.ScriptEnt scp: TransOptScriptList) {
			if(scp.script!=null) {
				if(scp.mname!=null && scp.type>=2) {
					if(scp.mpath!=null) {  
						//create sub-folders
						pa=PMSUtil.createDLNApath(this,scp.mpath,"/");
					}
					else {
						pa=this;
					}
					m1= new rz_ScriptMenuButton(2,renderer,i);
					m1.sort_enabled=false;
					//m1.sort_immune=1;
					m1.allowCtlFolder=false;
					pa.addChild(m1);
				}
			}
			i++;
		}
		resolved=true;
	}
}