/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// FolderType Buttons
// for the renderers that don't work well with FileType Buttons
//-----------------------------------------------------------------------------
package net.pms.dlna;

import java.util.ArrayList;
import net.pms.PMS;
import net.pms.dlna.rz_VirtualFolderButton;
import net.pms.dlna.rz_ScriptExecutor;
import net.pms.configuration.RendererConfiguration;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class rz_ScriptMenuButton extends rz_VirtualVideoActionF {
	private static final Logger logger = LoggerFactory.getLogger(rz_ScriptMenuButton.class);
	private String name;
	private RendererConfiguration renderer;
	private rz_ScriptExecutor scex;
	private ArrayList<rz_ScriptExecutor.ScriptEnt> slist;
	private rz_ScriptExecutor.ScriptEnt scp;
	private long prevCallTime=0;
	private int act;
	private int spos;
	
	//public rz_ScriptMenuButton(int act, RendererConfiguration renderer, RendererConfiguration.ScriptEnt scp) {
	public rz_ScriptMenuButton(int act, RendererConfiguration renderer, int spos) {
		//super("unknown");
		super("unknown",false,0,0);
		this.renderer=renderer;
		//this.slist=renderer.getRz_TransOptScriptList();
		this.spos=spos;
		this.act=act;  //=0:menu reset (all aff),=1: menu reset(deafoult)_off, =2: individual menu_on/off
	}
	
	@Override
	public String getDisplayName() {
		return this.getDisplayName(null);
	}
	@Override
	public String getDisplayName(RendererConfiguration mediaRenderer) {
		//act==1: this menu displayed, even if no scrpts
		if(act==0) return "#- Reset Menu (Default) -#";
		if(act==1) return "#- Reset Menu (All Off) -#";
		
		scex=getParent().getCurrentSession().scex;
		if(scex==null) return null;
		slist=scex.getRz_TransOptScriptList();
		if(slist==null || slist.size()<=spos) return null;
		
		scp=slist.get(spos);
		if((scp.stat&0x2)!=0) {  	// 0x02: oneshot exec
				name="[!] "+scp.mname;
		}
		else {	// toggle button
			if((scp.stat&0x1)!=0) {  	// 0x01: ON
				name="[*] "+scp.mname;
			}
			else {
				name="[-] "+scp.mname;
			}
		}
		if(PMS.rz_debug>1) PMS.dbg("rz_ScriptMenuButton.getDisplayName: stat="+scp.stat+", return name="+name);
		return name;
	}

	@Override
	public int activate(int type) {
		enabled=true;  //should be maintained, according to button activations
		scex=getParent().getCurrentSession().scex;
		if(scex==null) return 0;
		slist=scex.getRz_TransOptScriptList();
		if(slist==null || slist.size()<=spos) return 0;
		scp=slist.get(spos);
			
		long tim1 = System.currentTimeMillis();
		if(PMS.rz_debug>1) {
			PMS.dbg("rz_ScriptMenuButton.activate: called, type="+type
				+", stat="+scp.stat+", when="+scp.when+", target="+scp.target
				+", mgrp="+scp.mgrp+", mname="+scp.mname);
			PMS.dbg("rz_ScriptMenuButton.activate: time interval(msec)="+(tim1-prevCallTime));
		}
		if(type==1) { // indicate Folder Open action from renderer, called 2 times on one open why??
			if((tim1-prevCallTime) <1000) {
				if(PMS.rz_debug>1) PMS.dbg("rz_ScriptMenuButton.activate: called in too short time(msec)="+(tim1-prevCallTime)+", return Noop");
				prevCallTime=tim1;
				return 0;
			}
			prevCallTime=tim1;
			
			if(act==0) {  //reset menu (to default)
				for(rz_ScriptExecutor.ScriptEnt scpwk: slist) {
					//if(scpwk.stat!=2 && (scpwk.stat&0x1)!=0 && scpwk.when==4) {  //not oneshot and stat=on and exec now
					if(scpwk.stat!=2 && (scpwk.stat&0x1)!=0 && (scpwk.when&0x4)!=0) {  //not oneshot and stat=on and exec now
						scpwk.stat=scpwk.stat_sv;  // off, must be before call execScripts_s
						scex.execScripts_s(2,4,0,null,"dummy_dlna",null,null,scpwk);  //exec single scp
					}
					else {
						scpwk.stat=scpwk.stat_sv; // off
						//enabled=false;
					}
				}
				scex.setRz_ScriptLastModified(tim1);
			}
			else if(act==1) {  //reset menu (all off)
				for(rz_ScriptExecutor.ScriptEnt scpwk: slist) {
					//if(scpwk.stat!=2 && (scpwk.stat&0x1)!=0 && scpwk.when==4) {  //not oneshot and stat=on and exec now
					if(scpwk.stat!=2 && (scpwk.stat&0x1)!=0 && (scpwk.when&0x4)!=0) {  //not oneshot and stat=on and exec now
						//scpwk.stat&=0x2;  // off, must be before call execScripts_s
						scpwk.stat&=0xfffe;  // off, must be before call execScripts_s
						scex.execScripts_s(2,4,0,null,"dummy_dlna",null,null,scpwk);  //exec single scp
					}
					else {
						scpwk.stat&=0xfffe;  // off, must be before call execScripts_s
						//scpwk.stat&=0x2;  // off
						//enabled=false;
					}
				}
				scex.setRz_ScriptLastModified(tim1);
			}
			else {  //act==2 :individual script menu on/off
				if(PMS.rz_debug>1) PMS.dbg("rz_ScriptMenuButton.activate: individual script menu on/off scp.type="+scp.type);
				if(scp.stat==2) {  //PushButton(OneShot)
					if(PMS.rz_debug>1) PMS.dbg("rz_ScriptMenuButton.activate: OneShotButton: exec now, scp.type="+scp.type+", mname="+scp.mname);
					if(scp.mgrp>0) {
						rgp_reset(scp.mgrp);
					}
					//execScripts(type,when,taget,dlna,..)
					// int type;	//=1:load,=2:exec
					// int when;	//=1:list,=2:play,  =3:list|play,  =4:oneshot
					// int target;	//=1:file,=2:folder,=3:file|folder,=4:other
					scex.execScripts_s(2,4,0,null,"dummy_dlna",null,null,scp);//exec now
					//scex.setRz_ScriptLastModified(tim1);  
				}
				else {  //Toggle Button
					if((scp.stat&0x1)!=0) {  //on
						scp.stat&=0xfffe;  //off (clear 0x1 bit with presreving 0x2 bit that indicates oneshot_btn)
					}
					else { //off
						if(scp.mgrp>0) {
							rgp_reset(scp.mgrp);  //all off in group 
						}
						scp.stat|=0x01;  //on (set 0x1 bit)
					}
					if((scp.when&0x4)!=0) {  // call immediately when button on/off occured
						PMS.dbg("ScriptMenuButton: exec toggle_button script scp.when==4, scp.stat="+scp.stat);
						
						//execScripts() will not exec, if (scp.stat&0x01)==0
						//so, fakeup even if scp.stat==0, ToDO: should be added to execScripts params
						//int stat_sv=scp.stat;
						//scp.stat=1;
						scex.execScripts_s(2,4,0,null,"dummy_dlna",null,null,scp);  //exec single scp
						scex.setRz_ScriptLastModified(tim1);  // need menu name(stat) update
						//scp.stat=stat_sv;
					}
						else { //only indicate updated --> exec later (when=1:disp list,=2:play start)
						scex.setRz_ScriptLastModified(tim1);  
					}
				}
			}
		}
		if(PMS.rz_debug>1) PMS.dbg("rz_ScriptMenuButton.activate: return, type="+type+", mname="+scp.mname+", stat="+scp.stat);
		return 0;
	}
	
	//reset(all off) radio_button menues
	private void rgp_reset(int rgp) {
		if(PMS.rz_debug>1) PMS.dbg("rgp_reset rgp="+rgp);
		int i=0;
		for(rz_ScriptExecutor.ScriptEnt scpwk: slist) {
			if(scpwk.mgrp==rgp) {
				if(PMS.rz_debug>1) PMS.dbg("rgp_reset i="+i+", mname="+scpwk.mname);
				scpwk.stat &= 0x2;
			}
			i++;
		}
	}
}

