/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// Folder for resume objs
//-----------------------------------------------------------------------------
package net.pms.dlna;

//import java.io.*;
import java.io.File;
import java.util.List;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;

import net.pms.PMS;
import net.pms.util.PMSUtil;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
//import net.pms.dlna.RealFile;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.dlna.rz_Resume;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

//for RESUME_DETETE folder and DEL Buttons on it
public class rz_ResumeVirtualFolder extends rz_VirtualVideoActionF {
	private static final Logger logger = LoggerFactory.getLogger(rz_ResumeVirtualFolder.class);
	private int rftype;
	private DLNAResource srcObj;
	private rz_Resume resume;
	private rz_ResumeFolder pa_folder;
	private rz_ResumeVirtualFolder pa_vfolder;
	private int u_params;   //user params
	//private ArrayList<rz_ResumeVirtualFolder> dellist;
	//private List<rz_ResumeVirtualFolder> chlist;
	private ArrayList<DLNAResource> dellist= new ArrayList<DLNAResource>();
	private List<DLNAResource> chlist;	//abstract: can't be set new instace
	
	public static int RF_RESUME=0;
	public static int RF_DEL_RESUME_BASE=1;
	public static int RF_DEL_RESUME_SGL=2;
	public static int RF_DEL_RESUME_ALL=3;
	public static int RF_DEL_RESUME_PART=4;
	
	/*
	public static int RF_DEL_RESUME_PART_WEEK=5;
	public static int RF_DEL_RESUME_PART_MONTH=6;
	public static int RF_DEL_RESUME_PART_HALF_YEAR=7;
	public static int RF_DEL_RESUME_PART_YEAR=8;
	*/
	
	public rz_ResumeVirtualFolder(String name) {
		//super(name,null);
		super(name,false,0,0);  //button
		//sort_immune=1;
	}
	
	public rz_ResumeVirtualFolder(String name,int dummy) {
		//super(name,null);
		super(name,false,0,3);   //normal folder (not button)
		//sort_immune=1;
	}

	@Override
	public boolean isTranscodeFolderAvailable() {
		return false;
	}

	public void setRfType(int type) {
		rftype=type;
	}
	
	public void setSrcObj(DLNAResource sobj) {
		srcObj=sobj;
	}
	public void setParams(int p) {
		u_params=p;
	}
	
	public void setParentRF(rz_ResumeFolder pa) {
		pa_folder=pa;
	}
	
	public void setParentVF(rz_ResumeVirtualFolder pa) {
		pa_vfolder=pa;
	}
	
	public void delAddAll(DLNAResource except) {
		//dellist=(ArrayList)getChildren(); //not recommended
		chlist=getChildren(); 
		if(chlist!=null) {
			for(DLNAResource ch: chlist) {
				if(ch.rz_Metafile!=null) {
					dellist.add(ch);
				}
			}
		}
		//dellist.remove(except);
	}
	public void delAdd(DLNAResource child) {
		//don't delete immediately! b/c child is active yet
		//instead, memory for later exec
		dellist.add(child);
	}
	
	public void delAdd_part (long tim_min) {
		chlist=getChildren(); 
		//PMS.dbg("delAdd_part: called: child cnt="+chlist.size()+", time_min="+PMSUtil.convTime2Date(tim_min));
		if(chlist!=null) {
			for(DLNAResource ch: chlist) {
				//PMS.dbg("delAdd_part: ch.rz_Metafile="+ch.rz_Metafile);
				if(ch.rz_Metafile!=null) {
					//PMS.dbg("delAdd_part: ch.lastModified="+PMSUtil.convTime2Date(ch.rz_Metafile.lastModified()));
					if(ch.rz_Metafile.lastModified() < tim_min) {
						//PMS.dbg("--> Older than check_time delAdd_part: dellist add ch="+ch.getName());
						dellist.add(ch);
					}
				}
			}
		}
	}
	
	public void setResumeBase(rz_Resume resume) {
		this.resume=resume;
	}
	
	public int activate(int type) {
		
		long tim;
		long tim_now=System.currentTimeMillis();
		if(type==1) {	// indicate Folder Open action from renderer
			//activate special action
			if(rftype==RF_DEL_RESUME_BASE) {  //I'm [del-list folder]
				if(dellist.size()>0) {
					chlist=getChildren(); 
					if(chlist!=null) {
						for(DLNAResource ch: dellist) {
							chlist.remove(ch);  //delete according [del-btn]
							if(ch.rz_Metafile!=null) {
								//PMS.dbg("ResumeVirtualFolder.activate: exec delete Metafile="+ch.rz_Metafile.getPath());
								resume.res_delete(ch.rz_Metafile);
							}
						}
					}
					dellist.clear();
				}
			}
			else if(rftype==RF_DEL_RESUME_SGL) {  //I'm individual [del-btn] on [del-list folder]
				if(pa_vfolder!=null) {
					pa_vfolder.delAdd((DLNAResource)this);
				}
				if(pa_folder!=null) {
					pa_folder.needRefresh(true);
				}
				//PMS.dbg("del_btn: dlna.meta_type="+srcObj.meta_type+", dlna.rz_Metafile="+srcObj.rz_Metafile);
				//resume.resDelete(srcObj);
			}
			else if(rftype==RF_DEL_RESUME_ALL) {	//I'm [del-all-btn] on [del-list folder]
				//delete on del-list
				if(pa_vfolder!=null) {
					pa_vfolder.delAddAll((DLNAResource)this);
				}
				
				//delete real resume-files
				/*
				if(pa_folder.dlna_tg!=null && pa_folder.dlna_tg.sotype==SO_PLAYLIST) {
					pa_folder.delAllFiles();
				}
				else if(pa_folder.filter) {
					resume.resDeleteAll(pa_folder.srcHash_list);
				}
				else {
					resume.resDeleteAll(null);
				}
				*/
				//refresh del-list
				if(pa_folder!=null) {
					pa_folder.needRefresh(true);
				}
			}
			else if(rftype==RF_DEL_RESUME_PART) {  //delete old (before one week or more)
				//---- delete on del-list
				if(pa_vfolder!=null) {
					Date date1 = new Date(System.currentTimeMillis() - TimeUnit.DAYS.toMillis(u_params));
					tim=date1.getTime();
					//tim=3600*24*1000*30;
					//tim=tim_now-tim;
					//PMS.dbg("ResumeVirtualFolder.activate: rftype='RF_DEL_RESUME_PART_HALF_YEAR', tim="+PMSUtil.convTime2Date(tim));
					pa_vfolder.delAdd_part(tim); //milli-sec for a month
					pa_folder.needRefresh(true);
				}
			}
		}
		return 0;
	}
	
	@Override
	public int getSortType() {	//regzamod add
		//PMS.dbg("rz_ResumeVirtualFolder.getSortType(): rz_MetaSortType="+rz_MetaSortType
		//	+", PMS.rz_resume_sort_type="+PMS.rz_resume_sort_type);
		if(rz_MetaSortType>=0) {
			return rz_MetaSortType;
		}
		else if(PMS.rz_resume_sort_type==PMS.SORT_DEFAULT) {
			return PMS.getConfiguration().getSortMethod();
		}
		else {
			return PMS.rz_resume_sort_type;
		}
	}

}

