/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// Folder for resume objs
//-----------------------------------------------------------------------------
package net.pms.dlna;

//import java.io.*;
import java.io.File;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;

import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.MapFileConfiguration;
//import net.pms.dlna.RealFile;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.dlna.rz_PlayMetaFile;
import net.pms.dlna.rz_Resume;
import net.pms.dlna.ZippedFile;
import net.pms.dlna.ZippedEntry;
import net.pms.dlna.rz_WatchedFolder;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class  rz_ResumeFolder extends MapFile {
	private static final Logger logger = LoggerFactory.getLogger(rz_ResumeFolder.class);
	private boolean resolved=false;
	private String thumbnailIcon=null;
	//public VirtualFolder delFolder;
	public rz_ResumeVirtualFolder delFolder;
	private rz_ResumeVirtualFolder delFolderAll;
	private int norefresh=0;
	private boolean active;
	private boolean childUpdate;
	//private String srcPath;
	//public String srcHash;
	public List<String> srcHash_list = new ArrayList<String>();
	public boolean filter;
	private File baseFolder;
	private static PmsConfiguration config=PMS.getConfiguration();
	private int menu_type=PMS.getConfiguration().getRZ_menu_type();
	public DLNAResource dlna_tg;	//target folder's DLNAobject
	private rz_WatchedFolder watched_base;
	
	public rz_ResumeFolder(File file, String name, boolean filter) {  //for all resume
		if(!file.isDirectory()) {
			//return;
		}
		sotype=SO_RESUME_FOLDER;
		//sort_immune=1;
		baseFolder=PMS.rz_resume.getBaseFolder();
		if(name!=null) getConf().setName(name);
		if(filter) {
			this.filter=true;
			//srcPath=file.getAbsolutePath();
			String hash=""+file.hashCode();
			srcHash_list.add(hash);
			getConf().getFiles().add(baseFolder);
			setLastmodified(baseFolder.lastModified());
		}
		else {
			this.filter=false;
			getConf().getFiles().add(file);
			setLastmodified(file.lastModified());
		}
	}
	
	public rz_ResumeFolder(DLNAResource dlna, String name, boolean filter) { //for perFolder resume
		
		//if(!dlna.isFolder()||!(dlna instanceof MapFile) && dlna.getSrcPath()==null) {
		if(!dlna.isFolder()) return;
		if(!(dlna instanceof MapFile) && dlna.getResumePath()==null) {
			return;
		}
		if(dlna instanceof ZippedFile) {
			//currentry not supported
			return;
		}
		dlna_tg=dlna;
		sotype=SO_RESUME_FOLDER;
		//sort_immune=1;
		baseFolder=PMS.rz_resume.getBaseFolder();
		if(name!=null) getConf().setName(name);
		getConf().getFiles().add(baseFolder);
		setLastmodified(baseFolder.lastModified());
		String path,hash;
		
		if(filter) {
			this.filter=true;
			if(dlna instanceof MapFile) {  //real folder
				for(File file : ((MapFile)dlna).getConf().getFiles()) {
					if (file != null && file.canRead()) {
						if(file.isDirectory()) {  // real/virtual folders
							if(file.getName().equals("VIDEO_TS")) { // roufgh check, tobe refiled
								path=file.getAbsolutePath()+"/"+file.lastModified();
								file=new File(path);
							}
							hash=""+file.hashCode();
						}
						else {  //may be files under virtual folder
							hash=rz_Resume.getResumeFileName(file,null);
						}
						srcHash_list.add(hash);
					}
				}
			}
			else { //virtual_folder (playlist/webfolder etc)
				//path=dlna.getSrcPath();
				hash=null;
				if((dlna.mflags & DLNAResource.MF_WEB_FOLDER)!=0) { //webFolder
					if(PMS.rz_resume_per_folder_web==0) {  // RESUME_PER_FOLDER disp all web_objs, instead of per webFolders
						hash=rz_Resume.HASH_PREFIX_WEB;
					}
				}
				if(hash==null) {
					path=dlna.getResumePath();
					if(path!=null) {
						File file=new File(path);
						if(file.getName().equals("VIDEO_TS")) { // roufgh check, tobe refiled
							path=file.getAbsolutePath()+"/"+file.lastModified();
							file=new File(path);
						}
						hash=""+file.hashCode();
						//PMS.dbg("rz_ResumeFolder: called, seems playlist, path="+path+", hash="+hash);
					}
				}
				if(hash!=null) srcHash_list.add(hash);
			}
		}
	}
	
	@Override
	public boolean isFolder() {
		return true;
	}
	
	@Override
	public boolean isTranscodeFolderAvailable() {
		return true;
	}

	@Override
	public void discoverChildren() {
		//1st time
		//PMS.dbg("rz_ResumeFolder.discoverChildren: called");
		long tim1=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.discoverChildren: Start");
		super.discoverChildren();
		long tim2=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.discoverChildren: End, elapsed="+(tim2-tim1));
	}
	
	
	@Override
	public boolean analyzeChildren(int count) {
		//1st time
		long tim1=System.currentTimeMillis();
		
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.analyzeChildren: Start, count="+count);
		boolean rc=super.analyzeChildren(count);
		createDelFolders(false);
		
		long tim2=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.analyzeChildren: End, elapsed="+(tim2-tim1));	//regzamod
		return rc;
	}

	
	@Override
	public void refreshChildren() {
		//2nd time or after 
		long tim1=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.refreshChildren: Start");
		
		if(false) {  //fast??
			ClearFolder(); //for whole re-create children
			delFolder=null;
			discoverChildren();
			analyzeChildren(-1);
		}
		else {  //slow??
			super.refreshChildren(); 
		}
		if(active) {
			refreshDelFolders();
			active=false;
		}
		long tim2=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.refreshChildren: End, elapsed="+(tim2-tim1));
	}
	
	public int activate(int type) {
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.activate: Start");

		//PMS.dbg("====>> rz_ResumeFolder.activate: called, childUpdate="+childUpdate);
		if(type>=0) {
			active=true;
		}
		if(false && childUpdate) {
			//PMS.dbg("====>> rz_ResumeFolder.activate: call refreshDelFolders");
			refreshDelFolders();
			childUpdate=false;
		}
		
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.activate: End");
		return 0;
	}
		
	public void needRefresh(boolean b) {
		//PMS.dbg("====> rz_ResumeFolder.needRefresh: called childUpdate set to true");
		active=false;
		childUpdate=true;
		//norefresh=1;
	}
	
	@Override
	public boolean isRefreshNeeded() {
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.isRefreshNeeded: Start");
		boolean rc;
		rc=super.isRefreshNeeded();
		//PMS.dbg("rz_ResumeFolder.isRefreshNeeded: return "+rc);
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.isRefreshNeeded: End rc="+rc);
		return rc;
	}
	
	public void delAllFiles() {  //delete all target resumefiles
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.delAllFiles: Start");
		List<File> files= getFileList();
		for(File f : files) {
			f.delete();
		}
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.delAllFiles: End");
	}

	@Override
	public List<File> getFileList() {
		long tim1=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.getFileList: Start");

		//PMS.dbg("r_ResumeFolder.getFileList: filter="+filter+", srcPath="+srcPath+", srcHash="+srcHash);
		List<File> out = new ArrayList<File>();
		File[] rfiles=baseFolder.listFiles();
		//PMS.dbg("rfiles="+rfiles);
		String rname;
		if(!filter) {
			for (File file : rfiles) {
				if (file != null) {
					if(file.isFile() && file.getName().endsWith(PMS.rz_ResumeFileSuffix)) {
						out.add(file);
					}
					/*
					else if(file.getName().equals(rz_Resume.watched_path_name)) {
						out.add(file);
					}
					*/
				}
			}
		}
		else if(dlna_tg!=null && dlna_tg.sotype==SO_PLAYLIST) {
			for (DLNAResource ch : dlna_tg.getChildren()) {
				if(ch.isFolder()) continue;
				rname=rz_Resume.getResumeObjName(ch);
				//PMS.dbg("----- getFileList: rname="+rname);
				if(rname==null) continue;
				for(File file: rfiles) {
					//PMS.dbg("getFileList: fname="+file.getName());
					if(file.getName().contains(rname)) {
						out.add(file);
					}
				}
			}
		}
		else {
			//PMS.dbg("r_ResumeFolder.getFileList: baseFolder="+baseFolder);
			for (File file : rfiles) {
				if (file != null && file.isFile()) {
					//PMS.dbg("r_ResumeFolder.getFileList: file="+file);
					String name=file.getName();
					for(String hash: srcHash_list) {
						if(name.contains(hash)) {
							out.add(file);
						}
					}
				}
			}
		}
		if(PMS.rz_trace>0) {
			long tim2=System.currentTimeMillis();
			PMS.trace("rz_ResumeFolder.getFileList: End, count="
			+(out==null?"0":out.size())
			+", elapsed="+(tim2-tim1));
		}
		return out;
	}
	
	public void createDelFolders(boolean init) {
		//---- create virtualFolder for delete-action of resume files)
		long tim1=System.currentTimeMillis();
		if(PMS.rz_trace>0) PMS.trace("rz_ResumeFolder.createDelFolders: Start");

		if(getChildren().size()<=0) {
			//return;
		}
		
		//File will be searched primary in *.jar, secondry on real directoriy
		//File okmovie=new File("videos/action_success-512.mpg");
		//rz_PlayMetaFile pxm;
		rz_ResumeVirtualFolder vf;
		
		//---- for delete-resume action
		if(delFolder==null) {
			//delFolder=new rz_ResumeVirtualFolder("#- DELETE RESUMES -#");
			//delFolder=new VirtualFolder("#- RESUME DELETE -#",null);
			delFolder=new rz_ResumeVirtualFolder("#- RESUME DELETE -#",1);
			delFolder.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_BASE);
			delFolder.setResumeBase(PMS.rz_resume);
			delFolder.setSerialId(DLNAResource.MENU_ORD_RESUME_DEL);
			delFolder.sort_immune=0;
			VirtualFolder pa;
			if(menu_type>=2) {  // newType
				pa=getCtlFolder(true,1);
			}
			else {
				pa=getTranscodeFolder(true,-1);
			}
			pa.doSort=true;
			//pa.addChildInternal(delFolder);	
			//addChildInternal(delFolder);  //can't disp activate_icon
			pa.addChild(delFolder);
			if(init) {
				if(PMS.rz_trace>0) {
					long tim2=System.currentTimeMillis();
					PMS.trace("rz_ResumeFolder.createDelFolders: End, already inited-1 elapsed="+(tim2-tim1));
				}
				return;
			}
		}
		else if(init){
			if(PMS.rz_trace>0) {
				long tim2=System.currentTimeMillis();
				PMS.trace("rz_ResumeFolder.createDelFolders: End, already inited-2 elapsed="+(tim2-tim1));
			}
		 	return;
		}
		else {
			//PMS.dbg("rz_ResumeFolder.createDelFolders: getChildren().clear()");
			delFolder.activate(1);
			delFolder.getChildren().clear();
			delFolder.initLastChildrenId();
			delFolder.deleteMenus();
		}
		//---- create folder for delete-part-action
		VirtualFolder vfp=new VirtualFolder("#- RESUME DELETE MULTI -#",null);
		vfp.sort_immune=1;
		delFolder.addChild(vfp);	

		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE ALL -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_ALL);
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		//vf.sort_immune=1;
		//delFolder.addChild(vf);	
		vfp.addChild(vf);	
		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE OLD (Before 1 Week) -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_PART);
		vf.setParams(7);  // 7 days (1 week)
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		vfp.addChild(vf);	
		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE OLD (Before 1 Month) -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_PART);
		vf.setParams(30);// 30 days (1 month)
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		vfp.addChild(vf);	
		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE OLD (Before 3 Month) -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_PART);
		vf.setParams(90);
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		vfp.addChild(vf);	
		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE OLD (Before 6 Month) -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_PART);
		vf.setParams(180);
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		vfp.addChild(vf);	
		//---- create folder for delete-all-action
		vf=new rz_ResumeVirtualFolder("#- RESUME DELETE OLD (Before 1 Year) -#");
		vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_PART);
		vf.setParams(365);
		vf.setParentRF(this);
		vf.setParentVF(delFolder);
		vf.setResumeBase(PMS.rz_resume);
		vfp.addChild(vf);	
		
		//---- create folders for delete-single-action
		for(DLNAResource ch: getChildren()) {
			if(!ch.isFolder() && ch.rz_Metafile!=null) {
				//create folder for delete-action per resume-files
				vf=new rz_ResumeVirtualFolder("DEL- "+ch.getName());
				vf.setRfType(rz_ResumeVirtualFolder.RF_DEL_RESUME_SGL);
				vf.setSrcObj(ch);
				if(ch.meta_type!=2) {
					if(PMS.rz_debug>0) PMS.dbg("ResumeFolder: Something wrong! obj.meta_type!=2: force =2, obj="+ch.getName0());
					ch.meta_type=2;
				}
				vf.setParentRF(this);
				vf.setParentVF(delFolder);
				vf.setResumeBase(PMS.rz_resume);
				//vf.sort_immune=0;
				vf.setDispDate(ch.getDispDate());
				vf.rz_Metafile=ch.rz_Metafile;
				delFolder.addChild(vf);
				/*
				// create ok-movie under the folder-for-delete-action
				pxm=new rz_PlayMetaFile(okmovie,"OK", 0);
				vf.addChild(pxm);
				*/
			}
		}
		//PMS.dbg("createDelFolders: set doSort=true, sort_type="+delFolder.getSortType());
		delFolder.sort_enabled=true;
		delFolder.doSort=true;
		//dlnaListSort(delFolder.getChildren(),delFolder.getSortType());
		if(PMS.rz_trace>0) {
			long tim2=System.currentTimeMillis();
			PMS.trace("rz_ResumeFolder.createDelFolders: End, elapsed="+(tim2-tim1));
		}

	}
	
	private void refreshDelFolders() {
		//easyway but heavy
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.refreshDelFolders: Start");
		createDelFolders(false);
		if(PMS.rz_debug>1) PMS.dbg("rz_ResumeFolder.refreshDelFolders: End");
	}
	
	@Override
	public int getSortType() {	//regzamod add
		//PMS.dbg("rz_ResumeFolder.getSortType(): rz_MetaSortType="+rz_MetaSortType
		//	+", PMS.rz_resume_sort_type="+PMS.rz_resume_sort_type);
		if(rz_MetaSortType>=0) {
			return rz_MetaSortType;
		}
		else if(PMS.rz_resume_sort_type==PMS.SORT_DEFAULT) {
			return PMS.getConfiguration().getSortMethod();
		}
		else {
			return PMS.rz_resume_sort_type;
		}
	}
	/*
	public void informWatchedFolder (rz_WatchedFolder watched) {
		watched_base=watched;   // indicate watched folder is attached as my child folder
	}
	*/
}