/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// Menu for Keyword Selection
//-----------------------------------------------------------------------------
package net.pms.dlna;

//import java.io.*;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ProcessBuilder;
import java.lang.Process;

import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.MapFileConfiguration;
import net.pms.util.PMSUtil;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.dlna.rz_KwdGroup;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class rz_KeywordMenu {
	private static final Logger logger = LoggerFactory.getLogger(rz_KeywordMenu.class);
	private static PmsConfiguration config=PMS.getConfiguration();
	private boolean resolved=false;
	private String[] undo_buf= new String[10];
	private int undo_max= 10;
	private int undo_pos;
	private List<rz_KwdGroup> kwgList;
	private rz_KwdGroup cur_kwg;

	public DLNAResource base_folder,root_folder,gdef_folder,gcur_folder;
	public DLNAResource kwdlist_root;
	public String extruct_sep;		//separate characters for extruct_keyword
	public String extruct_sep2;		//separate characters for extruct_keyword (but reatain itsself)
	public String extruct_sep3;		//separate characters for extruct_keyword (but reatain itsself)
	public int btn_type;
	
	//global directives: position sensitive in .conf statements
	public boolean dir_entry_dpinput;
	public boolean dir_entry_dpipmd;
	public boolean dir_suffix_enabled=true;
	public String dir_suffix_str="/";
	public boolean dir_add_edit_menu;
	public int dir_add_edit_menu_sort=2;  //=1: force top, =2:force last in list
	public boolean dir_is_kwd_folder;
	public String dt_sc_str=""; //search string
	public boolean kwdlist_need_update;
	
	private String extruct_menu_path;  	//part_menu_path for option menu of extruct_keyword_list
	private String select_menu_path;  	//part_menu_path for option menu of select_keyword_list
	private DLNAResource extruct_menu;  //part_menu_path for option menu of extruct_keyword_list
	private DLNAResource select_menu;  	//part_menu_path for option menu of select_keyword_list
	String menuf;  //path of file KwdMenu.conf
	String listf;
	List<String> list_paths;  //path of file KwdList.conf
	String ErrMsg;
	
	int g_tab=8;
	int g_format;
	String g_encode;
	
	public rz_KeywordMenu(DLNAResource pa, String menuf, List<String> list_paths,int btn_type) {
		root_folder=pa;  
		kwdlist_root=pa; 
		this.menuf=menuf;
		this.list_paths=list_paths;
		this.btn_type=btn_type;

		if(PMS.rz_debug>1) PMS.dbg("rz_KeywordMenu: parent="+pa);
		//---- init group stat
		kwgList= new ArrayList<rz_KwdGroup>();
		rz_KwdGroup kwg=new rz_KwdGroup();
		kwgList.add(kwg);
		cur_kwg=kwg;

		loadKeywordMenu(menuf);
		loadKeywordList(list_paths);
		listf=list_paths.get(0);
	}
	
	public void undo_put(String data) {
		undo_pos=undo_pos+1;
		if(undo_pos<0) undo_pos=undo_max-1;
		else if(undo_pos>=undo_max) undo_pos=0;
		undo_buf[undo_pos]=data;
	}
	
	public String undo_get() {
		undo_pos=undo_pos-1;
		if(undo_pos<0) undo_pos=undo_max-1;
		else if(undo_pos>=undo_max) undo_pos=0;
		String ret=undo_buf[undo_pos];
		if(ret==null) ret="";
		return ret;
	}
	public String redo_get() {
		undo_pos=undo_pos+1;
		if(undo_pos<0) undo_pos=undo_max-1;
		else if(undo_pos>=undo_max) undo_pos=0;
		String ret=undo_buf[undo_pos];
		if(ret==null) ret="";
		return ret;
	}
	
	public DLNAResource getCurrentList() {
		return gcur_folder;
	}
	
	public DLNAResource getDefaultList() {
		return gdef_folder;
	}
	
	public void setCurToDefList() {
		if(gcur_folder==null) {
			setErrMsg("WARN: Current folder not found");
			return;
		}
		gdef_folder=gcur_folder;
		
	}
	
	public void addKeyword(String name,String[] cmd,int mode) {
		DLNAResource target=null;
		
		if(mode==0) {  //default folder
			target=gdef_folder;
		}
		else if(mode==1) {  //current folder
			target=gcur_folder;
		}
		if(target==null) {
			logger.warn("createKeywordMenuBtn: target_folder is NULL");
			setErrMsg("WARN: Target folder not found");
			return;
		}
		for(DLNAResource d : target.getChildren()) {
			if(d.getName0().equals(name)) {
				logger.warn("Same keyword already exisis: ignored");
				setErrMsg("WARN: Same keyword already exisis");
				return;
			}
		}
		rz_KeywordMenuBtn m1;
		m1= new rz_KeywordMenuBtn(name,cmd,0,dir_entry_dpinput,this);
		//m1.setMenuRoot(this);
		m1.sotype=DLNAResource.SO_KWM_KWD;
		m1.mflags|=DLNAResource.MF_KWM_LIST;
		m1.kwg=cur_kwg;
		//target.addChildInternal(m1);  //can't disp activate icon (when transcode type)
		target.addChild(m1);
		target.doSort=true;  // exec sort
	}
	
	public void delKeyword(String name,String[] cmd,int mode) {
		DLNAResource target=null,ch=null;
		
		if(mode==0) {  //default folder
			target=gdef_folder;
		}
		else if(mode==1) {  //current folder
			target=gcur_folder;
		}
		if(target==null) {
			logger.warn("createKeywordMenuBtn: target folder is NULL");
			setErrMsg("WARN: Target folder not found");
			return;
		}
		for(DLNAResource d : target.getChildren()) {
			if(d.getName0().equals(name)) {
				ch=d;
				break;
			}
		}
		if(ch==null) {
			logger.warn("createKeywordMenuBtn: target kwd not found");
			setErrMsg("WARN: Target Keyword not found");
		}
		target.getChildren().remove(ch);
	}
	
	public void AddOptMenu(DLNAResource target,int MenuType) {
		if(extruct_menu==null) {
			logger.warn("rz_KeywordMenu.AddOptMenu: extruct_menu not setted");
			return;
		}
		VirtualFolder vf=new VirtualFolder(extruct_menu.getName(), "");
		vf.rz_linkobj=extruct_menu;
		vf.mflags|=DLNAResource.MF_USE_LINKNAME;
		target.addChildInternal(vf);
	}
	
	public void getSelectOptMenu (DLNAResource target,int MenuType,int imtype) {
		if(select_menu==null) {
			logger.warn("getSelectOptMenu.AddOptMenu: select_menu not setted");
			return;
		}
		//PMS.dbg("getSelectOptMenu: target="+target.getName());
		VirtualFolder vf=new VirtualFolder(select_menu.getName(), "");
		vf.rz_linkobj=select_menu;
		vf.mflags|=DLNAResource.MF_USE_LINKNAME;
		vf.mflags|=DLNAResource.MF_KWM_IN_KWL;  //obj is kwd_menu in kwd_list
		vf.sort_immune=imtype; //sort always [pos=1:top,=2:last] in list
		target.addChildInternal(vf); 
	}
	
	public rz_KwdGroup getKwdGroupForExtruct() {
		for(rz_KwdGroup kg: kwgList) {
			if(kg.gname.equals("extruct")) {
				return kg;
			}
		}
		return kwgList.get(0);
	}
	
	public void resetErrMsg() {
		ErrMsg=null;
	}
	
	public void setErrMsg(String msg) {
		ErrMsg=msg;
	}
	
	public String getErrMsg() {
		String s=ErrMsg;
		ErrMsg=null;
		return s;
	}
	public String chkErrMsg() {
		return ErrMsg;
	}
	
	private void loadKeywordMenu(String fname) {
		int pos;
		String str,s;
		String encode="UTF-8";
		
		//PMS.dbg("==== loadKeywordMenu - loadKeywordList_P: start");

		try{
			//check encode
			BufferedReader br = new BufferedReader(new FileReader(new File(fname)));
			int lc=0;
			while((s=br.readLine())!= null && lc <10){
				lc++;
				s=s.trim();
				if(s.startsWith("#")) continue;
				if(s.startsWith("@")) {
					pos=s.indexOf("#");
					if(pos>0) {
						s=s.substring(0,pos-1);
						s=s.trim();
					}
				}
				else if(s.length()>0) {
					break;
				}
				if(s.startsWith("@encode=")) {
					encode=s.substring("@encode=".length());
				}
			}
			br.close();
			loadKeywordList_P(fname,root_folder,DLNAResource.MF_KWM_MENU,DLNAResource.MF_KWM_LIST,encode);
			
		}catch(FileNotFoundException e){
			logger.error("FileNotFoundException",e);
	    }catch(IOException e){
			logger.error("IOException",e);
		}
		//PMS.dbg("==== loadKeywordMenu - loadKeywordList_P: end");
	}
	
	//private static Process update_proc;  //process should be singleton
	
	public void reloadKeywordList() {
		long tim1 = System.currentTimeMillis(),tim2;
		if(PMS.rz_debug>1) PMS.dbg("reloadKeywordList: list_paths="+list_paths+", kwdlist_root="+kwdlist_root);
		if(kwdlist_root==null) return;
		
		//---- kick kwdUpdate prog
		int rc=-1;
		String prog=config.getRZ_kwdlist_update_prog();
		String mprog[]=PMSUtil.splitx1(prog,",");
		if(mprog!=null) {
			InputStream is=null;
			List<String> list = new ArrayList<String>();
			for (String s: mprog) {
				list.add(s);
			}
			list.add("--prof_dir");
			list.add(config.getProfileBaseDir());
			list.add("--temp_dir");
			list.add(config.getTempDir());
			
			ProcessBuilder pb = new ProcessBuilder(list);
			pb.redirectErrorStream(true); // merge stderr to stdout
			if(PMS.rz_debug>1) PMS.dbg("reloadKeywordList: exec kwdUpdate prog="+list);
			
			
			try {
				final Process update_proc=pb.start();
				//--------------------------------------------------------
				// for watchdog proc: 
				// what the java force fucking agry & redundant scripting
				//--------------------------------------------------------
				Runnable r = new Runnable() {
					/*
					Process tg_proc;
					public Runnable setParam(Process tg_proc) {
						//memory params from external 
						this.tg_proc=tg_proc;
						return this;
					}
					*/
					@Override
					public void run() {
						boolean interrupted=false;
						try {
							Thread.sleep(15000); //msec
						} catch (InterruptedException e) {
							if(PMS.rz_debug>1) PMS.dbg("rz_KeywordMenu.watchdog: interrupted");
							//may be OK: proc ended before timeout
							interrupted=true;
						}
						if(!interrupted) {  //timeouted
							if(PMS.rz_debug>1) PMS.dbg("rz_KeywordMenu.watchdog: timeout, kill tgproc");
							//tg_proc.destroy();  //terminate
							update_proc.destroy();  //terminate
						}
					}
				}; //.setParam(update_proc);  //need if update_proc not declared final
				
				Thread wdg = new Thread(r);
				wdg.start();
				//--------------------------------------------------------
				
				is= update_proc.getInputStream();
				if(is!=null) while(is.read() >= 0); //stderr merged to stdout: see redirectErrorStream(true);
				if(is!=null) is.close();
				wdg.interrupt();  //stop watchdog
				if(update_proc!=null) rc = update_proc.waitFor();
			} catch (IOException e) {
			} catch (InterruptedException e) {
			} finally {
			}
		}
		if(PMS.rz_debug>1) {
			tim2 = System.currentTimeMillis();
			PMS.dbg("reloadKeywordList: retrieve end, elapsed="+(tim2-tim1));
		}
		//---- update(re-load) kwd list
		if(rc==0) {
			if(PMS.rz_debug>1) PMS.dbg("reloadKeywordList: Update succeeded");
			kwdlist_root.getChildren().clear();
			if(dir_add_edit_menu) {
				//this child is also cleared: re-create
				getSelectOptMenu(kwdlist_root,0,dir_add_edit_menu_sort);
			}
			loadKeywordList(list_paths);
		}
		else {
			logger.warn("reloadKeywordList: Keywords Update failed rc="+rc);
			setErrMsg("Keywords Update failed rc="+rc);
		}
		if(PMS.rz_debug>1) {
			tim2 = System.currentTimeMillis();
			PMS.dbg("reloadKeywordList: All end, elapsed="+(tim2-tim1));
		}

	}
	
	public void loadKeywordList (List<String> paths) {
		for(String path : paths) {
			loadKeywordList_in(path);
		}
		
		//-------------------------------------------------------
		//Force kwd_menu in kwd_list that's sort_immune==2 to be really last in list.
		//followings do only for children direct under root
		//ToDO: should do recursive under subfolders 
		//-------------------------------------------------------
		ArrayList<DLNAResource> movelist= new ArrayList<DLNAResource>();
		
		//list up move targets
		if(kwdlist_root!=null) {
			for(DLNAResource d : kwdlist_root.getChildren()) {
				if((d.mflags&DLNAResource.MF_KWM_IN_KWL)!=0 && d.sort_immune==2) { 
					//obj is kwd_menu in kwd_list, and sort_immune==2 (force last in list)
					//kwdlist_root.getChildren().remove(d);  //don't delete now
					movelist.add(d);
				}
			}
		}
		// exec move
		for(DLNAResource d : movelist) {
			kwdlist_root.getChildren().remove(d);
			kwdlist_root.getChildren().add(d);
		}
	}
	
	public void loadKeywordList_in (String fname) {
		int pos;
		int format=2;
		String str,s;
		String encode="UTF-8";
		int tab=8;
		
		//PMS.dbg("loadKeywordList: Start fname="+fname);
		
		try{
			//check format
			BufferedReader br = new BufferedReader(new FileReader(new File(fname)));
			int lc=0;
			while((s=br.readLine())!= null && lc <10){
				lc++;
				s=s.trim();
				if(s.startsWith("#")) continue;
				//String[] mpara=PMSUtil.splitx1(str,",");
				if(s.startsWith("@")) {
					pos=s.indexOf("#");
					if(pos>0) {
						//logger.info("Line start with @ and has tail # , origin="+s);
						s=s.substring(0,pos-1);
						s=s.trim();
						//logger.info("Line start with @ and has tail # , trimed="+s);
					}
				}
				else if(s.length()>0) {
					break;
				}
				if(s.startsWith("@format=")) {
					String f=s.substring("@format=".length());
					if(f.equals("parametric")) {
						format=1;
					}
					else if(f.equals("tab-indent")) {
						format=2;
					}
				}
				else if(s.startsWith("@encode=")) {
					encode=s.substring("@encode=".length());
				}
				else if(s.startsWith("@tab=")) { 
					s=s.substring("@tab=".length());
					tab=Integer.parseInt(s.trim());
				}
			}
			br.close();
			if(format==0) {
				logger.warn("KwdList.conf name="+fname+": Illegal format, Ignored.");
				return;
			}
			g_format=format;
			g_encode=encode;
			g_tab=tab;
			
			//kwdListFormat=format;
			if(format==1) {  //parametric
				loadKeywordList_P(fname,kwdlist_root,DLNAResource.MF_KWM_LIST,DLNAResource.MF_KWM_MENU,encode);
			}
			else {  //tab-indented"
				loadKeywordList_S(fname,kwdlist_root,DLNAResource.MF_KWM_LIST,DLNAResource.MF_KWM_MENU,encode);
			}
		}catch(FileNotFoundException e){
			logger.error("FileNotFoundException",e);
	    }catch(IOException e){
			logger.error("IOException",e);
		}
	}
	
	// Simple indent type format
	private void loadKeywordList_S (String fname, DLNAResource root_folder, long mftype_on, long mftype_off, String encode) {
		DLNAResource cur_folder=root_folder,nobj;
		String str,line,strw;
		boolean first_call=true;
		int cur_lay=0;
		int cur_bias=0;
		BufferedReader br=null;
		
		if(PMS.rz_debug>1) PMS.dbg("loadKeywordList_S: Start file="+fname+", encode="+encode);
		
		try {
			FileInputStream fis=new FileInputStream(fname);
			if(encode==null) {
				br= new BufferedReader(new FileReader(new File(fname)));
			}
			else {
				br= new BufferedReader(new InputStreamReader(fis,encode));
			}
			while((line=br.readLine())!= null){
				nobj=null;
				int etype=1;  //entry type, =1:file,=2:folder
				String[] mpara=PMSUtil.splitx1(line,",");
				String ename=null;
				str=mpara[0];
				int hide=0,set_def=0;
				boolean dpinput=false,dpipmd=false,nosave=false;
				
				//-- ignored lines
				strw=line.trim();
				if(strw==null || strw.length()<=0) continue;
				if(strw.startsWith("#")) continue;
				
				//-- get entry layer
				int lay=getLay(str,first_call);
				if(first_call) first_call=false;
				str=str.trim();
				
				//-- get entry type/name
				if(str.startsWith("@")) { //commands
					//---- Special Command menu 
					if(str.startsWith("@cmd=")) {
						str=strw.substring(5);  //reload from whole line
						String mkwd[]= PMSUtil.splitx1(str,",");	//separate by comma, if not escaped
						if(PMS.rz_debug>1) PMS.dbg("loadKeywordList_S: found @cmd, mkwd="+mkwd);
						DLNAResource pa=getParentByLay(root_folder,cur_folder,cur_lay,lay);
						if(pa!=null) {
							rz_KeywordMenuBtn m1= new rz_KeywordMenuBtn(mkwd[0].trim(),mkwd,1,false,this);
							m1.sotype=DLNAResource.SO_KWM_CMD;
							m1.kwg=cur_kwg;
							m1.mflags &=~mftype_off;
							m1.mflags |=mftype_on;
							m1.sort_immune=2; //sort always last (ToDO: should indicate by cmd_args, instead of hard_coding)
							pa.addChild(m1);
						}
						else {
							logger.warn("menu folder not defined");
						}
					}
					continue;
				}
				else if(str.endsWith("/") && !str.endsWith("\\/")) {
					etype=2; //folder
					//ename=str.substring(0,str.length()-1).replaceAll("\\\\@","@").replaceAll("\\\\/","/");;
					ename=str.substring(0,str.length()-1).replace("\\@","@").replace("\\/","/");;
					int i=0;
					for(String kwd : mpara) {
						if(i++ <=0) continue;  // it's pathname
						kwd=kwd.trim();
						if(kwd.equals("cmd_hide")) hide=1;
						else if(kwd.equals("cmd_dsp")) dpinput=true;
						else if(kwd.equals("cmd_dpipmd")) dpipmd=true;
						else if(kwd.equals("cmd_setdef")) set_def=1;//set as default folder for new keyword to save
						else if(kwd.equals("cmd_nosave")) nosave=true;
					}
				}
				else {
					etype=1; //file: keywords
					//ename=str.replaceAll("\\\\@","@").replaceAll("\\\\/","/");
				}
				//PMS.dbg("loadKeywordList_S: valid line="+line+", lay="+lay+", type="+etype+", name="+ename);
					
				DLNAResource pa=getParentByLay(root_folder,cur_folder,cur_lay,lay);
				DLNAResource vf=null,vf1=null;
				if(pa!=null) {
					if(etype==1) { //file
						for(String e :mpara) {
							//e=e.trim().replaceAll("\\\\@","@").replaceAll("\\\\/","/");
							e=e.trim().replace("\\@","@").replace("\\/","/");
							vf1=getChildByName(pa,e);
							if(vf1==null) {
								vf=new rz_KeywordMenuBtn(e,null,0,false,this);
								vf.sotype=DLNAResource.SO_KWM_KWD;
								//((rz_KeywordMenuBtn)vf).setMenuRoot(this);
								((rz_KeywordMenuBtn)vf).kwg=cur_kwg;
								pa.addChild(vf);
								nobj=vf;
							}
							else {
								logger.warn("Keyword Already exists name="+vf1.getName());
								continue;
							}
						}
					}
					else {  //folder
						vf1=getChildByName(pa,ename);
						if(pa==root_folder) {
							//PMS.dbg("loadKeywordList_S: search folder name="+ename+", under pa="+pa+",result="+vf1);
						}
						if(vf1==null) {
							//vf=new rz_KwdMenuFolder(ename,mpara,false,false,false,null,false);
							vf=new rz_KwdMenuFolder(ename,mpara,dpinput,dpipmd,dir_suffix_enabled,dir_suffix_str,dir_is_kwd_folder,this);
							
							//((rz_KwdMenuFolder)vf).setMenuRoot(this);
							((rz_KwdMenuFolder)vf).kwg=cur_kwg;
							if(nosave) {
								if(PMS.rz_debug>1) PMS.dbg("loadKeywordList_S: nosave found, name="+ename);
								((rz_KwdMenuFolder)vf).nosave=nosave;
							}
							if(dir_add_edit_menu) {
								getSelectOptMenu(vf,0,dir_add_edit_menu_sort);
							}
							pa.addChildInternal(vf);
							nobj=vf;
						}
						else if(etype==2 && vf1!=null && vf1.sotype==DLNAResource.SO_KWM_DIR) {
							//existing folder re-selected
							vf=vf1;
						}
						else {
							logger.warn("Folder Already exists name="+vf1.getName());
							continue;
						}
					}
					//--- maint. currents
					DLNAResource cur_folder_sv=cur_folder;
					if(etype==2) {
						cur_folder=vf;
						if(set_def==1) {
							gdef_folder=cur_folder;
						}
					}
					else {
						cur_folder=pa;
					}
					if(cur_folder_sv!=cur_folder) {
						cur_lay=0;
						pa=cur_folder;
						while(pa!=null && pa!=root_folder) {
							pa=pa.getParent();
							cur_lay++;
						}
					}
				}
				else {
					logger.warn("parent folder not found");
					continue;
				}
				if(nobj!=null) {
					pa=PMSUtil.getDirectChild(root_folder,nobj);
					if(pa!=null) {
						//set sighn to root objs of keyword menu (under WEB_QS) 
						pa.mflags &=~mftype_off;
						pa.mflags |=mftype_on;
					}
				}
			}
			br.close();
		}catch(FileNotFoundException e){
			logger.error("FileNotFoundException",e);
	    }catch(IOException e){
			logger.error("IOException",e);
		}
	}
	
	int lay_bias=0;
	private int getLay(String str, boolean first_call) {
		//int g_tab=4;
		int sc=0;
		char[] cc=str.toCharArray();
		for(char c: cc) {
			if(c==' ') sc++;
			else if(c=='\t') sc+=g_tab;
			//else if(c=='@') sc+=2; //kanji-space
			else break;
		}
		if(first_call) lay_bias=sc;  //extra tabs
		sc=sc-lay_bias;  //ignore extra tabs
		return sc/g_tab;
	}
	
	private DLNAResource getChildByName(DLNAResource pa, String name) {
		for(DLNAResource d : pa.getChildren()) {
			if(d.getName0().equals(name)) {
				return d;
			}
		}
		return null;
	}
		
	private DLNAResource getParentByLay(DLNAResource root_folder, DLNAResource cur_folder,int cur_lay, int lay) {
		DLNAResource pa=null;
		if(lay>cur_lay) {
			pa=cur_folder;
		}
		else {
			pa=cur_folder;
			for(int i=0;i<cur_lay-lay;i++){
				pa=pa.getParent();
				if(pa==root_folder) {
					break;
				}
			}
		}
		return pa;
	}

	// parametric type format (i.e. dir=.., kwd=.. )
	private void loadKeywordList_P (String fname, DLNAResource root_folder, long mftype_on, long mftype_off,String encode) {
		int pos,pos2,pos_next;
		String[] sep={","};
		String cur_path="";
		DLNAResource cur_folder=root_folder,pa,nobj;
		String path,str;
		rz_KeywordMenuBtn m1;
		BufferedReader br=null;
		
		if(PMS.rz_debug>1) PMS.dbg("loadKeywordList_P: Start file="+fname+", encode="+encode);
		try{
			FileInputStream fis=new FileInputStream(fname);
			if(encode==null) {
				br= new BufferedReader(new FileReader(new File(fname)));
			}
			else {
				br= new BufferedReader(new InputStreamReader(fis,encode));
			}
			while((str=br.readLine())!= null){
				//PMS.dbg("cur_path="+cur_path+", cur_folder="+cur_folder);
				if(cur_folder==null) {
					cur_folder=root_folder;
					cur_path="";
				}
				nobj=null;
				str=str.trim();
				if(str.startsWith("#")) continue;
				//PMS.dbg("get line="+str);
				//---- Menu folder 
				if(str.startsWith("dir_entry_dpinput=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_entry_dpinput=".length()).trim();
					if(str.equals("true")) {
						dir_entry_dpinput=true;
					}
					else if(str.equals("false")) {
						dir_entry_dpinput=false;
					}
				}
				else if(str.startsWith("dir_add_edit_menu=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_add_edit_menu=".length()).trim();
					if(str.equals("true")) {
						dir_add_edit_menu=true;
					}
					else if(str.equals("false")) {
						dir_add_edit_menu=false;
					}
				}
				else if(str.startsWith("dir_add_edit_menu_sort=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_add_edit_menu_sort=".length()).trim();
					pos=str.indexOf("#");
					if(pos>=0) {
						str=str.substring(0,pos).trim();
					}
					if(str.length()>0) {
						try {
							dir_add_edit_menu_sort=Integer.parseInt(str);
						} catch (NumberFormatException e) {
							logger.warn("rz_KeywordMenu: dir_add_edit_menu_sort value error="+e.getMessage());
						} 
					}
				}
				else if(str.startsWith("dir_suffix_enabled=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_suffix_enabled=".length()).trim();
					if(str.equals("true")) {
						dir_suffix_enabled=true;
					}
					else if(str.equals("false")) {
						dir_suffix_enabled=false;
					}
					//PMS.dbg("loadKeyword: dir_suffix_enabled="+dir_suffix_enabled);
				}
				else if(str.startsWith("dir_is_kwd_folder=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_is_kwd_folder=".length()).trim();
					if(str.equals("true")) {
						dir_is_kwd_folder=true;
					}
					else if(str.equals("false")) {
						dir_is_kwd_folder=false;
					}
					//PMS.dbg("loadKeyword: dir_is_kwd_folder="+dir_suffix_enabled);
				}
				else if(str.startsWith("dir_suffix_str=")) {
					//value is changeable within parse sequence
					str=str.substring("dir_suffix_str=".length()).trim();
					dir_suffix_str=str;
					//PMS.dbg("loadKeyword: dir_suffix_str='"+dir_suffix_str+"'");
				}
				else if(str.startsWith("extruct_sep=")) {
					str=str.substring("extruct_sep=".length()).trim();
					if(str!=null) {
						if(extruct_sep==null) {
							extruct_sep=str;
						}
						else {
							extruct_sep +=str;
						}
					}
				}
				else if(str.startsWith("extruct_sep2=")) {
					str=str.substring("extruct_sep2=".length()).trim();
					if(str!=null) {
						if(extruct_sep2==null) {
							extruct_sep2=str;
						}
						else {
							extruct_sep2 +=str;
						}
					}
				}
				else if(str.startsWith("extruct_sep3=")) {
					str=str.substring("extruct_sep3=".length()).trim();
					if(str!=null) {
						if(extruct_sep3==null) {
							extruct_sep3=str;
						}
						else {
							extruct_sep3 +=str;
						}
					}
				}
				else if(str.startsWith("extruct_menu_path=")) { //option menu for extruct_keyword_list
					str=str.substring("extruct_menu_path=".length()).trim();
					if(str!=null) {
						extruct_menu_path=str;
						if(extruct_menu_path!=null) {
							extruct_menu=PMSUtil.searchDLNApath(root_folder,extruct_menu_path,"/");
						}
					}
				}
				else if(str.startsWith("select_menu_path=")) { //option menu for select_keyword_list
					str=str.substring("select_menu_path=".length()).trim();
					if(str!=null) {
						select_menu_path=str;
						if(select_menu_path!=null) {
							select_menu=PMSUtil.searchDLNApath(root_folder,select_menu_path,"/");
						}
					}
				}
				else if(str.startsWith("set_kwdlist_root=")) {
					str=str.substring("set_kwdlist_root=".length()).trim();
					pa=PMSUtil.searchDLNApath(root_folder,str,"/");
					if(pa!=null) {
						kwdlist_root=pa;
					}
				}
				else if(str.startsWith("set_group=")) {
					str=str.substring("set_group=".length()).trim();
					int found=0;
					for(rz_KwdGroup kg: kwgList) {
						if(kg.gname.equals(str)) {
							found=1;
							cur_kwg=kg;
							break;
						}
					}
					if(found==0) {
						rz_KwdGroup kg=new rz_KwdGroup();
						kg.gname=str;
						kwgList.add(kg);
						cur_kwg=kg;
					}
				}
				else if(str.startsWith("set_group_input_mode=")) {
					str=str.substring("set_group_input_mode=".length()).trim();
					if(str.equals("append")) {
						cur_kwg.input_mode=rz_KwdGroup.IPMD_APPEND;
					}
					else if(str.equals("append_plus")) {
						cur_kwg.input_mode=rz_KwdGroup.IPMD_APPEND_PLUS;
					}
					else if(str.equals("overwrite")) {
						cur_kwg.input_mode=rz_KwdGroup.IPMD_OVERWRITE;
					}
					else {
						logger.warn("unknown input_mode="+str);
					}
				}
				else if(str.startsWith("lnk=")) {
					DLNAResource vf,m2;
					boolean dpinput=false,dpipmd=false;
					str=str.substring("lnk=".length()).trim();
					String mkwd[]= PMSUtil.splitx1(str,",");	//separate by comma, if not escaped
					int i=0;
					for(String kwd : mkwd) {
						if(i++ <=1) continue;  // it's name,link path
						kwd=kwd.trim();
						if(kwd.equals("cmd_dsp")) dpinput=true;
						else if(kwd.equals("cmd_dpipmd")) dpipmd=true;
					}
					vf=new rz_KwdMenuFolder(mkwd[0],mkwd,dpinput,dpipmd,dir_suffix_enabled,dir_suffix_str,dir_is_kwd_folder,this);
					m2=PMSUtil.searchDLNApath(root_folder,mkwd[1].trim(),"/");
					vf.mflags|=DLNAResource.MF_USE_LINKNAME;
					vf.rz_linkobj=m2;
					((rz_KwdMenuFolder)vf).kwg=cur_kwg;
					//((rz_KwdMenuFolder)vf).setMenuRoot(this);
					cur_folder.addChildInternal(vf);
				}
				else if(str.startsWith("dir=")) {
					//---- get path
					int set_def=0;
					int hide=0;
					boolean nosave=false;
					boolean dpinput=false,dpipmd=false;
					str=str.substring(4).trim();
					String mkwd[]= PMSUtil.splitx1(str,",");	//separate by comma, if not escaped
					int i=0;
					for(String kwd : mkwd) {
						if(i++ <=0) continue;  // it's pathname
						kwd=kwd.trim();
						if(kwd.equals("cmd_hide")) hide=1;
						else if(kwd.equals("cmd_dsp")) dpinput=true;
						else if(kwd.equals("cmd_dpipmd")) dpipmd=true;
						else if(kwd.equals("cmd_setdef")) set_def=1;//set as default folder for new keyword to save
						else if(kwd.equals("cmd_setdef")) nosave=true;
					}
					path=mkwd[0].trim();
					//path.replaceAll("\\,",",");
					path.replace("\\,",",");
					if(path.startsWith("/")) {  //full pathname
						cur_path=path;
					}
					else {	//relative pathname
						if(path.startsWith("../")) {
							pos=cur_path.lastIndexOf("/");
							if(pos>=0) {
								cur_path=cur_path.substring(0,pos);
							}
							if(path.length()<=3) path="";
							else path=path.substring(3);
						}
						if(path.length()>0){
							cur_path=cur_path+"/"+path;
						}
					}
					if(cur_path.equals("/")) cur_path="";
					if(true || mkwd.length>1) { 
						//---- get/create menu_folder of cur_path (create if not exist)
						//use Special VirtualFolder 
						//PMS.dbg("Dinput==1, original cur_path="+cur_path);
						String[] mpath= PMSUtil.splitx1(cur_path,"/");
						String pathw="";
						String dname="";
						for(int j=0;j<mpath.length;j++) {
							//PMS.dbg("Dinput==1, mpath="+mpath[j]);
							if(mpath[j].length()==0) continue;
							if(j<mpath.length-1)
								pathw = pathw +"/"+mpath[j];
							else
								dname=mpath[j];
						}
						//PMS.dbg("dir: cur_path="+cur_path+", path_part="+pathw+", name_part="+dname);
						if(pathw.length()==0) cur_folder=root_folder;
						else cur_folder=PMSUtil.createDLNApath(root_folder,pathw,"/");
						if(cur_folder!=null && dname.length()>0) {
							DLNAResource vf=null;
							for(DLNAResource d: cur_folder.getChildren()) {
								if(d.sotype==DLNAResource.SO_KWM_DIR && d.getName0().equals(dname)) {
									vf=d;
									break;
								}
							}
							if(vf==null) { 
								//PMS.dbg("dir: new create, path="+pathw+", dname="+dname+", dir_add_edit_menu="+dir_add_edit_menu);
								vf=new rz_KwdMenuFolder(dname,mkwd,dpinput,dpipmd,dir_suffix_enabled,dir_suffix_str,dir_is_kwd_folder,this);
								//((rz_KwdMenuFolder)vf).setMenuRoot(this);
								((rz_KwdMenuFolder)vf).kwg=cur_kwg;
								if(nosave) {
									if(PMS.rz_debug>1) PMS.dbg("loadKeywordList_S: nosave found, name="+dname);
									((rz_KwdMenuFolder)vf).nosave=nosave;
								}
								cur_folder.addChildInternal(vf);
								if(dir_add_edit_menu) {
									getSelectOptMenu(vf,0,dir_add_edit_menu_sort);
								}
							}
							cur_folder=vf;
						}
					}
					else {
						//---- get/create menu_folder of cur_path (create if not exist)
						//use Normal VirtualFolder 
						//PMS.dbg("cur_path="+cur_path);
						cur_folder=PMSUtil.createDLNApath(root_folder,cur_path,"/");
					}
					if(set_def==1) {
						gdef_folder=cur_folder;
					}
					if(hide==1 && cur_folder!=null) {
						cur_folder.mflags|= DLNAResource.MF_HIDE;
					}
					nobj=cur_folder;
					cur_folder.sotype=DLNAResource.SO_KWM_DIR;
					//PMS.dbg("--> set cur_path="+cur_path);
				}
				//---- Keyword menues 
				else if(str.startsWith("kwd=")) {
					//rz_KeywordMenuBtn m1;
					str=str.substring(4).trim();
					String mkwd[]=str.split(",");  
					//PMS.dbg("kwd="+str);
					if(cur_folder!=null) {
						for(String kwd : mkwd) {
							//PMS.dbg("rz_keywordMenuBtn create Start kwd name="+kwd.trim()+",menuRoot="+this);
							m1= new rz_KeywordMenuBtn(kwd.trim(),null,0,dir_entry_dpinput,this);
							//PMS.dbg("rz_keywordMenuBtn create End kwd name="+kwd.trim()+", menuRoot="+m1.menuRoot);
							//m1.setMenuRoot(this);
							m1.sotype=DLNAResource.SO_KWM_KWD;
							m1.kwg=cur_kwg;
							cur_folder.addChild(m1);
							//PMS.dbg("--> set keyword="+kwd);
							nobj=m1;
							if(m1.menuRoot==null) {
								PMS.dbg("rz_keywordMenu kwd.menuRoot==null, name="+m1.getName());
							}
						}
					}
					else {
						logger.warn("menu folder not defined");
					}
				}
				//---- Special Command menu 
				else if(str.startsWith("cmd=")) {
					//rz_KeywordMenuBtn m1;
					str=str.substring(4).trim();
					//String mkwd[]=str.split(",");  
					//String mkwd[]=str.split("(?!\\\\),"); 	//separate by comma, if not escaped
					String mkwd[]= PMSUtil.splitx1(str,",");	//separate by comma, if not escaped
					int i=0;
					for(String kwd : mkwd) {
						//PMS.dbg("mkwd["+i+"]="+kwd);
						i++;
					}
					if(cur_folder!=null) {
						m1= new rz_KeywordMenuBtn(mkwd[0].trim(),mkwd,1,false,this);
						//m1.setMenuRoot(this);
						m1.sotype=DLNAResource.SO_KWM_CMD;
						m1.kwg=cur_kwg;
						cur_folder.addChild(m1);
						nobj=m1;
					}
					else {
						logger.warn("menu folder not defined");
					}
				}
				//---- disp input 
				else if(str.startsWith("dsp=")) {
					//PMS.dbg("dsp, cur_path="+cur_path+", cur_folder="+cur_folder);
					if(cur_folder!=null) {
						//rz_KeywordMenuBtn m1;
						str=str.substring(4).trim();
						m1= new rz_KeywordMenuBtn(str,null,2,true,this);
						//m1.setMenuRoot(this);
						m1.sotype=DLNAResource.SO_KWM_DSP;
						m1.kwg=cur_kwg;
						cur_folder.addChild(m1);
						nobj=m1;
					}
				}
				if(nobj!=null) {
					pa=PMSUtil.getDirectChild(root_folder,nobj);
					if(pa!=null) {
						//set sighn to root objs of keyword menu (under WEB_QS) 
						pa.mflags &=~mftype_off;
						pa.mflags |=mftype_on;
					}
				}
			}
			br.close();
		}catch(FileNotFoundException e){
			logger.error("FileNotFoundException",e);
	    }catch(IOException e){
			logger.error("IOException",e);
		}
		/* moved upper: exec immediately
		if(extruct_menu_path!=null) {
			extruct_menu=PMSUtil.searchDLNApath(root_folder,extruct_menu_path,"/");
		}
		if(select_menu_path!=null) {
			select_menu=PMSUtil.searchDLNApath(root_folder,select_menu_path,"/");
		}
		*/
	}
	
	public void saveKeywordList(int mode) {
		int format=0;
		if(mode>=0 || mode<=2) {
			format=mode;
		}
		else if(mode==-1) {  //alternative format
			format=g_format;
			if(format==1) format=2;
			else if(format==2) format=1;
		}
		saveKeywordList_in(format);
	}
	
	private void saveKeywordList_in(int fmt) {
		PrintWriter pw=null;
		PMS.dbg("saveKeywordList: start, save_file="+listf+", format="+fmt+", encode="+g_encode);
		
		//---- save KwdList.conf
		File f=new File(listf);
		try{
			pw = new PrintWriter(f,g_encode);
			if(fmt==1) {
				pw.println("#------------------------------------------------------------------");
				pw.println("@KeywordList");
				pw.println("@format=parametric    #{tab-indent|parametric}");
				pw.println("@encode="+g_encode+"         #{UTF-8|MS932|etc.}");
				pw.println("#------------------------------------------------------------------");
			}
			else {
				pw.println("#------------------------------------------------------------------");
				pw.println("@KeywordList");
				pw.println("@format=tab-indent    #{tab-indent|parametric}");
				pw.println("@encode="+g_encode+"         #{UTF-8|MS932|etc.}");
				pw.println("@tab="+g_tab);
				pw.println("# character '@,/' must be escaped by '\\', to use literally");
				pw.println("#------------------------------------------------------------------");
			}
			pw.println("");
			svKwdList(kwdlist_root,0,pw,DLNAResource.MF_KWM_LIST,fmt);
			pw.close();
		}catch(FileNotFoundException e){
			logger.error("FileNotFoundException",e);
	    }catch(IOException e){
			logger.error("IOException",e);
		}
		
		//---- save KwdMenu.conf
		if(false) {  //test
			f=new File(menuf);
			try{
				pw = new PrintWriter(f,"UTF-8");
				svKwdList(kwdlist_root,0,pw,DLNAResource.MF_KWM_MENU,fmt);
				pw.close();
			}catch(FileNotFoundException e){
				logger.error("FileNotFoundException",e);
		    }catch(IOException e){
				logger.error("IOException",e);
			}
		}
	}

	private void svKwdList(DLNAResource pa, int lay, PrintWriter pw, long mflags,int fmt) {
		String tab0="",tab,name;
		int start=0;
		
		if(fmt==1) { //parametric
			for(int i=1; i<lay; i++) {
				//tab0 += "  ";
				tab0 += "\t";
			}
			//tab=tab0+ "  ";
			tab=tab0+ "\t";
		}
		else {//tab-indent
			for(int i=1; i<lay; i++) {
				tab0 += "\t";
			}
			tab=tab0+ "\t";
		}
		if(lay==0) tab=tab0;
		else if(lay>0) {
			int opts=0;
			if(pa.sotype==DLNAResource.SO_KWM_DIR) {
				name=pa.getName0();
				name=name.replace("@","\\@").replace("/","\\/").replace(",","\\,");
				if(fmt==1) {  //parametric
					if(lay==1) pw.print(tab0+"dir=/"+name);
					else pw.print(tab0+"dir="+name);
				}
				else { //tab-indent
					//name=name.replaceAll("@","\\\\@").replaceAll("/","\\\\/").replaceAll(",","\\\\,");
					pw.print(tab0+name+"/");
				}
				opts=1;
			}
			if(opts>0) {
				String[] opt=getKwdOpt(pa);
				if(opt!=null) {
					int i=0;
					for(String s: opt) {
						if(i++ >0) pw.print(","+s);
					}
				}
				pw.print("\n");
			}

		}
		
		if((pa instanceof rz_KwdMenuFolder) && ((rz_KwdMenuFolder)pa).nosave ) {
			if(PMS.rz_debug>1) PMS.dbg("svKwdList: kwd folder.nosave=true, name="+pa.getName0());
			return;
		}
		
		for(DLNAResource ch: pa.getChildren()) {
			if(lay==0 && (ch.mflags&mflags)==0) continue;  //not keyword list objects
			int opts=0;
			if(ch.sotype==DLNAResource.SO_KWM_DIR) {
				svKwdList(ch,lay+1,pw,mflags,fmt);
			}
			else if(ch.sotype==DLNAResource.SO_KWM_KWD) {
				if(fmt==1) pw.print(tab+"kwd=");
				else pw.print(tab);
				opts=1;
			}
			else if(ch.sotype==DLNAResource.SO_KWM_DSP) {
				if(fmt==1) pw.print(tab+"dsp=");
				else pw.print(tab+"@dsp=");
				opts=1;
			}
			else if(ch.sotype==DLNAResource.SO_KWM_CMD) {
				if(fmt==1) pw.print(tab0+"cmd=");
				else pw.print(tab0+"@cmd=");
				opts=1;
			}
			if(opts>0) {
				String[] opt=getKwdOpt(ch);
				if(opt!=null) {
					int i=0;
					for(String s: opt) {
						if(i==0) pw.print(s);
						else pw.print(","+s);
						i++;
					}
				}
				else {
					name=ch.getName0();
					if(fmt==2) {
						//name=name.replaceAll("@","\\\\@").replaceAll("/","\\\\/").replaceAll(",","\\\\,");
						name=name.replace("@","\\@").replace("/","\\/").replace(",","\\,");
					}
					pw.print(name);
				}
				pw.print("\n");
			}
		}
		if(fmt==1 && lay>0) pw.println(tab0+"dir=../");
	}
		
	String[] getKwdOpt(DLNAResource dlna) {
		if(dlna instanceof rz_KeywordMenuBtn) {
			rz_KeywordMenuBtn obj=(rz_KeywordMenuBtn)dlna;
			return obj.cmd;
		}
		else if(dlna instanceof rz_KwdMenuFolder) {
			rz_KwdMenuFolder obj=(rz_KwdMenuFolder)dlna;
			return obj.cmd;
		}
		return null;
	}

	public static class rz_KwdMenuFolder extends VirtualFolder {
		boolean dpinput;
		boolean dpipmd;
		boolean dir_suffix_enabled;
		boolean dir_is_kwd_folder;
		String dir_suffix_str;
		String name,dpname;
		String[] cmd;
		private rz_KeywordMenu menuRoot;
		public rz_KwdGroup kwg;
		public boolean nosave;
		
		//private long timer1;
		private long prevCallTime=0;
		
		public rz_KwdMenuFolder(String name,String[] cmd,
			boolean dpinput,boolean dpipmd, boolean dir_suffix_enabled, String dir_suffix_str, 
			boolean dir_is_kwd_folder,rz_KeywordMenu menuRoot) {
				
			super(name,null);  //should call, if params not equals to super constructor
			this.dpinput=dpinput;	//use current value;
			this.dpipmd=dpipmd;	//use current value;
			this.dir_suffix_enabled=dir_suffix_enabled;  //use current value;
			this.dir_suffix_str=dir_suffix_str;  //use current value;
			this.dir_is_kwd_folder=dir_is_kwd_folder;  //use current value;
			this.cmd= cmd;
			this.name= name;
			this.menuRoot= menuRoot;
			this.sotype=DLNAResource.SO_KWM_DIR;
			
			if(menuRoot==null) {
				logger.error("rz_KwdMenuFolder: menuRoot=null, name="+name);
			}
			
			if(dir_suffix_enabled) {
				dpname=name+dir_suffix_str;
			}
			else {
				dpname=name;
			}
		}
		
		
		public void setMenuRoot(rz_KeywordMenu obj) {
			menuRoot=obj;
		}
		
		@Override
		public int activate(int type) {
			//called when folder open
			long tim1 = System.currentTimeMillis();
			if(type!=1 || (tim1-prevCallTime) <1000) { 
				return 0;
			}
			prevCallTime=tim1;
			//if(dir_is_kwd_folder) {  //i am keyword list folder, i.e. not other misc folders
			if(dir_is_kwd_folder) {  //i am keyword list folder, i.e. not other misc folders
				menuRoot.gcur_folder=this;  // may be used as target keyword folder
				if(this==menuRoot.kwdlist_root) {  // I am root of kwdlist
					if(menuRoot.kwdlist_need_update==true) {
						if(PMS.rz_debug>1) {
							PMS.dbg("rz_KeywordMenu.rz_KwdMenuFolder: I'm root, name="+getName()
								+", kwdlist_need_update=true --> exec update");
						}
						menuRoot.reloadKeywordList();  //re-create me!
						menuRoot.kwdlist_need_update=false;
					}
				}
			}
			return 0;
		}

		@Override
		public String getName () {
			if(dpinput) {  //disp input field
				return dpname+" ["+menuRoot.dt_sc_str+"]";
			}
			else if(dpipmd) {
				String sfx="";
				if(kwg.input_mode==rz_KwdGroup.IPMD_APPEND) {
					sfx="Append";
				}
				else if(kwg.input_mode==rz_KwdGroup.IPMD_APPEND_PLUS) {
					sfx="Append(+)";
				}
				else if(kwg.input_mode==rz_KwdGroup.IPMD_OVERWRITE) {
					sfx="OverWrite";
				}
				else {
					sfx="Unknown";
				}
				return dpname+" ["+sfx+"]";
			}
			else {
				return dpname;
			}
		}
		
		@Override
		public String getName0() {
			return name;
		}
		
	}
	
}