/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
//-----------------------------------------------------------------------------
// Menu for Keyword Extruct
//-----------------------------------------------------------------------------
package net.pms.dlna;

//import java.io.*;
import java.io.File;
import java.util.Arrays;
import java.util.ArrayList;
import java.util.List;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import net.pms.PMS;
import net.pms.configuration.PmsConfiguration;
import net.pms.configuration.RendererConfiguration;
import net.pms.configuration.MapFileConfiguration;
import net.pms.dlna.virtual.VirtualFolder;
import net.pms.dlna.rz_KwdGroup;
import net.pms.util.PMSUtil;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class rz_KeyExtructMenu extends VirtualFolder {
	private static final Logger logger = LoggerFactory.getLogger(rz_KeyExtructMenu.class);
	private boolean resolved=false;
	private DLNAResource target;
	private rz_KeywordMenu kwm;
	private long prevCallTime=0;
	private char[] extruct_ct = {  //separate characters for keyword extruct
		//2byte(kanji) separators
		0x3000,0x3001,0xFF08,0xFF09,0xFF3B,0xFF3D,0xFF5B,0xFF5D,
		0x3008,0x3009,0x300A,0x300B,0x300C,0x300D,0x300E,0x300F,0x3010,0x3011,0x3014,0x3015,
		//1byte separators
		0x0020	,0x002C	,0x005B	,0x005D	,0x0028	,0x0029,
	};
	private char[] extruct_ct2 = null;
	private char[] extruct_ct3 = null;

	public rz_KeyExtructMenu(String name, String thumbnailIcon) {
		super(name, thumbnailIcon);
	}
	
	public void setOpt(DLNAResource target, rz_KeywordMenu kwm) {
		this.target=target;     //target folder to extruct
		this.kwm=kwm;  //keyword menu controller
	}
	
	@Override
	public int activate(int type) {
		//PMS.dbg("rz_KeyExtructMenu.activate: called");
		
		long tim1 = System.currentTimeMillis();
		if(type!=1 || (tim1-prevCallTime) <1000) { 
			// type=1: indicate Folder Open action from renderer, called 2 times on one open why??
			return 0;
		}
		prevCallTime=tim1;
		if(target.getLastRefreshTime()>getLastRefreshTime()) {
			//PMS.dbg("rz_KeyExtructMenu.activate: target updated , need re-resolve");
			resolved=false;
		}
		resolve_in();
		return 0;
	}

	public synchronized void resolve() {
		//PMS.dbg("rz_KeyExtructMenu.resolve: called");
		//resolve_in();
	}
	
	private void resolve_in() {
		if(kwm==null) return;  //something wrong
		if(!resolved) {
			getChildren().clear();
			//PMS.dbg("rz_KeyExtructMenu: Use external(defined in keyword.conf) extruct_sep ="+kwm.extruct_sep);
			if(kwm.extruct_sep!=null) extruct_ct=kwm.extruct_sep.toCharArray();
			if(kwm.extruct_sep2!=null) extruct_ct2=kwm.extruct_sep2.toCharArray();
			if(kwm.extruct_sep3!=null) extruct_ct3=kwm.extruct_sep3.toCharArray();
			createKeyExtructMenu(target);
			setLastmodified(System.currentTimeMillis()); //memory created time of me
		}
		resolved=true;
	}
	
	private void createKeyExtructMenu(DLNAResource tpa) {
		//---- Create KeywordEditMenu 
		kwm.AddOptMenu(this,0);
		rz_KwdGroup kwg=kwm.getKwdGroupForExtruct();
		
		//---- Create Child menues according to tpa.childlen
		for(DLNAResource ch: tpa.getChildren()) {
			if(ch.isFolder()) continue; 
			String name0=ch.getName();
			VirtualFolder m1=new VirtualFolder(name0, null);
			kwm.AddOptMenu(m1,0);
			addChildInternal(m1);
			String[] wds=extructWords(name0);
			for(String wd : wds) {
				rz_KeywordMenuBtn m2=  new rz_KeywordMenuBtn(wd.trim(),null,0,false,kwm);
				//m1.addChildInternal(m2);  //addChildInternal does not exec resolve, cause error on disp activate icon
				m1.addChild(m2);
				//m2.setMenuRoot(kwm);
				m2.kwg=kwg;
			}
			//last, menu for full title
			if(wds.length>1) {  //splitted two or more
				rz_KeywordMenuBtn m2=  new rz_KeywordMenuBtn(name0,null,0,false,kwm);
				m1.addChild(m2);
				//m2.setMenuRoot(kwm);
				m2.kwg=kwg;
			}
		}
	}
	
	private String[] extructWords(String str) {
		boolean found;
		
		char[] ct=extruct_ct;
		char[] ct2=extruct_ct2;
		char[] ct3=extruct_ct3;
		char[] cc = str.toCharArray();
		StringBuilder sb = new StringBuilder();
		
		for (char c : cc) {
			char newChar = c;
			found=false;
			for(char t : ct) {
				if(c==t) {
					//PMS.dbg("extructWords: src='"+c+"', target='"+t+"' -->Matched ");
					found=true;
					break;
				}
			}
			if(found) {
				sb.append(" ");
			}
			if(!found && ct2!=null) {
				for(char t : ct2) {
					if(c==t) {
						found=true;
						break;
					}
				}
				if(found) {
					sb.append(" "+newChar);
				}
			}
			if(!found && ct3!=null) {
				for(char t : ct3) {
					if(c==t) {
						//PMS.dbg("extructWords: src='"+c+"', target='"+t+"' -->Matched ");
						found=true;
						break;
					}
				}
				if(found) {
					sb.append(newChar+" ");
				}
			}
			if(!found) {
				sb.append(newChar);
			}
		}
		String s=sb.toString();
		//PMS.dbg("extructWords: str="+s);
		return s.split("[ ]+");
	}

}