/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.dlna;

import java.io.*;
import java.util.Enumeration;
import net.pms.PMS;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.pms.util.NaturalComparator;
import org.apache.tools.zip.ZipEntry;
import java.util.zip.ZipException;
import org.apache.tools.zip.ZipFile;
import com.sun.jna.Platform;
import java.util.zip.ZipInputStream;
import net.pms.formats.Format;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedFile extends DLNAResource {
	private static final Logger LOGGER = LoggerFactory.getLogger(ZippedFile.class);
	private File z;
	private ZipFile zip;
	private static final Collator collator;
	static {
		collator = Collator.getInstance();
		collator.setStrength(Collator.PRIMARY);
	}

	public ZippedFile(File z) {
		this.z = z;
		setLastmodified(z.lastModified());
		
		//-- regzamod, moved to discoverChildren()
		//-- to create childlen here cause slow down to open parent folder of zipfolder
		//-- instead, delay child creation until zipfolder open
		/*
		try {
			if (Platform.isWindows()) zip = new ZipFile(z,"MS932");
			else zip = new ZipFile(z);
			Enumeration enm = zip.getEntries();

			List<DLNAResource> ZipList= new ArrayList<DLNAResource>();

			while (enm.hasMoreElements()) {
				ZipEntry ze = (ZipEntry) enm.nextElement();
				ZipList.add(new ZippedEntry(z, ze.getName(), ze.getSize()));
			}
			for (DLNAResource d : ZipList){
				addChild(d);
			}			
			ZipList=null;
			zip.close();
		} catch (ZipException e) {
			LOGGER.error(null, e);
		} catch (IOException e) {
			LOGGER.error(null, e);
		}
		*/
	}
	
	
	@Override
	public void discoverChildren() {
		//if(resolved) return;
		try {
			if (Platform.isWindows()) zip = new ZipFile(z,"MS932");
			else zip = new ZipFile(z);
			
			Enumeration enm = zip.getEntries();
			List<DLNAResource> ZipList= new ArrayList<DLNAResource>();

			while (enm.hasMoreElements()) {
				ZipEntry ze = (ZipEntry) enm.nextElement();
				ZipList.add(new ZippedEntry(z, ze.getName(), ze.getSize()));
			}
			for (DLNAResource d : ZipList){
				addChild(d);
			}			
			ZipList=null;
			zip.close();
		} catch (ZipException e) {
			LOGGER.error(null, e);
		} catch (IOException e) {
			LOGGER.error(null, e);
		}
		//resolved=true;
	}

	@Override
	protected String getThumbnailURL() {
		if (getType() == Format.IMAGE) {
			// no thumbnail support for now for real based disk images
			return null;
		}
		return super.getThumbnailURL();
	}

	public InputStream getInputStream() {
		try {
			return new ZipInputStream(new FileInputStream(z));
		} catch (FileNotFoundException e) {
			throw new RuntimeException(e);
		}
	}

	public String getName() {
		return z.getName();
	}

	public long length() {
		return z.length();
	}

	public boolean isFolder() {
		return true;
	}

	public long lastModified() {
		return 0;
	}

	public String  getSrcPath() {	//regzamod
		return z.getAbsolutePath();
	}
	
	@Override
	public String getSystemName() {
		return z.getAbsolutePath();
	}

	@Override
	public boolean isValid() {
		return z.exists();
	}
}
