/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.dlna;

import java.io.IOException;

import net.pms.PMS;
import net.pms.formats.Format;
import net.pms.configuration.PmsConfiguration;
import net.pms.dlna.DLNAMediaInfo;
import net.pms.encoders.MEncoderWebVideo;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;


public class WebVideoStream extends WebStream {
	private PmsConfiguration conf=PMS.getConfiguration();
	public boolean resolve_running;

	public WebVideoStream(String fluxName, String URL, String thumbURL) {
		super(fluxName, URL, thumbURL, Format.VIDEO);
		if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.manageItem: fluxName="+fluxName+", url="+URL+", thumbURL="+thumbURL);
		sotype=SO_VIDEO_STREAM;
	}
	
	@Override
	public void setResolved(boolean set) {	//regzamod add
		if(!set) {
			param_cache=null;
			bitrateForTimeSeek=0;
		}
		resolved=set;
	}
	
	public void resolve_p(ProcessWrapper externalProcess) {
		final ProcessWrapper ep=externalProcess;
		
		
		if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve_p: start");
		Runnable r = new Runnable() {
			@Override
			public void run() {
				try {
					Thread.sleep(conf.getRZ_web_resolve_delay());
				} catch (InterruptedException e) {
				}
				if(ep==null || ep.isDestroyed()) {
					if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve_p: externalProcess not running, Noop");
					return;
				}
				if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve_p: exec next resolve name="+getName());
				resolve_s();
			}
		}; 
		Thread t = new Thread(r);
		t.start();
	}
	
	public void resolve_s() {
		if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve_s: start");
		
		synchronized(this) {
			if(resolved && param_cache!=null) {
				if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve: Noop: already resolved and cached");
				return;
			}
			resolved=true; //fast set: to avoid simultanious kick before complete
		}
		
		DLNAResource dlna=this;
		DLNAMediaInfo media=dlna.getMedia();
		rz_SessionInfo sess=dlna.getSession();
		String url=getUrl();

		OutputParams params = new OutputParams(conf);
		params.mediaRenderer = getDefaultRenderer();
		params.sess=sess;
		params.ctx=(sess==null?null:sess.ctx);
		params.mflags|=OutputParams.F_GETINFO;  //only getinfo: not exec play
		//params.aid = getMediaAudio();
		//params.sid = getMediaSubtitle();
		//params.timeseek = timeRange.getStartOrZero();
		//params.timeend = timeRange.getEndOrZero();
		//params.shift_scr = timeseek_auto;
		
	
		MEncoderWebVideo player = new MEncoderWebVideo(conf);
		try {
			if(PMS.rz_debug>1) PMS.dbg("WebVideoStream.resolve: kick player for resolve");
			player.launchTranscode(url,dlna,media,params);
		} catch (IOException e) {
		}
	}
}

