/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package net.pms.dlna;

import net.pms.formats.Format;
import net.pms.PMS;

public class VideosFeed extends Feed {
	
	@Override
	public DLNAResource manageItem(int mode) {
		int type=Format.VIDEO;
		String thumbURL = getTempItemThumbURL();

		if(PMS.rz_debug>1) PMS.dbg("VideoFeed.manageItem: url="+getTempItemLink()+", feedLink="+getTempFeedLink()+", thumbURL="+thumbURL);
		//---- is Node?
		//PMS.dbg("VideosFeed.manageItem: url="+getTempItemLink());
		/*
		if(getTempItemLink()!=null) {
			if(getTempItemLink().contains("www.youtube.com/playlist?list=")) {
		*/
		if(getTempFeedLink()!=null && type==Format.VIDEO) { 
			if(PMS.rz_debug>1) PMS.dbg("Feed.manageItem: found FeedLink --> Add subfolder for Feed ");
			String url1=getTempFeedLink();
			
			//PMS.dbg("VideosFeed.manageItem: Feed url1="+url1);
			// a high-cost way : to be refined
			/*
			for(DLNAResource cs : getChildren()) {
				String url2=cs.getSrcPath();
				//PMS.dbg("VideosFeed.manageItem: Existing url2="+url2);
				if(url1.equals(url2)) {
					//PMS.dbg("Same VideoStream already exists under this Feed");
					return null;  //already exists
				}
			}
			*/
			
			VideosFeed ch=new VideosFeed(getTempFeedLink(),getTempItemTitle());
			if(mode==1) addChild(ch);
			return (DLNAResource)ch;
			/*
			if(getTempItemLink().contains("://webcache.google")) {
				//garbage data?
				//PMS.dbg("Feed.manageItem: found webcash --> Ignore");
				return null;
			}
			*/
		}
		
		//---- normal video stream
		WebVideoStream fi = new WebVideoStream(getTempItemTitle(), getTempItemLink(), thumbURL);
		fi.setSerialId(getTempSerialId());//regzamod
		fi.wmed_duration=tempDuration;//regzamod, need for AutoChapter made in addChild() 
		if(tempDuration==0) {
			fi.wmed_duration=36000-1;//regzamod
		}
		if(mode==1) addChild(fi);  //include media parse & player decidion
		
		//misc. resolve, shuld be refined.
		//must do after addChild() , or should be in WebVideoStream.resolve() that called after addChild()
		//addChild suppose media not setted yet, so, if setted, judge in addchild will fail
		
		if(fi.getMedia()==null) {
			fi.setMedia(new DLNAMediaInfo());
		}
		DLNAMediaInfo med=fi.getMedia();
		
		//---- thumbnail
		if(type==Format.IMAGE || type==Format.VIDEO) {
			//type==Format.IMAGE never comes here: b/c this is 'Videos'Feed
			//PMS.dbg("VideosFeed.manageItem: type="+type);
			if(thumbURL!=null && thumbURL.startsWith("data:image/")) {
				//---- mediainfo
				//PMS.dbg("VideosFeed.manageItem: thumbURL!=null && thumbURL.startsWith(\"data:image/\")");
				//fi.wmed_valid=true;
				
				//inline image data : decode by base64.decoder "data:image/;base64,"
				int pos=thumbURL.indexOf(";base64,");
				if(pos>0) {
					int len=thumbURL.length();
					//PMS.dbg("VideosFeed.manageItem: thumbURL seems to be inline image, len="+len+", data top="+thumbURL.substring(0,(len>60?60:len)));
					//PMS.dbg("VideosFeed.manageItem: data body="+thumbURL.substring(pos+8,len));
					med.setThumb(MediaInfoParser.getCover(thumbURL.substring(pos+8,len)));
					med.setThumbready(true);
					med.setMediaparsed(true); //fake, some values setted
					fi.setThumbURL(null);
				}
			}
		}

		//PMS.dbg("VideosFeed.manageItem: duration="+tempDuration);	//regzamod,add
		//---- set duration 
		med.setMediaparsed(true); //fake, dummy values except duration setted
		med.setDuration(new Double(tempDuration));
		if(rz_PartPlaySttp>0) {
			if(rz_PartPlayEndp==0) rz_PartPlayEndp=tempDuration;
			rz_PartPlayDuration=rz_PartPlayEndp - rz_PartPlaySttp;
			fi.setSplitRange(new Range.Time(rz_PartPlaySttp,rz_PartPlayEndp));
		}
		//---- set other mediainfos with dummy values
		//-->> test for avoid qurious non-zero-start-time on REGZA
		med.setWidth(720);
		med.setHeight(480);
		med.setAspect("1.777777");
		med.setFrameRate("29.97");
		
		return (DLNAResource)fi;
	}

	public static void manage_setDur(WebVideoStream fi, float dur) {
		DLNAMediaInfo med=fi.getMedia();
		fi.wmed_duration=dur;
		if(med!=null) {
			med.setDuration(new Double(dur));
			if(fi.rz_PartPlaySttp>0) {
				if(fi.rz_PartPlayEndp==0) fi.rz_PartPlayEndp=dur;
				fi.rz_PartPlayDuration=fi.rz_PartPlayEndp - fi.rz_PartPlaySttp;
				fi.setSplitRange(new Range.Time(fi.rz_PartPlaySttp,fi.rz_PartPlayEndp));
			}
		}
	}
	
	public static void manage_setThumb(WebVideoStream fi, String thumbURL) {
		if(thumbURL!=null && thumbURL.startsWith("data:image/")) {
			//---- mediainfo
			//PMS.dbg("Feed.manageItem: thumbURL!=null && thumbURL.startsWith(\"data:image/\")");
			DLNAMediaInfo med;
			if(fi.getMedia()==null) {
				fi.setMedia(new DLNAMediaInfo());
			}
			med=fi.getMedia();
			//wmed_valid=true;
			
			//inline image data : decode by base64.decoder
			int pos=thumbURL.indexOf(";base64,");
			if(pos>0) {
				int len=thumbURL.length();
				//PMS.dbg("Feed.manageItem: thumbURL seems to be inline image, len="+len+", data top="+thumbURL.substring(0,60));
				//PMS.dbg("Feed.manageItem: data body="+thumbURL.substring(pos+8,len));
				med.setThumb(MediaInfoParser.getCover(thumbURL.substring(pos+8,len)));
				med.setThumbready(true);
				med.setMediaparsed(true); //fake, some values setted
				fi.setThumbURL(null);
			}
		}
	}
	/*
	@Override
	protected void manage_setDur(FeedItem fi, float dur) {
		fi.wmed_duration=dur;
	}
	
	@Override
	protected void manage_setThumb(FeedItem fi, String thumbURL) {
		
	}
	*/
	public VideosFeed(String url,String name) {
		//super("" + System.currentTimeMillis(), url, Format.VIDEO);
		super(name, url, Format.VIDEO);
	}
}
