/*
 * PS3 Media Server, for streaming any medias to your PS3.
 * Copyright (C) 2008  A.Brochard
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package net.pms.dlna;


import java.io.IOException;
import java.io.InputStream;


//import net.pms.dlna.MediaInfoParser;
//import net.pms.dlna.DLNAMediaInfo;
import net.pms.PMS;
import net.pms.formats.Format;

public class FeedItem extends DLNAResource {
	@Override
	protected String getThumbnailURL() {
		if (thumbURL != null) {
			return thumbURL;
		}
		return super.getThumbnailURL();
	}

	@Override
	public String getThumbnailContentType() {
		if (thumbURL != null && thumbURL.toLowerCase().endsWith(".jpg")) {
			return JPEG_TYPEMIME;
		} else {
			return super.getThumbnailContentType();
		}
	}

	@Override
	public InputStream getThumbnailInputStream() throws IOException {
		
		//PMS.dbg("FeedItem.getThumbnailInputStream: url="+thumbURL);
		//return downloadAndSend(thumbURL, true); origin
		DLNAMediaInfo med=getMedia();
		//PMS.dbg("FeedItem.getThumbnailInputStream: called");
		
		if (getThumbURL() != null) {
			//PMS.dbg("FeedItem.getThumbnailInputStream: name="+getName()+", getThumbURL() != null --> return downloadAndSend(getThumbURL())");
			return downloadAndSend(getThumbURL(), true);
		} 
		else if(med!=null && med.getThumb()!=null) {
			//PMS.dbg("FeedItem.getThumbnailInputStream: name="+getName()+", getThumb()!=null --> return this.getThumbnailInputStream()");
			return med.getThumbnailInputStream();
		}
		else {
			//PMS.dbg("FeedItem.getThumbnailInputStream: name="+getName()+", getThumb()==null --> return super.getThumbnailInputStream()");
			return super.getThumbnailInputStream();
		}

	}
	
	private String title;
	private String itemURL;
	private String thumbURL;
	private long length;

	public FeedItem(String title, String itemURL, String thumbURL, DLNAMediaInfo media, int type) {
		//PMS.dbg("FeedItem: thumbURL="+thumbURL);
		super(type);
		this.title = title;
		this.itemURL = itemURL;
		this.thumbURL = thumbURL;
		this.setMedia(media);
		this.wmed_duration=3600*10-1;  //set defaults: 9:59:59

	}

	protected String getThumbURL() {
		return thumbURL;
	}

	protected void setThumbURL(String thumbURL) {
		this.thumbURL = thumbURL;
	}

	public InputStream getInputStream() throws IOException {
		InputStream i = downloadAndSend(itemURL, true);
		if (i != null) {
			length = i.available();
		}
		return i;
	}

	public String getName() {
		return title;
	}
	@Override
	public String getDpName() {	//regzamod
		return getName();
	}

	public boolean isFolder() {
		return false;
	}

	public long length() {
		return length;
	}

	/* regzamod, use super
	public long lastModified() {
		//return 0;
	}
	*/

	@Override
	public void discoverChildren() {
	}

	@Override
	public String getSystemName() {
		return itemURL;
	}
	public String getSrcPath() {
		return itemURL;
	}

	public void parse(String content) {
	}

	@Override
	public boolean isValid() {
		checktype();
		return getExt() != null;
	}
}
