<?php
/**
 * @copyright 2005-2007 OpenPNE Project
 * @license   http://www.php.net/license/3_01.txt PHP License 3.01
 */


//デフォルトページ
$GLOBALS['__Framework']['default_page'] = 'h_home';

//<PCKTAI
if (!OPENPNE_ENABLE_KTAI) {
    // disable ktai module
    exit;
}
//>

// User-Agent判別
if (CHECK_KTAI_UA && !isKtaiUserAgent()) {
    openpne_redirect('pc');
}

// 文字コード変換
function ktai_convert_encoding($arr)
{
    return is_array($arr) ?
        array_map('ktai_convert_encoding', $arr) :
        mb_convert_encoding($arr, 'UTF-8', 'SJIS-win');
}

// 絵文字変換
function ktai_convert_emoji($arr)
{
    return is_array($arr) ?
        array_map('ktai_convert_emoji', $arr) :
        emoji_escape($arr);
}

function ktai_convert($arr)
{
    $arr = ktai_convert_emoji($arr);
    $arr = ktai_convert_encoding($arr);
    return $arr;
}

$_GET     = ktai_convert($_GET);
$_POST    = ktai_convert($_POST);
$_REQUEST = ktai_convert($_REQUEST);

ini_set('session.use_cookies', '0');

function init_ktai_page(&$smarty)
{
    //---- inc_ テンプレート用 変数 ----//
    $smarty->assign('inc_ktai_header', fetch_inc_ktai_header());
    $smarty->assign('inc_ktai_footer', fetch_inc_ktai_footer());

    //全ページ共通変数のアサイン
    $smarty->assign('msg', k_p_common_msg4msg_id($_REQUEST['msg']));
    $smarty->assign('WORD_FRIEND', WORD_FRIEND);
    $smarty->assign('WORD_MY_FRIEND', WORD_MY_FRIEND);
    $smarty->assign('WORD_FRIEND_HALF', WORD_FRIEND_HALF);
    $smarty->assign('WORD_MY_FRIEND_HALF', WORD_MY_FRIEND_HALF);

    $is_secure = $GLOBALS['__Framework']['is_secure'];

    if ($is_secure) {
        $smarty->assign('u', $GLOBALS['KTAI_C_MEMBER_ID']);
        $smarty->assign('tail', $GLOBALS['KTAI_URL_TAIL']);
        @session_start();
        $smarty->assign('PHPSESSID', session_id());
    }

    // set SJIS
    $smarty->setOutputCharset('SJIS');
}

?>
