/*
  ImageMagick Magick API Method Prefix.

  nm .libs/libMagick.a | grep ' T ' | \
    awk '{ printf("#define %s  PrependMagickMethod(%s)\n", $3, $3); }' | \
    sort
*/
#ifndef _MAGICK_METHOD_H
#define _MAGICK_METHOD_H

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

#if defined(MagickMethodPrefix)

#if defined(__STDC__)
#define PrescanMagickPrefix(prefix,method)  prefix ## method
#else
#define PrescanMagickPrefix(prefix,method)  prefix(method)
#endif
#define EvaluateMagickPrefix(prefix,method)  PrescanMagickPrefix(prefix,method)
#define PrependMagickMethod(method) \
  EvaluateMagickPrefix(MagickMethodPrefix,method)

#define AcquireCacheNexus  PrependMagickMethod(AcquireCacheNexus)
#define AcquireCacheView  PrependMagickMethod(AcquireCacheView)
#define AcquireImagePixels  PrependMagickMethod(AcquireImagePixels)
#define AcquireMagickMemory  PrependMagickMethod(AcquireMagickMemory)
#define AcquireMagickResource  PrependMagickMethod(AcquireMagickResource)
#define AcquireMemory  PrependMagickMethod(AcquireMemory)
#define AcquireOnePixel  PrependMagickMethod(AcquireOnePixel)
#define AcquireSemaphoreInfo  PrependMagickMethod(AcquireSemaphoreInfo)
#define AcquireStringInfo  PrependMagickMethod(AcquireStringInfo)
#define AcquireString  PrependMagickMethod(AcquireString)
#define AcquireUniqueFilename  PrependMagickMethod(AcquireUniqueFilename)
#define AcquireUniqueFileResource  PrependMagickMethod(AcquireUniqueFileResource)
#define AdaptiveThresholdImage  PrependMagickMethod(AdaptiveThresholdImage)
#define AddNoiseImage  PrependMagickMethod(AddNoiseImage)
#define AffineTransformImage  PrependMagickMethod(AffineTransformImage)
#define AllocateImageColormap  PrependMagickMethod(AllocateImageColormap)
#define AllocateImage  PrependMagickMethod(AllocateImage)
#define AllocateNextImage  PrependMagickMethod(AllocateNextImage)
#define AllocateSemaphoreInfo  PrependMagickMethod(AllocateSemaphoreInfo)
#define AllocateString  PrependMagickMethod(AllocateString)
#define AnalyzeImage  PrependMagickMethod(AnalyzeImage)
#define AnimateImageCommand  PrependMagickMethod(AnimateImageCommand)
#define AnimateImages  PrependMagickMethod(AnimateImages)
#define AnnotateImage  PrependMagickMethod(AnnotateImage)
#define AppendElementToLinkedList  PrependMagickMethod(AppendElementToLinkedList)
#define AppendImageFormat  PrependMagickMethod(AppendImageFormat)
#define AppendImages  PrependMagickMethod(AppendImages)
#define AppendImageToList  PrependMagickMethod(AppendImageToList)
#define Ascii85Encode  PrependMagickMethod(Ascii85Encode)
#define Ascii85Flush  PrependMagickMethod(Ascii85Flush)
#define Ascii85Initialize  PrependMagickMethod(Ascii85Initialize)
#define AsynchronousDestroyMagickResources  PrependMagickMethod(AsynchronousDestroyMagickResources)
#define AttachBlob  PrependMagickMethod(AttachBlob)
#define AverageImages  PrependMagickMethod(AverageImages)
#define Base64Decode  PrependMagickMethod(Base64Decode)
#define Base64Encode  PrependMagickMethod(Base64Encode)
#define BilevelImageChannel  PrependMagickMethod(BilevelImageChannel)
#define BilevelImage  PrependMagickMethod(BilevelImage)
#define BlackThresholdImage  PrependMagickMethod(BlackThresholdImage)
#define BlobToFile  PrependMagickMethod(BlobToFile)
#define BlobToImage  PrependMagickMethod(BlobToImage)
#define BlurImageChannel  PrependMagickMethod(BlurImageChannel)
#define BlurImage  PrependMagickMethod(BlurImage)
#define BorderImage  PrependMagickMethod(BorderImage)
#define CatchException  PrependMagickMethod(CatchException)
#define CatchImageException  PrependMagickMethod(CatchImageException)
#define ChannelImage  PrependMagickMethod(ChannelImage)
#define ChannelThresholdImage  PrependMagickMethod(ChannelThresholdImage)
#define CharcoalImage  PrependMagickMethod(CharcoalImage)
#define ChopImage  PrependMagickMethod(ChopImage)
#define ChopPathComponents  PrependMagickMethod(ChopPathComponents)
#define ClearLinkedList  PrependMagickMethod(ClearLinkedList)
#define ClipImage  PrependMagickMethod(ClipImage)
#define ClipPathImage  PrependMagickMethod(ClipPathImage)
#define CloneBlobInfo  PrependMagickMethod(CloneBlobInfo)
#define CloneDrawInfo  PrependMagickMethod(CloneDrawInfo)
#define CloneImageInfo  PrependMagickMethod(CloneImageInfo)
#define CloneImageList  PrependMagickMethod(CloneImageList)
#define CloneImageOptions  PrependMagickMethod(CloneImageOptions)
#define CloneImage  PrependMagickMethod(CloneImage)
#define CloneImageProfiles  PrependMagickMethod(CloneImageProfiles)
#define CloneMemory  PrependMagickMethod(CloneMemory)
#define CloneMontageInfo  PrependMagickMethod(CloneMontageInfo)
#define ClonePixelCacheMethods  PrependMagickMethod(ClonePixelCacheMethods)
#define CloneQuantizeInfo  PrependMagickMethod(CloneQuantizeInfo)
#define CloneStringInfo  PrependMagickMethod(CloneStringInfo)
#define CloneString  PrependMagickMethod(CloneString)
#define CloseBlob  PrependMagickMethod(CloseBlob)
#define CloseCacheView  PrependMagickMethod(CloseCacheView)
#define CoalesceImages  PrependMagickMethod(CoalesceImages)
#define ColorFloodfillImage  PrependMagickMethod(ColorFloodfillImage)
#define ColorizeImage  PrependMagickMethod(ColorizeImage)
#define CombineImages  PrependMagickMethod(CombineImages)
#define CompareImageChannels  PrependMagickMethod(CompareImageChannels)
#define CompareImageCommand  PrependMagickMethod(CompareImageCommand)
#define CompareImages  PrependMagickMethod(CompareImages)
#define CompareStringInfo  PrependMagickMethod(CompareStringInfo)
#define CompositeImageCommand  PrependMagickMethod(CompositeImageCommand)
#define CompositeImage  PrependMagickMethod(CompositeImage)
#define CompressImageColormap  PrependMagickMethod(CompressImageColormap)
#define ConcatenateMagickString  PrependMagickMethod(ConcatenateMagickString)
#define ConcatenateStringInfo  PrependMagickMethod(ConcatenateStringInfo)
#define ConcatenateString  PrependMagickMethod(ConcatenateString)
#define ConjureImageCommand  PrependMagickMethod(ConjureImageCommand)
#define ConsolidateCMYKImages  PrependMagickMethod(ConsolidateCMYKImages)
#define ConstituteImage  PrependMagickMethod(ConstituteImage)
#define ContinueTimer  PrependMagickMethod(ContinueTimer)
#define ContrastImage  PrependMagickMethod(ContrastImage)
#define Contrast  PrependMagickMethod(Contrast)
#define ConvertImageCommand  PrependMagickMethod(ConvertImageCommand)
#define ConvolveImageChannel  PrependMagickMethod(ConvolveImageChannel)
#define ConvolveImage  PrependMagickMethod(ConvolveImage)
#define CopyMagickMemory  PrependMagickMethod(CopyMagickMemory)
#define CopyMagickString  PrependMagickMethod(CopyMagickString)
#define CropImage  PrependMagickMethod(CropImage)
#define CycleColormapImage  PrependMagickMethod(CycleColormapImage)
#define DeconstructImages  PrependMagickMethod(DeconstructImages)
#define DefineImageOption  PrependMagickMethod(DefineImageOption)
#define DeleteImageFromList  PrependMagickMethod(DeleteImageFromList)
#define DeleteImageList  PrependMagickMethod(DeleteImageList)
#define DeleteImageOption  PrependMagickMethod(DeleteImageOption)
#define DeleteMagickRegistry  PrependMagickMethod(DeleteMagickRegistry)
#define DescribeImage  PrependMagickMethod(DescribeImage)
#define DespeckleImage  PrependMagickMethod(DespeckleImage)
#define DestroyBlobInfo  PrependMagickMethod(DestroyBlobInfo)
#define DestroyBlob  PrependMagickMethod(DestroyBlob)
#define DestroyCacheInfo  PrependMagickMethod(DestroyCacheInfo)
#define DestroyCacheNexus  PrependMagickMethod(DestroyCacheNexus)
#define DestroyCoderList  PrependMagickMethod(DestroyCoderList)
#define DestroyColorList  PrependMagickMethod(DestroyColorList)
#define DestroyConfigureList  PrependMagickMethod(DestroyConfigureList)
#define DestroyConfigureOptions  PrependMagickMethod(DestroyConfigureOptions)
#define DestroyConstitute  PrependMagickMethod(DestroyConstitute)
#define DestroyDelegateList  PrependMagickMethod(DestroyDelegateList)
#define DestroyDrawInfo  PrependMagickMethod(DestroyDrawInfo)
#define DestroyExceptionInfo  PrependMagickMethod(DestroyExceptionInfo)
#define DestroyHashmap  PrependMagickMethod(DestroyHashmap)
#define DestroyImageAttributes  PrependMagickMethod(DestroyImageAttributes)
#define DestroyImageInfo  PrependMagickMethod(DestroyImageInfo)
#define DestroyImageList  PrependMagickMethod(DestroyImageList)
#define DestroyImageOptions  PrependMagickMethod(DestroyImageOptions)
#define DestroyImagePixels  PrependMagickMethod(DestroyImagePixels)
#define DestroyImage  PrependMagickMethod(DestroyImage)
#define DestroyImageProfiles  PrependMagickMethod(DestroyImageProfiles)
#define DestroyImages  PrependMagickMethod(DestroyImages)
#define DestroyLinkedList  PrependMagickMethod(DestroyLinkedList)
#define DestroyLocaleList  PrependMagickMethod(DestroyLocaleList)
#define DestroyLocaleOptions  PrependMagickMethod(DestroyLocaleOptions)
#define DestroyLogList  PrependMagickMethod(DestroyLogList)
#define DestroyMagickList  PrependMagickMethod(DestroyMagickList)
#define DestroyMagickMemory  PrependMagickMethod(DestroyMagickMemory)
#define DestroyMagick  PrependMagickMethod(DestroyMagick)
#define DestroyMagickRegistry  PrependMagickMethod(DestroyMagickRegistry)
#define DestroyMagickResources  PrependMagickMethod(DestroyMagickResources)
#define DestroyMagicList  PrependMagickMethod(DestroyMagicList)
#define DestroyMontageInfo  PrependMagickMethod(DestroyMontageInfo)
#define DestroyQuantizeInfo  PrependMagickMethod(DestroyQuantizeInfo)
#define DestroyRandomReservoir  PrependMagickMethod(DestroyRandomReservoir)
#define DestroySemaphoreInfo  PrependMagickMethod(DestroySemaphoreInfo)
#define DestroySemaphore  PrependMagickMethod(DestroySemaphore)
#define DestroyStringInfo  PrependMagickMethod(DestroyStringInfo)
#define DestroyStringList  PrependMagickMethod(DestroyStringList)
#define DestroyString  PrependMagickMethod(DestroyString)
#define DestroyTypeList  PrependMagickMethod(DestroyTypeList)
#define DestroyXResources  PrependMagickMethod(DestroyXResources)
#define DestroyXWidget  PrependMagickMethod(DestroyXWidget)
#define DetachBlob  PrependMagickMethod(DetachBlob)
#define DispatchImage  PrependMagickMethod(DispatchImage)
#define DisplayImageCommand  PrependMagickMethod(DisplayImageCommand)
#define DisplayImages  PrependMagickMethod(DisplayImages)
#define DistillRandomEvent  PrependMagickMethod(DistillRandomEvent)
#define DrawAffineImage  PrependMagickMethod(DrawAffineImage)
#define DrawClipPath  PrependMagickMethod(DrawClipPath)
#define DrawImage  PrependMagickMethod(DrawImage)
#define DrawPatternPath  PrependMagickMethod(DrawPatternPath)
#define DrawPrimitive  PrependMagickMethod(DrawPrimitive)
#define EdgeImage  PrependMagickMethod(EdgeImage)
#define EmbossImage  PrependMagickMethod(EmbossImage)
#define EnhanceImage  PrependMagickMethod(EnhanceImage)
#define EOFBlob  PrependMagickMethod(EOFBlob)
#define EqualizeImage  PrependMagickMethod(EqualizeImage)
#define EscapeString  PrependMagickMethod(EscapeString)
#define EvaluateImageChannel  PrependMagickMethod(EvaluateImageChannel)
#define EvaluateImage  PrependMagickMethod(EvaluateImage)
#define ExecuteModuleProcess  PrependMagickMethod(ExecuteModuleProcess)
#define ExpandAffine  PrependMagickMethod(ExpandAffine)
#define ExpandFilename  PrependMagickMethod(ExpandFilename)
#define ExpandFilenames  PrependMagickMethod(ExpandFilenames)
#define ExportImagePixels  PrependMagickMethod(ExportImagePixels)
#define FileToBlob  PrependMagickMethod(FileToBlob)
#define FileToStringInfo  PrependMagickMethod(FileToStringInfo)
#define FileToString  PrependMagickMethod(FileToString)
#define FinalizeSignature  PrependMagickMethod(FinalizeSignature)
#define FlattenImages  PrependMagickMethod(FlattenImages)
#define FlipImage  PrependMagickMethod(FlipImage)
#define FlopImage  PrependMagickMethod(FlopImage)
#define FormatMagickString  PrependMagickMethod(FormatMagickString)
#define FormatSize  PrependMagickMethod(FormatSize)
#define FormatString  PrependMagickMethod(FormatString)
#define FrameImage  PrependMagickMethod(FrameImage)
#define FuzzyColorCompare  PrependMagickMethod(FuzzyColorCompare)
#define FuzzyColorMatch  PrependMagickMethod(FuzzyColorMatch)
#define FuzzyOpacityCompare  PrependMagickMethod(FuzzyOpacityCompare)
#define FxImageChannel  PrependMagickMethod(FxImageChannel)
#define FxImage  PrependMagickMethod(FxImage)
#define GammaImageChannel  PrependMagickMethod(GammaImageChannel)
#define GammaImage  PrependMagickMethod(GammaImage)
#define GaussianBlurImageChannel  PrependMagickMethod(GaussianBlurImageChannel)
#define GaussianBlurImage  PrependMagickMethod(GaussianBlurImage)
#define GetAffineMatrix  PrependMagickMethod(GetAffineMatrix)
#define GetBlobError  PrependMagickMethod(GetBlobError)
#define GetBlobFileHandle  PrependMagickMethod(GetBlobFileHandle)
#define GetBlobInfo  PrependMagickMethod(GetBlobInfo)
#define GetBlobSize  PrependMagickMethod(GetBlobSize)
#define GetBlobStreamData  PrependMagickMethod(GetBlobStreamData)
#define GetBlobStreamHandler  PrependMagickMethod(GetBlobStreamHandler)
#define GetCacheClass  PrependMagickMethod(GetCacheClass)
#define GetCacheColorspace  PrependMagickMethod(GetCacheColorspace)
#define GetCacheInfo  PrependMagickMethod(GetCacheInfo)
#define GetCacheNexus  PrependMagickMethod(GetCacheNexus)
#define GetCacheViewIndexes  PrependMagickMethod(GetCacheViewIndexes)
#define GetCacheViewPixels  PrependMagickMethod(GetCacheViewPixels)
#define GetCacheView  PrependMagickMethod(GetCacheView)
#define GetClientName  PrependMagickMethod(GetClientName)
#define GetClientPath  PrependMagickMethod(GetClientPath)
#define GetCoderInfoList  PrependMagickMethod(GetCoderInfoList)
#define GetCoderInfo  PrependMagickMethod(GetCoderInfo)
#define GetCoderList  PrependMagickMethod(GetCoderList)
#define GetColorInfoList  PrependMagickMethod(GetColorInfoList)
#define GetColorInfo  PrependMagickMethod(GetColorInfo)
#define GetColorList  PrependMagickMethod(GetColorList)
#define GetColorTuple  PrependMagickMethod(GetColorTuple)
#define GetConfigureBlob  PrependMagickMethod(GetConfigureBlob)
#define GetConfigureInfoList  PrependMagickMethod(GetConfigureInfoList)
#define GetConfigureInfo  PrependMagickMethod(GetConfigureInfo)
#define GetConfigureList  PrependMagickMethod(GetConfigureList)
#define GetConfigureOptions  PrependMagickMethod(GetConfigureOptions)
#define GetConfigurePaths  PrependMagickMethod(GetConfigurePaths)
#define GetConfigureValue  PrependMagickMethod(GetConfigureValue)
#define GetDelegateCommand  PrependMagickMethod(GetDelegateCommand)
#define GetDelegateCommands  PrependMagickMethod(GetDelegateCommands)
#define GetDelegateInfoList  PrependMagickMethod(GetDelegateInfoList)
#define GetDelegateInfo  PrependMagickMethod(GetDelegateInfo)
#define GetDelegateList  PrependMagickMethod(GetDelegateList)
#define GetDelegateMode  PrependMagickMethod(GetDelegateMode)
#define GetDrawInfo  PrependMagickMethod(GetDrawInfo)
#define GetElapsedTime  PrependMagickMethod(GetElapsedTime)
#define GetElementFromLinkedList  PrependMagickMethod(GetElementFromLinkedList)
#define GetEntryFromHashmap  PrependMagickMethod(GetEntryFromHashmap)
#define GetExceptionInfo  PrependMagickMethod(GetExceptionInfo)
#define GetExecutionPath  PrependMagickMethod(GetExecutionPath)
#define GetFirstImageInList  PrependMagickMethod(GetFirstImageInList)
#define GetGeometry  PrependMagickMethod(GetGeometry)
#define GetImageAttribute  PrependMagickMethod(GetImageAttribute)
#define GetImageBoundingBox  PrependMagickMethod(GetImageBoundingBox)
#define GetImageChannelDepth  PrependMagickMethod(GetImageChannelDepth)
#define GetImageChannelExtrema  PrependMagickMethod(GetImageChannelExtrema)
#define GetImageChannelMean  PrependMagickMethod(GetImageChannelMean)
#define GetImageClipMask  PrependMagickMethod(GetImageClipMask)
#define GetImageClippingPathAttribute  PrependMagickMethod(GetImageClippingPathAttribute)
#define GetImageDepth  PrependMagickMethod(GetImageDepth)
#define GetImageDynamicThreshold  PrependMagickMethod(GetImageDynamicThreshold)
#define GetImageException  PrependMagickMethod(GetImageException)
#define GetImageExtrema  PrependMagickMethod(GetImageExtrema)
#define GetImageFromList  PrependMagickMethod(GetImageFromList)
#define GetImageFromMagickRegistry  PrependMagickMethod(GetImageFromMagickRegistry)
#define GetImageGeometry  PrependMagickMethod(GetImageGeometry)
#define GetImageHistogram  PrependMagickMethod(GetImageHistogram)
#define GetImageIndexInList  PrependMagickMethod(GetImageIndexInList)
#define GetImageInfoAttribute  PrependMagickMethod(GetImageInfoAttribute)
#define GetImageInfo  PrependMagickMethod(GetImageInfo)
#define GetImageListIndex  PrependMagickMethod(GetImageListIndex)
#define GetImageListLength  PrependMagickMethod(GetImageListLength)
#define GetImageList  PrependMagickMethod(GetImageList)
#define GetImageListSize  PrependMagickMethod(GetImageListSize)
#define GetImageMagick  PrependMagickMethod(GetImageMagick)
#define GetImageMean  PrependMagickMethod(GetImageMean)
#define GetImageOption  PrependMagickMethod(GetImageOption)
#define GetImagePixels  PrependMagickMethod(GetImagePixels)
#define GetImageProfile  PrependMagickMethod(GetImageProfile)
#define GetImageQuantizeError  PrependMagickMethod(GetImageQuantizeError)
#define GetImageQuantumDepth  PrependMagickMethod(GetImageQuantumDepth)
#define GetImageType  PrependMagickMethod(GetImageType)
#define GetImageVirtualPixelMethod  PrependMagickMethod(GetImageVirtualPixelMethod)
#define GetIndexes  PrependMagickMethod(GetIndexes)
#define GetLastElementInLinkedList  PrependMagickMethod(GetLastElementInLinkedList)
#define GetLastImageInList  PrependMagickMethod(GetLastImageInList)
#define GetLocaleExceptionMessage  PrependMagickMethod(GetLocaleExceptionMessage)
#define GetLocaleInfoList  PrependMagickMethod(GetLocaleInfoList)
#define GetLocaleInfo_  PrependMagickMethod(GetLocaleInfo_)
#define GetLocaleList  PrependMagickMethod(GetLocaleList)
#define GetLocaleMessage  PrependMagickMethod(GetLocaleMessage)
#define GetLocaleMonitorMessage  PrependMagickMethod(GetLocaleMonitorMessage)
#define GetLocaleOptions  PrependMagickMethod(GetLocaleOptions)
#define GetLocaleValue  PrependMagickMethod(GetLocaleValue)
#define GetLogInfoList  PrependMagickMethod(GetLogInfoList)
#define GetLogInfo  PrependMagickMethod(GetLogInfo)
#define GetLogList  PrependMagickMethod(GetLogList)
#define GetMagicInfoList  PrependMagickMethod(GetMagicInfoList)
#define GetMagicInfo  PrependMagickMethod(GetMagicInfo)
#define GetMagickAdjoin  PrependMagickMethod(GetMagickAdjoin)
#define GetMagickBlobSupport  PrependMagickMethod(GetMagickBlobSupport)
#define GetMagickCopyright  PrependMagickMethod(GetMagickCopyright)
#define GetMagickDecoder  PrependMagickMethod(GetMagickDecoder)
#define GetMagickDescription  PrependMagickMethod(GetMagickDescription)
#define GetMagickEncoder  PrependMagickMethod(GetMagickEncoder)
#define GetMagickGeometry  PrependMagickMethod(GetMagickGeometry)
#define GetMagickHomeURL  PrependMagickMethod(GetMagickHomeURL)
#define GetMagickInfoList  PrependMagickMethod(GetMagickInfoList)
#define GetMagickInfo  PrependMagickMethod(GetMagickInfo)
#define GetMagickList  PrependMagickMethod(GetMagickList)
#define GetMagickOptions  PrependMagickMethod(GetMagickOptions)
#define GetMagickPackageName  PrependMagickMethod(GetMagickPackageName)
#define GetMagickPixelPacket  PrependMagickMethod(GetMagickPixelPacket)
#define GetMagickQuantumDepth  PrependMagickMethod(GetMagickQuantumDepth)
#define GetMagickRegistry  PrependMagickMethod(GetMagickRegistry)
#define GetMagickReleaseDate  PrependMagickMethod(GetMagickReleaseDate)
#define GetMagickResource  PrependMagickMethod(GetMagickResource)
#define GetMagickSeekableStream  PrependMagickMethod(GetMagickSeekableStream)
#define GetMagickThreadSupport  PrependMagickMethod(GetMagickThreadSupport)
#define GetMagickVersion  PrependMagickMethod(GetMagickVersion)
#define GetMagicList  PrependMagickMethod(GetMagicList)
#define GetMagicName  PrependMagickMethod(GetMagicName)
#define GetMontageInfo  PrependMagickMethod(GetMontageInfo)
#define GetNextElementInLinkedList  PrependMagickMethod(GetNextElementInLinkedList)
#define GetNextEntryInHashmap  PrependMagickMethod(GetNextEntryInHashmap)
#define GetNextImageInList  PrependMagickMethod(GetNextImageInList)
#define GetNextImageOption  PrependMagickMethod(GetNextImageOption)
#define GetNextImage  PrependMagickMethod(GetNextImage)
#define GetNextImageProfile  PrependMagickMethod(GetNextImageProfile)
#define GetNexusIndexes  PrependMagickMethod(GetNexusIndexes)
#define GetNexusPixels  PrependMagickMethod(GetNexusPixels)
#define GetNexus  PrependMagickMethod(GetNexus)
#define GetNumberColors  PrependMagickMethod(GetNumberColors)
#define GetNumberOfElementsInLinkedList  PrependMagickMethod(GetNumberOfElementsInLinkedList)
#define GetNumberOfEntriesInHashmap  PrependMagickMethod(GetNumberOfEntriesInHashmap)
#define GetNumberScenes  PrependMagickMethod(GetNumberScenes)
#define GetOnePixel  PrependMagickMethod(GetOnePixel)
#define GetOptimalKernelWidth1D  PrependMagickMethod(GetOptimalKernelWidth1D)
#define GetOptimalKernelWidth2D  PrependMagickMethod(GetOptimalKernelWidth2D)
#define GetOptimalKernelWidth  PrependMagickMethod(GetOptimalKernelWidth)
#define GetPageGeometry  PrependMagickMethod(GetPageGeometry)
#define GetPathComponent  PrependMagickMethod(GetPathComponent)
#define GetPixelCacheArea  PrependMagickMethod(GetPixelCacheArea)
#define GetPixels  PrependMagickMethod(GetPixels)
#define GetPreviousImageInList  PrependMagickMethod(GetPreviousImageInList)
#define GetPreviousImage  PrependMagickMethod(GetPreviousImage)
#define GetQuantizeInfo  PrependMagickMethod(GetQuantizeInfo)
#define GetRandomKey  PrependMagickMethod(GetRandomKey)
#define GetRandomValue  PrependMagickMethod(GetRandomValue)
#define GetSignatureInfo  PrependMagickMethod(GetSignatureInfo)
#define GetTimerInfo  PrependMagickMethod(GetTimerInfo)
#define GetToken  PrependMagickMethod(GetToken)
#define GetTypeInfoByFamily  PrependMagickMethod(GetTypeInfoByFamily)
#define GetTypeInfoList  PrependMagickMethod(GetTypeInfoList)
#define GetTypeInfo  PrependMagickMethod(GetTypeInfo)
#define GetTypeList  PrependMagickMethod(GetTypeList)
#define GetTypeMetrics  PrependMagickMethod(GetTypeMetrics)
#define GetUserTime  PrependMagickMethod(GetUserTime)
#define GlobExpression  PrependMagickMethod(GlobExpression)
#define GradientImage  PrependMagickMethod(GradientImage)
#define HashPointerType  PrependMagickMethod(HashPointerType)
#define HashStringInfoType  PrependMagickMethod(HashStringInfoType)
#define HashStringType  PrependMagickMethod(HashStringType)
#define HSBTransform  PrependMagickMethod(HSBTransform)
#define HSLTransform  PrependMagickMethod(HSLTransform)
#define Huffman2DEncodeImage  PrependMagickMethod(Huffman2DEncodeImage)
#define HuffmanDecodeImage  PrependMagickMethod(HuffmanDecodeImage)
#define HuffmanEncodeImage  PrependMagickMethod(HuffmanEncodeImage)
#define Hull  PrependMagickMethod(Hull)
#define HWBTransform  PrependMagickMethod(HWBTransform)
#define IdentifyImageCommand  PrependMagickMethod(IdentifyImageCommand)
#define IdentityAffine  PrependMagickMethod(IdentityAffine)
#define ImageListToArray  PrependMagickMethod(ImageListToArray)
#define ImageToBlob  PrependMagickMethod(ImageToBlob)
#define ImageToFile  PrependMagickMethod(ImageToFile)
#define ImplodeImage  PrependMagickMethod(ImplodeImage)
#define ImportImageCommand  PrependMagickMethod(ImportImageCommand)
#define ImportImagePixels  PrependMagickMethod(ImportImagePixels)
#define InheritException  PrependMagickMethod(InheritException)
#define InitializeMagick  PrependMagickMethod(InitializeMagick)
#define InitializeMagickResources  PrependMagickMethod(InitializeMagickResources)
#define InitializeSemaphore  PrependMagickMethod(InitializeSemaphore)
#define InsertElementInLinkedList  PrependMagickMethod(InsertElementInLinkedList)
#define InsertElementInSortedLinkedList  PrependMagickMethod(InsertElementInSortedLinkedList)
#define InsertImageInList  PrependMagickMethod(InsertImageInList)
#define InterpolateColor  PrependMagickMethod(InterpolateColor)
#define InvokeDelegate  PrependMagickMethod(InvokeDelegate)
#define InvokePostscriptDelegate  PrependMagickMethod(InvokePostscriptDelegate)
#define IsAccessible  PrependMagickMethod(IsAccessible)
#define IsBlobExempt  PrependMagickMethod(IsBlobExempt)
#define IsBlobSeekable  PrependMagickMethod(IsBlobSeekable)
#define IsBlobTemporary  PrependMagickMethod(IsBlobTemporary)
#define IsMagickColorSimilar  PrependMagickMethod(IsMagickColorSimilar)
#define IsEventLogging  PrependMagickMethod(IsEventLogging)
#define IsGeometry  PrependMagickMethod(IsGeometry)
#define IsGlob  PrependMagickMethod(IsGlob)
#define IsGrayImage  PrependMagickMethod(IsGrayImage)
#define IsHashmapEmpty  PrependMagickMethod(IsHashmapEmpty)
#define IsImagesEqual  PrependMagickMethod(IsImagesEqual)
#define IsLinkedListEmpty  PrependMagickMethod(IsLinkedListEmpty)
#define IsMagickConflict  PrependMagickMethod(IsMagickConflict)
#define IsMagickInstantiated  PrependMagickMethod(IsMagickInstantiated)
#define IsMonochromeImage  PrependMagickMethod(IsMonochromeImage)
#define IsOpaqueImage  PrependMagickMethod(IsOpaqueImage)
#define IsPaletteImage  PrependMagickMethod(IsPaletteImage)
#define IsSceneGeometry  PrependMagickMethod(IsSceneGeometry)
#define IsSubimage  PrependMagickMethod(IsSubimage)
#define IsTaintImage  PrependMagickMethod(IsTaintImage)
#define IsTrue  PrependMagickMethod(IsTrue)
#define JPEGEncodeImage  PrependMagickMethod(JPEGEncodeImage)
#define LevelImageChannel  PrependMagickMethod(LevelImageChannel)
#define LevelImage  PrependMagickMethod(LevelImage)
#define LiberateMemory  PrependMagickMethod(LiberateMemory)
#define LiberateSemaphoreInfo  PrependMagickMethod(LiberateSemaphoreInfo)
#define LinkedListToArray  PrependMagickMethod(LinkedListToArray)
#define ListCoderInfo  PrependMagickMethod(ListCoderInfo)
#define ListColorInfo  PrependMagickMethod(ListColorInfo)
#define ListConfigureInfo  PrependMagickMethod(ListConfigureInfo)
#define ListDelegateInfo  PrependMagickMethod(ListDelegateInfo)
#define ListFiles  PrependMagickMethod(ListFiles)
#define ListLocaleInfo  PrependMagickMethod(ListLocaleInfo)
#define ListLogInfo  PrependMagickMethod(ListLogInfo)
#define ListMagicInfo  PrependMagickMethod(ListMagicInfo)
#define ListMagickInfo  PrependMagickMethod(ListMagickInfo)
#define ListMagickResourceInfo  PrependMagickMethod(ListMagickResourceInfo)
#define ListTypeInfo  PrependMagickMethod(ListTypeInfo)
#define LoadWPG2Flags  PrependMagickMethod(LoadWPG2Flags)
#define LocaleCompare  PrependMagickMethod(LocaleCompare)
#define LocaleLower  PrependMagickMethod(LocaleLower)
#define LocaleNCompare  PrependMagickMethod(LocaleNCompare)
#define LocaleUpper  PrependMagickMethod(LocaleUpper)
#define LockSemaphoreInfo  PrependMagickMethod(LockSemaphoreInfo)
#define LogMagickEvent  PrependMagickMethod(LogMagickEvent)
#define LZWEncodeImage  PrependMagickMethod(LZWEncodeImage)
#define MagickError  PrependMagickMethod(MagickError)
#define MagickFatalError  PrependMagickMethod(MagickFatalError)
#define MagickIncarnate  PrependMagickMethod(MagickIncarnate)
#define MagickOptionToMnemonic  PrependMagickMethod(MagickOptionToMnemonic)
#define MagickToMime  PrependMagickMethod(MagickToMime)
#define MagickWarning  PrependMagickMethod(MagickWarning)
#define MagnifyImage  PrependMagickMethod(MagnifyImage)
#define MapBlob  PrependMagickMethod(MapBlob)
#define MapImage  PrependMagickMethod(MapImage)
#define MapImages  PrependMagickMethod(MapImages)
#define MatteFloodfillImage  PrependMagickMethod(MatteFloodfillImage)
#define MedianFilterImage  PrependMagickMethod(MedianFilterImage)
#define MinifyImage  PrependMagickMethod(MinifyImage)
#define ModifyImage  PrependMagickMethod(ModifyImage)
#define ModulateImage  PrependMagickMethod(ModulateImage)
#define Modulate  PrependMagickMethod(Modulate)
#define MogrifyImageCommand  PrependMagickMethod(MogrifyImageCommand)
#define MogrifyImageList  PrependMagickMethod(MogrifyImageList)
#define MogrifyImage  PrependMagickMethod(MogrifyImage)
#define MogrifyImages  PrependMagickMethod(MogrifyImages)
#define MontageImageCommand  PrependMagickMethod(MontageImageCommand)
#define MontageImages  PrependMagickMethod(MontageImages)
#define MorphImages  PrependMagickMethod(MorphImages)
#define MosaicImages  PrependMagickMethod(MosaicImages)
#define MotionBlurImage  PrependMagickMethod(MotionBlurImage)
#define MSBOrderLong  PrependMagickMethod(MSBOrderLong)
#define MSBOrderShort  PrependMagickMethod(MSBOrderShort)
#define MultilineCensus  PrependMagickMethod(MultilineCensus)
#define NegateImageChannel  PrependMagickMethod(NegateImageChannel)
#define NegateImage  PrependMagickMethod(NegateImage)
#define NewHashmap  PrependMagickMethod(NewHashmap)
#define NewImageList  PrependMagickMethod(NewImageList)
#define NewLinkedList  PrependMagickMethod(NewLinkedList)
#define NormalizeImageChannel  PrependMagickMethod(NormalizeImageChannel)
#define NormalizeImage  PrependMagickMethod(NormalizeImage)
#define OilPaintImage  PrependMagickMethod(OilPaintImage)
#define OpaqueImage  PrependMagickMethod(OpaqueImage)
#define OpenBlob  PrependMagickMethod(OpenBlob)
#define OpenCache  PrependMagickMethod(OpenCache)
#define OpenCacheView  PrependMagickMethod(OpenCacheView)
#define OrderedDitherImage  PrependMagickMethod(OrderedDitherImage)
#define PackbitsEncodeImage  PrependMagickMethod(PackbitsEncodeImage)
#define ParseAbsoluteGeometry  PrependMagickMethod(ParseAbsoluteGeometry)
#define ParseChannelOption  PrependMagickMethod(ParseChannelOption)
#define ParseGeometry  PrependMagickMethod(ParseGeometry)
#define ParseGravityGeometry  PrependMagickMethod(ParseGravityGeometry)
#define ParseImageGeometry  PrependMagickMethod(ParseImageGeometry)
#define ParseMagickOption  PrependMagickMethod(ParseMagickOption)
#define ParseMetaGeometry  PrependMagickMethod(ParseMetaGeometry)
#define ParsePageGeometry  PrependMagickMethod(ParsePageGeometry)
#define ParseSizeGeometry  PrependMagickMethod(ParseSizeGeometry)
#define PersistCache  PrependMagickMethod(PersistCache)
#define PingBlob  PrependMagickMethod(PingBlob)
#define PingImage  PrependMagickMethod(PingImage)
#define PlasmaImage  PrependMagickMethod(PlasmaImage)
#define PopImageList  PrependMagickMethod(PopImageList)
#define PopImagePixels  PrependMagickMethod(PopImagePixels)
#define PosterizeImage  PrependMagickMethod(PosterizeImage)
#define PostscriptGeometry  PrependMagickMethod(PostscriptGeometry)
#define PrependImageToList  PrependMagickMethod(PrependImageToList)
#define PreviewImage  PrependMagickMethod(PreviewImage)
#define PrintStringInfo  PrependMagickMethod(PrintStringInfo)
#define ProfileImage  PrependMagickMethod(ProfileImage)
#define PushImageList  PrependMagickMethod(PushImageList)
#define PushImagePixels  PrependMagickMethod(PushImagePixels)
#define PutEntryInHashmap  PrependMagickMethod(PutEntryInHashmap)
#define QuantizationError  PrependMagickMethod(QuantizationError)
#define QuantizeImage  PrependMagickMethod(QuantizeImage)
#define QuantizeImages  PrependMagickMethod(QuantizeImages)
#define QueryColorDatabase  PrependMagickMethod(QueryColorDatabase)
#define QueryColorname  PrependMagickMethod(QueryColorname)
#define QueryMagickColor  PrependMagickMethod(QueryMagickColor)
#define RadialBlurImage  PrependMagickMethod(RadialBlurImage)
#define RaiseImage  PrependMagickMethod(RaiseImage)
#define RandomChannelThresholdImage  PrependMagickMethod(RandomChannelThresholdImage)
#define RandomThresholdImageChannel  PrependMagickMethod(RandomThresholdImageChannel)
#define RandomThresholdImage  PrependMagickMethod(RandomThresholdImage)
#define ReacquireMemory  PrependMagickMethod(ReacquireMemory)
#define ReadBlobByte  PrependMagickMethod(ReadBlobByte)
#define ReadBlobLSBLong  PrependMagickMethod(ReadBlobLSBLong)
#define ReadBlobLSBShort  PrependMagickMethod(ReadBlobLSBShort)
#define ReadBlobMSBLong  PrependMagickMethod(ReadBlobMSBLong)
#define ReadBlobMSBShort  PrependMagickMethod(ReadBlobMSBShort)
#define ReadBlob  PrependMagickMethod(ReadBlob)
#define ReadBlobString  PrependMagickMethod(ReadBlobString)
#define ReadImage  PrependMagickMethod(ReadImage)
#define ReadInlineImage  PrependMagickMethod(ReadInlineImage)
#define ReadStream  PrependMagickMethod(ReadStream)
#define ReduceNoiseImage  PrependMagickMethod(ReduceNoiseImage)
#define ReferenceBlob  PrependMagickMethod(ReferenceBlob)
#define ReferenceCache  PrependMagickMethod(ReferenceCache)
#define ReferenceImage  PrependMagickMethod(ReferenceImage)
#define RegisterARTImage  PrependMagickMethod(RegisterARTImage)
#define RegisterAVIImage  PrependMagickMethod(RegisterAVIImage)
#define RegisterAVSImage  PrependMagickMethod(RegisterAVSImage)
#define RegisterBMPImage  PrependMagickMethod(RegisterBMPImage)
#define RegisterCAPTIONImage  PrependMagickMethod(RegisterCAPTIONImage)
#define RegisterCINImage  PrependMagickMethod(RegisterCINImage)
#define RegisterCIPImage  PrependMagickMethod(RegisterCIPImage)
#define RegisterCLIPBOARDImage  PrependMagickMethod(RegisterCLIPBOARDImage)
#define RegisterCLIPImage  PrependMagickMethod(RegisterCLIPImage)
#define RegisterCMYKImage  PrependMagickMethod(RegisterCMYKImage)
#define RegisterCUTImage  PrependMagickMethod(RegisterCUTImage)
#define RegisterDCMImage  PrependMagickMethod(RegisterDCMImage)
#define RegisterDIBImage  PrependMagickMethod(RegisterDIBImage)
#define RegisterDOTImage  PrependMagickMethod(RegisterDOTImage)
#define RegisterDPSImage  PrependMagickMethod(RegisterDPSImage)
#define RegisterDPXImage  PrependMagickMethod(RegisterDPXImage)
#define RegisterEMFImage  PrependMagickMethod(RegisterEMFImage)
#define RegisterEPTImage  PrependMagickMethod(RegisterEPTImage)
#define RegisterFAXImage  PrependMagickMethod(RegisterFAXImage)
#define RegisterFITSImage  PrependMagickMethod(RegisterFITSImage)
#define RegisterFPXImage  PrependMagickMethod(RegisterFPXImage)
#define RegisterGIFImage  PrependMagickMethod(RegisterGIFImage)
#define RegisterGRADIENTImage  PrependMagickMethod(RegisterGRADIENTImage)
#define RegisterGRAYImage  PrependMagickMethod(RegisterGRAYImage)
#define RegisterHISTOGRAMImage  PrependMagickMethod(RegisterHISTOGRAMImage)
#define RegisterHTMLImage  PrependMagickMethod(RegisterHTMLImage)
#define RegisterICONImage  PrependMagickMethod(RegisterICONImage)
#define RegisterJBIGImage  PrependMagickMethod(RegisterJBIGImage)
#define RegisterJP2Image  PrependMagickMethod(RegisterJP2Image)
#define RegisterJPEGImage  PrependMagickMethod(RegisterJPEGImage)
#define RegisterLABELImage  PrependMagickMethod(RegisterLABELImage)
#define RegisterMAGICKImage  PrependMagickMethod(RegisterMAGICKImage)
#define RegisterMagickInfo  PrependMagickMethod(RegisterMagickInfo)
#define RegisterMAPImage  PrependMagickMethod(RegisterMAPImage)
#define RegisterMATImage  PrependMagickMethod(RegisterMATImage)
#define RegisterMATTEImage  PrependMagickMethod(RegisterMATTEImage)
#define RegisterMETAImage  PrependMagickMethod(RegisterMETAImage)
#define RegisterMIFFImage  PrependMagickMethod(RegisterMIFFImage)
#define RegisterMONOImage  PrependMagickMethod(RegisterMONOImage)
#define RegisterMPCImage  PrependMagickMethod(RegisterMPCImage)
#define RegisterMPEGImage  PrependMagickMethod(RegisterMPEGImage)
#define RegisterMPRImage  PrependMagickMethod(RegisterMPRImage)
#define RegisterMSLImage  PrependMagickMethod(RegisterMSLImage)
#define RegisterMTVImage  PrependMagickMethod(RegisterMTVImage)
#define RegisterMVGImage  PrependMagickMethod(RegisterMVGImage)
#define RegisterNULLImage  PrependMagickMethod(RegisterNULLImage)
#define RegisterOTBImage  PrependMagickMethod(RegisterOTBImage)
#define RegisterPALMImage  PrependMagickMethod(RegisterPALMImage)
#define RegisterPATTERNImage  PrependMagickMethod(RegisterPATTERNImage)
#define RegisterPCDImage  PrependMagickMethod(RegisterPCDImage)
#define RegisterPCLImage  PrependMagickMethod(RegisterPCLImage)
#define RegisterPCXImage  PrependMagickMethod(RegisterPCXImage)
#define RegisterPDBImage  PrependMagickMethod(RegisterPDBImage)
#define RegisterPDFImage  PrependMagickMethod(RegisterPDFImage)
#define RegisterPICTImage  PrependMagickMethod(RegisterPICTImage)
#define RegisterPIXImage  PrependMagickMethod(RegisterPIXImage)
#define RegisterPLASMAImage  PrependMagickMethod(RegisterPLASMAImage)
#define RegisterPNGImage  PrependMagickMethod(RegisterPNGImage)
#define RegisterPNMImage  PrependMagickMethod(RegisterPNMImage)
#define RegisterPREVIEWImage  PrependMagickMethod(RegisterPREVIEWImage)
#define RegisterPS2Image  PrependMagickMethod(RegisterPS2Image)
#define RegisterPS3Image  PrependMagickMethod(RegisterPS3Image)
#define RegisterPSDImage  PrependMagickMethod(RegisterPSDImage)
#define RegisterPSImage  PrependMagickMethod(RegisterPSImage)
#define RegisterPWPImage  PrependMagickMethod(RegisterPWPImage)
#define RegisterRAWImage  PrependMagickMethod(RegisterRAWImage)
#define RegisterRGBImage  PrependMagickMethod(RegisterRGBImage)
#define RegisterRLAImage  PrependMagickMethod(RegisterRLAImage)
#define RegisterRLEImage  PrependMagickMethod(RegisterRLEImage)
#define RegisterSCRImage  PrependMagickMethod(RegisterSCRImage)
#define RegisterSCTImage  PrependMagickMethod(RegisterSCTImage)
#define RegisterSFWImage  PrependMagickMethod(RegisterSFWImage)
#define RegisterSGIImage  PrependMagickMethod(RegisterSGIImage)
#define RegisterStaticModules  PrependMagickMethod(RegisterStaticModules)
#define RegisterSTEGANOImage  PrependMagickMethod(RegisterSTEGANOImage)
#define RegisterSUNImage  PrependMagickMethod(RegisterSUNImage)
#define RegisterSVGImage  PrependMagickMethod(RegisterSVGImage)
#define RegisterTGAImage  PrependMagickMethod(RegisterTGAImage)
#define RegisterTIFFImage  PrependMagickMethod(RegisterTIFFImage)
#define RegisterTILEImage  PrependMagickMethod(RegisterTILEImage)
#define RegisterTIMImage  PrependMagickMethod(RegisterTIMImage)
#define RegisterTTFImage  PrependMagickMethod(RegisterTTFImage)
#define RegisterTXTImage  PrependMagickMethod(RegisterTXTImage)
#define RegisterUILImage  PrependMagickMethod(RegisterUILImage)
#define RegisterURLImage  PrependMagickMethod(RegisterURLImage)
#define RegisterUYVYImage  PrependMagickMethod(RegisterUYVYImage)
#define RegisterVICARImage  PrependMagickMethod(RegisterVICARImage)
#define RegisterVIDImage  PrependMagickMethod(RegisterVIDImage)
#define RegisterVIFFImage  PrependMagickMethod(RegisterVIFFImage)
#define RegisterWBMPImage  PrependMagickMethod(RegisterWBMPImage)
#define RegisterWMFImage  PrependMagickMethod(RegisterWMFImage)
#define RegisterWPGImage  PrependMagickMethod(RegisterWPGImage)
#define RegisterXBMImage  PrependMagickMethod(RegisterXBMImage)
#define RegisterXCFImage  PrependMagickMethod(RegisterXCFImage)
#define RegisterXCImage  PrependMagickMethod(RegisterXCImage)
#define RegisterXImage  PrependMagickMethod(RegisterXImage)
#define RegisterXPMImage  PrependMagickMethod(RegisterXPMImage)
#define RegisterXWDImage  PrependMagickMethod(RegisterXWDImage)
#define RegisterYCBCRImage  PrependMagickMethod(RegisterYCBCRImage)
#define RegisterYUVImage  PrependMagickMethod(RegisterYUVImage)
#define RelinquishMagickMemory  PrependMagickMethod(RelinquishMagickMemory)
#define RelinquishMagickResource  PrependMagickMethod(RelinquishMagickResource)
#define RelinquishSemaphoreInfo  PrependMagickMethod(RelinquishSemaphoreInfo)
#define RelinquishUniqueFileResource  PrependMagickMethod(RelinquishUniqueFileResource)
#define RemoveElementByValueFromLinkedList  PrependMagickMethod(RemoveElementByValueFromLinkedList)
#define RemoveElementFromLinkedList  PrependMagickMethod(RemoveElementFromLinkedList)
#define RemoveEntryFromHashmap  PrependMagickMethod(RemoveEntryFromHashmap)
#define RemoveFirstImageFromList  PrependMagickMethod(RemoveFirstImageFromList)
#define RemoveImageFromList  PrependMagickMethod(RemoveImageFromList)
#define RemoveImageOption  PrependMagickMethod(RemoveImageOption)
#define RemoveImageProfile  PrependMagickMethod(RemoveImageProfile)
#define RemoveLastElementFromLinkedList  PrependMagickMethod(RemoveLastElementFromLinkedList)
#define RemoveLastImageFromList  PrependMagickMethod(RemoveLastImageFromList)
#define ReplaceImageInList  PrependMagickMethod(ReplaceImageInList)
#define ResetHashmapIterator  PrependMagickMethod(ResetHashmapIterator)
#define ResetImageOptionIterator  PrependMagickMethod(ResetImageOptionIterator)
#define ResetImageProfileIterator  PrependMagickMethod(ResetImageProfileIterator)
#define ResetLinkedListIterator  PrependMagickMethod(ResetLinkedListIterator)
#define ResetMagickMemory  PrependMagickMethod(ResetMagickMemory)
#define ResetStringInfo  PrependMagickMethod(ResetStringInfo)
#define ResetTimer  PrependMagickMethod(ResetTimer)
#define ResizeImage  PrependMagickMethod(ResizeImage)
#define ResizeMagickMemory  PrependMagickMethod(ResizeMagickMemory)
#define ReverseImageList  PrependMagickMethod(ReverseImageList)
#define RGBTransformImage  PrependMagickMethod(RGBTransformImage)
#define RollImage  PrependMagickMethod(RollImage)
#define RotateImage  PrependMagickMethod(RotateImage)
#define SampleImage  PrependMagickMethod(SampleImage)
#define ScaleImage  PrependMagickMethod(ScaleImage)
#define SeekBlob  PrependMagickMethod(SeekBlob)
#define SegmentImage  PrependMagickMethod(SegmentImage)
#define SeparateImageChannel  PrependMagickMethod(SeparateImageChannel)
#define SetBlobExempt  PrependMagickMethod(SetBlobExempt)
#define SetCacheNexus  PrependMagickMethod(SetCacheNexus)
#define SetCacheThreshold  PrependMagickMethod(SetCacheThreshold)
#define SetCacheView  PrependMagickMethod(SetCacheView)
#define SetClientName  PrependMagickMethod(SetClientName)
#define SetClientPath  PrependMagickMethod(SetClientPath)
#define SetErrorHandler  PrependMagickMethod(SetErrorHandler)
#define SetExceptionInfo  PrependMagickMethod(SetExceptionInfo)
#define SetFatalErrorHandler  PrependMagickMethod(SetFatalErrorHandler)
#define SetGeometryInfo  PrependMagickMethod(SetGeometryInfo)
#define SetGeometry  PrependMagickMethod(SetGeometry)
#define SetImageAttribute  PrependMagickMethod(SetImageAttribute)
#define SetImageChannelDepth  PrependMagickMethod(SetImageChannelDepth)
#define SetImageClipMask  PrependMagickMethod(SetImageClipMask)
#define SetImageColorspace  PrependMagickMethod(SetImageColorspace)
#define SetImageDepth  PrependMagickMethod(SetImageDepth)
#define SetImageInfo  PrependMagickMethod(SetImageInfo)
#define SetImageList  PrependMagickMethod(SetImageList)
#define SetImageOpacity  PrependMagickMethod(SetImageOpacity)
#define SetImageOption  PrependMagickMethod(SetImageOption)
#define SetImagePixels  PrependMagickMethod(SetImagePixels)
#define SetImage  PrependMagickMethod(SetImage)
#define SetImageProfile  PrependMagickMethod(SetImageProfile)
#define SetImageProgressMonitor  PrependMagickMethod(SetImageProgressMonitor)
#define SetImageInfoProgressMonitor  PrependMagickMethod(SetImageInfoProgressMonitor)
#define SetImageType  PrependMagickMethod(SetImageType)
#define SetImageVirtualPixelMethod  PrependMagickMethod(SetImageVirtualPixelMethod)
#define SetLogEventMask  PrependMagickMethod(SetLogEventMask)
#define SetLogFormat  PrependMagickMethod(SetLogFormat)
#define SetMagickInfo  PrependMagickMethod(SetMagickInfo)
#define SetMagickRegistry  PrependMagickMethod(SetMagickRegistry)
#define SetMagickResourceLimit  PrependMagickMethod(SetMagickResourceLimit)
#define SetPixelCacheMethods  PrependMagickMethod(SetPixelCacheMethods)
#define SetStringInfoDatum  PrependMagickMethod(SetStringInfoDatum)
#define SetStringInfoLength  PrependMagickMethod(SetStringInfoLength)
#define SetStringInfo  PrependMagickMethod(SetStringInfo)
#define SetWarningHandler  PrependMagickMethod(SetWarningHandler)
#define ShadeImage  PrependMagickMethod(ShadeImage)
#define SharpenImageChannel  PrependMagickMethod(SharpenImageChannel)
#define SharpenImage  PrependMagickMethod(SharpenImage)
#define ShaveImage  PrependMagickMethod(ShaveImage)
#define ShearImage  PrependMagickMethod(ShearImage)
#define ShiftImageList  PrependMagickMethod(ShiftImageList)
#define SignatureImage  PrependMagickMethod(SignatureImage)
#define SizeBlob  PrependMagickMethod(SizeBlob)
#define SolarizeImage  PrependMagickMethod(SolarizeImage)
#define SortColormapByIntensity  PrependMagickMethod(SortColormapByIntensity)
#define SpliceImageIntoList  PrependMagickMethod(SpliceImageIntoList)
#define SpliceImageList  PrependMagickMethod(SpliceImageList)
#define SpliceImage  PrependMagickMethod(SpliceImage)
#define SplitImageList  PrependMagickMethod(SplitImageList)
#define SplitStringInfo  PrependMagickMethod(SplitStringInfo)
#define SpreadImage  PrependMagickMethod(SpreadImage)
#define StartTimer  PrependMagickMethod(StartTimer)
#define SteganoImage  PrependMagickMethod(SteganoImage)
#define StereoImage  PrependMagickMethod(StereoImage)
#define StringInfoToString  PrependMagickMethod(StringInfoToString)
#define StringToArgv  PrependMagickMethod(StringToArgv)
#define StringToDouble  PrependMagickMethod(StringToDouble)
#define StringToList  PrependMagickMethod(StringToList)
#define StringToStringInfo  PrependMagickMethod(StringToStringInfo)
#define StripImage  PrependMagickMethod(StripImage)
#define Strip  PrependMagickMethod(Strip)
#define StripString  PrependMagickMethod(StripString)
#define SubstituteString  PrependMagickMethod(SubstituteString)
#define SwirlImage  PrependMagickMethod(SwirlImage)
#define SyncBlob  PrependMagickMethod(SyncBlob)
#define SyncCacheNexus  PrependMagickMethod(SyncCacheNexus)
#define SyncCache  PrependMagickMethod(SyncCache)
#define SyncCacheView  PrependMagickMethod(SyncCacheView)
#define SyncImageList  PrependMagickMethod(SyncImageList)
#define SyncImagePixels  PrependMagickMethod(SyncImagePixels)
#define SyncImage  PrependMagickMethod(SyncImage)
#define SyncNextImageInList  PrependMagickMethod(SyncNextImageInList)
#define SystemCommand  PrependMagickMethod(SystemCommand)
#define TellBlob  PrependMagickMethod(TellBlob)
#define TemporaryFilename  PrependMagickMethod(TemporaryFilename)
#define TextureImage  PrependMagickMethod(TextureImage)
#define ThresholdImageChannel  PrependMagickMethod(ThresholdImageChannel)
#define ThresholdImage  PrependMagickMethod(ThresholdImage)
#define ThrowException  PrependMagickMethod(ThrowException)
#define ThrowMagickException  PrependMagickMethod(ThrowMagickException)
#define ThumbnailImage  PrependMagickMethod(ThumbnailImage)
#define TintImage  PrependMagickMethod(TintImage)
#define Tokenizer  PrependMagickMethod(Tokenizer)
#define TransformColorspace  PrependMagickMethod(TransformColorspace)
#define TransformHSB  PrependMagickMethod(TransformHSB)
#define TransformHSL  PrependMagickMethod(TransformHSL)
#define TransformHWB  PrependMagickMethod(TransformHWB)
#define TransformImage  PrependMagickMethod(TransformImage)
#define TransformRGBImage  PrependMagickMethod(TransformRGBImage)
#define TranslateText  PrependMagickMethod(TranslateText)
#define TransparentImage  PrependMagickMethod(TransparentImage)
#define TrimImage  PrependMagickMethod(TrimImage)
#define UnlockSemaphoreInfo  PrependMagickMethod(UnlockSemaphoreInfo)
#define UnmapBlob  PrependMagickMethod(UnmapBlob)
#define UnregisterARTImage  PrependMagickMethod(UnregisterARTImage)
#define UnregisterAVIImage  PrependMagickMethod(UnregisterAVIImage)
#define UnregisterAVSImage  PrependMagickMethod(UnregisterAVSImage)
#define UnregisterBMPImage  PrependMagickMethod(UnregisterBMPImage)
#define UnregisterCAPTIONImage  PrependMagickMethod(UnregisterCAPTIONImage)
#define UnregisterCINImage  PrependMagickMethod(UnregisterCINImage)
#define UnregisterCIPImage  PrependMagickMethod(UnregisterCIPImage)
#define UnregisterCLIPBOARDImage  PrependMagickMethod(UnregisterCLIPBOARDImage)
#define UnregisterCLIPImage  PrependMagickMethod(UnregisterCLIPImage)
#define UnregisterCMYKImage  PrependMagickMethod(UnregisterCMYKImage)
#define UnregisterCUTImage  PrependMagickMethod(UnregisterCUTImage)
#define UnregisterDCMImage  PrependMagickMethod(UnregisterDCMImage)
#define UnregisterDIBImage  PrependMagickMethod(UnregisterDIBImage)
#define UnregisterDOTImage  PrependMagickMethod(UnregisterDOTImage)
#define UnregisterDPSImage  PrependMagickMethod(UnregisterDPSImage)
#define UnregisterDPXImage  PrependMagickMethod(UnregisterDPXImage)
#define UnregisterEMFImage  PrependMagickMethod(UnregisterEMFImage)
#define UnregisterEPTImage  PrependMagickMethod(UnregisterEPTImage)
#define UnregisterFAXImage  PrependMagickMethod(UnregisterFAXImage)
#define UnregisterFITSImage  PrependMagickMethod(UnregisterFITSImage)
#define UnregisterFPXImage  PrependMagickMethod(UnregisterFPXImage)
#define UnregisterGIFImage  PrependMagickMethod(UnregisterGIFImage)
#define UnregisterGRADIENTImage  PrependMagickMethod(UnregisterGRADIENTImage)
#define UnregisterGRAYImage  PrependMagickMethod(UnregisterGRAYImage)
#define UnregisterHISTOGRAMImage  PrependMagickMethod(UnregisterHISTOGRAMImage)
#define UnregisterHTMLImage  PrependMagickMethod(UnregisterHTMLImage)
#define UnregisterICONImage  PrependMagickMethod(UnregisterICONImage)
#define UnregisterJBIGImage  PrependMagickMethod(UnregisterJBIGImage)
#define UnregisterJP2Image  PrependMagickMethod(UnregisterJP2Image)
#define UnregisterJPEGImage  PrependMagickMethod(UnregisterJPEGImage)
#define UnregisterLABELImage  PrependMagickMethod(UnregisterLABELImage)
#define UnregisterMAGICKImage  PrependMagickMethod(UnregisterMAGICKImage)
#define UnregisterMagickInfo  PrependMagickMethod(UnregisterMagickInfo)
#define UnregisterMAPImage  PrependMagickMethod(UnregisterMAPImage)
#define UnregisterMATImage  PrependMagickMethod(UnregisterMATImage)
#define UnregisterMATTEImage  PrependMagickMethod(UnregisterMATTEImage)
#define UnregisterMETAImage  PrependMagickMethod(UnregisterMETAImage)
#define UnregisterMIFFImage  PrependMagickMethod(UnregisterMIFFImage)
#define UnregisterMONOImage  PrependMagickMethod(UnregisterMONOImage)
#define UnregisterMPCImage  PrependMagickMethod(UnregisterMPCImage)
#define UnregisterMPEGImage  PrependMagickMethod(UnregisterMPEGImage)
#define UnregisterMPRImage  PrependMagickMethod(UnregisterMPRImage)
#define UnregisterMSLImage  PrependMagickMethod(UnregisterMSLImage)
#define UnregisterMTVImage  PrependMagickMethod(UnregisterMTVImage)
#define UnregisterMVGImage  PrependMagickMethod(UnregisterMVGImage)
#define UnregisterNULLImage  PrependMagickMethod(UnregisterNULLImage)
#define UnregisterOTBImage  PrependMagickMethod(UnregisterOTBImage)
#define UnregisterPALMImage  PrependMagickMethod(UnregisterPALMImage)
#define UnregisterPATTERNImage  PrependMagickMethod(UnregisterPATTERNImage)
#define UnregisterPCDImage  PrependMagickMethod(UnregisterPCDImage)
#define UnregisterPCLImage  PrependMagickMethod(UnregisterPCLImage)
#define UnregisterPCXImage  PrependMagickMethod(UnregisterPCXImage)
#define UnregisterPDBImage  PrependMagickMethod(UnregisterPDBImage)
#define UnregisterPDFImage  PrependMagickMethod(UnregisterPDFImage)
#define UnregisterPICTImage  PrependMagickMethod(UnregisterPICTImage)
#define UnregisterPIXImage  PrependMagickMethod(UnregisterPIXImage)
#define UnregisterPLASMAImage  PrependMagickMethod(UnregisterPLASMAImage)
#define UnregisterPNGImage  PrependMagickMethod(UnregisterPNGImage)
#define UnregisterPNMImage  PrependMagickMethod(UnregisterPNMImage)
#define UnregisterPREVIEWImage  PrependMagickMethod(UnregisterPREVIEWImage)
#define UnregisterPS2Image  PrependMagickMethod(UnregisterPS2Image)
#define UnregisterPS3Image  PrependMagickMethod(UnregisterPS3Image)
#define UnregisterPSDImage  PrependMagickMethod(UnregisterPSDImage)
#define UnregisterPSImage  PrependMagickMethod(UnregisterPSImage)
#define UnregisterPWPImage  PrependMagickMethod(UnregisterPWPImage)
#define UnregisterRAWImage  PrependMagickMethod(UnregisterRAWImage)
#define UnregisterRGBImage  PrependMagickMethod(UnregisterRGBImage)
#define UnregisterRLAImage  PrependMagickMethod(UnregisterRLAImage)
#define UnregisterRLEImage  PrependMagickMethod(UnregisterRLEImage)
#define UnregisterSCRImage  PrependMagickMethod(UnregisterSCRImage)
#define UnregisterSCTImage  PrependMagickMethod(UnregisterSCTImage)
#define UnregisterSFWImage  PrependMagickMethod(UnregisterSFWImage)
#define UnregisterSGIImage  PrependMagickMethod(UnregisterSGIImage)
#define UnregisterStaticModules  PrependMagickMethod(UnregisterStaticModules)
#define UnregisterSTEGANOImage  PrependMagickMethod(UnregisterSTEGANOImage)
#define UnregisterSUNImage  PrependMagickMethod(UnregisterSUNImage)
#define UnregisterSVGImage  PrependMagickMethod(UnregisterSVGImage)
#define UnregisterTGAImage  PrependMagickMethod(UnregisterTGAImage)
#define UnregisterTIFFImage  PrependMagickMethod(UnregisterTIFFImage)
#define UnregisterTILEImage  PrependMagickMethod(UnregisterTILEImage)
#define UnregisterTIMImage  PrependMagickMethod(UnregisterTIMImage)
#define UnregisterTTFImage  PrependMagickMethod(UnregisterTTFImage)
#define UnregisterTXTImage  PrependMagickMethod(UnregisterTXTImage)
#define UnregisterUILImage  PrependMagickMethod(UnregisterUILImage)
#define UnregisterURLImage  PrependMagickMethod(UnregisterURLImage)
#define UnregisterUYVYImage  PrependMagickMethod(UnregisterUYVYImage)
#define UnregisterVICARImage  PrependMagickMethod(UnregisterVICARImage)
#define UnregisterVIDImage  PrependMagickMethod(UnregisterVIDImage)
#define UnregisterVIFFImage  PrependMagickMethod(UnregisterVIFFImage)
#define UnregisterWBMPImage  PrependMagickMethod(UnregisterWBMPImage)
#define UnregisterWMFImage  PrependMagickMethod(UnregisterWMFImage)
#define UnregisterWPGImage  PrependMagickMethod(UnregisterWPGImage)
#define UnregisterXBMImage  PrependMagickMethod(UnregisterXBMImage)
#define UnregisterXCFImage  PrependMagickMethod(UnregisterXCFImage)
#define UnregisterXCImage  PrependMagickMethod(UnregisterXCImage)
#define UnregisterXImage  PrependMagickMethod(UnregisterXImage)
#define UnregisterXPMImage  PrependMagickMethod(UnregisterXPMImage)
#define UnregisterXWDImage  PrependMagickMethod(UnregisterXWDImage)
#define UnregisterYCBCRImage  PrependMagickMethod(UnregisterYCBCRImage)
#define UnregisterYUVImage  PrependMagickMethod(UnregisterYUVImage)
#define UnsharpMaskImageChannel  PrependMagickMethod(UnsharpMaskImageChannel)
#define UnsharpMaskImage  PrependMagickMethod(UnsharpMaskImage)
#define UnshiftImageList  PrependMagickMethod(UnshiftImageList)
#define UpdateSignature  PrependMagickMethod(UpdateSignature)
#define Upsample  PrependMagickMethod(Upsample)
#define ValidateColormapIndex  PrependMagickMethod(ValidateColormapIndex)
#define WaveImage  PrependMagickMethod(WaveImage)
#define WhiteThresholdImage  PrependMagickMethod(WhiteThresholdImage)
#define WriteBlobByte  PrependMagickMethod(WriteBlobByte)
#define WriteBlobLSBLong  PrependMagickMethod(WriteBlobLSBLong)
#define WriteBlobLSBShort  PrependMagickMethod(WriteBlobLSBShort)
#define WriteBlobMSBLong  PrependMagickMethod(WriteBlobMSBLong)
#define WriteBlobMSBShort  PrependMagickMethod(WriteBlobMSBShort)
#define WriteBlob  PrependMagickMethod(WriteBlob)
#define WriteBlobString  PrependMagickMethod(WriteBlobString)
#define WriteImage  PrependMagickMethod(WriteImage)
#define WriteImages  PrependMagickMethod(WriteImages)
#define WriteStream  PrependMagickMethod(WriteStream)
#define XAnimateBackgroundImage  PrependMagickMethod(XAnimateBackgroundImage)
#define XAnimateImages  PrependMagickMethod(XAnimateImages)
#define XAnnotateImage  PrependMagickMethod(XAnnotateImage)
#define XBestFont  PrependMagickMethod(XBestFont)
#define XBestIconSize  PrependMagickMethod(XBestIconSize)
#define XBestPixel  PrependMagickMethod(XBestPixel)
#define XBestVisualInfo  PrependMagickMethod(XBestVisualInfo)
#define XCheckDefineCursor  PrependMagickMethod(XCheckDefineCursor)
#define XCheckRefreshWindows  PrependMagickMethod(XCheckRefreshWindows)
#define XClientMessage  PrependMagickMethod(XClientMessage)
#define XColorBrowserWidget  PrependMagickMethod(XColorBrowserWidget)
#define XCommandWidget  PrependMagickMethod(XCommandWidget)
#define XConfigureImageColormap  PrependMagickMethod(XConfigureImageColormap)
#define XConfirmWidget  PrependMagickMethod(XConfirmWidget)
#define XConstrainWindowPosition  PrependMagickMethod(XConstrainWindowPosition)
#define XDelay  PrependMagickMethod(XDelay)
#define XDestroyResourceInfo  PrependMagickMethod(XDestroyResourceInfo)
#define XDestroyWindowColors  PrependMagickMethod(XDestroyWindowColors)
#define XDialogWidget  PrependMagickMethod(XDialogWidget)
#define XDisplayBackgroundImage  PrependMagickMethod(XDisplayBackgroundImage)
#define XDisplayImageInfo  PrependMagickMethod(XDisplayImageInfo)
#define XDisplayImage  PrependMagickMethod(XDisplayImage)
#define XDrawImage  PrependMagickMethod(XDrawImage)
#define XError  PrependMagickMethod(XError)
#define XFileBrowserWidget  PrependMagickMethod(XFileBrowserWidget)
#define XFontBrowserWidget  PrependMagickMethod(XFontBrowserWidget)
#define XFreeResources  PrependMagickMethod(XFreeResources)
#define XFreeStandardColormap  PrependMagickMethod(XFreeStandardColormap)
#define XGetAnnotateInfo  PrependMagickMethod(XGetAnnotateInfo)
#define XGetImportInfo  PrependMagickMethod(XGetImportInfo)
#define XGetMapInfo  PrependMagickMethod(XGetMapInfo)
#define XGetPixelPacket  PrependMagickMethod(XGetPixelPacket)
#define XGetResourceClass  PrependMagickMethod(XGetResourceClass)
#define XGetResourceDatabase  PrependMagickMethod(XGetResourceDatabase)
#define XGetResourceInfo  PrependMagickMethod(XGetResourceInfo)
#define XGetResourceInstance  PrependMagickMethod(XGetResourceInstance)
#define XGetScreenDensity  PrependMagickMethod(XGetScreenDensity)
#define XGetWindowColor  PrependMagickMethod(XGetWindowColor)
#define XGetWindowInfo  PrependMagickMethod(XGetWindowInfo)
#define XHighlightEllipse  PrependMagickMethod(XHighlightEllipse)
#define XHighlightLine  PrependMagickMethod(XHighlightLine)
#define XHighlightRectangle  PrependMagickMethod(XHighlightRectangle)
#define XImportImage  PrependMagickMethod(XImportImage)
#define XInfoWidget  PrependMagickMethod(XInfoWidget)
#define XInitializeWindows  PrependMagickMethod(XInitializeWindows)
#define XListBrowserWidget  PrependMagickMethod(XListBrowserWidget)
#define XMagickProgressMonitor  PrependMagickMethod(XMagickProgressMonitor)
#define XMakeCursor  PrependMagickMethod(XMakeCursor)
#define XMakeImage  PrependMagickMethod(XMakeImage)
#define XMakeMagnifyImage  PrependMagickMethod(XMakeMagnifyImage)
#define XMakeStandardColormap  PrependMagickMethod(XMakeStandardColormap)
#define XMakeWindow  PrependMagickMethod(XMakeWindow)
#define XMenuWidget  PrependMagickMethod(XMenuWidget)
#define XMonitorWidget  PrependMagickMethod(XMonitorWidget)
#define XNoticeWidget  PrependMagickMethod(XNoticeWidget)
#define XPreferencesWidget  PrependMagickMethod(XPreferencesWidget)
#define XQueryColorDatabase  PrependMagickMethod(XQueryColorDatabase)
#define XQueryPosition  PrependMagickMethod(XQueryPosition)
#define XRefreshWindow  PrependMagickMethod(XRefreshWindow)
#define XRemoteCommand  PrependMagickMethod(XRemoteCommand)
#define XRetainWindowColors  PrependMagickMethod(XRetainWindowColors)
#define XSetCursorState  PrependMagickMethod(XSetCursorState)
#define XSetWindows  PrependMagickMethod(XSetWindows)
#define XTextViewWidget  PrependMagickMethod(XTextViewWidget)
#define XUserPreferences  PrependMagickMethod(XUserPreferences)
#define XWarning  PrependMagickMethod(XWarning)
#define XWindowByID  PrependMagickMethod(XWindowByID)
#define XWindowByName  PrependMagickMethod(XWindowByName)
#define XWindowByProperty  PrependMagickMethod(XWindowByProperty)
#define ZLIBEncodeImage  PrependMagickMethod(ZLIBEncodeImage)
#define ZoomImage  PrependMagickMethod(ZoomImage)

#endif

#if defined(__cplusplus) || defined(c_plusplus)
}
#endif

#endif
